/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v3_0_0;

import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.ResultSet;
import java.sql.Statement;

public class JournalArticleImageUpgradeProcess
extends UpgradeProcess {
    private final ImageLocalService _imageLocalService;

    public JournalArticleImageUpgradeProcess(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("JournalArticleImage")) {
            return;
        }
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet resultSet1 = statement.executeQuery("select articleImageId from JournalArticleImage");){
            while (resultSet1.next()) {
                long articleImageId = resultSet1.getLong(1);
                this._imageLocalService.deleteImage(articleImageId);
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"JournalArticleImage"})};
    }
}

