/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v3_5_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JournalArticleDataFileEntryIdUpgradeProcess
extends UpgradeProcess {
    private static final Pattern _dataFileEntryIdPattern = Pattern.compile("data-fileEntryId=", 34);

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select id_, content from JournalArticle");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");){
            while (resultSet.next()) {
                String upgradedContent;
                String content = resultSet.getString("content");
                if (Objects.equals(content, upgradedContent = this._upgradeContent(content))) continue;
                preparedStatement2.setString(1, upgradedContent);
                preparedStatement2.setLong(2, resultSet.getLong("id_"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _upgradeContent(String content) throws DocumentException {
        Document document = SAXReaderUtil.read((String)content);
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='text_area']");
        List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
        for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
            Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
            List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String stringValue = dynamicContentElement.getStringValue();
                Matcher matcher = _dataFileEntryIdPattern.matcher(stringValue);
                String upgradedStringValue = matcher.replaceAll("data-fileentryid=");
                if (upgradedStringValue.equals(stringValue)) continue;
                dynamicContentElement.clearContent();
                dynamicContentElement.addCDATA(upgradedStringValue);
            }
        }
        return document.asXML();
    }
}

