/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v4_3_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BasicWebContentAssetEntryClassTypeIdUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BasicWebContentAssetEntryClassTypeIdUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final GroupLocalService _groupLocalService;

    public BasicWebContentAssetEntryClassTypeIdUpgradeProcess(CompanyLocalService companyLocalService, DDMStructureLocalService ddmStructureLocalService, GroupLocalService groupLocalService) {
        this._companyLocalService = companyLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._updateBasicWebContentAssetEntries();
    }

    private void _updateBasicWebContentAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
            this._companyLocalService.forEachCompanyId(companyId -> this._updateBasicWebContentAssetEntries((long)companyId, classNameId));
        }
    }

    private void _updateBasicWebContentAssetEntries(long companyId, long classNameId) throws Exception {
        block16: {
            Group companyGroup = this._groupLocalService.getCompanyGroup(companyId);
            String structureKey = "BASIC-WEB-CONTENT";
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(companyGroup.getGroupId(), PortalUtil.getClassNameId((String)JournalArticle.class.getName()), structureKey);
            if (ddmStructure == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"No dynamic data mapping structure with structure key ", structureKey, " found in group ", companyGroup.getGroupId(), " for company ", companyId}));
                }
                return;
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update AssetEntry set classTypeId = ? where classNameId = ? and companyId = ? and classTypeId = ?");){
                preparedStatement.setLong(1, ddmStructure.getStructureId());
                preparedStatement.setLong(2, classNameId);
                preparedStatement.setLong(3, companyId);
                preparedStatement.setLong(4, 0L);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Throwable)sqlException);
            }
        }
    }
}

