/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v4_4_0;

import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class GlobalJournalArticleUrlTitleUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final CompanyLocalService _companyLocalService;
    private final GroupLocalService _groupLocalService;

    public GlobalJournalArticleUrlTitleUpgradeProcess(ClassNameLocalService classNameLocalService, CompanyLocalService companyLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._companyLocalService = companyLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._updateGlobalJournalArticles();
    }

    private String _getUrlTitle(long classNameId, long classPK, long groupId, String languageId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select urlTitle from FriendlyURLEntryLocalization where languageId = ? and groupId = ? and classNameId = ? and classPK = ?");){
            preparedStatement.setString(1, languageId);
            preparedStatement.setLong(2, groupId);
            preparedStatement.setLong(3, classNameId);
            preparedStatement.setLong(4, classPK);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    String string = resultSet.getString("urlTitle");
                    return string;
                }
            }
        }
        return "";
    }

    private void _updateGlobalJournalArticles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = this._classNameLocalService.getClassNameId(JournalArticle.class.getName());
            this._companyLocalService.forEachCompanyId(companyId -> this._updateGlobalJournalArticles(classNameId, (long)companyId));
        }
    }

    private void _updateGlobalJournalArticles(long classNameId, long companyId) throws Exception {
        Group companyGroup = this._groupLocalService.getCompanyGroup(companyId);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select id_, resourcePrimKey, defaultLanguageId from JournalArticle where groupId = ? and (urlTitle is null or urlTitle = '')");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set urlTitle = ? where id_ = ?");){
            preparedStatement1.setLong(1, companyGroup.getGroupId());
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long classPK = resultSet.getLong("resourcePrimKey");
                    String defaultLanguageId = resultSet.getString("defaultLanguageId");
                    preparedStatement2.setString(1, this._getUrlTitle(classNameId, classPK, companyGroup.getGroupId(), defaultLanguageId));
                    long id = resultSet.getLong("id_");
                    preparedStatement2.setLong(2, id);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

