/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v4_4_3;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javax.portlet.PortletPreferences;

public class JournalArticleLayoutClassedModelUsageUpgradeProcess
extends UpgradeProcess {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final ClassNameLocalService _classNameLocalService;
    private final LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final PortletPreferencesLocalService _portletPreferencesLocalService;
    private final PortletPreferenceValueLocalService _portletPreferenceValueLocalService;

    public JournalArticleLayoutClassedModelUsageUpgradeProcess(AssetEntryLocalService assetEntryLocalService, ClassNameLocalService classNameLocalService, LayoutLocalService layoutLocalService, LayoutClassedModelUsageLocalService layoutClassedModelUsageLocalService, PortletPreferencesLocalService portletPreferencesLocalService, PortletPreferenceValueLocalService portletPreferenceValueLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._classNameLocalService = classNameLocalService;
        this._layoutLocalService = layoutLocalService;
        this._layoutClassedModelUsageLocalService = layoutClassedModelUsageLocalService;
        this._portletPreferencesLocalService = portletPreferencesLocalService;
        this._portletPreferenceValueLocalService = portletPreferenceValueLocalService;
    }

    protected void doUpgrade() throws Exception {
        long journalArticleClassNameId = this._classNameLocalService.getClassNameId(JournalArticle.class.getName());
        long portletClassNameId = this._classNameLocalService.getClassNameId(Portlet.class.getName());
        ServiceContext serviceContext = new ServiceContext();
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select groupId, resourcePrimKey, articleId from JournalArticle");
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                long resourcePrimKey = resultSet.getLong("resourcePrimKey");
                if (this._layoutClassedModelUsageLocalService.hasDefaultLayoutClassedModelUsage(journalArticleClassNameId, resourcePrimKey)) continue;
                String articleId = GetterUtil.getString((String)resultSet.getString("articleId"));
                long groupId = resultSet.getLong("groupId");
                this._addJournalContentSearchLayoutClassedModelUsages(articleId, resourcePrimKey, groupId, journalArticleClassNameId, portletClassNameId, serviceContext);
                AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(journalArticleClassNameId, resourcePrimKey);
                if (assetEntry == null || Validator.isNull((String)assetEntry.getClassUuid())) continue;
                this._addAssetPublisherPortletPreferencesLayoutClassedModelUsages(assetEntry.getClassUuid(), resourcePrimKey, groupId, journalArticleClassNameId, portletClassNameId, this._portletPreferencesLocalService.getPortletPreferences(assetEntry.getCompanyId(), groupId, 0L, 3, "com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", true), serviceContext);
                this._addAssetPublisherPortletPreferencesLayoutClassedModelUsages(assetEntry.getClassUuid(), resourcePrimKey, groupId, journalArticleClassNameId, portletClassNameId, this._portletPreferencesLocalService.getPortletPreferences(assetEntry.getCompanyId(), groupId, 0L, 3, "com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", false), serviceContext);
                this._layoutClassedModelUsageLocalService.addDefaultLayoutClassedModelUsage(groupId, journalArticleClassNameId, resourcePrimKey, serviceContext);
            }
        }
    }

    private void _addAssetPublisherPortletPreferencesLayoutClassedModelUsages(String assetEntryClassUuid, long classPK, long groupId, long journalArticleClassNameId, long portletClassNameId, List<com.liferay.portal.kernel.model.PortletPreferences> portletPreferencesList, ServiceContext serviceContext) {
        for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : portletPreferencesList) {
            LayoutClassedModelUsage layoutClassedModelUsage;
            String assetEntryXml;
            PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
            String selectionStyle = jxPortletPreferences.getValue("selectionStyle", "dynamic");
            if (!StringUtil.equals((String)selectionStyle, (String)"manual") || !(assetEntryXml = jxPortletPreferences.getValue("assetEntryXml", "")).contains(assetEntryClassUuid) || (layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(journalArticleClassNameId, classPK, portletPreferences.getPortletId(), portletClassNameId, portletPreferences.getPlid())) != null) continue;
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(groupId, journalArticleClassNameId, classPK, portletPreferences.getPortletId(), portletClassNameId, portletPreferences.getPlid(), serviceContext);
        }
    }

    private void _addJournalContentSearchLayoutClassedModelUsages(String articleId, long classPK, long groupId, long journalArticleClassNameId, long portletClassNameId, ServiceContext serviceContext) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select privateLayout, layoutId, portletId from JournalContentSearch where groupId = ? and articleId = ?");){
            preparedStatement.setLong(1, groupId);
            preparedStatement.setString(2, articleId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String portletId;
                    LayoutClassedModelUsage layoutClassedModelUsage;
                    Layout layout = this._layoutLocalService.fetchLayout(groupId, resultSet.getBoolean("privateLayout"), resultSet.getLong("layoutId"));
                    if (layout == null || (layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(journalArticleClassNameId, classPK, portletId = GetterUtil.getString((String)resultSet.getString("portletId")), portletClassNameId, layout.getPlid())) != null) continue;
                    this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(groupId, journalArticleClassNameId, classPK, portletId, portletClassNameId, layout.getPlid(), serviceContext);
                }
            }
        }
    }
}

