/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v4_4_4;

import com.liferay.asset.entry.rel.service.AssetEntryAssetCategoryRelLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JournalFeedTypeUpgradeProcess
extends UpgradeProcess {
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetEntryAssetCategoryRelLocalService _assetEntryAssetCategoryRelLocalService;
    private final AssetEntryLocalService _assetEntryLocalService;
    private final AssetVocabularyLocalService _assetVocabularyLocalService;
    private final CompanyLocalService _companyLocalService;
    private final Language _language;
    private final Localization _localization;
    private final Portal _portal;
    private final UserLocalService _userLocalService;

    public JournalFeedTypeUpgradeProcess(AssetCategoryLocalService assetCategoryLocalService, AssetEntryAssetCategoryRelLocalService assetEntryAssetCategoryRelLocalService, AssetEntryLocalService assetEntryLocalService, AssetVocabularyLocalService assetVocabularyLocalService, CompanyLocalService companyLocalService, Language language, Localization localization, Portal portal, UserLocalService userLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetEntryAssetCategoryRelLocalService = assetEntryAssetCategoryRelLocalService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._assetVocabularyLocalService = assetVocabularyLocalService;
        this._companyLocalService = companyLocalService;
        this._language = language;
        this._localization = localization;
        this._portal = portal;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (this.hasColumn("JournalFeed", "type_")) {
            this._addJournalFeedTypesAndAssetEntries();
        } else {
            this._addJournalFeedAssetEntries();
        }
    }

    private void _addAssetEntry(long assetCategoryId, long classNameId, long defaultUserId, ResultSet resultSet) throws Exception {
        long id = resultSet.getLong("id_");
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, id);
        if (assetEntry != null) {
            return;
        }
        long userId = resultSet.getLong("userId");
        Date createDate = resultSet.getDate("createDate");
        if (this._userLocalService.fetchUser(userId) == null) {
            userId = defaultUserId;
        }
        assetEntry = this._assetEntryLocalService.updateEntry(userId, resultSet.getLong("groupId"), (java.util.Date)resultSet.getDate("createDate"), (java.util.Date)resultSet.getDate("modifiedDate"), JournalFeed.class.getName(), id, resultSet.getString("uuid_"), 0L, new long[0], new String[0], true, true, null, null, (java.util.Date)createDate, null, "text/plain", resultSet.getString("name"), resultSet.getString("description"), null, null, null, 0, 0, Double.valueOf(0.0));
        if (assetCategoryId > 0L) {
            this._assetEntryAssetCategoryRelLocalService.addAssetEntryAssetCategoryRel(assetEntry.getEntryId(), assetCategoryId);
        }
    }

    private void _addJournalFeedAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = this._portal.getClassNameId(JournalFeed.class.getName());
            this._companyLocalService.forEachCompanyId(companyId -> {
                long defaultUserId = this._userLocalService.getDefaultUserId(companyId.longValue());
                try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select uuid_, id_, groupId, userId, ", "createDate, modifiedDate, name, ", "description from JournalFeed where ", "companyId = ", companyId}));
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        this._addAssetEntry(0L, classNameId, defaultUserId, resultSet);
                    }
                }
            });
        }
    }

    private void _addJournalFeedAssetEntries(long classNameId, long companyId, long defaultUserId, Map<String, Long> journalFeedTypesMap) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select uuid_, id_, groupId, userId, createDate, ", "modifiedDate, name, description, type_ from JournalFeed ", "where companyId = ", companyId}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long assetCategoryId = 0L;
                String type = StringUtil.toLowerCase((String)resultSet.getString("type_"));
                if (Validator.isNotNull((String)type) && journalFeedTypesMap.containsKey(type)) {
                    assetCategoryId = journalFeedTypesMap.get(type);
                }
                this._addAssetEntry(assetCategoryId, classNameId, defaultUserId, resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addJournalFeedTypesAndAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            Locale localeThreadLocalDefaultLocale = LocaleThreadLocal.getDefaultLocale();
            long journalArticleClassNameId = this._portal.getClassNameId(JournalArticle.class.getName());
            long journalFeedClassNameId = this._portal.getClassNameId(JournalFeed.class.getName());
            try {
                this._companyLocalService.forEachCompany(company -> {
                    Set<String> journalFeedTypes = this._getJournalFeedTypes(company.getCompanyId());
                    if (SetUtil.isEmpty(journalFeedTypes)) {
                        return;
                    }
                    LocaleThreadLocal.setDefaultLocale((Locale)company.getLocale());
                    long userId = this._userLocalService.getDefaultUserId(company.getCompanyId());
                    ServiceContext serviceContext = new ServiceContext();
                    serviceContext.setAddGroupPermissions(true);
                    serviceContext.setAddGuestPermissions(true);
                    AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchGroupVocabulary(company.getGroupId(), "type");
                    if (assetVocabulary == null) {
                        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper();
                        assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{journalArticleClassNameId, journalFeedClassNameId}, new long[]{-1L, -1L}, new boolean[]{false, false});
                        assetVocabularySettingsHelper.setMultiValued(false);
                        assetVocabulary = this._assetVocabularyLocalService.addVocabulary(userId, company.getGroupId(), "type", this._localization.getLocalizationMap((Collection)this._language.getAvailableLocales(company.getGroupId()), LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)company.getCompanyId())), "type"), Collections.emptyMap(), assetVocabularySettingsHelper.toString(), serviceContext);
                    } else {
                        assetVocabulary = this._updateAssetVocabulary(assetVocabulary, journalFeedClassNameId);
                    }
                    HashMap<String, Long> journalFeedTypesMap = new HashMap<String, Long>();
                    for (String type : journalFeedTypes) {
                        journalFeedTypesMap.put(type, this._getAssetCategoryId(assetVocabulary, type, serviceContext, userId));
                    }
                    this._addJournalFeedAssetEntries(journalFeedClassNameId, company.getCompanyId(), userId, journalFeedTypesMap);
                });
            }
            finally {
                LocaleThreadLocal.setDefaultLocale((Locale)localeThreadLocalDefaultLocale);
            }
        }
    }

    private long _getAssetCategoryId(AssetVocabulary assetVocabulary, String name, ServiceContext serviceContext, long userId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select categoryId from AssetCategory where name = ? and vocabularyId = ?");){
            preparedStatement.setString(1, name);
            preparedStatement.setLong(2, assetVocabulary.getVocabularyId());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong("categoryId");
                    return l;
                }
            }
        }
        AssetCategory assetCategory = this._assetCategoryLocalService.addCategory(userId, assetVocabulary.getGroupId(), name, assetVocabulary.getVocabularyId(), serviceContext);
        return assetCategory.getCategoryId();
    }

    /*
     * Exception decompiling
     */
    private Set<String> _getJournalFeedTypes(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AssetVocabulary _updateAssetVocabulary(AssetVocabulary assetVocabulary, long journalFeedClassNameId) throws Exception {
        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper(assetVocabulary.getSettings());
        long[] selectedClassNameIds = assetVocabularySettingsHelper.getClassNameIds();
        if (ArrayUtil.contains((long[])selectedClassNameIds, (long)0L) || ArrayUtil.contains((long[])selectedClassNameIds, (long)journalFeedClassNameId)) {
            return assetVocabulary;
        }
        long[] requiredClassNameIds = assetVocabularySettingsHelper.getRequiredClassNameIds();
        selectedClassNameIds = ArrayUtil.append((long[])selectedClassNameIds, (long)journalFeedClassNameId);
        boolean[] requireds = new boolean[selectedClassNameIds.length];
        for (int i = 0; i < selectedClassNameIds.length; ++i) {
            requireds[i] = ArrayUtil.contains((long[])requiredClassNameIds, (long)selectedClassNameIds[i]);
        }
        assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(selectedClassNameIds, ArrayUtil.append((long[])assetVocabularySettingsHelper.getClassTypePKs(), (long)-1L), requireds);
        return this._assetVocabularyLocalService.updateVocabulary(assetVocabulary.getVocabularyId(), assetVocabulary.getTitleMap(), assetVocabulary.getDescriptionMap(), assetVocabularySettingsHelper.toString());
    }
}

