/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.journal.exception.ArticleContentException;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XMLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JournalConverter.class})
public class JournalConverterImpl
implements JournalConverter {
    private static final Log _log = LogFactoryUtil.getLog(JournalConverterImpl.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public String getContent(DDMStructure ddmStructure, Fields ddmFields, long groupId) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        rootElement.addAttribute("available-locales", this._getAvailableLocales(ddmFields));
        Locale defaultLocale = ddmFields.getDefaultLocale();
        if (!this._language.isAvailableLocale(groupId, defaultLocale)) {
            defaultLocale = LocaleUtil.getSiteDefault();
        }
        rootElement.addAttribute("default-locale", LocaleUtil.toLanguageId((Locale)defaultLocale));
        rootElement.addAttribute("version", "1.0");
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this._updateDynamicElementElement(ddmFields, ddmFieldsCounter, ddmFormField, rootElement, -1);
        }
        try {
            String content = XMLUtil.stripInvalidChars((String)document.asXML());
            return Dom4jUtil.toString((String)content);
        }
        catch (Exception exception) {
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)exception);
        }
    }

    public Fields getDDMFields(DDMStructure ddmStructure, String content) throws PortalException {
        try {
            Document document = SAXReaderUtil.read((String)content);
            Fields ddmFields = new Fields();
            ddmFields.put(new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)"")));
            DDMForm ddmForm = ddmStructure.getDDMForm();
            Element rootElement = document.getRootElement();
            String[] availableLanguageIds = StringUtil.split((String)rootElement.attributeValue("available-locales"));
            String defaultLanguageId = rootElement.attributeValue("default-locale");
            for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                this._addDDMFields(availableLanguageIds, defaultLanguageId, ddmFields, ddmFormField, ddmStructure, rootElement);
            }
            return ddmFields;
        }
        catch (DocumentException documentException) {
            throw new PortalException((Throwable)documentException);
        }
    }

    private void _addDDMFields(String[] availableLanguageIds, String defaultLanguageId, Fields ddmFields, DDMFormField ddmFormField, DDMStructure ddmStructure, Element element) throws PortalException {
        List<Element> dynamicElementElements = this._getDynamicElementElements(element, ddmFormField.getName());
        if (dynamicElementElements == null) {
            if (Objects.equals(ddmFormField.getType(), "fieldset")) {
                this._updateFieldsDisplay(ddmFields, ddmFormField.getName(), String.valueOf(ddmStructure.getStructureId()));
            }
            this._addNestedDDMFields(availableLanguageIds, defaultLanguageId, ddmFields, ddmFormField, ddmStructure, element);
            return;
        }
        for (Element dynamicElementElement : dynamicElementElements) {
            if (!ddmFormField.isTransient()) {
                Field ddmField = this._getField(dynamicElementElement, ddmStructure, availableLanguageIds, defaultLanguageId);
                String fieldName = ddmField.getName();
                Field existingDDMField = ddmFields.get(fieldName);
                if (existingDDMField != null) {
                    for (Locale locale : ddmField.getAvailableLocales()) {
                        existingDDMField.addValues(locale, ddmField.getValues(locale));
                    }
                } else {
                    ddmFields.put(ddmField);
                }
            }
            this._updateFieldsDisplay(ddmFields, ddmFormField.getName(), dynamicElementElement.attributeValue("instance-id"));
            this._addNestedDDMFields(availableLanguageIds, defaultLanguageId, ddmFields, ddmFormField, ddmStructure, dynamicElementElement);
        }
    }

    private void _addMissingFieldValues(Field ddmField, String defaultLanguageId, Set<String> missingLanguageIds) {
        if (missingLanguageIds.isEmpty()) {
            return;
        }
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        Serializable fieldValue = ddmField.getValue(defaultLocale);
        for (String missingLanguageId : missingLanguageIds) {
            Locale missingLocale = LocaleUtil.fromLanguageId((String)missingLanguageId);
            ddmField.setValue(missingLocale, fieldValue);
        }
    }

    private void _addNestedDDMFields(String[] availableLanguageIds, String defaultLanguageId, Fields ddmFields, DDMFormField ddmFormField, DDMStructure ddmStructure, Element element) throws PortalException {
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this._addDDMFields(availableLanguageIds, defaultLanguageId, ddmFields, nestedDDMFormField, ddmStructure, element);
        }
    }

    private int _countFieldRepetition(Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws Exception {
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String[] fieldsDisplayValues = this._getDDMFieldsDisplayValues(fieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        for (String fieldDisplayName : fieldsDisplayValues) {
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
            ++repetitions;
        }
        return repetitions;
    }

    private String _getAvailableLocales(Fields ddmFields) {
        Set availableLocales = ddmFields.getAvailableLocales();
        Locale[] availableLocalesArray = new Locale[availableLocales.size()];
        availableLocalesArray = availableLocales.toArray(availableLocalesArray);
        Object[] languageIds = LocaleUtil.toLanguageIds((Locale[])availableLocalesArray);
        return StringUtil.merge((Object[])languageIds);
    }

    private Serializable _getCheckboxMultipleValue(DDMFormField ddmFormField, Element dynamicContentElement) {
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("options");
        Map options = ddmFormFieldOptions.getOptions();
        if (options.size() == 1) {
            if (GetterUtil.getBoolean((String)dynamicContentElement.getText())) {
                Set entrySet = options.entrySet();
                Iterator iterator = entrySet.iterator();
                Map.Entry entry = iterator.next();
                return JSONUtil.putAll((Object[])new Object[]{entry.getKey()}).toString();
            }
            return "";
        }
        return FieldConstants.getSerializable((String)ddmFormField.getDataType(), (String)dynamicContentElement.getText());
    }

    private String[] _getDDMFieldsDisplayValues(Field ddmFieldsDisplayField) throws Exception {
        try {
            String[] values;
            DDMStructure ddmStructure = ddmFieldsDisplayField.getDDMStructure();
            ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
            for (String value : values = this._splitFieldsDisplayValue(ddmFieldsDisplayField)) {
                String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
                if (!ddmStructure.hasField(fieldName)) continue;
                fieldsDisplayValues.add(fieldName);
            }
            return fieldsDisplayValues.toArray(new String[0]);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private List<Element> _getDynamicElementElements(Element element, String name) {
        Element parentElement = this._getParentElement(element, name);
        if (parentElement == null) {
            return null;
        }
        ArrayList<Element> dynamicElementElements = null;
        for (Element dynamicElement : parentElement.elements("dynamic-element")) {
            if (!Objects.equals(dynamicElement.attributeValue("name"), name)) continue;
            if (dynamicElementElements == null) {
                dynamicElementElements = new ArrayList<Element>();
            }
            dynamicElementElements.add(dynamicElement);
        }
        return dynamicElementElements;
    }

    private Field _getField(Element dynamicElementElement, DDMStructure ddmStructure, String[] availableLanguageIds, String defaultLanguageId) throws PortalException {
        Field ddmField = new Field();
        ddmField.setDDMStructureId(ddmStructure.getStructureId());
        Locale defaultLocale = null;
        defaultLocale = defaultLanguageId == null ? LocaleUtil.getSiteDefault() : LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmField.setDefaultLocale(defaultLocale);
        String name = dynamicElementElement.attributeValue("name");
        if (!GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(name, "localizable"))) {
            availableLanguageIds = StringPool.EMPTY_ARRAY;
        }
        ddmField.setName(name);
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(name);
        Set missingLanguageIds = SetUtil.fromArray((Object[])availableLanguageIds);
        missingLanguageIds.remove(defaultLanguageId);
        List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            Locale locale = defaultLocale;
            String languageId = dynamicContentElement.attributeValue("language-id");
            if (Validator.isNotNull((String)languageId)) {
                locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false);
                if (locale == null) continue;
                missingLanguageIds.remove(languageId);
            }
            Serializable serializable = this._getFieldValue(ddmFormField, dynamicContentElement);
            ddmField.addValue(locale, serializable);
        }
        this._addMissingFieldValues(ddmField, defaultLanguageId, missingLanguageIds);
        return ddmField;
    }

    private String _getFieldInstanceId(Fields ddmFields, String fieldName, int index) {
        String[] fieldsDisplayValues;
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String prefix = fieldName.concat("_INSTANCE_");
        for (String fieldsDisplayValue : fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())))) {
            if (!fieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    private Serializable _getFieldValue(DDMFormField ddmFormField, Element dynamicContentElement) {
        if (Objects.equals("checkbox_multiple", ddmFormField.getType())) {
            return this._getCheckboxMultipleValue(ddmFormField, dynamicContentElement);
        }
        if (Objects.equals("select", ddmFormField.getType())) {
            return this._getSelectValue(dynamicContentElement);
        }
        String value = dynamicContentElement.getText();
        return FieldConstants.getSerializable((Locale)LocaleUtil.ROOT, (Locale)LocaleUtil.fromLanguageId((String)dynamicContentElement.attributeValue("language-id")), (String)ddmFormField.getDataType(), (String)value.trim());
    }

    private Element _getParentElement(Element element, String name) {
        for (Element dynamicElement : element.elements("dynamic-element")) {
            if (Objects.equals(dynamicElement.attributeValue("name"), name)) {
                return element;
            }
            Element parentElement = this._getParentElement(dynamicElement, name);
            if (parentElement == null) continue;
            return parentElement;
        }
        return null;
    }

    private String _getSelectValue(Element dynamicContentElement) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        List optionElements = dynamicContentElement.elements("option");
        if (!optionElements.isEmpty()) {
            for (Element optionElement : optionElements) {
                jsonArray.put(optionElement.getText());
            }
        } else {
            jsonArray.put(dynamicContentElement.getText());
        }
        return jsonArray.toString();
    }

    private String[] _splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }

    private void _updateContentDynamicElement(int count, DDMFormField ddmFormField, Element dynamicElementElement, Field field) {
        for (Locale locale : field.getAvailableLocales()) {
            String valueString;
            Serializable fieldValue = field.getValue(locale, count);
            if (fieldValue == null) {
                fieldValue = field.getValue(field.getDefaultLocale(), count);
            }
            if (StringUtil.equals((String)(valueString = String.valueOf(fieldValue)), (String)"_FIELD_EMPTY_VALUE_")) continue;
            Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
            dynamicContentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)locale));
            this._updateDynamicContentValue(ddmFormField, dynamicContentElement, ddmFormField.getName(), ddmFormField.getType(), valueString.trim(), ddmFormField.isMultiple());
        }
    }

    private void _updateDynamicContentValue(DDMFormField ddmFormField, Element dynamicContentElement, String fieldName, String fieldType, String fieldValue, boolean multiple) {
        if (Objects.equals("checkbox_multiple", fieldType)) {
            block13: {
                try {
                    DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("options");
                    Map options = ddmFormFieldOptions.getOptions();
                    if (options.size() > 1) {
                        dynamicContentElement.addCDATA(fieldValue);
                        return;
                    }
                    JSONArray fieldValueJSONArray = this._jsonFactory.createJSONArray(fieldValue);
                    fieldValue = fieldValueJSONArray.length() == 1 ? Boolean.TRUE.toString() : "";
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block13;
                    _log.debug((Object)("Unable to get dynamic data mapping form field for " + fieldName), (Throwable)portalException);
                }
            }
            dynamicContentElement.addCDATA(fieldValue);
        } else if (Objects.equals("select", fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONArray jsonArray = null;
            try {
                jsonArray = this._jsonFactory.createJSONArray(fieldValue);
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to parse object", (Throwable)jsonException);
                }
                return;
            }
            if (multiple) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Element optionElement = dynamicContentElement.addElement("option");
                    optionElement.addCDATA(jsonArray.getString(i));
                }
            } else {
                dynamicContentElement.addCDATA(jsonArray.getString(0));
            }
        } else {
            dynamicContentElement.addCDATA(fieldValue);
        }
    }

    private void _updateDynamicElementElement(Fields ddmFields, DDMFieldsCounter ddmFieldsCounter, DDMFormField ddmFormField, Element dynamicElementElement, int parentOffset) throws Exception {
        String fieldName = ddmFormField.getName();
        int count = ddmFieldsCounter.get((Object)fieldName);
        int repetitions = this._countFieldRepetition(ddmFields, fieldName, dynamicElementElement.attributeValue("name"), parentOffset);
        for (int i = 0; i < repetitions; ++i) {
            Element childDynamicElementElement = dynamicElementElement.addElement("dynamic-element");
            childDynamicElementElement.addAttribute("field-reference", ddmFormField.getFieldReference());
            childDynamicElementElement.addAttribute("index-type", ddmFormField.getIndexType());
            childDynamicElementElement.addAttribute("instance-id", this._getFieldInstanceId(ddmFields, fieldName, count + i));
            childDynamicElementElement.addAttribute("name", fieldName);
            childDynamicElementElement.addAttribute("type", ddmFormField.getType());
            List nestedDDMFormFields = ddmFormField.getNestedDDMFormFields();
            Field field = ddmFields.get(fieldName);
            if (!Objects.equals(ddmFormField.getType(), "fieldset") && !ddmFormField.isTransient() && field != null) {
                this._updateContentDynamicElement(ddmFieldsCounter.get((Object)fieldName), ddmFormField, childDynamicElementElement, field);
            } else if (ListUtil.isNotEmpty((List)nestedDDMFormFields)) {
                for (DDMFormField nestedDDMFormField : nestedDDMFormFields) {
                    this._updateDynamicElementElement(ddmFields, ddmFieldsCounter, nestedDDMFormField, childDynamicElementElement, count + i);
                }
            }
            ddmFieldsCounter.incrementKey((Object)fieldName);
        }
    }

    private void _updateFieldsDisplay(Fields ddmFields, String fieldName, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            instanceId = StringUtil.randomString();
        }
        String fieldsDisplayValue = StringBundler.concat((String[])new String[]{fieldName, "_INSTANCE_", instanceId});
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldsDisplayValue);
        fieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }
}

