/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.ThemeDisplayModel;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class JournalUtil {
    public static final String[] SELECTED_FIELD_NAMES = new String[]{"articleId", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(JournalUtil.class);
    private static Map<String, String> _customTokens;

    public static String getJournalControlPanelLink(long folderId, long groupId, LiferayPortletResponse liferayPortletResponse) {
        if (liferayPortletResponse != null) {
            return PortletURLBuilder.createRenderURL((LiferayPortletResponse)liferayPortletResponse).setParameter("folderId", (Object)folderId).setParameter("groupId", (Object)groupId).buildString();
        }
        try {
            String articleURL = PortalUtil.getControlPanelFullURL((long)groupId, (String)PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT), null);
            String namespace = PortalUtil.getPortletNamespace((String)"com_liferay_journal_web_portlet_JournalPortlet");
            articleURL = HttpComponentsUtil.addParameter((String)articleURL, (String)(namespace + "groupId"), (long)groupId);
            return HttpComponentsUtil.addParameter((String)articleURL, (String)(namespace + "folderId"), (long)folderId);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return "";
        }
    }

    public static String getJournalControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException {
        return PortletURLBuilder.create((PortletURL)PortletProviderUtil.getPortletURL((PortletRequest)portletRequest, (String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT)).setParameter("folderId", (Object)folderId).buildString();
    }

    public static Map<String, String> getTokens(JournalArticle article, DDMTemplate ddmTemplate, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        Group companyGroup;
        DDMStructure ddmStructure = article.getDDMStructure();
        HashMap tokens = HashMapBuilder.put((Object)"class_name_id", (Object)String.valueOf(ClassNameLocalServiceUtil.getClassNameId(DDMStructure.class))).put((Object)"article_resource_pk", (Object)String.valueOf(article.getResourcePrimKey())).put((Object)"ddm_structure_id", (Object)String.valueOf(ddmStructure.getStructureId())).put((Object)"ddm_structure_key", (Object)ddmStructure.getStructureKey()).build();
        if (ddmTemplate != null) {
            tokens.put("ddm_template_id", String.valueOf(ddmTemplate.getTemplateId()));
            tokens.put("ddm_template_key", String.valueOf(ddmTemplate.getTemplateKey()));
            companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)article.getCompanyId());
            if (companyGroup.getGroupId() == ddmTemplate.getGroupId()) {
                tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
            }
        }
        if (themeDisplay != null) {
            JournalUtil._populateTokens((Map<String, String>)tokens, article.getGroupId(), themeDisplay);
        } else if (portletRequestModel != null) {
            ThemeDisplayModel themeDisplayModel = portletRequestModel.getThemeDisplayModel();
            if (themeDisplayModel != null) {
                try {
                    JournalUtil._populateTokens((Map<String, String>)tokens, article.getGroupId(), themeDisplayModel);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)exception);
                    }
                }
            }
        } else {
            tokens.put("company_id", String.valueOf(article.getCompanyId()));
            companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)article.getCompanyId());
            tokens.put("article_group_id", String.valueOf(article.getGroupId()));
            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
        }
        return tokens;
    }

    public static String getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)title);
        return ModelHintsUtil.trimString((String)JournalArticle.class.getName(), (String)"urlTitle", (String)title);
    }

    public static boolean isHead(JournalArticle article) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int[])new int[]{0, 8});
        if (latestArticle != null && !latestArticle.isIndexable()) {
            return false;
        }
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    public static boolean isHeadListable(JournalArticle article) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int[])new int[]{0, 8, 7});
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    public static boolean isLatestArticle(JournalArticle article) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int)-1, (boolean)false);
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    private static String _getCustomTokenValue(String tokenName, JournalServiceConfiguration journalServiceConfiguration) {
        for (String tokenValue : journalServiceConfiguration.customTokenValues()) {
            String[] tokenValueParts = tokenValue.split("\\=");
            if (tokenValueParts.length != 2 || !tokenValueParts[0].equals(tokenName)) continue;
            return tokenValueParts[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void _populateCustomTokens(Map<String, String> tokens, long companyId) {
        JournalServiceConfiguration journalServiceConfiguration = null;
        try {
            journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)companyId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (journalServiceConfiguration == null) {
            return;
        }
        if (MapUtil.isEmpty(_customTokens)) {
            Class<JournalUtil> clazz = JournalUtil.class;
            // MONITORENTER : com.liferay.journal.internal.util.JournalUtil.class
            _customTokens = new HashMap<String, String>();
            for (String tokenName : journalServiceConfiguration.customTokenNames()) {
                String tokenValue = JournalUtil._getCustomTokenValue(tokenName, journalServiceConfiguration);
                if (Validator.isNull((String)tokenValue)) continue;
                _customTokens.put(tokenName, tokenValue);
            }
            // MONITOREXIT : clazz
        }
        if (_customTokens.isEmpty()) return;
        tokens.putAll(_customTokens);
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplay.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplay.getPathFriendlyURLPrivateUser() : themeDisplay.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplay.getI18nPath();
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (virtualHostnames.isEmpty() || !virtualHostnames.containsKey(themeDisplay.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplay.getCDNHost());
        tokens.put("company_id", String.valueOf(themeDisplay.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplay.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplay.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplay.getPathMain());
        tokens.put("portal_ctx", themeDisplay.getPathContext());
        tokens.put("portal_url", HttpComponentsUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("protocol", HttpComponentsUtil.getProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("root_path", themeDisplay.getPathContext());
        tokens.put("scope_group_id", String.valueOf(themeDisplay.getScopeGroupId()));
        tokens.put("site_group_id", String.valueOf(themeDisplay.getSiteGroupId()));
        tokens.put("theme_image_path", themeDisplay.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens, themeDisplay.getCompanyId());
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplayModel themeDisplayModel) throws Exception {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplayModel.getPlid());
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplayModel.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplayModel.getPathFriendlyURLPrivateUser() : themeDisplayModel.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplayModel.getI18nPath();
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (virtualHostnames.isEmpty() || !virtualHostnames.containsKey(themeDisplayModel.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplayModel.getCdnHost());
        tokens.put("company_id", String.valueOf(themeDisplayModel.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplayModel.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplayModel.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplayModel.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplayModel.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplayModel.getPathMain());
        tokens.put("portal_ctx", themeDisplayModel.getPathContext());
        tokens.put("portal_url", HttpComponentsUtil.removeProtocol((String)themeDisplayModel.getURLPortal()));
        tokens.put("protocol", HttpComponentsUtil.getProtocol((String)themeDisplayModel.getURLPortal()));
        tokens.put("root_path", themeDisplayModel.getPathContext());
        tokens.put("scope_group_id", String.valueOf(themeDisplayModel.getScopeGroupId()));
        tokens.put("theme_image_path", themeDisplayModel.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens, themeDisplayModel.getCompanyId());
    }
}

