/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.validation;

import com.liferay.depot.group.provider.SiteConnectedGroupGroupProvider;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldNameException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldRequiredException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.ExportImportContentProcessorRegistryUtil;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.configuration.JournalFileUploadsConfiguration;
import com.liferay.journal.exception.ArticleContentException;
import com.liferay.journal.exception.ArticleExpirationDateException;
import com.liferay.journal.exception.ArticleIdException;
import com.liferay.journal.exception.ArticleSmallImageNameException;
import com.liferay.journal.exception.ArticleSmallImageSizeException;
import com.liferay.journal.exception.ArticleTitleException;
import com.liferay.journal.exception.DuplicateArticleExternalReferenceCodeException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.InvalidDDMStructureException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleLocalization;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.service.persistence.JournalArticlePersistence;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.JournalHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.validation.ModelValidationResults;
import com.liferay.portal.validation.ModelValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ModelValidator.class})
public class JournalArticleModelValidator
implements ModelValidator<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleModelValidator.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticlePersistence _journalArticlePersistence;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JournalFileUploadsConfiguration _journalFileUploadsConfiguration;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private JournalHelper _journalHelper;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private SiteConnectedGroupGroupProvider _siteConnectedGroupGroupProvider;

    public void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        DDMTemplate ddmTemplate;
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)this._localization.getDefaultLanguageId(content));
        if (!ExportImportThreadLocal.isImportInProcess()) {
            if (!this._language.isAvailableLocale(groupId, articleDefaultLocale)) {
                LocaleException localeException = new LocaleException(3, StringBundler.concat((Object[])new Object[]{"The locale ", articleDefaultLocale.getLanguage(), " is not available in site with groupId", groupId}));
                localeException.setSourceAvailableLocales(Collections.singleton(articleDefaultLocale));
                localeException.setTargetAvailableLocales((Collection)this._language.getAvailableLocales(groupId));
                throw localeException;
            }
            if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
                throw new ArticleExpirationDateException("Expiration date " + expirationDate + " is in the past");
            }
        }
        if (classNameId == 0L && (titleMap.isEmpty() || Validator.isNull((String)titleMap.get(articleDefaultLocale)))) {
            throw new ArticleTitleException("Title is null");
        }
        int titleMaxLength = ModelHintsUtil.getMaxLength((String)JournalArticleLocalization.class.getName(), (String)"title");
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            String title = entry.getValue();
            if (Validator.isNull((String)title) || title.length() <= titleMaxLength) continue;
            throw new ArticleTitleException.MustNotExceedMaximumLength(title, titleMaxLength);
        }
        this.validateContent(content);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            this.validateDDMStructureFields(ddmStructure, classNameId, content, articleDefaultLocale);
        }
        if (Validator.isNotNull((String)ddmTemplateKey) && (ddmTemplate = this._ddmTemplateLocalService.getTemplate(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true)).getClassPK() != ddmStructure.getStructureId()) {
            throw new NoSuchTemplateException("{templateKey=" + ddmTemplateKey + "}");
        }
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        boolean validSmallImageExtension = false;
        for (String imageExtension : this._journalFileUploadsConfiguration.imageExtensions()) {
            if (!"*".equals(imageExtension) && !StringUtil.endsWith((String)smallImageName, (String)imageExtension)) continue;
            validSmallImageExtension = true;
            break;
        }
        if (!validSmallImageExtension) {
            throw new ArticleSmallImageNameException("Invalid image extension " + FileUtil.getExtension((String)smallImageName));
        }
        long smallImageMaxSize = this._journalFileUploadsConfiguration.smallImageMaxSize();
        if (smallImageMaxSize > 0L && (long)smallImageBytes.length > smallImageMaxSize) {
            throw new ArticleSmallImageSizeException(smallImageBytes.length + " exceeds " + smallImageMaxSize);
        }
    }

    public void validate(String articleId) throws PortalException {
        if (Validator.isNull((String)articleId) || articleId.indexOf(44) != -1 || articleId.indexOf(32) != -1) {
            throw new ArticleIdException("Invalid article ID: " + articleId);
        }
    }

    public void validate(String externalReferenceCode, long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        List articles;
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        if (!autoArticleId) {
            this.validate(articleId);
        }
        if (!(ExportImportThreadLocal.isImportInProcess() && !autoArticleId || (articles = this._journalArticlePersistence.findByG_A(groupId, articleId)).isEmpty())) {
            throw new DuplicateArticleIdException(StringBundler.concat((Object[])new Object[]{"{groupId=", groupId, ", articleId=", articleId, ", version=", version, "}"}));
        }
        this.validate(companyId, groupId, classNameId, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    public void validateContent(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new ArticleContentException("Content is null");
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (DocumentException documentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid content:\n" + content));
            }
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)documentException);
        }
    }

    public void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, Fields fields, Locale defaultlocale) throws PortalException {
        for (Field field : fields) {
            if (!ddmStructure.hasField(field.getName())) {
                throw new StorageFieldNameException("No field exists for {name=" + field.getName() + "}");
            }
            if (!ddmStructure.getFieldRequired(field.getName()) || !Validator.isNull((Object)field.getValue(defaultlocale)) || classNameId != 0L) continue;
            throw new StorageFieldRequiredException(StringBundler.concat((Object[])new Object[]{"Required field ", field.getName(), " is not present for structure ", ddmStructure.getNameCurrentValue(), " for locale ", defaultlocale}));
        }
    }

    public void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, String content, Locale defaultlocale) throws PortalException {
        Fields fields = this._journalConverter.getDDMFields(ddmStructure, content);
        this.validateDDMStructureFields(ddmStructure, classNameId, fields, defaultlocale);
    }

    public void validateDDMStructureId(long groupId, long folderId, String ddmStructureKey) throws PortalException {
        int restrictionType = this._journalHelper.getRestrictionType(folderId);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        List folderDDMStructures = this._journalFolderLocalService.getDDMStructures(this._siteConnectedGroupGroupProvider.getCurrentAndAncestorSiteAndDepotGroupIds(groupId, true), folderId, restrictionType);
        for (DDMStructure folderDDMStructure : folderDDMStructures) {
            if (folderDDMStructure.getStructureId() != ddmStructure.getStructureId()) continue;
            return;
        }
        throw new InvalidDDMStructureException(StringBundler.concat((Object[])new Object[]{"Invalid structure ", ddmStructure.getStructureId(), " for folder ", folderId}));
    }

    public ModelValidationResults validateModel(JournalArticle article) {
        ServiceContext serviceContext;
        Image image;
        String ddmStructureKey = article.getDDMStructureKey();
        String ddmTemplateKey = article.getDDMTemplateKey();
        boolean smallImage = article.isSmallImage();
        String smallImageURL = article.getSmallImageURL();
        byte[] smallImageBytes = null;
        File smallImageFile = null;
        if (smallImage && (image = this._imageLocalService.fetchImage(article.getSmallImageId())) != null && (smallImageBytes = image.getTextObj()) != null) {
            try {
                smallImageFile = FileUtil.createTempFile((String)image.getType());
                FileUtil.write((File)smallImageFile, (byte[])smallImageBytes, (boolean)false);
            }
            catch (IOException ioException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)ioException);
                }
                smallImageBytes = null;
            }
        }
        if ((serviceContext = ServiceContextThreadLocal.getServiceContext()) == null) {
            serviceContext = new ServiceContext();
        }
        String content = article.getContent();
        try {
            this.validate(article.getCompanyId(), article.getGroupId(), article.getClassNameId(), article.getTitleMap(), content, ddmStructureKey, ddmTemplateKey, article.getDisplayDate(), article.getExpirationDate(), smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        }
        catch (PortalException portalException) {
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(portalException.getMessage(), (Throwable)portalException).getResults();
        }
        try {
            this.validateReferences(article.getGroupId(), ddmStructureKey, ddmTemplateKey, article.getLayoutUuid(), smallImage, smallImageURL, smallImageBytes, article.getSmallImageId(), content);
        }
        catch (ExportImportContentValidationException exportImportContentValidationException) {
            exportImportContentValidationException.setStagedModelClassName(JournalArticle.class.getName());
            exportImportContentValidationException.setStagedModelPrimaryKeyObj((Serializable)((Object)article.getArticleId()));
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(exportImportContentValidationException.getMessage(), (Throwable)exportImportContentValidationException).getResults();
        }
        catch (PortalException portalException) {
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(portalException.getMessage(), (Throwable)portalException).getResults();
        }
        return ModelValidationResults.success();
    }

    public void validateReferences(long groupId, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean smallImage, String smallImageURL, byte[] smallImageBytes, long smallImageId, String content) throws PortalException {
        DDMTemplate ddmTemplate;
        DDMStructure ddmStructure;
        if (Validator.isNotNull((String)ddmStructureKey) && (ddmStructure = this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(JournalArticle.class.getName()), ddmStructureKey, true)) == null) {
            throw new NoSuchStructureException();
        }
        if (Validator.isNotNull((String)ddmTemplateKey) && (ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(DDMStructure.class.getName()), ddmTemplateKey, true)) == null) {
            throw new NoSuchTemplateException();
        }
        if (smallImage && Validator.isNull((String)smallImageURL) && ArrayUtil.isEmpty((byte[])smallImageBytes)) {
            Image image = this._imageLocalService.fetchImage(smallImageId);
            if (image != null) {
                smallImageBytes = image.getTextObj();
            }
            if (image == null || smallImageBytes == null) {
                throw new NoSuchImageException("Small image ID " + smallImageId);
            }
        }
        ExportImportContentProcessor exportImportContentProcessor = ExportImportContentProcessorRegistryUtil.getExportImportContentProcessor((String)JournalArticle.class.getName());
        exportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        List articles = this._journalArticlePersistence.findByG_ERC(groupId, externalReferenceCode);
        if (!articles.isEmpty()) {
            throw new DuplicateArticleExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate journal article external reference code ", externalReferenceCode, "in group ", groupId}));
        }
    }
}

