/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.validation;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureModel;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.exception.DuplicateFolderNameException;
import com.liferay.journal.exception.InvalidDDMStructureException;
import com.liferay.journal.exception.InvalidFolderException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.service.persistence.JournalFolderPersistence;
import com.liferay.journal.util.JournalValidator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.validation.ModelValidationResults;
import com.liferay.portal.validation.ModelValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFolder"}, service={ModelValidator.class})
public class JournalFolderModelValidator
implements ModelValidator<JournalFolder> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private JournalFolderPersistence _journalFolderPersistence;
    @Reference
    private JournalValidator _journalValidator;
    @Reference
    private Portal _portal;

    public void validateArticleDDMStructures(long folderId, long[] ddmStructureIds) throws PortalException {
        List folders;
        if (ArrayUtil.isEmpty((long[])ddmStructureIds)) {
            return;
        }
        JournalFolder folder = this._journalFolderPersistence.findByPrimaryKey(folderId);
        List articles = this._journalArticleLocalService.getArticles(folder.getGroupId(), folderId);
        if (!articles.isEmpty()) {
            long classNameId = this._classNameLocalService.getClassNameId(JournalArticle.class);
            for (JournalArticle article : articles) {
                DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(article.getGroupId(), classNameId, article.getDDMStructureKey(), true);
                if (ddmStructure == null) {
                    throw new InvalidDDMStructureException(StringBundler.concat((Object[])new Object[]{"No DDM structure exists for group ", article.getGroupId(), ", class name ", classNameId, ", and structure key ", article.getDDMStructureKey(), " that includes ancestor structures"}));
                }
                if (ArrayUtil.contains((long[])ddmStructureIds, (long)ddmStructure.getStructureId())) continue;
                throw new InvalidDDMStructureException("Invalid DDM structure " + ddmStructure.getStructureId());
            }
        }
        if ((folders = this._journalFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId())).isEmpty()) {
            return;
        }
        for (JournalFolder curFolder : folders) {
            if (curFolder.getRestrictionType() == 1) continue;
            this.validateArticleDDMStructures(curFolder.getFolderId(), ddmStructureIds);
        }
    }

    public void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException {
        this._journalValidator.validateFolderName(name);
        JournalFolder folder = this._journalFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
        if (folder != null && folder.getFolderId() != folderId) {
            throw new DuplicateFolderNameException(name);
        }
    }

    public void validateFolderDDMStructures(long folderId, long parentFolderId) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.fetchFolder(folderId);
        int restrictionType = 1;
        JournalFolder parentFolder = this._journalFolderLocalService.fetchFolder(parentFolderId);
        if (parentFolder != null) {
            restrictionType = parentFolder.getRestrictionType();
        }
        this.validateArticleDDMStructures(folderId, TransformUtil.transformToLongArray((Collection)this._journalFolderLocalService.getDDMStructures(this._portal.getCurrentAndAncestorSiteGroupIds(folder.getGroupId()), parentFolderId, restrictionType), DDMStructureModel::getStructureId));
    }

    public ModelValidationResults validateModel(JournalFolder folder) {
        long[] ddmStructureIds = null;
        try {
            ddmStructureIds = TransformUtil.transformToLongArray((Collection)this._journalFolderLocalService.getDDMStructures(new long[]{folder.getGroupId()}, folder.getFolderId(), folder.getRestrictionType()), DDMStructureModel::getStructureId);
        }
        catch (PortalException portalException) {
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure("Unable to retrieve folder structures for validation: " + portalException.getMessage(), (Throwable)portalException).getResults();
        }
        long folderId = folder.getFolderId();
        try {
            this.validateArticleDDMStructures(folderId, ddmStructureIds);
            this.validateFolder(folderId, folder.getGroupId(), folder.getParentFolderId(), folder.getName());
        }
        catch (PortalException portalException) {
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(portalException.getMessage(), (Throwable)portalException).getResults();
        }
        return ModelValidationResults.success();
    }

    public void validateParentFolder(JournalFolder folder, long parentFolderId) throws PortalException {
        if (parentFolderId == 0L) {
            return;
        }
        if (folder.getFolderId() == parentFolderId) {
            throw new InvalidFolderException(folder, 2);
        }
        JournalFolder parentFolder = this._journalFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null) {
            throw new InvalidFolderException(4);
        }
        if (folder.getGroupId() != parentFolder.getGroupId()) {
            throw new InvalidFolderException(3);
        }
        ArrayList subfolderIds = new ArrayList();
        this._journalFolderLocalService.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            throw new InvalidFolderException(folder, 1);
        }
    }
}

