/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.workflow;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={WorkflowHandler.class})
public class JournalArticleWorkflowHandler
extends BaseWorkflowHandler<JournalArticle> {
    private static final boolean _VISIBLE = true;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getArticle(classPK);
        long folderId = this._journalFolderLocalService.getInheritedWorkflowFolderId(article.getFolderId());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(article.getGroupId()), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, JournalFolder.class.getName(), folderId, ddmStructure.getStructureId(), true);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, JournalFolder.class.getName(), folderId, -1L, true);
        }
        if (workflowDefinitionLink != null) {
            return workflowDefinitionLink;
        }
        if (folderId == 0L) {
            return super.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        JournalFolder folder = this._journalFolderLocalService.fetchFolder(folderId);
        if (folder != null && folder.getRestrictionType() == 0) {
            return super.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        return null;
    }

    public boolean isVisible() {
        return true;
    }

    public JournalArticle updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        JournalArticle article = this._journalArticleLocalService.getArticle(classPK);
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        String articleURL = this._portal.getControlPanelFullURL(serviceContext.getScopeGroupId(), PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT), null);
        return this._journalArticleLocalService.updateStatus(userId, article, status, articleURL, serviceContext, workflowContext);
    }
}

