/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalServiceUtil;
import com.liferay.journal.internal.transformer.LocaleTransformerListener;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalArticleBaseImpl;
import com.liferay.journal.model.impl.JournalFolderImpl;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

@JSON(strict=true)
public class JournalArticleImpl
extends JournalArticleBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleImpl.class);
    private static volatile DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private static volatile JournalConverter _journalConverter;
    private static volatile LocaleTransformerListener _localeTransformerListener;
    private Map<Locale, String> _descriptionMap;
    private Document _document;
    private long _imagesFolderId;
    private String _smallImageType;
    private Map<Locale, String> _titleMap;

    public static String getContentByLocale(Document document, String languageId) {
        return JournalArticleImpl.getContentByLocale(document, languageId, null);
    }

    public static String getContentByLocale(Document document, String languageId, Map<String, String> tokens) {
        if (_localeTransformerListener != null) {
            document = _localeTransformerListener.onXml(document.clone(), languageId, tokens);
        }
        return document.asXML();
    }

    public static void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        _ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    public static void setJournalConverter(JournalConverter journalConverter) {
        _journalConverter = journalConverter;
    }

    public static void setLocaleTransformerListener(LocaleTransformerListener localeTransformerListener) {
        _localeTransformerListener = localeTransformerListener;
    }

    public Folder addImagesFolder() throws PortalException {
        if (this._imagesFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFolder((long)this._imagesFolderId);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)this.getGroupId(), (String)"com.liferay.journal", (ServiceContext)serviceContext);
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)PortalUtil.getValidUserId((long)this.getCompanyId(), (long)this.getUserId()), (long)repository.getRepositoryId(), (long)0L, (String)String.valueOf(this.getResourcePrimKey()), (ServiceContext)serviceContext);
        this._imagesFolderId = folder.getFolderId();
        return folder;
    }

    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        JournalFolder folder = this.getFolder();
        return folder.buildTreePath();
    }

    @Override
    public Object clone() {
        JournalArticleImpl journalArticleImpl = (JournalArticleImpl)((Object)super.clone());
        journalArticleImpl.setDescriptionMap(this.getDescriptionMap());
        journalArticleImpl.setTitleMap(this.getTitleMap());
        return journalArticleImpl;
    }

    public String getArticleImageURL(ThemeDisplay themeDisplay) {
        if (!this.isSmallImage()) {
            return null;
        }
        if (Validator.isNotNull((String)this.getSmallImageURL())) {
            return this.getSmallImageURL();
        }
        return StringBundler.concat((Object[])new Object[]{themeDisplay.getPathImage(), "/journal/article?img_id=", this.getSmallImageId(), "&t=", WebServerServletTokenUtil.getToken((long)this.getSmallImageId())});
    }

    public JournalArticleResource getArticleResource() throws PortalException {
        return JournalArticleResourceLocalServiceUtil.getArticleResource((long)this.getResourcePrimKey());
    }

    public String getArticleResourceUuid() throws PortalException {
        JournalArticleResource articleResource = this.getArticleResource();
        return articleResource.getUuid();
    }

    public String[] getAvailableLanguageIds() {
        TreeSet<String> availableLanguageIds = new TreeSet<String>();
        availableLanguageIds.addAll(JournalArticleLocalServiceUtil.getArticleLocalizationLanguageIds((long)this.getId()));
        DDMFormValues ddmFormValues = this.getDDMFormValues();
        if (ddmFormValues != null) {
            for (Locale availableLocale : ddmFormValues.getAvailableLocales()) {
                availableLanguageIds.add(LocaleUtil.toLanguageId((Locale)availableLocale));
            }
        }
        return availableLanguageIds.toArray(new String[0]);
    }

    @JSON
    public String getContent() {
        String content;
        block4: {
            content = null;
            DDMStructure ddmStructure = this.getDDMStructure();
            if (ddmStructure == null) {
                return content;
            }
            DDMFormValues ddmFormValues = DDMFieldLocalServiceUtil.getDDMFormValues((DDMForm)ddmStructure.getDDMForm(), (long)this.getId());
            if (ddmFormValues != null) {
                try {
                    Fields fields = _ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
                    content = _journalConverter.getContent(ddmStructure, fields, this.getGroupId());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Throwable)exception);
                }
            }
        }
        return content;
    }

    public String getContentByLocale(String languageId) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        DDMStructure ddmStructure = this.getDDMStructure();
        if (ddmStructure != null) {
            tokens.put("ddm_structure_id", String.valueOf(ddmStructure.getStructureId()));
        }
        return JournalArticleImpl.getContentByLocale(this.getDocument(), languageId, tokens);
    }

    public DDMFormValues getDDMFormValues() {
        DDMStructure ddmStructure = this.getDDMStructure();
        if (ddmStructure == null) {
            return null;
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMFormValues ddmFormValues = DDMFieldLocalServiceUtil.getDDMFormValues((DDMForm)ddmForm, (long)this.getId());
        if (ddmFormValues != null) {
            ddmFormValues.setDDMFormFieldValues(DDMFormValuesConverterUtil.addMissingDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true)));
        }
        return ddmFormValues;
    }

    public DDMStructure getDDMStructure() {
        return DDMStructureLocalServiceUtil.fetchStructure((long)PortalUtil.getSiteGroupId((long)this.getGroupId()), (long)ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class), (String)this.getDDMStructureKey(), (boolean)true);
    }

    public DDMTemplate getDDMTemplate() {
        return DDMTemplateLocalServiceUtil.fetchTemplate((long)PortalUtil.getSiteGroupId((long)this.getGroupId()), (long)ClassNameLocalServiceUtil.getClassNameId(DDMStructure.class), (String)this.getDDMTemplateKey(), (boolean)true);
    }

    @JSON
    public String getDescription() {
        String description = JournalArticleLocalServiceUtil.getArticleDescription((long)this.getId(), (String)this.getDefaultLanguageId());
        if (description == null) {
            return "";
        }
        return description;
    }

    public String getDescription(Locale locale) {
        String description = JournalArticleLocalServiceUtil.getArticleDescription((long)this.getId(), (Locale)locale);
        if (description == null) {
            return this.getDescription();
        }
        return description;
    }

    public String getDescription(Locale locale, boolean useDefault) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getDescription(languageId, useDefault);
    }

    public String getDescription(String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getDescription(locale);
    }

    public String getDescription(String languageId, boolean useDefault) {
        String description = JournalArticleLocalServiceUtil.getArticleDescription((long)this.getId(), (String)languageId);
        if (description != null) {
            return description;
        }
        if (useDefault) {
            return this.getDescription();
        }
        return "";
    }

    @JSON
    public String getDescriptionCurrentValue() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        return this.getDescription(locale, true);
    }

    public Map<Locale, String> getDescriptionMap() {
        if (this._descriptionMap != null) {
            return this._descriptionMap;
        }
        this._descriptionMap = JournalArticleLocalServiceUtil.getArticleDescriptionMap((long)this.getId());
        return this._descriptionMap;
    }

    @JSON
    public String getDescriptionMapAsXML() {
        return LocalizationUtil.updateLocalization(this.getDescriptionMap(), (String)"", (String)"Description", (String)this.getDefaultLanguageId());
    }

    @Override
    @JSON
    public Date getDisplayDate() {
        if (!(PropsValues.SCHEDULER_ENABLED || ExportImportThreadLocal.isExportInProcess() || ExportImportThreadLocal.isImportInProcess())) {
            return null;
        }
        return super.getDisplayDate();
    }

    public Document getDocument() {
        block3: {
            String content;
            if (this._document == null && (content = this.getContent()) != null) {
                try {
                    this._document = SAXReaderUtil.read((String)content);
                }
                catch (DocumentException documentException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)documentException);
                }
            }
        }
        return this._document;
    }

    @Override
    @JSON
    public Date getExpirationDate() {
        if (!(PropsValues.SCHEDULER_ENABLED || ExportImportThreadLocal.isExportInProcess() || ExportImportThreadLocal.isImportInProcess())) {
            return null;
        }
        return super.getExpirationDate();
    }

    public JournalFolder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            JournalFolderImpl journalFolder = new JournalFolderImpl();
            journalFolder.setCompanyId(this.getCompanyId());
            return journalFolder;
        }
        return JournalFolderLocalServiceUtil.getFolder((long)this.getFolderId());
    }

    public Map<Locale, String> getFriendlyURLMap() throws PortalException {
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
        List friendlyURLEntries = FriendlyURLEntryLocalServiceUtil.getFriendlyURLEntries((long)this.getGroupId(), (long)classNameId, (long)this.getResourcePrimKey());
        if (friendlyURLEntries.isEmpty()) {
            friendlyURLMap.put(LocaleUtil.fromLanguageId((String)this.getDefaultLanguageId()), this.getUrlTitle());
            return friendlyURLMap;
        }
        FriendlyURLEntry friendlyURLEntry = FriendlyURLEntryLocalServiceUtil.getMainFriendlyURLEntry((long)classNameId, (long)this.getResourcePrimKey());
        List friendlyURLEntryLocalizations = FriendlyURLEntryLocalServiceUtil.getFriendlyURLEntryLocalizations((long)friendlyURLEntry.getFriendlyURLEntryId());
        for (FriendlyURLEntryLocalization friendlyURLEntryLocalization : friendlyURLEntryLocalizations) {
            Locale locale = LocaleUtil.fromLanguageId((String)friendlyURLEntryLocalization.getLanguageId());
            friendlyURLMap.put(locale, friendlyURLEntryLocalization.getUrlTitle());
        }
        Locale defaultSiteLocale = LocaleUtil.getSiteDefault();
        if (Validator.isNull((String)((String)friendlyURLMap.get(defaultSiteLocale)))) {
            Locale defaultLocale = LocaleUtil.fromLanguageId((String)this.getDefaultLanguageId());
            friendlyURLMap.put(defaultSiteLocale, (String)friendlyURLMap.get(defaultLocale));
        }
        return friendlyURLMap;
    }

    public String getFriendlyURLsXML() throws PortalException {
        return LocalizationUtil.updateLocalization(this.getFriendlyURLMap(), (String)"", (String)"FriendlyURL", (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
    }

    public List<FileEntry> getImagesFileEntries() throws PortalException {
        return this.getImagesFileEntries(-1, -1);
    }

    public List<FileEntry> getImagesFileEntries(int start, int end) throws PortalException {
        return this.getImagesFileEntries(start, end, null);
    }

    public List<FileEntry> getImagesFileEntries(int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        long imagesFolderId = this.getImagesFolderId();
        if (imagesFolderId == 0L) {
            return new ArrayList<FileEntry>();
        }
        return PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)imagesFolderId, (int)0, (int)start, (int)end, orderByComparator);
    }

    public int getImagesFileEntriesCount() throws PortalException {
        long imagesFolderId = this.getImagesFolderId();
        if (imagesFolderId == 0L) {
            return 0;
        }
        return PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)imagesFolderId, (int)0);
    }

    public long getImagesFolderId() {
        block4: {
            if (this._imagesFolderId != 0L) {
                return this._imagesFolderId;
            }
            Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)this.getGroupId(), (String)"com.liferay.journal");
            if (repository == null) {
                return 0L;
            }
            try {
                Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)0L, (String)String.valueOf(this.getResourcePrimKey()));
                this._imagesFolderId = folder.getFolderId();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("Unable to get folder for " + this.getResourcePrimKey()), (Throwable)exception);
            }
        }
        return this._imagesFolderId;
    }

    public Layout getLayout() {
        if (Validator.isNull((String)this.getLayoutUuid())) {
            return null;
        }
        Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)this.getLayoutUuid(), (long)this.getGroupId(), (boolean)false);
        if (layout == null) {
            layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)this.getLayoutUuid(), (long)this.getGroupId(), (boolean)true);
        }
        return layout;
    }

    @Override
    @JSON
    public Date getReviewDate() {
        if (!(PropsValues.SCHEDULER_ENABLED || ExportImportThreadLocal.isExportInProcess() || ExportImportThreadLocal.isImportInProcess())) {
            return null;
        }
        return super.getReviewDate();
    }

    public String getSmallImageType() throws PortalException {
        if (this._smallImageType == null && this.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.getImage((long)this.getSmallImageId());
            this._smallImageType = smallImage.getType();
        }
        return this._smallImageType;
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(JournalArticle.class);
    }

    @JSON
    public String getTitle() {
        String title = JournalArticleLocalServiceUtil.getArticleTitle((long)this.getId(), (String)this.getDefaultLanguageId());
        if (title == null) {
            return "";
        }
        return title;
    }

    public String getTitle(Locale locale) {
        String title = JournalArticleLocalServiceUtil.getArticleTitle((long)this.getId(), (Locale)locale);
        if (title == null) {
            return this.getTitle();
        }
        return title;
    }

    public String getTitle(Locale locale, boolean useDefault) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getTitle(languageId, useDefault);
    }

    public String getTitle(String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getTitle(locale);
    }

    public String getTitle(String languageId, boolean useDefault) {
        String title = JournalArticleLocalServiceUtil.getArticleTitle((long)this.getId(), (String)languageId);
        if (title != null) {
            return title;
        }
        if (useDefault) {
            return this.getTitle();
        }
        return "";
    }

    @JSON
    public String getTitleCurrentValue() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        return this.getTitle(locale, true);
    }

    public Map<Locale, String> getTitleMap() {
        if (this._titleMap != null) {
            return this._titleMap;
        }
        this._titleMap = JournalArticleLocalServiceUtil.getArticleTitleMap((long)this.getId());
        return this._titleMap;
    }

    @JSON
    public String getTitleMapAsXML() {
        return LocalizationUtil.updateLocalization(this.getTitleMap(), (String)"", (String)"Title", (String)this.getDefaultLanguageId());
    }

    @Override
    public long getTrashEntryClassPK() {
        return this.getResourcePrimKey();
    }

    public String getUrlTitle(Locale locale) throws PortalException {
        String urlTitle = this.getFriendlyURLMap().get(locale);
        if (Validator.isNull((String)urlTitle)) {
            return this.getUrlTitle();
        }
        return urlTitle;
    }

    public boolean hasApprovedVersion() {
        JournalArticle article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)this.getGroupId(), (String)this.getArticleId(), (int)0);
        return article != null;
    }

    public void setDescriptionMap(Map<Locale, String> descriptionMap) {
        this._descriptionMap = descriptionMap;
    }

    public void setDocument(Document document) {
        this._document = document;
    }

    public void setImagesFolderId(long imagesFolderId) {
        this._imagesFolderId = imagesFolderId;
    }

    public void setSmallImageType(String smallImageType) {
        this._smallImageType = smallImageType;
    }

    public void setTitleMap(Map<Locale, String> titleMap) {
        this._titleMap = titleMap;
    }
}

