/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.model.AssetDisplayPageEntryTable;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.diff.DiffHtml;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeUtil;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.friendly.url.exception.NoSuchFriendlyURLEntryLocalizationException;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalizationTable;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.journal.configuration.JournalGroupServiceConfiguration;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.constants.JournalArticleConstants;
import com.liferay.journal.content.compatibility.converter.JournalContentCompatibilityConverter;
import com.liferay.journal.exception.ArticleExpirationDateException;
import com.liferay.journal.exception.ArticleFriendlyURLException;
import com.liferay.journal.exception.ArticleReviewDateException;
import com.liferay.journal.exception.ArticleVersionException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.exception.RequiredArticleLocalizationException;
import com.liferay.journal.internal.transformer.JournalTransformer;
import com.liferay.journal.internal.util.JournalTreePathUtil;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.internal.validation.JournalArticleModelValidator;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleLocalization;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalArticleTable;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalArticleDisplayImpl;
import com.liferay.journal.model.impl.JournalArticleImpl;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.service.base.JournalArticleLocalServiceBaseImpl;
import com.liferay.journal.service.persistence.JournalArticleLocalizationPersistence;
import com.liferay.journal.service.persistence.JournalArticleResourcePersistence;
import com.liferay.journal.service.persistence.JournalFolderPersistence;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.JournalDefaultTemplateProvider;
import com.liferay.journal.util.JournalHelper;
import com.liferay.journal.util.comparator.ArticleIDComparator;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupSubscriptionCheckSubscriptionSender;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.validation.ModelValidator;
import com.liferay.portal.validation.ModelValidatorRegistryUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import com.liferay.upload.AttachmentContentUpdater;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={AopService.class})
public class JournalArticleLocalServiceImpl
extends JournalArticleLocalServiceBaseImpl {
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected DDMStorageLinkLocalService ddmStorageLinkLocalService;
    @Reference
    protected DDMStructureLinkLocalService ddmStructureLinkLocalService;
    @Reference
    protected DDMStructureLocalService ddmStructureLocalService;
    @Reference
    protected DDMTemplateLinkLocalService ddmTemplateLinkLocalService;
    @Reference
    protected DDMTemplateLocalService ddmTemplateLocalService;
    @Reference
    protected FriendlyURLEntryLocalService friendlyURLEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleLocalServiceImpl.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private AttachmentContentUpdater _attachmentContentUpdater;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMFieldLocalService _ddmFieldLocalService;
    @Reference
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DiffHtml _diffHtml;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticleLocalizationPersistence _journalArticleLocalizationPersistence;
    @Reference
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    @Reference
    private JournalArticleResourcePersistence _journalArticleResourcePersistence;
    @Reference
    private JournalContentCompatibilityConverter _journalContentCompatibilityConverter;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JournalDefaultTemplateProvider _journalDefaultTemplateProvider;
    @Reference
    private JournalFolderPersistence _journalFolderPersistence;
    @Reference
    private JournalHelper _journalHelper;
    private final JournalTransformer _journalTransformer = new JournalTransformer();
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    private Date _previousCheckDate;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    private ServiceTrackerList<TransformerListener> _serviceTrackerList;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private SystemEventLocalService _systemEventLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.addArticle(null, userId, groupId, folderId, classNameId, classPK, articleId, autoArticleId, version, titleMap, descriptionMap, friendlyURLMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallImageFile, images, articleURL, serviceContext);
    }

    @Deprecated
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.journalArticleLocalService.addArticle(null, userId, groupId, folderId, classNameId, classPK, articleId, autoArticleId, version, titleMap, descriptionMap, titleMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallImageFile, images, articleURL, serviceContext);
    }

    @Deprecated
    public JournalArticle addArticle(long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException {
        return this.addArticle(null, userId, groupId, folderId, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(String externalReferenceCode, long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        boolean validate;
        byte[] smallImageBytes;
        Date reviewDate;
        Date expirationDate;
        Date displayDate;
        User user;
        block16: {
            user = this._userLocalService.getUser(userId);
            articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
            displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), null);
            expirationDate = null;
            reviewDate = null;
            if (!neverExpire) {
                expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = this._portal.getDate(reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, user.getTimeZone(), ArticleReviewDateException.class);
            }
            smallImageBytes = null;
            try {
                smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block16;
                _log.debug((Throwable)ioException);
            }
        }
        boolean bl = validate = !ExportImportThreadLocal.isImportInProcess();
        if (validate) {
            this.validateDDMStructureId(groupId, folderId, ddmStructureKey);
        }
        if (autoArticleId) {
            articleId = String.valueOf(this.counterLocalService.increment());
        }
        this.sanitize(user.getCompanyId(), groupId, userId, classPK, descriptionMap);
        if (validate) {
            this.validate(externalReferenceCode, user.getCompanyId(), groupId, classNameId, articleId, autoArticleId, version, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
            try {
                this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, 0L, content);
            }
            catch (ExportImportContentValidationException exportImportContentValidationException) {
                exportImportContentValidationException.setStagedModelClassName(JournalArticle.class.getName());
                exportImportContentValidationException.setStagedModelPrimaryKeyObj((Serializable)((Object)articleId));
                throw exportImportContentValidationException;
            }
        }
        serviceContext.setAttribute("articleId", (Serializable)((Object)articleId));
        long id = this.counterLocalService.increment();
        String articleResourceUuid = GetterUtil.getString((Object)serviceContext.getAttribute("articleResourceUuid"));
        long resourcePrimKey = this._journalArticleResourceLocalService.getArticleResourcePrimKey(articleResourceUuid, groupId, articleId);
        JournalArticle article = this.journalArticlePersistence.create(id);
        Locale locale = this.getArticleDefaultLocale(content);
        friendlyURLMap = this._checkFriendlyURLMap(locale, friendlyURLMap, titleMap);
        Map<String, String> urlTitleMap = this._getURLTitleMap(groupId, resourcePrimKey, friendlyURLMap, titleMap);
        article.setUuid(serviceContext.getUuid());
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setExternalReferenceCode(externalReferenceCode);
        article.setFolderId(folderId);
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setTreePath(article.buildTreePath());
        article.setArticleId(articleId);
        article.setVersion(version);
        article.setUrlTitle(urlTitleMap.get(LocaleUtil.toLanguageId((Locale)locale)));
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            article.setSmallImageId(this.counterLocalService.increment());
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        Date date = new Date();
        if (expirationDate == null || expirationDate.after(date)) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setStatusByUserId(userId);
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(serviceContext.getModifiedDate(date));
        article.setExpandoBridgeAttributes(serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.updateFriendlyURLs(article, urlTitleMap, serviceContext);
        this._addArticleLocalizedFields(user.getCompanyId(), article.getId(), titleMap, descriptionMap);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addArticleResources(article, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addArticleResources(article, serviceContext.getModelPermissions());
        }
        this.saveImages(article.getCompanyId(), smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this.updateDDMFields(article, this._formatContent(article, content, groupId, user));
        if (this._classNameLocalService.getClassNameId(DDMStructure.class) != classNameId) {
            this.updateDDMLinks(id, groupId, ddmStructureKey, ddmTemplateKey, true);
        }
        articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
        serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
        this.sendEmail(article, articleURL, "requested", serviceContext);
        this.startWorkflowInstance(userId, article, serviceContext);
        return article;
    }

    public JournalArticle addArticle(String externalReferenceCode, long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        int displayDateMonth = calendar.get(2);
        int displayDateDay = calendar.get(5);
        int displayDateYear = calendar.get(1);
        int displayDateHour = calendar.get(11);
        int displayDateMinute = calendar.get(12);
        return this.journalArticleLocalService.addArticle(externalReferenceCode, userId, groupId, folderId, 0L, 0L, "", true, 1.0, titleMap, descriptionMap, titleMap, content, ddmStructureKey, ddmTemplateKey, null, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
    }

    public JournalArticle addArticleDefaultValues(long userId, long groupId, long classNameId, long classPK, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        String articleId;
        byte[] smallImageBytes;
        Date reviewDate;
        Date expirationDate;
        Date displayDate;
        User user;
        block5: {
            user = this._userLocalService.getUser(userId);
            displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), null);
            if (displayDateMonth == displayDateDay && displayDateDay == displayDateYear && displayDateYear == 0) {
                displayDate = null;
            }
            expirationDate = null;
            reviewDate = null;
            if (!neverExpire) {
                expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = this._portal.getDate(reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, user.getTimeZone(), ArticleReviewDateException.class);
            }
            smallImageBytes = null;
            try {
                smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)ioException);
            }
        }
        String externalReferenceCode = articleId = String.valueOf(this.counterLocalService.increment());
        this.sanitize(user.getCompanyId(), groupId, userId, classPK, descriptionMap);
        this.validate(externalReferenceCode, user.getCompanyId(), groupId, classNameId, articleId, true, 0.0, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        serviceContext.setAttribute("articleId", (Serializable)((Object)articleId));
        long id = this.counterLocalService.increment();
        JournalArticle article = this.journalArticlePersistence.create(id);
        article.setUuid(serviceContext.getUuid());
        String articleResourceUuid = GetterUtil.getString((Object)serviceContext.getAttribute("articleResourceUuid"));
        article.setResourcePrimKey(this._journalArticleResourceLocalService.getArticleResourcePrimKey(articleResourceUuid, groupId, articleId));
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setExternalReferenceCode(externalReferenceCode);
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setArticleId(articleId);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        Locale locale = this.getArticleDefaultLocale(content);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        article.setStatus(0);
        article.setStatusByUserId(userId);
        article.setStatusDate(serviceContext.getModifiedDate(new Date()));
        article.setExpandoBridgeAttributes(serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this._addArticleLocalizedFields(user.getCompanyId(), article.getId(), titleMap, descriptionMap);
        this.addArticleResources(article, serviceContext.getModelPermissions());
        this.saveImages(article.getCompanyId(), smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this.updateDDMFields(article, this._formatContent(article, content, groupId, user));
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public void addArticleResources(JournalArticle article, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(JournalArticle article, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), modelPermissions);
    }

    public void addArticleResources(long groupId, String articleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, addGroupPermissions, addGuestPermissions);
    }

    public JournalArticle checkArticleResourcePrimKey(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.getResourcePrimKey() > 0L) {
            return article;
        }
        article.setResourcePrimKey(this._journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId));
        return (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
    }

    public void checkArticles() throws PortalException {
        Date date = new Date();
        this.checkArticlesByExpirationDate(date);
        this.checkArticlesByReviewDate(date);
        this.checkArticlesByDisplayDate(date);
        this._previousCheckDate = date;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle copyArticle(long userId, long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException {
        Image image;
        oldArticleId = StringUtil.toUpperCase((String)StringUtil.trim((String)oldArticleId));
        newArticleId = StringUtil.toUpperCase((String)StringUtil.trim((String)newArticleId));
        JournalArticle oldArticle = this.journalArticlePersistence.findByG_A_V(groupId, oldArticleId, version);
        if (autoArticleId) {
            newArticleId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newArticleId);
            if (this.journalArticlePersistence.countByG_A(groupId, newArticleId) > 0) {
                throw new DuplicateArticleIdException(StringBundler.concat((Object[])new Object[]{"{groupId=", groupId, ", articleId=", newArticleId, "}"}));
            }
        }
        User user = this._userLocalService.getUser(userId);
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this._journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, newArticleId);
        JournalArticle newArticle = this.journalArticlePersistence.create(id);
        newArticle.setResourcePrimKey(resourcePrimKey);
        newArticle.setGroupId(groupId);
        newArticle.setCompanyId(user.getCompanyId());
        newArticle.setUserId(user.getUserId());
        newArticle.setUserName(user.getFullName());
        Date modifiedDate = new Date();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        modifiedDate = serviceContext.getModifiedDate(modifiedDate);
        newArticle.setModifiedDate(modifiedDate);
        newArticle.setExternalReferenceCode(newArticleId);
        newArticle.setFolderId(oldArticle.getFolderId());
        newArticle.setTreePath(oldArticle.getTreePath());
        newArticle.setArticleId(newArticleId);
        newArticle.setVersion(1.0);
        newArticle.setDDMStructureKey(oldArticle.getDDMStructureKey());
        newArticle.setDDMTemplateKey(oldArticle.getDDMTemplateKey());
        newArticle.setDefaultLanguageId(oldArticle.getDefaultLanguageId());
        newArticle.setLayoutUuid(oldArticle.getLayoutUuid());
        newArticle.setDisplayDate(oldArticle.getDisplayDate());
        newArticle.setExpirationDate(oldArticle.getExpirationDate());
        newArticle.setReviewDate(oldArticle.getReviewDate());
        newArticle.setIndexable(oldArticle.isIndexable());
        newArticle.setSmallImage(oldArticle.isSmallImage());
        newArticle.setSmallImageId(this.counterLocalService.increment());
        newArticle.setSmallImageURL(oldArticle.getSmallImageURL());
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)JournalArticle.class.getName());
        WorkflowDefinitionLink workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(oldArticle.getCompanyId(), oldArticle.getGroupId(), oldArticle.getId());
        if (oldArticle.isPending() || workflowDefinitionLink != null) {
            newArticle.setStatus(2);
        } else {
            newArticle.setStatus(oldArticle.getStatus());
        }
        newArticle.setStatusByUserId(user.getUserId());
        newArticle.setStatusByUserName(user.getFullName());
        newArticle.setStatusDate(modifiedDate);
        int uniqueUrlTitleCount = this._getUniqueUrlTitleCount(groupId, newArticleId, JournalUtil.getUrlTitle(id, oldArticle.getUrlTitle()));
        Map newTitleMap = oldArticle.getTitleMap();
        HashMap<Locale, String> newUniqueURLTitleMap = new HashMap<Locale, String>();
        for (Map.Entry entry : newTitleMap.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            String urlTitle = StringBundler.concat((Object[])new Object[]{entry.getValue(), " ", this._language.get(locale, "duplicate"), " ", uniqueUrlTitleCount});
            newTitleMap.put(locale, urlTitle);
            newUniqueURLTitleMap.put(locale, this.getUniqueUrlTitle(id, groupId, newArticleId, urlTitle));
        }
        DDMFormValues ddmFormValues = oldArticle.getDDMFormValues();
        Locale locale = ddmFormValues.getDefaultLocale();
        String newURLTitle = (String)newUniqueURLTitleMap.get(locale);
        while (this.fetchArticleByUrlTitle(groupId, newURLTitle) != null) {
            newURLTitle = this.getUniqueUrlTitle(id, groupId, newArticleId, newURLTitle);
        }
        newArticle.setUrlTitle(newURLTitle);
        ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)oldArticle.getExpandoBridge(), (ExpandoBridge)newArticle.getExpandoBridge());
        newArticle = (JournalArticle)this.journalArticlePersistence.update((BaseModel)newArticle);
        Map<Locale, String> friendlyURLMap = this._checkFriendlyURLMap(locale, new HashMap<Locale, String>(), newTitleMap);
        Map<String, String> newUrlTitleMap = this._getURLTitleMap(groupId, resourcePrimKey, friendlyURLMap, newUniqueURLTitleMap);
        this.updateFriendlyURLs(newArticle, newUrlTitleMap, serviceContext);
        this._addArticleLocalizedFields(newArticle.getCompanyId(), newArticle.getId(), newTitleMap, oldArticle.getDescriptionMap());
        this._resourceLocalService.copyModelResources(oldArticle.getCompanyId(), JournalArticle.class.getName(), oldArticle.getResourcePrimKey(), resourcePrimKey);
        if (oldArticle.isSmallImage() && (image = this._imageLocalService.fetchImage(oldArticle.getSmallImageId())) != null) {
            byte[] smallImageBytes = image.getTextObj();
            this._imageLocalService.updateImage(newArticle.getCompanyId(), newArticle.getSmallImageId(), smallImageBytes);
        }
        long[] assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        String[] assetTagNames = this._assetTagLocalService.getTagNames(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        AssetEntry oldAssetEntry = this._assetEntryLocalService.getEntry(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        List assetLinks = this._assetLinkLocalService.getDirectLinks(oldAssetEntry.getEntryId(), false);
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        this.updateAsset(userId, newArticle, assetCategoryIds, assetTagNames, assetLinkEntryIds, oldAssetEntry.getPriority());
        AssetDisplayPageEntry assetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(groupId, this._portal.getClassNameId(JournalArticle.class.getName()), oldArticle.getResourcePrimKey());
        if (assetDisplayPageEntry != null) {
            this._assetDisplayPageEntryLocalService.addAssetDisplayPageEntry(userId, groupId, this._portal.getClassNameId(JournalArticle.class.getName()), newArticle.getResourcePrimKey(), assetDisplayPageEntry.getLayoutPageTemplateEntryId(), assetDisplayPageEntry.getType(), serviceContext);
        }
        this.updateDDMFields(newArticle, this.copyArticleImages(oldArticle, newArticle));
        this.updateDDMLinks(id, groupId, oldArticle.getDDMStructureKey(), oldArticle.getDDMTemplateKey(), true);
        return newArticle;
    }

    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article) throws PortalException {
        return this.journalArticleLocalService.deleteArticle(article, "", null);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException {
        int articlesCount;
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchArticleResource(article.getGroupId(), article.getArticleId());
        if (article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion(), 0)) {
            this.updatePreviousApprovedArticle(article);
        }
        this._journalArticleLocalizationPersistence.removeByArticlePK(article.getId());
        if (article.isDraft() || article.isInTrash()) {
            this._assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getPrimaryKey());
        }
        if (serviceContext != null && Validator.isNotNull((String)articleURL) && !article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, "denied", serviceContext);
        }
        this._ddmFieldLocalService.deleteDDMFormValues(article.getId());
        if (article.getClassNameId() != this._classNameLocalService.getClassNameId(DDMStructure.class)) {
            this.ddmStorageLinkLocalService.deleteClassStorageLink(article.getId());
            this.ddmStructureLinkLocalService.deleteStructureLinks(this._classNameLocalService.getClassNameId(JournalArticle.class), article.getId());
            this.ddmTemplateLinkLocalService.deleteTemplateLink(this._classNameLocalService.getClassNameId(JournalArticle.class), article.getId());
        }
        this._expandoRowLocalService.deleteRows(article.getCompanyId(), this._classNameLocalService.getClassNameId(JournalArticle.class), article.getId());
        if (article.isInTrash() && this._trashHelper.getTrashEntry((TrashedModel)article) != null) {
            this._trashVersionLocalService.deleteTrashVersion(JournalArticle.class.getName(), article.getId());
        }
        if (!article.isDraft()) {
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        if ((articlesCount = this.journalArticlePersistence.countByG_A(article.getGroupId(), article.getArticleId())) == 1) {
            long folderId;
            this._assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this._commentManager.deleteDiscussion(JournalArticle.class.getName(), article.getResourcePrimKey());
            List friendlyURLEntries = this.friendlyURLEntryLocalService.getFriendlyURLEntries(article.getGroupId(), this._classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
            if (!friendlyURLEntries.isEmpty()) {
                this.friendlyURLEntryLocalService.deleteFriendlyURLEntry(article.getGroupId(), JournalArticle.class, article.getResourcePrimKey());
            }
            if ((folderId = article.getImagesFolderId()) != 0L) {
                this._portletFileRepository.deletePortletFolder(folderId);
            }
            this._ratingsStatsLocalService.deleteStats(JournalArticle.class.getName(), article.getResourcePrimKey());
            this._imageLocalService.deleteImage(article.getSmallImageId());
            this._trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this._resourceLocalService.deleteResource(article.getCompanyId(), JournalArticle.class.getName(), 4, article.getResourcePrimKey());
            if (articleResource != null) {
                this._journalArticleResourceLocalService.deleteJournalArticleResource(articleResource);
            }
        }
        this.journalArticlePersistence.remove((BaseModel)article);
        if (articleResource != null) {
            this._systemEventLocalService.addSystemEvent(0L, article.getGroupId(), article.getModelClassName(), article.getPrimaryKey(), articleResource.getUuid(), null, 1, JSONUtil.put((String)"uuid", (Object)article.getUuid()).put("version", article.getVersion()).toString());
        }
        return article;
    }

    public JournalArticle deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.deleteArticle(article, articleURL, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticle(long groupId, String articleId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchArticleResource(groupId, articleId);
        try {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.deleteArticle(article, null, serviceContext);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        if (articleResource != null) {
            this._systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticleDefaultValues(long groupId, String articleId, String ddmStructureKey) throws PortalException {
        this._deleteDDMStructurePredefinedValues(groupId, ddmStructureKey);
        this.journalArticleLocalService.deleteArticle(groupId, articleId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            Object articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByGroupId(groupId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResources.add(this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey()));
                }
                this.journalArticleLocalService.deleteArticle(article, null, null);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this._systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, long folderId) throws PortalException {
        this.deleteArticles(groupId, folderId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByG_F(groupId, folderId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                if (includeTrashedEntries || !this._trashHelper.isInTrashExplicitly((TrashedModel)article)) {
                    this.journalArticleLocalService.deleteArticle(article, null, null);
                    continue;
                }
                articleResources.remove(articleResource);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this._systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, String className, long classPK) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, this._classNameLocalService.getClassNameId(className), classPK);
        for (JournalArticle article : articles) {
            this.journalArticleLocalService.deleteArticle(article, null, null);
        }
    }

    public void deleteLayoutArticleReferences(long groupId, String layoutUuid) {
        List articles = this.journalArticlePersistence.findByG_L(groupId, layoutUuid);
        for (JournalArticle article : articles) {
            article.setLayoutUuid("");
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle expireArticle(long userId, long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, groupId, articleId, version, 3, articleURL, new HashMap<String, Serializable>(), serviceContext);
    }

    public void expireArticle(long userId, long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (this.isExpireAllArticleVersions(user.getCompanyId())) {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                if (article.isExpired()) continue;
                this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
            }
        } else {
            JournalArticle article = this.getLatestArticle(groupId, articleId, 0);
            this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
        }
    }

    public JournalArticle fetchArticle(long id) {
        return this.journalArticlePersistence.fetchByPrimaryKey(id);
    }

    public JournalArticle fetchArticle(long groupId, String articleId) {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        if (article != null) {
            return article;
        }
        return this.fetchLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle fetchArticle(long groupId, String articleId, double version) {
        return this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version);
    }

    public JournalArticle fetchArticleByUrlTitle(long groupId, String urlTitle) {
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null) {
            return article;
        }
        return this.fetchLatestArticleByUrlTitle(groupId, urlTitle, -1);
    }

    public JournalArticle fetchArticleByUrlTitle(long groupId, String urlTitle, double version) {
        JournalArticle article;
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        if (friendlyURLEntry != null && (article = this.fetchLatestArticle(friendlyURLEntry.getClassPK(), -1, true)).getVersion() == version) {
            return article;
        }
        article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null && article.getVersion() == version) {
            return article;
        }
        article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, -1);
        if (article != null && article.getVersion() == version) {
            return article;
        }
        if (article != null) {
            return this.fetchArticle(article.getGroupId(), article.getArticleId(), version);
        }
        return null;
    }

    public JournalArticle fetchDisplayArticle(long groupId, String articleId) {
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        if (articles.isEmpty()) {
            return null;
        }
        Date date = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate != null && !displayDate.before(date) || expirationDate != null && !expirationDate.after(date)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey) {
        return this.fetchLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status) {
        return this.fetchLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status, boolean preferApproved) {
        JournalArticle article = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
            }
            if (article == null) {
                article = this.journalArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
            }
        } else {
            article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        return article;
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int[] statuses) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        List articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (!articles.isEmpty()) {
            return (JournalArticle)articles.get(0);
        }
        return null;
    }

    public JournalArticle fetchLatestArticle(long groupId, String articleId, int status) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            return this.journalArticlePersistence.fetchByG_A_NotST_First(groupId, articleId, 8, (OrderByComparator)orderByComparator);
        }
        return this.journalArticlePersistence.fetchByG_A_ST_First(groupId, articleId, status, (OrderByComparator)orderByComparator);
    }

    public JournalArticle fetchLatestArticleByExternalReferenceCode(long groupId, String externalReferenceCode) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        return this.journalArticlePersistence.fetchByG_ERC_First(groupId, externalReferenceCode, (OrderByComparator)orderByComparator);
    }

    public JournalArticle fetchLatestArticleByUrlTitle(long groupId, String urlTitle, int status) {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        if (friendlyURLEntry != null) {
            JournalArticle article = this.fetchLatestArticle(friendlyURLEntry.getClassPK(), status);
            if (article != null && article.getGroupId() != groupId) {
                article = this.fetchLatestArticle(groupId, article.getArticleId(), status);
            }
            return article;
        }
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_UT(groupId, this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle), 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_UT_ST(groupId, this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle), status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchLatestIndexableArticle(long resourcePrimKey) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        List articles = this.journalArticlePersistence.findByR_I_S(resourcePrimKey, true, new int[]{0, 8}, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticle(long id) throws PortalException {
        return this.journalArticlePersistence.findByPrimaryKey(id);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        if (article != null) {
            return article;
        }
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException {
        return this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, this._classNameLocalService.getClassNameId(className), classPK);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No approved JournalArticle exists with the key {groupId=", groupId, ", className=", className, ", classPK=", classPK, "}"}));
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        if (friendlyURLEntry != null) {
            return this.getLatestArticle(friendlyURLEntry.getClassPK(), -1, true);
        }
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null) {
            return article;
        }
        return this.getLatestArticleByUrlTitle(groupId, urlTitle, -1);
    }

    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        return articleDisplay.getContent();
    }

    public String getArticleDescription(long articlePK, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getArticleDescription(articlePK, languageId);
    }

    public String getArticleDescription(long articlePK, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this._journalArticleLocalizationPersistence.fetchByA_L(articlePK, languageId);
        if (journalArticleLocalization == null) {
            return null;
        }
        return journalArticleLocalization.getDescription();
    }

    public Map<Locale, String> getArticleDescriptionMap(long articlePK) {
        HashMap<Locale, String> journalArticleLocalizationDescriptionMap = new HashMap<Locale, String>();
        List journalArticleLocalizationList = this._journalArticleLocalizationPersistence.findByArticlePK(articlePK);
        for (JournalArticleLocalization journalArticleLocalization : journalArticleLocalizationList) {
            journalArticleLocalizationDescriptionMap.put(LocaleUtil.fromLanguageId((String)journalArticleLocalization.getLanguageId()), journalArticleLocalization.getDescription());
        }
        return journalArticleLocalizationDescriptionMap;
    }

    public JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay, false);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        Date expirationDate;
        Date date = new Date();
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        boolean preview = Objects.equals(viewMode, "preview");
        if (article.isExpired() && !preview && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(date)) {
            return null;
        }
        Date displayDate = article.getDisplayDate();
        if (displayDate != null && displayDate.after(date) && !preview) {
            return null;
        }
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getDDMTemplateKey(), viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getDDMTemplateKey(), viewMode, languageId, themeDisplay);
    }

    public List<String> getArticleLocalizationLanguageIds(long articlePK) {
        List journalArticleLocalizationList = this._journalArticleLocalizationPersistence.findByArticlePK(articlePK);
        ArrayList<String> availableLanguageIds = new ArrayList<String>();
        for (JournalArticleLocalization journalArticleLocalization : journalArticleLocalizationList) {
            availableLanguageIds.add(journalArticleLocalization.getLanguageId());
        }
        return availableLanguageIds;
    }

    public List<JournalArticle> getArticles() {
        return this.journalArticlePersistence.findAll();
    }

    public List<JournalArticle> getArticles(long groupId) {
        return this.journalArticlePersistence.findByGroupId(groupId);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int status, int start, int end) {
        return this.journalArticlePersistence.findByG_F_ST(groupId, folderId, status, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey);
    }

    public List<JournalArticle> getArticlesBySmallImageId(long smallImageId) {
        return this.journalArticlePersistence.findBySmallImageId(smallImageId);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, long classNameId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.journalArticleFinder.findByG_F_C_S_L(groupId, Collections.emptyList(), classNameId, ddmStructureKey, LocaleUtil.getMostRelevantLocale(), queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, long classNameId, String ddmStructureKey, Locale locale, int status, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.journalArticleFinder.findByG_F_C_S_L(groupId, Collections.emptyList(), classNameId, ddmStructureKey, locale, queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.journalArticleFinder.findByG_F_C_S_L(groupId, Collections.emptyList(), 0L, ddmStructureKey, LocaleUtil.getMostRelevantLocale(), queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.getArticlesByStructureId(groupId, ddmStructureKey, -1, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, Locale locale, int status, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.journalArticleFinder.findByG_F_C_S_L(groupId, Collections.emptyList(), 0L, ddmStructureKey, locale, queryDefinition);
    }

    public List<Long> getArticlesClassPKsWithDefaultDisplayPage(long groupId, long classTypeId) {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchDefaultLayoutPageTemplateEntry(groupId, this._portal.getClassNameId(JournalArticle.class.getName()), classTypeId);
        if (layoutPageTemplateEntry == null) {
            return Collections.emptyList();
        }
        JournalArticleTable tempJournalArticleTable = (JournalArticleTable)JournalArticleTable.INSTANCE.as("tempJournalArticleTable");
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(layoutPageTemplateEntry.getClassTypeId());
        return (List)this.journalArticlePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{JournalArticleTable.INSTANCE.resourcePrimKey}).from((Table)JournalArticleTable.INSTANCE).where(JournalArticleTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)JournalArticleTable.INSTANCE.DDMStructureKey.eq((Object)ddmStructure.getStructureKey())).and((Expression)JournalArticleTable.INSTANCE.layoutUuid.isNull()).and((Expression)JournalArticleTable.INSTANCE.status.eq((Object)0)).and((Expression)JournalArticleTable.INSTANCE.version.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.max((Expression)tempJournalArticleTable.version)}).from((Table)tempJournalArticleTable).where(tempJournalArticleTable.resourcePrimKey.eq((Expression)JournalArticleTable.INSTANCE.resourcePrimKey).and((Expression)tempJournalArticleTable.status.eq((Object)0))))).and((Expression)JournalArticleTable.INSTANCE.resourcePrimKey.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{AssetDisplayPageEntryTable.INSTANCE.classPK}).from((Table)AssetDisplayPageEntryTable.INSTANCE).where(AssetDisplayPageEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)AssetDisplayPageEntryTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(JournalArticle.class.getName()))))))));
    }

    public int getArticlesCount(long groupId) {
        return this.journalArticlePersistence.countByGroupId(groupId);
    }

    public int getArticlesCount(long groupId, long folderId) {
        return this.journalArticlePersistence.countByG_F(groupId, folderId);
    }

    public int getArticlesCount(long groupId, long folderId, int status) {
        return this.journalArticlePersistence.countByG_F_ST(groupId, folderId, status);
    }

    public int getArticlesCount(long groupId, String articleId) {
        return this.journalArticlePersistence.countByG_A(groupId, articleId);
    }

    public String getArticleTitle(long articlePK, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getArticleTitle(articlePK, languageId);
    }

    public String getArticleTitle(long articlePK, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this._journalArticleLocalizationPersistence.fetchByA_L(articlePK, languageId);
        if (journalArticleLocalization == null) {
            return null;
        }
        return journalArticleLocalization.getTitle();
    }

    public Map<Locale, String> getArticleTitleMap(long articlePK) {
        HashMap<Locale, String> journalArticleLocalizationTitleMap = new HashMap<Locale, String>();
        List journalArticleLocalizationList = this._journalArticleLocalizationPersistence.findByArticlePK(articlePK);
        for (JournalArticleLocalization journalArticleLocalization : journalArticleLocalizationList) {
            journalArticleLocalizationTitleMap.put(LocaleUtil.fromLanguageId((String)journalArticleLocalization.getLanguageId()), journalArticleLocalization.getTitle());
        }
        return journalArticleLocalizationTitleMap;
    }

    public List<JournalArticle> getCompanyArticles(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByC_V(companyId, version, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_V_ST(companyId, version, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public List<JournalArticle> getCompanyArticles(long companyId, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_ST(companyId, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public int getCompanyArticlesCount(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.countByC_V(companyId, version);
        }
        return this.journalArticlePersistence.countByC_V_ST(companyId, version, status);
    }

    public int getCompanyArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.journalArticlePersistence.countByCompanyId(companyId);
        }
        return this.journalArticlePersistence.countByC_ST(companyId, status);
    }

    public JournalArticle getDisplayArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.fetchDisplayArticle(groupId, articleId);
        if (article == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No approved JournalArticle exists with the key {groupId=", groupId, ", articleId=", articleId, "}"}));
        }
        return article;
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        List articles = null;
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        articles = friendlyURLEntry != null ? this.journalArticlePersistence.findByR_ST(friendlyURLEntry.getClassPK(), 0, -1, -1, (OrderByComparator)new ArticleVersionComparator()) : this.journalArticlePersistence.findByG_UT_ST(groupId, this._friendlyURLNormalizer.normalizeWithEncoding(urlTitle), 0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key {groupId=", groupId, ", urlTitle=", urlTitle, "}"}));
        }
        Date date = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate == null || !displayDate.before(date) || expirationDate != null && !expirationDate.after(date)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public List<Long> getGroupIdsByUrlTitle(long companyId, String urlTitle) {
        return (List)this.journalArticlePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{FriendlyURLEntryLocalizationTable.INSTANCE.groupId}).from((Table)FriendlyURLEntryLocalizationTable.INSTANCE).where(FriendlyURLEntryLocalizationTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)FriendlyURLEntryLocalizationTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(JournalArticle.class.getName())).and((Expression)FriendlyURLEntryLocalizationTable.INSTANCE.urlTitle.eq((Object)urlTitle)))));
    }

    public List<JournalArticle> getIndexableArticlesByDDMStructureKey(String[] ddmStructureKeys) {
        if (this.isReindexAllArticleVersions()) {
            return this.getStructureArticles(ddmStructureKeys);
        }
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        QueryDefinition approvedQueryDefinition = new QueryDefinition(0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_F_C_S_L(0L, Collections.emptyList(), 0L, ddmStructureKeys, LocaleUtil.getMostRelevantLocale(), approvedQueryDefinition));
        QueryDefinition trashQueryDefinition = new QueryDefinition(8, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_F_C_S_L(0L, Collections.emptyList(), 0L, ddmStructureKeys, LocaleUtil.getMostRelevantLocale(), trashQueryDefinition));
        return articles;
    }

    public List<JournalArticle> getIndexableArticlesByDDMStructureKey(String[] ddmStructureKeys, Locale locale) {
        if (this.isReindexAllArticleVersions()) {
            return this.getStructureArticles(ddmStructureKeys);
        }
        QueryDefinition approvedQueryDefinition = new QueryDefinition(0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        articles.addAll(this.journalArticleFinder.findByG_F_C_S_L(0L, Collections.emptyList(), 0L, ddmStructureKeys, locale, approvedQueryDefinition));
        QueryDefinition trashQueryDefinition = new QueryDefinition(8, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_F_C_S_L(0L, Collections.emptyList(), 0L, ddmStructureKeys, locale, trashQueryDefinition));
        return articles;
    }

    public List<JournalArticle> getIndexableArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByR_I(resourcePrimKey, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws PortalException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, 0, 0, 1, (OrderByComparator)orderByComparator);
            }
            if (ListUtil.isEmpty(articles)) {
                articles = this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey, 0, 1, (OrderByComparator)orderByComparator);
            }
        } else {
            articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, status, 0, 1, (OrderByComparator)orderByComparator);
        }
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + resourcePrimKey + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId) throws PortalException {
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator());
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, this._classNameLocalService.getClassNameId(className), classPK, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key {groupId=", groupId, ", className=", className, ", classPK =", classPK, "}"}));
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticleByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        return this.journalArticlePersistence.findByG_ERC_First(groupId, externalReferenceCode, (OrderByComparator)orderByComparator);
    }

    public JournalArticle getLatestArticleByUrlTitle(long groupId, String urlTitle, int status) throws PortalException {
        JournalArticle article = null;
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        article = friendlyURLEntry != null ? this.fetchLatestArticle(friendlyURLEntry.getClassPK(), status) : this.fetchLatestArticleByUrlTitle(groupId, urlTitle, status);
        if (article == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key {groupId=", groupId, ", urlTitle=", urlTitle, ", status=", status, "}"}));
        }
        return article;
    }

    public double getLatestVersion(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        return article.getVersion();
    }

    public double getLatestVersion(long groupId, String articleId, int status) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, status);
        return article.getVersion();
    }

    public List<JournalArticle> getNoAssetArticles() {
        return this.journalArticleFinder.findByNoAssets();
    }

    public List<JournalArticle> getNoPermissionArticles() {
        return this.journalArticleFinder.findByNoPermissions();
    }

    public int getNotInTrashArticlesCount(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalArticleFinder.countByG_F(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), queryDefinition);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId) throws PortalException {
        return this.getOldestArticle(groupId, articleId, -1);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator(true));
    }

    public JournalArticle getPreviousApprovedArticle(JournalArticle article) {
        List approvedArticles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0, 0, 2);
        if (approvedArticles.isEmpty() || approvedArticles.size() == 1 && article.getStatus() == 0) {
            return article;
        }
        JournalArticle previousApprovedArticle = (JournalArticle)approvedArticles.get(0);
        if (approvedArticles.size() > 1 && previousApprovedArticle.getVersion() == article.getVersion()) {
            previousApprovedArticle = (JournalArticle)approvedArticles.get(1);
        }
        return previousApprovedArticle;
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.findByG_DDMSK(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_DDMSK(groupId, ddmStructureKey, start, end, orderByComparator);
    }

    public List<JournalArticle> getStructureArticles(String[] ddmStructureKeys) {
        return this.journalArticlePersistence.findByDDMStructureKey(ddmStructureKeys);
    }

    public int getStructureArticlesCount(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.countByG_DDMSK(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.findByG_DDMTK(groupId, ddmTemplateKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_DDMTK(groupId, ddmTemplateKey, start, end, orderByComparator);
    }

    public int getTemplateArticlesCount(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.countByG_DDMTK(groupId, ddmTemplateKey);
    }

    public String getUniqueUrlTitle(long groupId, String articleId, String urlTitle) throws PortalException {
        JournalArticle article;
        int i = 1;
        while ((article = this.fetchArticleByUrlTitle(groupId, urlTitle)) != null && !articleId.equals(article.getArticleId())) {
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
        return urlTitle;
    }

    public boolean hasArticle(long groupId, String articleId) {
        JournalArticle article = this.fetchArticle(groupId, articleId);
        return article != null;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version) throws PortalException {
        return this.getLatestVersion(groupId, articleId) == version;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version, int status) throws PortalException {
        return this.getLatestVersion(groupId, articleId, status) == version;
    }

    public boolean isListable(JournalArticle article) {
        return article != null && article.isIndexable();
    }

    public boolean isRenderable(JournalArticle article, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            this.getArticleDisplay(article, article.getDDMTemplateKey(), "view", article.getDefaultLanguageId(), 0, portletRequestModel, themeDisplay, true);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
        return true;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        JournalArticle latestArticle = this.getLatestArticle(groupId, articleId);
        this.validateDDMStructureId(groupId, newFolderId, latestArticle.getDDMStructureKey());
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        String treePath = null;
        for (JournalArticle article : articles) {
            article.setFolderId(newFolderId);
            if (treePath == null) {
                treePath = article.buildTreePath();
            }
            article.setTreePath(treePath);
            this.journalArticlePersistence.update((BaseModel)article);
        }
        if (serviceContext != null) {
            this.notifySubscribers(serviceContext.getUserId(), latestArticle, "move_from", serviceContext);
            latestArticle.setFolderId(newFolderId);
            latestArticle.setTreePath(latestArticle.buildTreePath());
            this.notifySubscribers(serviceContext.getUserId(), latestArticle, "move_to", serviceContext);
        }
        return this.getArticle(groupId, articleId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleFromTrash(long userId, long groupId, JournalArticle article, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (!article.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)article)) {
            article = this.restoreArticleFromTrash(userId, article);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), article.getResourcePrimKey());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            article = this.updateStatus(userId, article, status, null, serviceContext, new HashMap<String, Serializable>());
            for (FileEntry fileEntry : article.getImagesFileEntries()) {
                this._portletFileRepository.restorePortletFileEntryFromTrash(userId, fileEntry.getFileEntryId());
            }
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.moveArticle(groupId, article.getArticleId(), newFolderId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleToTrash(long userId, JournalArticle article) throws PortalException {
        if (article.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = article.getStatus();
        if (oldStatus == 1) {
            article.setStatus(2);
            article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        }
        article = this.updateStatus(userId, article.getId(), 8, new HashMap<String, Serializable>(), new ServiceContext());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        articleVersions = ListUtil.sort((List)articleVersions, (Comparator)new ArticleVersionComparator());
        List<Object> articleVersionStatusOVPs = new ArrayList();
        if (articleVersions != null && !articleVersions.isEmpty()) {
            articleVersionStatusOVPs = this.getArticleVersionStatuses(articleVersions);
        }
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), articleResource.getUuid(), null, oldStatus, articleVersionStatusOVPs, UnicodePropertiesBuilder.put((String)"title", (String)article.getArticleId()).build());
        String trashArticleId = this._trashHelper.getTrashTitle(trashEntry.getEntryId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setExternalReferenceCode(trashArticleId);
            articleVersion.setArticleId(trashArticleId);
            articleVersion.setStatus(8);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        articleResource.setArticleId(trashArticleId);
        this._journalArticleResourcePersistence.update((BaseModel)articleResource);
        article.setExternalReferenceCode(trashArticleId);
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this._assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        for (FileEntry fileEntry : article.getImagesFileEntries()) {
            this._portletFileRepository.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
        }
        if (this.isArticleCommentsEnabled(article.getCompanyId())) {
            this._commentManager.moveDiscussionToTrash(JournalArticle.class.getName(), article.getResourcePrimKey());
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)article.getTitleMapAsXML());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)article, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        if (oldStatus == 1) {
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        return article;
    }

    public JournalArticle moveArticleToTrash(long userId, long groupId, String articleId) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (!articles.isEmpty()) {
            return this.journalArticleLocalService.moveArticleToTrash(userId, (JournalArticle)articles.get(0));
        }
        return null;
    }

    public void rebuildTree(long companyId) throws PortalException {
        JournalTreePathUtil.rebuildTree(companyId, 0L, "/", this._journalFolderPersistence, this);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (Objects.equals(languageId, article.getDefaultLanguageId())) {
            throw new RequiredArticleLocalizationException("Default article localization is required");
        }
        JournalArticleLocalization journalArticleLocalization = this._journalArticleLocalizationPersistence.fetchByA_L(article.getId(), languageId);
        if (journalArticleLocalization != null) {
            this._journalArticleLocalizationPersistence.removeByA_L(article.getId(), languageId);
        }
        this._removeArticleLocale(article, languageId);
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(article.getGroupId(), JournalArticle.class, article.getUrlTitle());
        if (friendlyURLEntry == null) {
            return article;
        }
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalService.fetchFriendlyURLEntryLocalization(friendlyURLEntry.getFriendlyURLEntryId(), languageId);
        if (friendlyURLEntryLocalization != null) {
            this.friendlyURLEntryLocalService.deleteFriendlyURLLocalizationEntry(friendlyURLEntry.getFriendlyURLEntryId(), languageId);
        }
        return article;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle restoreArticleFromTrash(long userId, JournalArticle article) throws PortalException {
        if (!article.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        String trashArticleId = this._trashHelper.getOriginalTitle(article.getArticleId());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setExternalReferenceCode(trashArticleId);
            articleVersion.setArticleId(trashArticleId);
            if (!article.equals(articleVersion = (JournalArticle)this.journalArticlePersistence.update((BaseModel)articleVersion))) continue;
            article = articleVersion;
        }
        article.setExternalReferenceCode(trashArticleId);
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        JournalArticleResource articleResource = this._journalArticleResourcePersistence.fetchByPrimaryKey(article.getResourcePrimKey());
        articleResource.setArticleId(trashArticleId);
        this._journalArticleResourcePersistence.update((BaseModel)articleResource);
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(article.getGroupId());
        article = this.updateStatus(userId, article, trashEntry.getStatus(), null, serviceContext, new HashMap<String, Serializable>());
        List trashVersions = this._trashVersionLocalService.getVersions(trashEntry.getEntryId());
        boolean visible = false;
        for (TrashVersion trashVersion : trashVersions) {
            JournalArticle trashArticleVersion = this.journalArticlePersistence.findByPrimaryKey(trashVersion.getClassPK());
            if (!ArrayUtil.contains((int[])new int[]{0, 8}, (int)trashVersion.getStatus())) {
                trashArticleVersion.setStatus(trashVersion.getStatus());
            } else {
                trashArticleVersion.setStatus(trashEntry.getStatus());
            }
            if (trashEntry.getStatus() == 0) {
                visible = true;
            }
            this.journalArticlePersistence.update((BaseModel)trashArticleVersion);
        }
        this._trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (visible) {
            this._assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
        }
        if (this.isArticleCommentsEnabled(article.getCompanyId())) {
            this._commentManager.restoreDiscussionFromTrash(JournalArticle.class.getName(), article.getResourcePrimKey());
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)article.getTitleMapAsXML());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)article, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        return article;
    }

    public List<JournalArticle> search(long groupId, List<Long> folderIds, Locale locale, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.journalArticleFinder.findByG_F_L(groupId, folderIds, locale, queryDefinition);
    }

    public List<JournalArticle> search(long groupId, long folderId, int status, int start, int end) {
        return this.search(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), LocaleUtil.getMostRelevantLocale(), status, start, end);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, Date reviewDate, int status, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticleFinder.findByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, status, start, end, orderByComparator);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, Date reviewDate, int status, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, Date reviewDate, int status, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return indexer.search(searchContext);
    }

    public int searchCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public int searchCount(long groupId, long folderId, int status) {
        return this.searchCount(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), status);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, Date reviewDate, int status) {
        return this.journalArticleFinder.countByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, status);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, Date reviewDate, int status, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, Date reviewDate, int status, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchJournalArticles(companyId, groupId, folderIds, classNameId, articleId, title, description, content, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
        return this.searchJournalArticles(searchContext);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return this.searchJournalArticles(searchContext);
    }

    public void setTreePaths(long folderId, String treePath, boolean reindex) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
        });
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        indexableActionableDynamicQuery.setPerformActionMethod(article -> {
            article.setTreePath(treePath);
            this.updateJournalArticle((JournalArticle)article);
            if (!reindex) {
                return;
            }
            indexableActionableDynamicQuery.setCompanyId(article.getCompanyId());
            indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(article)});
        });
        indexableActionableDynamicQuery.performActions();
    }

    public void subscribe(long userId, long groupId, long articleId) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, JournalArticle.class.getName(), articleId);
    }

    public void subscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, DDMStructure.class.getName(), ddmStructureId);
    }

    public void unsubscribe(long userId, long groupId, long articleId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, JournalArticle.class.getName(), articleId);
    }

    public void unsubscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, DDMStructure.class.getName(), ddmStructureId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        boolean validate;
        JournalArticle latestArticle;
        byte[] smallImageBytes;
        block26: {
            articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
            smallImageBytes = null;
            try {
                smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block26;
                _log.debug((Throwable)ioException);
            }
        }
        JournalArticle article = latestArticle = this.getLatestArticle(groupId, articleId, -1);
        boolean imported = ExportImportThreadLocal.isImportInProcess();
        boolean addNewVersion = false;
        if (imported) {
            article = this.getArticle(groupId, articleId, version);
        } else {
            double latestArticleVersion = latestArticle.getVersion();
            if (version > 0.0 && version != latestArticleVersion) {
                throw new ArticleVersionException(StringBundler.concat((Object[])new Object[]{"Version ", version, " is not the same as ", latestArticleVersion}));
            }
            serviceContext.validateModifiedDate((AuditedModel)latestArticle, ArticleVersionException.class);
            if (latestArticle.isApproved() || latestArticle.isExpired() || latestArticle.isScheduled()) {
                addNewVersion = true;
                version = this.getNextVersion(article);
            }
        }
        User user = this._userLocalService.getUser(userId);
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), null);
        Date expirationDate = null;
        Date reviewDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), ArticleExpirationDateException.class);
        }
        if (!neverReview) {
            reviewDate = this._portal.getDate(reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, user.getTimeZone(), ArticleReviewDateException.class);
        }
        Date date = new Date();
        boolean expired = false;
        if (expirationDate != null && expirationDate.before(date)) {
            expired = true;
        }
        this.sanitize(user.getCompanyId(), groupId, userId, article.getClassPK(), descriptionMap);
        boolean bl = validate = !ExportImportThreadLocal.isImportInProcess();
        if (validate) {
            this.validate(user.getCompanyId(), groupId, latestArticle.getClassNameId(), titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
            try {
                this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, latestArticle.getSmallImageId(), content);
            }
            catch (ExportImportContentValidationException exportImportContentValidationException) {
                exportImportContentValidationException.setStagedModelClassName(JournalArticle.class.getName());
                exportImportContentValidationException.setStagedModelPrimaryKeyObj((Serializable)((Object)articleId));
                throw exportImportContentValidationException;
            }
        }
        if (addNewVersion) {
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(latestArticle.getResourcePrimKey());
            article.setGroupId(latestArticle.getGroupId());
            article.setCompanyId(latestArticle.getCompanyId());
            article.setUserId(latestArticle.getUserId());
            article.setUserName(latestArticle.getUserName());
            article.setCreateDate(latestArticle.getCreateDate());
            article.setExternalReferenceCode(latestArticle.getExternalReferenceCode());
            article.setClassNameId(latestArticle.getClassNameId());
            article.setClassPK(latestArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(version);
            article.setSmallImageId(latestArticle.getSmallImageId());
            serviceContext.setAttribute("version", (Serializable)Double.valueOf(version));
            this._addArticleLocalizedFields(article.getCompanyId(), article.getId(), titleMap, descriptionMap);
        } else {
            this._updateArticleLocalizedFields(article.getCompanyId(), article.getId(), titleMap, descriptionMap);
        }
        Locale locale = this.getArticleDefaultLocale(content);
        Map<String, String> urlTitleMap = this._getURLTitleMap(groupId, article.getResourcePrimKey(), friendlyURLMap, titleMap);
        String urlTitle = urlTitleMap.get(LocaleUtil.toLanguageId((Locale)locale));
        if (Validator.isNull((String)urlTitle) && this._classNameLocalService.getClassNameId(DDMStructure.class) != article.getClassNameId()) {
            throw new ArticleFriendlyURLException();
        }
        article.setFolderId(folderId);
        article.setTreePath(article.buildTreePath());
        article.setUrlTitle(urlTitle);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null && article.getSmallImageId() <= 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        if (latestArticle.isPending()) {
            article.setStatus(latestArticle.getStatus());
        } else if (!expired) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)latestArticle.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge(), (ServiceContext)serviceContext);
        article.setModifiedDate(serviceContext.getModifiedDate(date));
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(serviceContext.getModifiedDate(date));
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.updateFriendlyURLs(article, urlTitleMap, serviceContext);
        if (this.hasModifiedLatestApprovedVersion(groupId, articleId, version)) {
            this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        }
        this.updateDDMFields(article, this._formatContent(article, content, groupId, user));
        if (this._classNameLocalService.getClassNameId(DDMStructure.class) != article.getClassNameId()) {
            this.updateDDMLinks(article.getId(), groupId, ddmStructureKey, ddmTemplateKey, addNewVersion);
        }
        this.saveImages(article.getCompanyId(), smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        if (expired && imported) {
            article = this.updateStatus(userId, article, article.getStatus(), articleURL, serviceContext, new HashMap<String, Serializable>());
        }
        if (serviceContext.getWorkflowAction() == 1) {
            articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
            serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
            serviceContext.setCommand("update");
            this.sendEmail(article, articleURL, "requested", serviceContext);
            this.startWorkflowInstance(userId, article, serviceContext);
        }
        return article;
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, article.getDDMStructureKey(), article.getDDMTemplateKey(), layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), null, null, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, -1);
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            String title = entry.getValue();
            if (Validator.isNull((String)title)) continue;
            String urlTitle = this.friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, this._classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey(), this._friendlyURLNormalizer.normalizeWithPeriods(title), this._language.getLanguageId(entry.getKey()));
            friendlyURLMap.put(entry.getKey(), urlTitle);
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, friendlyURLMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, null, null, null, serviceContext);
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, article.getTitleMap(), article.getDescriptionMap(), content, article.getLayoutUuid(), serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long id, String urlTitle) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByPrimaryKey(id);
        article.setUrlTitle(urlTitle);
        return (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
    }

    public JournalArticle updateArticleDefaultValues(long userId, long groupId, String articleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        JournalArticle article;
        byte[] smallImageBytes;
        User user;
        block8: {
            user = this._userLocalService.getUser(userId);
            articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
            smallImageBytes = null;
            try {
                smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Throwable)ioException);
            }
        }
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), null);
        Date expirationDate = null;
        Date reviewDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), ArticleExpirationDateException.class);
        }
        if (!neverReview) {
            reviewDate = this._portal.getDate(reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, user.getTimeZone(), ArticleReviewDateException.class);
        }
        if ((article = this.getArticle(groupId, articleId)).getClassNameId() > 0L && displayDateMonth == displayDateDay && displayDateDay == displayDateYear && displayDateYear == 0) {
            displayDate = null;
        }
        serviceContext.validateModifiedDate((AuditedModel)article, ArticleVersionException.class);
        this.sanitize(user.getCompanyId(), groupId, userId, article.getClassPK(), descriptionMap);
        this.validate(user.getCompanyId(), groupId, article.getClassNameId(), titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        this._updateArticleLocalizedFields(article.getCompanyId(), article.getId(), titleMap, descriptionMap);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        Locale locale = this.getArticleDefaultLocale(content);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null && article.getSmallImageId() <= 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        article.setStatus(0);
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)article.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge(), (ServiceContext)serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this.updateDDMFields(article, this._formatContent(article, content, groupId, user));
        this.saveImages(article.getCompanyId(), smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException {
        this.validateContent(content);
        JournalArticle oldArticle = this.getLatestArticle(groupId, articleId, -1);
        double oldVersion = oldArticle.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new ArticleVersionException(StringBundler.concat((Object[])new Object[]{"Version ", version, " is not the same as ", oldVersion}));
        }
        boolean incrementVersion = false;
        if (oldArticle.isApproved() || oldArticle.isExpired()) {
            incrementVersion = true;
        }
        if (serviceContext != null) {
            serviceContext.validateModifiedDate((AuditedModel)oldArticle, ArticleVersionException.class);
        }
        JournalArticle article = null;
        User user = this._userLocalService.fetchUser(oldArticle.getUserId());
        if (user == null) {
            user = this._userLocalService.getDefaultUser(oldArticle.getCompanyId());
        }
        if (incrementVersion) {
            double newVersion = this.getNextVersion(oldArticle);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(oldArticle.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(oldArticle.getCreateDate());
            article.setExternalReferenceCode(oldArticle.getExternalReferenceCode());
            article.setFolderId(oldArticle.getFolderId());
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setUrlTitle(this.getUniqueUrlTitle(id, groupId, articleId, title, oldArticle.getUrlTitle(), serviceContext));
            article.setDDMStructureKey(oldArticle.getDDMStructureKey());
            article.setDDMTemplateKey(oldArticle.getDDMTemplateKey());
            article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)this.getArticleDefaultLocale(content)));
            article.setLayoutUuid(oldArticle.getLayoutUuid());
            article.setDisplayDate(oldArticle.getDisplayDate());
            article.setExpirationDate(oldArticle.getExpirationDate());
            article.setReviewDate(oldArticle.getReviewDate());
            article.setIndexable(oldArticle.isIndexable());
            article.setSmallImage(oldArticle.isSmallImage());
            article.setSmallImageId(oldArticle.getSmallImageId());
            if (article.getSmallImageId() == 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
            article.setSmallImageURL(oldArticle.getSmallImageURL());
            article.setStatus(2);
            User statusUser = this._userLocalService.fetchUser(serviceContext.getUserId());
            if (statusUser == null) {
                statusUser = this._userLocalService.getDefaultUser(oldArticle.getCompanyId());
            }
            article.setStatusByUserId(statusUser.getUserId());
            article.setStatusByUserName(statusUser.getFullName());
            article.setStatusDate(new Date());
            ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)oldArticle.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge());
            this._addArticleLocalizedFields(article.getCompanyId(), article.getId(), oldArticle.getTitleMap(), oldArticle.getDescriptionMap());
        } else {
            article = oldArticle;
        }
        this._updateArticleLocalizedFields(article.getCompanyId(), article.getId(), title, description, LocaleUtil.toLanguageId((Locale)locale));
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.updateDDMFields(article, this._formatContent(article, content, groupId, user));
        if (incrementVersion) {
            this.updateDDMLinks(article.getId(), groupId, oldArticle.getDDMStructureKey(), oldArticle.getDDMTemplateKey(), true);
        }
        return article;
    }

    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        boolean visible = article.isApproved();
        if (article.getClassNameId() != 0L) {
            visible = false;
        }
        boolean addDraftAssetEntry = this._addDraftAssetEntry(article);
        AssetEntry assetEntry = null;
        String title = article.getTitleMapAsXML();
        String description = article.getDescriptionMapAsXML();
        if (addDraftAssetEntry) {
            assetEntry = this._assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getPrimaryKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), false, null, null, null, article.getExpirationDate(), "text/html", title, description, description, null, article.getLayoutUuid(), 0, 0, priority);
        } else {
            JournalArticleResource journalArticleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
            Date publishDate = null;
            if (article.isApproved()) {
                publishDate = article.getDisplayDate();
            }
            assetEntry = this._assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), journalArticleResource.getResourcePrimKey(), journalArticleResource.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), visible, null, null, publishDate, article.getExpirationDate(), "text/html", title, description, description, null, article.getLayoutUuid(), 0, 0, priority);
        }
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public void updateDDMTemplateKey(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) {
        List articles = this.journalArticlePersistence.findByG_C_DDMTK(groupId, classNameId, oldDDMTemplateKey);
        for (JournalArticle article : articles) {
            article.setDDMTemplateKey(newDDMTemplateKey);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateStatus(long userId, JournalArticle article, int status, String articleURL, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        if (status == 0 && article.getDisplayDate() != null && date.before(article.getDisplayDate())) {
            status = 7;
        }
        int oldStatus = article.getStatus();
        Date modifiedDate = serviceContext.getModifiedDate(date);
        article.setModifiedDate(modifiedDate);
        Date expirationDate = article.getExpirationDate();
        if (status == 0 && expirationDate != null && expirationDate.before(date)) {
            article.setExpirationDate(null);
        }
        if (status == 3 && expirationDate == null) {
            article.setExpirationDate(date);
        }
        article.setStatus(status);
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(modifiedDate);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        if (this.isExpireAllArticleVersions(article.getCompanyId()) && expirationDate != null && expirationDate.before(date)) {
            article = this.setArticlesExpirationDate(article);
        }
        if (this.hasModifiedLatestApprovedVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            if (status == 0) {
                AssetEntry draftAssetEntry;
                this.updateUrlTitles(article.getGroupId(), article.getArticleId(), article.getUrlTitle());
                String title = article.getTitleMapAsXML();
                if (oldStatus != 0 && article.getVersion() != 1.0 && (draftAssetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getPrimaryKey())) != null) {
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this._assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0, false);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    String description = article.getDescriptionMapAsXML();
                    AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), false, null, null, null, null, "text/html", title, description, description, null, article.getLayoutUuid(), 0, 0, Double.valueOf(draftAssetEntry.getPriority()));
                    this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    this._assetEntryLocalService.deleteEntry(draftAssetEntry.getEntryId());
                }
                this._assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), article.getDisplayDate(), article.getExpirationDate(), this.isListable(article), true);
                this.expireMaxVersionArticles(article, user.getUserId(), serviceContext, articleURL);
                JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)title);
                if (serviceContext.isCommandUpdate()) {
                    SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)article, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                } else {
                    SocialActivityManagerUtil.addUniqueActivity((long)user.getUserId(), (ClassedModel)article, (int)1, (String)extraDataJSONObject.toString(), (long)0L);
                }
            } else if (oldStatus == 0 && status != 8) {
                this.updatePreviousApprovedArticle(article);
            }
        }
        String action = "update";
        if (oldStatus != 8 && status != 8) {
            if (oldStatus == 1 && (status == 0 || status == 4)) {
                String msg = "granted";
                if (status == 4) {
                    msg = "denied";
                }
                try {
                    articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
                    this.sendEmail(article, articleURL, msg, serviceContext);
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to send email to notify the change of ", "status to ", msg, " for article ", article.getId(), ": ", exception.getMessage()}));
                }
            }
            if (article.equals(this.getOldestArticle(article.getGroupId(), article.getArticleId()))) {
                action = "add";
            }
        }
        if (oldStatus != 8 && status == 8) {
            action = "move_to_trash";
        } else if (oldStatus == 8 && status != 8) {
            action = "move_from_trash";
        }
        Group group = this._groupLocalService.getGroup(article.getGroupId());
        if (!group.isStaged() || group.isStagingGroup()) {
            this.notifySubscribers(user.getUserId(), article, action, serviceContext);
        }
        return article;
    }

    public JournalArticle updateStatus(long userId, long classPK, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        return this.journalArticleLocalService.updateStatus(userId, this.getArticle(classPK), status, null, serviceContext, workflowContext);
    }

    public JournalArticle updateStatus(long userId, long groupId, String articleId, double version, int status, String articleURL, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateStatus(userId, article, status, articleURL, serviceContext, workflowContext);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        JournalArticleImpl.setDDMFormValuesToFieldsConverter(this._ddmFormValuesToFieldsConverter);
        JournalArticleImpl.setJournalConverter(this._journalConverter);
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, TransformerListener.class, (String)"(javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addImageFileEntries(JournalArticle article, String value) throws PortalException {
        FileEntry finalTempFileEntry;
        String string;
        if (ExportImportThreadLocal.isImportInProcess()) {
            return value;
        }
        JSONObject valueJSONObject = this._jsonFactory.createJSONObject(value);
        FileEntry fileEntry = this._getFileEntry(valueJSONObject);
        if (fileEntry == null) {
            return value;
        }
        FileEntry tempFileEntry = null;
        try {
            boolean tempFile = fileEntry.isRepositoryCapabilityProvided(TemporaryFileEntriesCapability.class);
            if (tempFile) {
                tempFileEntry = fileEntry;
                Folder folder = article.addImagesFolder();
                String fileEntryName = DLUtil.getUniqueFileName((long)folder.getGroupId(), (long)folder.getFolderId(), (String)tempFileEntry.getFileName(), (boolean)false);
                fileEntry = this._portletFileRepository.addPortletFileEntry(null, folder.getGroupId(), tempFileEntry.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), "com.liferay.journal", folder.getFolderId(), tempFileEntry.getContentStream(), fileEntryName, tempFileEntry.getMimeType(), false);
            }
            String previewURL = this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, true);
            string = this._toJSON(valueJSONObject.getString("alt"), article, fileEntry, valueJSONObject.getString("height"), valueJSONObject.getString("type"), previewURL, valueJSONObject.getString("width"));
            finalTempFileEntry = tempFileEntry;
        }
        catch (Throwable throwable) {
            FileEntry finalTempFileEntry2 = tempFileEntry;
            TransactionCommitCallbackUtil.registerCallback(() -> {
                FileEntry persistedFileEntry;
                if (finalTempFileEntry2 != null && (persistedFileEntry = this._portletFileRepository.fetchPortletFileEntry(finalTempFileEntry2.getGroupId(), finalTempFileEntry2.getFolderId(), finalTempFileEntry2.getFileName())) != null) {
                    TempFileEntryUtil.deleteTempFileEntry((long)finalTempFileEntry2.getFileEntryId());
                }
                return null;
            });
            throw throwable;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            FileEntry persistedFileEntry;
            if (finalTempFileEntry2 != null && (persistedFileEntry = this._portletFileRepository.fetchPortletFileEntry(finalTempFileEntry2.getGroupId(), finalTempFileEntry2.getFolderId(), finalTempFileEntry2.getFileName())) != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)finalTempFileEntry2.getFileEntryId());
            }
            return null;
        });
        return string;
    }

    protected String buildArticleURL(String articleURL, long groupId, long folderId, String articleId) {
        String namespace = this._portal.getPortletNamespace(PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT));
        articleURL = HttpComponentsUtil.addParameter((String)articleURL, (String)(namespace + "groupId"), (long)groupId);
        articleURL = HttpComponentsUtil.addParameter((String)articleURL, (String)(namespace + "folderId"), (long)folderId);
        articleURL = HttpComponentsUtil.addParameter((String)articleURL, (String)(namespace + "articleId"), (String)articleId);
        return articleURL;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"articleId", (Object)articleId).put((Object)"classNameId", (Object)classNameId).put((Object)"content", (Object)content).put((Object)"description", (Object)description).put((Object)"status", (Object)status).put((Object)"title", (Object)title).put((Object)"ddmStructureKey", (Object)ddmStructureKey).put((Object)"ddmTemplateKey", (Object)ddmTemplateKey).put((Object)"params", params).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setGroupIds(new long[]{groupId});
        if (params != null) {
            searchContext.setIncludeDiscussions(GetterUtil.getBoolean((Object)params.get("includeDiscussions")));
            String keywords = (String)params.remove("keywords");
            if (Validator.isNotNull((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        Group group = this._groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    protected void checkArticlesByCompanyIdAndExpirationDate(long companyId, Date expirationDate, Date nextExpirationDate) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)0L));
            Property expirationDateProperty = PropertyFactoryUtil.forName((String)"expirationDate");
            dynamicQuery.add(expirationDateProperty.le((Object)nextExpirationDate));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(article -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Expiring article " + article.getId()));
            }
            if (this.isExpireAllArticleVersions(companyId)) {
                List currentArticles = this.journalArticleLocalService.getArticles(article.getGroupId(), article.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
                for (JournalArticle currentArticle : currentArticles) {
                    if (currentArticle.getVersion() >= article.getVersion()) continue;
                    currentArticle.setExpirationDate(article.getExpirationDate());
                    currentArticle.setStatus(3);
                    this.journalArticlePersistence.update((BaseModel)currentArticle);
                }
            }
            article.setStatus(3);
            article = this.journalArticleLocalService.updateJournalArticle(article);
            this.updatePreviousApprovedArticle((JournalArticle)article);
            if (indexer != null) {
                indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(article)});
            }
        });
        indexableActionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        indexableActionableDynamicQuery.performActions();
    }

    protected void checkArticlesByDisplayDate(Date displayDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Publishing articles with display date less than ", displayDate, " and status ", 7}));
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property displayDateProperty = PropertyFactoryUtil.forName((String)"displayDate");
            dynamicQuery.add(displayDateProperty.lt((Object)displayDate));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)7));
        });
        actionableDynamicQuery.setPerformActionMethod(article -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Publishing article " + article.getId()));
            }
            long userId = this._portal.getValidUserId(article.getCompanyId(), article.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            serviceContext.setScopeGroupId(article.getGroupId());
            this.journalArticleLocalService.updateStatus(userId, article.getId(), 0, new HashMap(), serviceContext);
        });
        actionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        actionableDynamicQuery.performActions();
    }

    protected void checkArticlesByExpirationDate(Date expirationDate) throws PortalException {
        long checkInterval = this.getArticleCheckInterval();
        Date nextExpirationDate = new Date(expirationDate.getTime() + checkInterval);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expiring articles with expiration date less than or ", "equal to ", nextExpirationDate, " and status ", 0}));
        }
        this._companyLocalService.forEachCompanyId(companyId -> this.checkArticlesByCompanyIdAndExpirationDate((long)companyId, expirationDate, nextExpirationDate));
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(expirationDate.getTime() - this.getArticleCheckInterval());
        }
    }

    protected void checkArticlesByReviewDate(Date reviewDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending review notification for articles with reviewDate ", "between ", this._previousCheckDate, " and ", reviewDate}));
        }
        List articles = this.journalArticleFinder.findByReviewDate(0L, reviewDate, this._previousCheckDate);
        for (JournalArticle article : articles) {
            if (article.isInTrash() || !this.journalArticleLocalService.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Sending review notification for article " + article.getId()));
            }
            String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            String articleURL = this._portal.getControlPanelFullURL(article.getGroupId(), portletId, null);
            articleURL = HttpComponentsUtil.addParameter((String)articleURL, (String)(this._portal.getPortletNamespace(portletId) + "mvcPath"), (String)"/edit_article.jsp");
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, "review", new ServiceContext());
        }
    }

    protected DDMFormValues copyArticleImages(JournalArticle oldArticle, JournalArticle newArticle) {
        DDMFormValues ddmFormValues;
        block2: {
            ddmFormValues = oldArticle.getDDMFormValues();
            try {
                Folder folder = newArticle.addImagesFolder();
                this._copyArticleImages(newArticle, ddmFormValues.getDDMFormFieldValues(), oldArticle.getGroupId(), folder.getFolderId());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        return ddmFormValues;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        JournalArticleImpl.setDDMFormValuesToFieldsConverter(null);
        JournalArticleImpl.setJournalConverter(null);
        this._serviceTrackerList.close();
    }

    protected void expireMaxVersionArticles(JournalArticle article, long userId, ServiceContext serviceContext, String articleURL) throws PortalException {
        int journalArticleMaxVersionCount = this.getJournalArticleMaxVersionCount();
        if (journalArticleMaxVersionCount <= 0) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Expiring oldest articles past the maximum version limit");
        }
        List articles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0);
        for (int i = journalArticleMaxVersionCount; i < articles.size(); ++i) {
            JournalArticle curArticle = (JournalArticle)articles.get(i);
            this.expireArticle(userId, curArticle.getGroupId(), curArticle.getArticleId(), curArticle.getVersion(), articleURL, serviceContext);
        }
    }

    protected JournalArticle fetchLatestLiveArticle(JournalArticle article) throws PortalException {
        Group group = this._groupLocalService.getGroup(article.getGroupId());
        long liveGroupId = group.getLiveGroupId();
        if (liveGroupId == 0L) {
            return null;
        }
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(article.getArticleResourceUuid(), liveGroupId);
        if (articleResource == null) {
            return null;
        }
        return this.journalArticleLocalService.fetchLatestArticle(articleResource.getResourcePrimKey(), -1, false);
    }

    protected void format(User user, long groupId, JournalArticle article, List<DDMFormFieldValue> ddmFormFieldValues) throws PortalException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            Value oldValue;
            if (ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) {
                this.format(user, groupId, article, ddmFormFieldValue.getNestedDDMFormFieldValues());
            }
            if (Objects.equals(ddmFormFieldValue.getType(), "fieldset") || (oldValue = ddmFormFieldValue.getValue()) == null) continue;
            LocalizedValue newValue = new LocalizedValue();
            newValue.setDefaultLocale(oldValue.getDefaultLocale());
            for (Locale locale : oldValue.getAvailableLocales()) {
                String content = oldValue.getString(locale);
                if (Validator.isNull((String)content)) {
                    newValue.addString(locale, content);
                    continue;
                }
                if (Objects.equals(ddmFormFieldValue.getType(), "image")) {
                    content = this.addImageFileEntries(article, content);
                } else if (Objects.equals(ddmFormFieldValue.getType(), "rich_text") || Objects.equals(ddmFormFieldValue.getType(), "text")) {
                    String contentType = "text/plain";
                    if (Objects.equals(ddmFormFieldValue.getType(), "rich_text")) {
                        contentType = "text/html";
                    }
                    content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)contentType, (String)content);
                }
                newValue.addString(locale, content);
            }
            ddmFormFieldValue.setValue((Value)newValue);
        }
    }

    protected long getArticleCheckInterval() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return (long)journalServiceConfiguration.checkInterval() * 60000L;
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected Locale getArticleDefaultLocale(String content) {
        String defaultLanguageId = this._localization.getDefaultLanguageId(content);
        if (Validator.isNotNull((String)defaultLanguageId)) {
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        return LocaleUtil.getSiteDefault();
    }

    protected JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay, boolean propagateException) throws PortalException {
        String content = null;
        if (page < 1) {
            page = 1;
        }
        int numberOfPages = 1;
        boolean paginate = false;
        boolean cacheable = true;
        try {
            DDMTemplate ddmTemplate;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Transforming ", article.getArticleId(), " ", article.getVersion(), " ", languageId}));
            }
            if ((ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(article.getGroupId()), this._classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true)) == null && !Objects.equals(article.getDDMTemplateKey(), ddmTemplateKey)) {
                ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(article.getGroupId()), this._classNameLocalService.getClassNameId(DDMStructure.class), article.getDDMTemplateKey(), true);
            }
            String script = "";
            if (ddmTemplate != null) {
                script = ddmTemplate.getScript();
                cacheable = ddmTemplate.isCacheable();
            } else {
                DDMStructure ddmStructure = article.getDDMStructure();
                script = this._journalDefaultTemplateProvider.getScript(ddmStructure.getStructureId());
                cacheable = this._journalDefaultTemplateProvider.isCacheable();
            }
            content = this._journalTransformer.transform(article, ddmTemplate, this._journalHelper, languageId, this._layoutDisplayPageProviderRegistry, ListUtil.filter((List)this._serviceTrackerList.toList(), TransformerListener::isEnabled), portletRequestModel, propagateException, script, themeDisplay, viewMode);
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, article.getCompanyId());
            String[] pieces = StringUtil.split((String)content, (String)journalServiceConfiguration.journalArticlePageBreakToken());
            if (pieces.length > 1) {
                if (page > pieces.length) {
                    page = 1;
                }
                content = pieces[page - 1];
                numberOfPages = pieces.length;
                paginate = true;
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        return new JournalArticleDisplayImpl(article.getCompanyId(), article.getId(), article.getResourcePrimKey(), article.getGroupId(), article.getUserId(), article.getArticleId(), article.getVersion(), article.getTitle(languageId), article.getUrlTitle(), article.getDescription(languageId), article.getAvailableLanguageIds(), content, article.getDDMStructureKey(), ddmTemplateKey, article.isSmallImage(), article.getSmallImageId(), article.getSmallImageURL(), numberOfPages, page, paginate, cacheable);
    }

    protected List<ObjectValuePair<Long, Integer>> getArticleVersionStatuses(List<JournalArticle> articles) {
        ArrayList<ObjectValuePair<Long, Integer>> articleVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(articles.size());
        for (JournalArticle article : articles) {
            int status = article.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair articleVersionStatusOVP = new ObjectValuePair((Object)article.getId(), (Object)status);
            articleVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)articleVersionStatusOVP);
        }
        return articleVersionStatusOVPs;
    }

    protected long getClassTypeId(JournalArticle article) {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(article.getGroupId()), this._classNameLocalService.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        return ddmStructure.getStructureId();
    }

    protected JournalArticle getFirstArticle(long groupId, String articleId, int status, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        if (status == -1) {
            return this.journalArticlePersistence.findByG_A_NotST_First(groupId, articleId, 8, orderByComparator);
        }
        return this.journalArticlePersistence.findByG_A_ST_First(groupId, articleId, status, orderByComparator);
    }

    protected int getJournalArticleMaxVersionCount() throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        return journalServiceConfiguration.journalArticleMaxVersionCount();
    }

    protected JournalGroupServiceConfiguration getJournalGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (JournalGroupServiceConfiguration)this.configurationProvider.getConfiguration(JournalGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.journal"));
    }

    protected double getNextVersion(JournalArticle article) throws PortalException {
        double nextVersion = article.getVersion();
        JournalArticle latestLiveArticle = this.fetchLatestLiveArticle(article);
        if (latestLiveArticle != null && latestLiveArticle.getVersion() > nextVersion) {
            nextVersion = latestLiveArticle.getVersion();
        }
        return MathUtil.format((double)(nextVersion + 0.1), (int)1, (int)1);
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title) throws PortalException {
        return this.getUniqueUrlTitle(groupId, articleId, JournalUtil.getUrlTitle(id, title));
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title, String oldUrlTitle, ServiceContext serviceContext) throws PortalException {
        String serviceContextUrlTitle = ParamUtil.getString((ServiceContext)serviceContext, (String)"urlTitle");
        String urlTitle = null;
        if (Validator.isNotNull((String)serviceContextUrlTitle)) {
            urlTitle = JournalUtil.getUrlTitle(id, serviceContextUrlTitle);
        } else {
            if (Validator.isNotNull((String)oldUrlTitle)) {
                return oldUrlTitle;
            }
            urlTitle = this.getUniqueUrlTitle(id, groupId, articleId, title);
        }
        JournalArticle urlTitleArticle = this.fetchArticleByUrlTitle(groupId, urlTitle);
        if (urlTitleArticle != null && !Objects.equals(urlTitleArticle.getArticleId(), articleId)) {
            urlTitle = this.getUniqueUrlTitle(id, groupId, articleId, urlTitle);
        }
        return urlTitle;
    }

    protected boolean hasModifiedLatestApprovedVersion(long groupId, String articleId, double version) {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        return article == null || article.getVersion() <= version;
    }

    protected boolean isArticleCommentsEnabled(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.articleCommentsEnabled();
    }

    protected boolean isExpireAllArticleVersions(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.expireAllArticleVersionsEnabled();
    }

    protected boolean isReindexAllArticleVersions() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    protected void notifySubscribers(long userId, JournalArticle article, String action, ServiceContext serviceContext) throws PortalException {
        String articleContent;
        String fromAddress;
        JournalFolder folder;
        GroupSubscriptionCheckSubscriptionSender subscriptionSender;
        block15: {
            JournalArticle liveGroupArticle;
            DDMStructure ddmStructure;
            JournalGroupServiceConfiguration journalGroupServiceConfiguration = this.getJournalGroupServiceConfiguration(article.getGroupId());
            if (!(action.equals("add") && journalGroupServiceConfiguration.emailArticleAddedEnabled() || action.equals("move_to") && journalGroupServiceConfiguration.emailArticleMovedToFolderEnabled() || action.equals("move_to_trash") && journalGroupServiceConfiguration.emailArticleMovedToTrashEnabled() || action.equals("move_from") && journalGroupServiceConfiguration.emailArticleMovedFromFolderEnabled() || action.equals("move_from_trash") && journalGroupServiceConfiguration.emailArticleMovedToTrashEnabled() || action.equals("update") && journalGroupServiceConfiguration.emailArticleUpdatedEnabled())) {
                return;
            }
            subscriptionSender = new GroupSubscriptionCheckSubscriptionSender("com.liferay.journal");
            subscriptionSender.setClassName(article.getModelClassName());
            subscriptionSender.setClassPK(article.getId());
            subscriptionSender.setCompanyId(article.getCompanyId());
            folder = this._journalFolderPersistence.fetchByPrimaryKey(article.getFolderId());
            subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), article.getGroupId());
            Group group = this._groupLocalService.getGroup(article.getGroupId());
            long liveGroupId = group.getLiveGroupId();
            subscriptionSender.addAssetEntryPersistedSubscribers(JournalArticle.class.getName(), article.getResourcePrimKey());
            if (liveGroupId > 0L) {
                subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), liveGroupId, false);
            }
            if (folder != null) {
                subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), folder.getFolderId());
                for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                    subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), ancestorFolderId.longValue());
                }
                if (liveGroupId > 0L && (folder = this._journalFolderPersistence.fetchByUUID_G(folder.getUuid(), liveGroupId)) != null) {
                    subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), folder.getFolderId(), false);
                    for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                        subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), ancestorFolderId.longValue(), false);
                    }
                }
            }
            if ((ddmStructure = this.ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(article.getGroupId()), this._classNameLocalService.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true)) != null) {
                subscriptionSender.addPersistedSubscribers(DDMStructure.class.getName(), ddmStructure.getStructureId());
            }
            subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), article.getResourcePrimKey());
            if (liveGroupId > 0L && (liveGroupArticle = this.journalArticlePersistence.fetchByUUID_G(article.getUuid(), liveGroupId)) != null) {
                subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), liveGroupArticle.getResourcePrimKey(), false);
            }
            if (!subscriptionSender.hasSubscribers()) {
                return;
            }
            fromAddress = journalGroupServiceConfiguration.emailFromAddress();
            this._populateSubscriptionSender(article, JournalUtil.getJournalControlPanelLink(article.getFolderId(), article.getGroupId(), serviceContext.getLiferayPortletResponse()), action, fromAddress, journalGroupServiceConfiguration.emailFromName(), journalGroupServiceConfiguration, serviceContext, (SubscriptionSender)subscriptionSender);
            articleContent = "";
            try {
                PortletRequestModel portletRequestModel = null;
                if (!ExportImportThreadLocal.isImportInProcess()) {
                    portletRequestModel = new PortletRequestModel((PortletRequest)serviceContext.getLiferayPortletRequest(), (PortletResponse)serviceContext.getLiferayPortletResponse());
                }
                JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, article.getDDMTemplateKey(), "view", LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), 1, portletRequestModel, serviceContext.getThemeDisplay());
                articleContent = articleDisplay.getContent();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block15;
                _log.debug((Throwable)exception);
            }
        }
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)articleContent, false);
        String folderName = "";
        if (folder != null) {
            folderName = folder.getName();
        } else if (article.getFolderId() == 0L) {
            folderName = this._language.get(LocaleUtil.getSiteDefault(), "home");
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$FOLDER_NAME$]", folderName, "[$ARTICLE_STATUS$]", this._language.get(LocaleUtil.getSiteDefault(), WorkflowConstants.getStatusLabel((int)article.getStatus()))});
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(article.getTitle(serviceContext.getLanguageId()));
        subscriptionSender.setNotificationType(this._getNotificationType(action));
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void sanitize(long companyId, long groupId, long userId, long classPK, Map<Locale, String> descriptionMap) throws PortalException {
        if (descriptionMap == null) {
            return;
        }
        for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
            String description = SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)JournalArticle.class.getName(), (long)classPK, (String)"text/html", (String)entry.getValue());
            descriptionMap.put(entry.getKey(), description);
        }
    }

    protected void saveImages(long companyId, boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this._imageLocalService.updateImage(companyId, smallImageId, smallImageBytes);
            }
        } else {
            this._imageLocalService.deleteImage(smallImageId);
        }
    }

    protected BaseModelSearchResult<JournalArticle> searchJournalArticles(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, JournalUtil.SELECTED_FIELD_NAMES);
            List articles = this._journalHelper.getArticles(hits);
            if (articles == null) continue;
            return new BaseModelSearchResult(articles, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void sendEmail(JournalArticle article, String articleURL, String emailType, ServiceContext serviceContext) throws PortalException {
        JournalGroupServiceConfiguration journalGroupServiceConfiguration = this.getJournalGroupServiceConfiguration(article.getGroupId());
        if (!(emailType.equals("denied") && journalGroupServiceConfiguration.emailArticleApprovalDeniedEnabled() || emailType.equals("granted") && journalGroupServiceConfiguration.emailArticleApprovalGrantedEnabled() || emailType.equals("requested") && journalGroupServiceConfiguration.emailArticleApprovalRequestedEnabled() || emailType.equals("review") && journalGroupServiceConfiguration.emailArticleReviewEnabled())) {
            return;
        }
        User user = this._userLocalService.fetchUser(article.getUserId());
        if (user == null) {
            return;
        }
        String fromName = journalGroupServiceConfiguration.emailFromName();
        String fromAddress = journalGroupServiceConfiguration.emailFromAddress();
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (emailType.equals("requested")) {
            String tempToName = fromName;
            String tempToAddress = fromAddress;
            fromName = toName;
            fromAddress = toAddress;
            toName = tempToName;
            toAddress = tempToAddress;
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        this._populateSubscriptionSender(article, articleURL, emailType, fromAddress, fromName, journalGroupServiceConfiguration, serviceContext, subscriptionSender);
        subscriptionSender.setClassPK(article.getPrimaryKey());
        subscriptionSender.setContextAttribute("[$ARTICLE_USER_NAME$]", (Object)article.getUserName());
        subscriptionSender.setEntryTitle(article.getTitle(user.getLocale()));
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected JournalArticle setArticlesExpirationDate(JournalArticle article) {
        if (ExportImportThreadLocal.isImportInProcess() || !article.isApproved() || article.getExpirationDate() == null) {
            return article;
        }
        List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        Date expirationDate = article.getExpirationDate();
        for (JournalArticle curArticle : articles) {
            curArticle.setExpirationDate(expirationDate);
            if (!article.equals(curArticle = this.journalArticleLocalService.updateJournalArticle(curArticle))) continue;
            article = curArticle;
        }
        return article;
    }

    protected void startWorkflowInstance(long userId, JournalArticle article, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)article.getCompanyId(), (long)article.getGroupId(), (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext, workflowContext);
    }

    protected void updateDDMFields(JournalArticle article, DDMFormValues ddmFormValues) throws PortalException {
        block2: {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(article.getGroupId()), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
            this._ddmFieldLocalService.updateDDMFormValues(ddmStructure.getStructureId(), article.getId(), ddmFormValues);
            try {
                Fields fields = this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
                String content = this._journalConverter.getContent(ddmStructure, fields, article.getGroupId());
                article.setDocument(SAXReaderUtil.read((String)content));
                this.journalArticlePersistence.cacheResult(article);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
    }

    protected void updateDDMLinks(long id, long groupId, String ddmStructureKey, String ddmTemplateKey, boolean incrementVersion) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
        if (incrementVersion) {
            DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getStructureVersion(ddmStructure.getStructureId(), ddmStructure.getVersion());
            this.ddmStorageLinkLocalService.addStorageLink(ddmStructure.getClassNameId(), id, ddmStructureVersion.getStructureVersionId(), new ServiceContext());
            this.ddmStructureLinkLocalService.addStructureLink(this._classNameLocalService.getClassNameId(JournalArticle.class), id, ddmStructure.getStructureId());
            if (ddmTemplate != null) {
                this.ddmTemplateLinkLocalService.addTemplateLink(this._classNameLocalService.getClassNameId(JournalArticle.class), id, ddmTemplate.getTemplateId());
            }
        } else {
            DDMStorageLink ddmStorageLink = this.ddmStorageLinkLocalService.getClassStorageLink(id);
            ddmStorageLink.setStructureId(ddmStructure.getStructureId());
            this.ddmStorageLinkLocalService.updateDDMStorageLink(ddmStorageLink);
            int count = this.ddmStructureLinkLocalService.getStructureLinksCount(this._classNameLocalService.getClassNameId(JournalArticle.class), id);
            if (count == 0) {
                this.ddmStructureLinkLocalService.addStructureLink(this._classNameLocalService.getClassNameId(JournalArticle.class), id, ddmStructure.getStructureId());
            } else {
                DDMStructureLink ddmStructureLink = this.ddmStructureLinkLocalService.getUniqueStructureLink(this._classNameLocalService.getClassNameId(JournalArticle.class), id);
                ddmStructureLink.setStructureId(ddmStructure.getStructureId());
                this.ddmStructureLinkLocalService.updateDDMStructureLink(ddmStructureLink);
            }
            if (ddmTemplate != null) {
                this.ddmTemplateLinkLocalService.updateTemplateLink(this._classNameLocalService.getClassNameId(JournalArticle.class), id, ddmTemplate.getTemplateId());
            }
        }
    }

    protected void updateFriendlyURLs(JournalArticle article, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess() || ExportImportThreadLocal.isStagingInProcess()) {
            return;
        }
        List friendlyURLEntries = this.friendlyURLEntryLocalService.getFriendlyURLEntries(article.getGroupId(), this._classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        FriendlyURLEntry newFriendlyURLEntry = this.friendlyURLEntryLocalService.addFriendlyURLEntry(article.getGroupId(), this._classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey(), urlTitleMap, serviceContext);
        for (Map.Entry<String, String> entry : urlTitleMap.entrySet()) {
            if (!Validator.isNull((String)entry.getValue())) continue;
            for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
                try {
                    this.friendlyURLEntryLocalService.deleteFriendlyURLLocalizationEntry(friendlyURLEntry.getFriendlyURLEntryId(), entry.getKey());
                }
                catch (NoSuchFriendlyURLEntryLocalizationException noSuchFriendlyURLEntryLocalizationException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)noSuchFriendlyURLEntryLocalizationException);
                }
            }
        }
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            if (newFriendlyURLEntry.getFriendlyURLEntryId() == friendlyURLEntry.getFriendlyURLEntryId()) continue;
            this.friendlyURLEntryLocalService.deleteFriendlyURLEntry(friendlyURLEntry);
        }
    }

    protected void updatePreviousApprovedArticle(JournalArticle article) throws PortalException {
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        if (previousApprovedArticle.getVersion() == article.getVersion()) {
            AssetEntry assetEntry = this._assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
            if (article.getStatus() == 3) {
                assetEntry.setExpirationDate(article.getExpirationDate());
                this._assetEntryLocalService.updateAssetEntry(assetEntry);
            }
        } else {
            AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), previousApprovedArticle.getDisplayDate(), previousApprovedArticle.getExpirationDate(), this.isListable(article), true);
            assetEntry.setModifiedDate(previousApprovedArticle.getModifiedDate());
            assetEntry.setTitle(previousApprovedArticle.getTitleMapAsXML());
            this._assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected void updateUrlTitles(long groupId, String articleId, String urlTitle) throws PortalException {
        JournalArticle firstArticle = this.journalArticlePersistence.findByG_A_First(groupId, articleId, (OrderByComparator)new ArticleVersionComparator(false));
        String firstArticleUrlTitle = firstArticle.getUrlTitle();
        if (firstArticleUrlTitle.equals(urlTitle)) {
            return;
        }
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            String curArticleUrlTitle = article.getUrlTitle();
            if (curArticleUrlTitle.equals(urlTitle)) continue;
            article.setUrlTitle(urlTitle);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        this._getModelValidator().validate(companyId, groupId, classNameId, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    protected void validate(String articleId) throws PortalException {
        this._getModelValidator().validate(articleId);
    }

    protected void validate(String externalReferenceCode, long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        this._getModelValidator().validate(externalReferenceCode, companyId, groupId, classNameId, articleId, autoArticleId, version, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    protected void validateContent(String content) throws PortalException {
        this._getModelValidator().validateContent(content);
    }

    protected void validateDDMStructureId(long groupId, long folderId, String ddmStructureKey) throws PortalException {
        this._getModelValidator().validateDDMStructureId(groupId, folderId, ddmStructureKey);
    }

    protected void validateReferences(long groupId, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean smallImage, String smallImageURL, byte[] smallImageBytes, long smallImageId, String content) throws PortalException {
        this._getModelValidator().validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, smallImageId, content);
    }

    private List<JournalArticleLocalization> _addArticleLocalizedFields(long companyId, long articlePK, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) {
        HashSet<Locale> localeSet = new HashSet<Locale>();
        localeSet.addAll(titleMap.keySet());
        if (descriptionMap != null) {
            localeSet.addAll(descriptionMap.keySet());
        }
        ArrayList<JournalArticleLocalization> journalArticleLocalizations = new ArrayList<JournalArticleLocalization>();
        for (Locale locale : localeSet) {
            String title = titleMap.get(locale);
            String description = null;
            if (descriptionMap != null) {
                description = descriptionMap.get(locale);
            }
            if (Validator.isNull((String)title) && Validator.isNull((String)description)) continue;
            JournalArticleLocalization journalArticleLocalization = this._addArticleLocalizedFields(companyId, articlePK, title, description, LocaleUtil.toLanguageId((Locale)locale));
            journalArticleLocalizations.add(journalArticleLocalization);
        }
        return journalArticleLocalizations;
    }

    private JournalArticleLocalization _addArticleLocalizedFields(long companyId, long articlePK, String title, String description, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this._journalArticleLocalizationPersistence.fetchByA_L(articlePK, languageId);
        if (journalArticleLocalization == null) {
            long journalArticleLocalizationId = this.counterLocalService.increment();
            journalArticleLocalization = this._journalArticleLocalizationPersistence.create(journalArticleLocalizationId);
            journalArticleLocalization.setCompanyId(companyId);
            journalArticleLocalization.setArticlePK(articlePK);
            journalArticleLocalization.setTitle(title);
            journalArticleLocalization.setDescription(description);
            journalArticleLocalization.setLanguageId(languageId);
        } else {
            journalArticleLocalization.setTitle(title);
            journalArticleLocalization.setDescription(description);
        }
        return (JournalArticleLocalization)this._journalArticleLocalizationPersistence.update((BaseModel)journalArticleLocalization);
    }

    private boolean _addDraftAssetEntry(JournalArticle journalArticle) {
        if (journalArticle.isApproved() || journalArticle.getVersion() == 1.0) {
            return false;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        if (assetEntry == null) {
            return false;
        }
        int approvedArticlesCount = this.journalArticlePersistence.countByG_A_ST(journalArticle.getGroupId(), journalArticle.getArticleId(), JournalArticleConstants.ASSET_ENTRY_CREATION_STATUSES);
        return approvedArticlesCount != 0;
    }

    private Map<Locale, String> _checkFriendlyURLMap(Locale defaultLocale, Map<Locale, String> friendlyURLMap, Map<Locale, String> titleMap) {
        for (Map.Entry<Locale, String> friendlyURL : friendlyURLMap.entrySet()) {
            if (!Validator.isNotNull((String)friendlyURL.getValue())) continue;
            return friendlyURLMap;
        }
        return HashMapBuilder.put((Object)defaultLocale, (Object)titleMap.get(defaultLocale)).build();
    }

    private void _copyArticleImages(JournalArticle article, List<DDMFormFieldValue> ddmFormFieldValues, long groupId, long folderId) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            Value oldValue;
            if (ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) {
                this._copyArticleImages(article, ddmFormFieldValue.getNestedDDMFormFieldValues(), groupId, folderId);
            }
            if (Objects.equals(ddmFormFieldValue.getType(), "fieldset") || !Objects.equals("image", ddmFormFieldValue.getType()) || (oldValue = ddmFormFieldValue.getValue()) == null) continue;
            LocalizedValue newValue = new LocalizedValue();
            newValue.setDefaultLocale(oldValue.getDefaultLocale());
            for (Locale locale : oldValue.getAvailableLocales()) {
                try {
                    JSONObject valueJSONObject = this._jsonFactory.createJSONObject(oldValue.getString(locale));
                    FileEntry oldFileEntry = this._getFileEntry(valueJSONObject);
                    if (oldFileEntry == null) continue;
                    FileEntry newFileEntry = this._portletFileRepository.addPortletFileEntry(null, groupId, article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), "com.liferay.journal", folderId, oldFileEntry.getContentStream(), oldFileEntry.getFileName(), oldFileEntry.getMimeType(), false);
                    String previewURL = this._dlURLHelper.getPreviewURL(newFileEntry, newFileEntry.getFileVersion(), null, "", false, true);
                    newValue.addString(locale, this._toJSON(valueJSONObject.getString("alt"), article, newFileEntry, valueJSONObject.getString("height"), valueJSONObject.getString("type"), previewURL, valueJSONObject.getString("width")));
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)exception);
                }
            }
            ddmFormFieldValue.setValue((Value)newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteDDMStructurePredefinedValues(long groupId, String ddmStructureKey) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, this._classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        if (ddmStructure == null) {
            return;
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            ddmFormField.setPredefinedValue(new LocalizedValue());
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean indexingEnabled = serviceContext.isIndexingEnabled();
        try {
            serviceContext.setIndexingEnabled(false);
            this.ddmStructureLocalService.updateStructure(serviceContext.getUserId(), ddmStructure.getStructureId(), ddmForm, ddmStructure.getDDMFormLayout(), serviceContext);
        }
        finally {
            serviceContext.setIndexingEnabled(indexingEnabled);
        }
    }

    private DDMFormValues _formatContent(JournalArticle article, String content, long groupId, User user) throws PortalException {
        content = this._journalContentCompatibilityConverter.convert(content);
        content = this._replaceTempImages(article, content);
        DDMStructure ddmStructure = article.getDDMStructure();
        DDMFormValues ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, this._journalConverter.getDDMFields(ddmStructure, content));
        this.format(user, groupId, article, ddmFormValues.getDDMFormFieldValues());
        return ddmFormValues;
    }

    private String _getArticleDiffs(JournalArticle article, ServiceContext serviceContext) {
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        try {
            PortletRequestModel portletRequestModel = null;
            if (!ExportImportThreadLocal.isImportInProcess() && serviceContext.getLiferayPortletRequest() != null && serviceContext.getLiferayPortletResponse() != null) {
                portletRequestModel = new PortletRequestModel((PortletRequest)serviceContext.getLiferayPortletRequest(), (PortletResponse)serviceContext.getLiferayPortletResponse());
            }
            String articleDiffs = this._journalHelper.diffHtml(article.getGroupId(), article.getArticleId(), previousApprovedArticle.getVersion(), article.getVersion(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), portletRequestModel, serviceContext.getThemeDisplay());
            return this._diffHtml.replaceStyles(articleDiffs);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    private FileEntry _getFileEntry(JSONObject valueJSONObject) {
        if (valueJSONObject == null || valueJSONObject.length() <= 0) {
            return null;
        }
        try {
            return this._dlAppLocalService.getFileEntryByUuidAndGroupId(valueJSONObject.getString("uuid"), valueJSONObject.getLong("groupId"));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get file entry", (Throwable)portalException);
            }
            return null;
        }
    }

    private Map<Locale, String> _getLocalizedBodyMap(String emailType, JournalGroupServiceConfiguration journalGroupServiceConfiguration) {
        if (emailType.equals("add")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleAddedBody());
        }
        if (emailType.equals("denied")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleApprovalDeniedBody());
        }
        if (emailType.equals("granted")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleApprovalGrantedBody());
        }
        if (emailType.equals("move_to")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedToFolderBody());
        }
        if (emailType.equals("move_to_trash")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedToTrashBody());
        }
        if (emailType.equals("move_from")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedFromFolderBody());
        }
        if (emailType.equals("move_from_trash")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedFromTrashBody());
        }
        if (emailType.equals("requested")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleApprovalRequestedBody());
        }
        if (emailType.equals("review")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleReviewBody());
        }
        if (emailType.equals("update")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleUpdatedBody());
        }
        return null;
    }

    private Map<Locale, String> _getLocalizedSubjectMap(String emailType, JournalGroupServiceConfiguration journalGroupServiceConfiguration) {
        if (emailType.equals("add")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleAddedSubject());
        }
        if (emailType.equals("denied")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleApprovalDeniedSubject());
        }
        if (emailType.equals("granted")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleApprovalGrantedSubject());
        }
        if (emailType.equals("move_to")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedToFolderSubject());
        }
        if (emailType.equals("move_to_trash")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedToTrashSubject());
        }
        if (emailType.equals("move_from")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedFromFolderSubject());
        }
        if (emailType.equals("move_from_trash")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleMovedFromTrashSubject());
        }
        if (emailType.equals("requested")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleApprovalRequestedSubject());
        }
        if (emailType.equals("review")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleReviewSubject());
        }
        if (emailType.equals("update")) {
            return this._localization.getMap(journalGroupServiceConfiguration.emailArticleUpdatedSubject());
        }
        return null;
    }

    private JournalArticleModelValidator _getModelValidator() {
        ModelValidator modelValidator = ModelValidatorRegistryUtil.getModelValidator(JournalArticle.class);
        return (JournalArticleModelValidator)modelValidator;
    }

    private int _getNotificationType(String emailType) {
        if (emailType.equals("move_from")) {
            return 2;
        }
        if (emailType.equals("move_from_trash")) {
            return 4;
        }
        if (emailType.equals("move_to")) {
            return 3;
        }
        if (emailType.equals("move_to_trash")) {
            return 5;
        }
        if (emailType.equals("update")) {
            return 1;
        }
        return 0;
    }

    private int _getUniqueUrlTitleCount(long groupId, String articleId, String urlTitle) {
        int i = 1;
        JournalArticle article;
        while ((article = this.fetchArticleByUrlTitle(groupId, urlTitle)) != null && !Objects.equals(articleId, article.getArticleId())) {
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
        return i - 1;
    }

    private Map<String, String> _getURLTitleMap(long groupId, long resourcePrimKey, Map<Locale, String> friendlyURLMap, Map<Locale, String> titleMap) {
        String urlTitle;
        HashMap<String, String> urlTitleMap = new HashMap<String, String>();
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            String friendlyURL = friendlyURLMap.get(entry.getKey());
            if (friendlyURL == null) continue;
            if (Validator.isNull((String)friendlyURL)) {
                urlTitleMap.put(this._language.getLanguageId(entry.getKey()), "");
                continue;
            }
            String languageId = this._language.getLanguageId(entry.getKey());
            urlTitle = this.friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, this._classNameLocalService.getClassNameId(JournalArticle.class), resourcePrimKey, this._friendlyURLNormalizer.normalizeWithPeriods(friendlyURL), languageId);
            urlTitleMap.put(languageId, urlTitle);
        }
        for (Map.Entry<Locale, String> entry : friendlyURLMap.entrySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)entry.getKey());
            String value = entry.getValue();
            if (urlTitleMap.containsKey(languageId) || !Validator.isNotNull((String)value)) continue;
            urlTitle = this.friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, this._classNameLocalService.getClassNameId(JournalArticle.class), resourcePrimKey, this._friendlyURLNormalizer.normalizeWithPeriods(value), languageId);
            urlTitleMap.put(languageId, urlTitle);
        }
        return urlTitleMap;
    }

    private void _populateSubscriptionSender(JournalArticle article, String articleURL, String emailType, String fromAddress, String fromName, JournalGroupServiceConfiguration journalGroupServiceConfiguration, ServiceContext serviceContext, SubscriptionSender subscriptionSender) {
        subscriptionSender.setClassName(article.getModelClassName());
        subscriptionSender.setCompanyId(article.getCompanyId());
        subscriptionSender.setContextAttribute("[$ARTICLE_DIFFS$]", (Object)this._getArticleDiffs(article, serviceContext), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(article.getUserId());
        subscriptionSender.setEntryURL(articleURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(this._getLocalizedBodyMap(emailType, journalGroupServiceConfiguration));
        subscriptionSender.setLocalizedSubjectMap(this._getLocalizedSubjectMap(emailType, journalGroupServiceConfiguration));
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setPortletId(PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT));
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
    }

    private void _removeArticleLocale(JournalArticle article, String languageId) throws PortalException {
        Locale locale;
        DDMFormValues ddmFormValues = article.getDDMFormValues();
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (!availableLocales.contains(locale = LocaleUtil.fromLanguageId((String)languageId))) {
            return;
        }
        DDMStructure ddmStructure = article.getDDMStructure();
        availableLocales.remove(locale);
        this._removeDDMFormFieldValues(ddmFormValues.getDDMFormFieldValues(), locale);
        this._ddmFieldLocalService.updateDDMFormValues(ddmStructure.getStructureId(), article.getId(), ddmFormValues);
    }

    private void _removeDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Locale locale) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                value.removeLocale(locale);
            }
            if (!ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) continue;
            this._removeDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), locale);
        }
    }

    private String _replaceTempImages(JournalArticle article, String content) throws PortalException {
        return this._attachmentContentUpdater.updateContent(content, "text/html", fileEntry -> {
            String fileEntryName = DLUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName(), (boolean)false);
            Folder folder = article.addImagesFolder();
            this._portletFileRepository.addPortletFileEntry(null, article.getGroupId(), fileEntry.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), "com.liferay.journal", folder.getFolderId(), fileEntry.getContentStream(), fileEntryName, fileEntry.getMimeType(), false);
            return null;
        });
    }

    private String _toJSON(String alt, JournalArticle article, FileEntry fileEntry, String height, String type, String url, String width) {
        return JSONUtil.put((String)"alt", (Object)alt).put("description", alt).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("height", height).put("name", fileEntry.getFileName()).put("resourcePrimKey", article.getResourcePrimKey()).put("title", fileEntry.getTitle()).put("type", type).put("url", url).put("uuid", fileEntry.getUuid()).put("width", width).toString();
    }

    private List<JournalArticleLocalization> _updateArticleLocalizedFields(long companyId, long articleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) {
        ArrayList oldJournalArticleLocalizations = new ArrayList(this._journalArticleLocalizationPersistence.findByArticlePK(articleId));
        List<JournalArticleLocalization> newJournalArticleLocalizations = this._addArticleLocalizedFields(companyId, articleId, titleMap, descriptionMap);
        oldJournalArticleLocalizations.removeAll(newJournalArticleLocalizations);
        for (JournalArticleLocalization oldJournalArticleLocalization : oldJournalArticleLocalizations) {
            this._journalArticleLocalizationPersistence.remove((BaseModel)oldJournalArticleLocalization);
        }
        return newJournalArticleLocalizations;
    }

    private JournalArticleLocalization _updateArticleLocalizedFields(long companyId, long articleId, String title, String description, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this._journalArticleLocalizationPersistence.fetchByA_L(articleId, languageId);
        if (journalArticleLocalization == null) {
            return this._addArticleLocalizedFields(companyId, articleId, title, description, languageId);
        }
        journalArticleLocalization.setTitle(title);
        journalArticleLocalization.setDescription(description);
        return (JournalArticleLocalization)this._journalArticleLocalizationPersistence.update((BaseModel)journalArticleLocalization);
    }
}

