/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.journal.model.JournalContentSearch;
import com.liferay.journal.service.base.JournalContentSearchLocalServiceBaseImpl;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.DisplayInformationProvider;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalContentSearch"}, service={AopService.class})
public class JournalContentSearchLocalServiceImpl
extends JournalContentSearchLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(JournalContentSearchLocalServiceImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    private ServiceTrackerMap<String, DisplayInformationProvider> _serviceTrackerMap;

    public void checkContentSearches(long companyId) throws PortalException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Checking journal content search for " + companyId));
        }
        HashMap<JournalContentSearchKey, JournalContentSearch> orphanedJournalContentSearches = new HashMap<JournalContentSearchKey, JournalContentSearch>();
        List journalContentSearches = this.journalContentSearchPersistence.findByCompanyId(companyId);
        for (JournalContentSearch journalContentSearch : journalContentSearches) {
            JournalContentSearchKey journalContentSearchKey = new JournalContentSearchKey(journalContentSearch);
            orphanedJournalContentSearches.put(journalContentSearchKey, journalContentSearch);
        }
        Set rootPortletIds = this._serviceTrackerMap.keySet();
        for (String rootPortletId : rootPortletIds) {
            DisplayInformationProvider displayInformationProvider = (DisplayInformationProvider)this._serviceTrackerMap.getService((Object)rootPortletId);
            ArrayList portletPreferencesList = new ArrayList();
            portletPreferencesList.addAll(this._portletPreferencesLocalService.getPortletPreferences(companyId, 0L, 3, rootPortletId));
            portletPreferencesList.addAll(this._portletPreferencesLocalService.getPortletPreferences(companyId, 0L, 3, rootPortletId + "_INSTANCE_%"));
            for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : portletPreferencesList) {
                Layout layout = this._layoutLocalService.fetchLayout(portletPreferences.getPlid());
                if (layout == null) continue;
                String portletId = portletPreferences.getPortletId();
                PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
                String articleId = displayInformationProvider.getClassPK(jxPortletPreferences);
                JournalContentSearchKey journalContentSearchKey = new JournalContentSearchKey(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, articleId);
                JournalContentSearch existingJournalContentSearch = (JournalContentSearch)orphanedJournalContentSearches.remove(journalContentSearchKey);
                if (existingJournalContentSearch != null) continue;
                this.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, articleId);
            }
        }
        for (JournalContentSearch journalContentSearch : orphanedJournalContentSearches.values()) {
            this.journalContentSearchPersistence.remove((BaseModel)journalContentSearch);
        }
    }

    public void deleteArticleContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId) {
        this.journalContentSearchPersistence.removeByG_P_L_P(groupId, privateLayout, layoutId, portletId);
    }

    public void deleteArticleContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId) {
        JournalContentSearch contentSearch = this.journalContentSearchPersistence.fetchByG_P_L_P_A(groupId, privateLayout, layoutId, portletId, articleId);
        if (contentSearch != null) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public void deleteArticleContentSearches(long groupId, String articleId) {
        List contentSearches = this.journalContentSearchPersistence.findByG_A(groupId, articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public void deleteLayoutContentSearches(long groupId, boolean privateLayout, long layoutId) {
        List contentSearches = this.journalContentSearchPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        for (JournalContentSearch contentSearch : contentSearches) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public void deleteOwnerContentSearches(long groupId, boolean privateLayout) {
        List contentSearches = this.journalContentSearchPersistence.findByG_P(groupId, privateLayout);
        for (JournalContentSearch contentSearch : contentSearches) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public List<JournalContentSearch> getArticleContentSearches() {
        return this.journalContentSearchPersistence.findAll();
    }

    public List<JournalContentSearch> getArticleContentSearches(long groupId, String articleId) {
        return this.journalContentSearchPersistence.findByG_A(groupId, articleId);
    }

    public List<JournalContentSearch> getArticleContentSearches(String articleId) {
        return this.journalContentSearchPersistence.findByArticleId(articleId);
    }

    public List<Long> getLayoutIds(long groupId, boolean privateLayout, String articleId) {
        ArrayList<Long> layoutIds = new ArrayList<Long>();
        List contentSearches = this.journalContentSearchPersistence.findByG_P_A(groupId, privateLayout, articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            layoutIds.add(contentSearch.getLayoutId());
        }
        return layoutIds;
    }

    public int getLayoutIdsCount(long groupId, boolean privateLayout, String articleId) {
        return this.journalContentSearchPersistence.countByG_P_A(groupId, privateLayout, articleId);
    }

    public int getLayoutIdsCount(String articleId) {
        return this.journalContentSearchPersistence.countByArticleId(articleId);
    }

    public List<JournalContentSearch> getPortletContentSearches(String portletId) {
        return this.journalContentSearchPersistence.findByPortletId(portletId);
    }

    public JournalContentSearch updateContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId) throws PortalException {
        return this.updateContentSearch(groupId, privateLayout, layoutId, portletId, articleId, false);
    }

    public JournalContentSearch updateContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId, boolean purge) throws PortalException {
        if (purge) {
            this.journalContentSearchPersistence.removeByG_P_L_P(groupId, privateLayout, layoutId, portletId);
        }
        Group group = this._groupLocalService.getGroup(groupId);
        JournalContentSearch contentSearch = this.journalContentSearchPersistence.fetchByG_P_L_P_A(groupId, privateLayout, layoutId, portletId, articleId);
        if (contentSearch == null) {
            long contentSearchId = this.counterLocalService.increment();
            contentSearch = this.journalContentSearchPersistence.create(contentSearchId);
            contentSearch.setGroupId(groupId);
            contentSearch.setCompanyId(group.getCompanyId());
            contentSearch.setPrivateLayout(privateLayout);
            contentSearch.setLayoutId(layoutId);
            contentSearch.setPortletId(portletId);
            contentSearch.setArticleId(articleId);
        }
        return (JournalContentSearch)this.journalContentSearchPersistence.update((BaseModel)contentSearch);
    }

    public List<JournalContentSearch> updateContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String[] articleIds) throws PortalException {
        this.journalContentSearchPersistence.removeByG_P_L_P(groupId, privateLayout, layoutId, portletId);
        ArrayList<JournalContentSearch> contentSearches = new ArrayList<JournalContentSearch>();
        for (String articleId : articleIds) {
            JournalContentSearch contentSearch = this.updateContentSearch(groupId, privateLayout, layoutId, portletId, articleId, false);
            contentSearches.add(contentSearch);
        }
        return contentSearches;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DisplayInformationProvider.class, (String)"javax.portlet.name");
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._serviceTrackerMap.close();
    }

    private static class JournalContentSearchKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _articleId;
        private final long _groupId;
        private final long _layoutId;
        private final String _portletId;
        private final boolean _privateLayout;

        public boolean equals(Object object) {
            JournalContentSearchKey journalContentSearchKey = (JournalContentSearchKey)object;
            return Objects.equals(journalContentSearchKey._articleId, this._articleId) && journalContentSearchKey._groupId == this._groupId && Objects.equals(journalContentSearchKey._layoutId, this._layoutId) && Objects.equals(journalContentSearchKey._portletId, this._portletId) && journalContentSearchKey._privateLayout == this._privateLayout;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._articleId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._layoutId);
            hashCode = HashUtil.hash((int)hashCode, (boolean)this._privateLayout);
            return HashUtil.hash((int)hashCode, (Object)this._portletId);
        }

        private JournalContentSearchKey(JournalContentSearch journalContentSearch) {
            this._articleId = journalContentSearch.getArticleId();
            this._groupId = journalContentSearch.getGroupId();
            this._layoutId = journalContentSearch.getLayoutId();
            this._portletId = journalContentSearch.getPortletId();
            this._privateLayout = journalContentSearch.getPrivateLayout();
        }

        private JournalContentSearchKey(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId) {
            this._groupId = groupId;
            this._privateLayout = privateLayout;
            this._layoutId = layoutId;
            this._portletId = portletId;
            this._articleId = articleId;
        }
    }
}

