/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.persistence.impl;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalFolderImpl;
import com.liferay.journal.service.persistence.JournalArticleUtil;
import com.liferay.journal.service.persistence.JournalFolderFinder;
import com.liferay.journal.service.persistence.JournalFolderUtil;
import com.liferay.journal.service.persistence.impl.JournalFolderFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JournalFolderFinder.class})
public class JournalFolderFinderImpl
extends JournalFolderFinderBaseImpl
implements JournalFolderFinder {
    public static final String COUNT_A_BY_G_U_F_DDMSK = JournalFolderFinder.class.getName() + ".countA_ByG_U_F_DDMSK";
    public static final String COUNT_F_BY_G_F = JournalFolderFinder.class.getName() + ".countF_ByG_F";
    public static final String FIND_A_BY_G_U_F_DDMSK = JournalFolderFinder.class.getName() + ".findA_ByG_U_F_DDMSK";
    public static final String FIND_A_BY_G_U_F_DDMSK_L = JournalFolderFinder.class.getName() + ".findA_ByG_U_F_DDMSK_L";
    public static final String FIND_F_BY_NO_ASSETS = JournalFolderFinder.class.getName() + ".findF_ByNoAssets";
    public static final String FIND_F_BY_G_F = JournalFolderFinder.class.getName() + ".findF_ByG_F";
    public static final String FIND_F_BY_G_F_L = JournalFolderFinder.class.getName() + ".findF_ByG_F_L";
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private Portal _portal;

    public int countF_A_ByG_F_DDMSK(long groupId, long folderId, String ddmStructureKey, QueryDefinition<?> queryDefinition) {
        return this.doCountF_A_ByG_F_DDMSK(groupId, folderId, ddmStructureKey, queryDefinition, false);
    }

    public int filterCountF_A_ByG_F_DDMSK(long groupId, long folderId, String ddmStructureKey, QueryDefinition<?> queryDefinition) {
        return this.doCountF_A_ByG_F_DDMSK(groupId, folderId, ddmStructureKey, queryDefinition, true);
    }

    public List<Object> filterFindF_A_ByG_F_DDMSK(long groupId, long folderId, String ddmStructureKey, QueryDefinition<?> queryDefinition) {
        return this.doFindF_A_ByG_F_DDMSK(groupId, folderId, ddmStructureKey, queryDefinition, true);
    }

    public List<Object> filterFindF_A_ByG_F_DDMSK_L(long groupId, long folderId, String ddmStructureKey, Locale locale, QueryDefinition<?> queryDefinition) {
        return this.doFindF_A_ByG_F_DDMSK_L(groupId, folderId, ddmStructureKey, locale, queryDefinition, true);
    }

    public List<Object> findF_A_ByG_F_DDMSK(long groupId, long folderId, String ddmStructureKey, QueryDefinition<?> queryDefinition) {
        return this.doFindF_A_ByG_F_DDMSK(groupId, folderId, ddmStructureKey, queryDefinition, false);
    }

    public List<JournalFolder> findF_ByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_F_BY_NO_ASSETS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("JournalFolder", JournalFolderImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(JournalFolder.class));
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountF_A_ByG_F_DDMSK(long groupId, long folderId, String ddmStructureKey, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this.updateSQL(StringBundler.concat((String[])new String[]{"(", this.getFoldersSQL(COUNT_F_BY_G_F, groupId, queryDefinition, inlineSQLHelper), ") UNION ALL (", this.getArticlesSQL(COUNT_A_BY_G_U_F_DDMSK, groupId, queryDefinition, inlineSQLHelper), ")"}), folderId, ddmStructureKey);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                queryPos.add(folderId);
            }
            queryPos.add(groupId);
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                queryPos.add(8);
            }
            queryPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                queryPos.add(folderId);
            }
            if (Validator.isNotNull((String)ddmStructureKey)) {
                queryPos.add(ddmStructureKey);
            }
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Object> doFindF_A_ByG_F_DDMSK(long groupId, long folderId, String ddmStructureKey, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this.updateSQL(StringBundler.concat((String[])new String[]{"(", this.getFoldersSQL(FIND_F_BY_G_F, groupId, queryDefinition, inlineSQLHelper), ") UNION ALL (", this.getArticlesSQL(FIND_A_BY_G_U_F_DDMSK, groupId, queryDefinition, inlineSQLHelper), ")"}), folderId, ddmStructureKey);
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("modelFolderId", Type.LONG);
            sqlQuery.addScalar("modelFolder", Type.LONG);
            sqlQuery.addScalar("articleId", Type.STRING);
            sqlQuery.addScalar("version", Type.DOUBLE);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                queryPos.add(folderId);
            }
            queryPos.add(groupId);
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                queryPos.add(8);
            }
            queryPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                queryPos.add(folderId);
            }
            if (Validator.isNotNull((String)ddmStructureKey)) {
                queryPos.add(ddmStructureKey);
            }
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                long modelFolder = (Long)array[1];
                JournalFolder object = null;
                if (modelFolder == 1L) {
                    long curFolderId = (Long)array[0];
                    object = JournalFolderUtil.findByPrimaryKey((long)curFolderId);
                } else {
                    String articleId = (String)array[2];
                    double version = (Double)array[3];
                    object = JournalArticleUtil.findByG_A_V((long)groupId, (String)articleId, (double)version);
                }
                models.add(object);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Object> doFindF_A_ByG_F_DDMSK_L(long groupId, long folderId, String ddmStructureKey, Locale locale, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this.updateSQL(StringBundler.concat((String[])new String[]{"(", this.getFoldersSQL(FIND_F_BY_G_F_L, groupId, queryDefinition, inlineSQLHelper), ") UNION ALL (", this.getArticlesSQL(FIND_A_BY_G_U_F_DDMSK_L, groupId, queryDefinition, inlineSQLHelper), ")"}), folderId, ddmStructureKey);
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("modelFolderId", Type.LONG);
            sqlQuery.addScalar("modelFolder", Type.LONG);
            sqlQuery.addScalar("articleId", Type.STRING);
            sqlQuery.addScalar("version", Type.DOUBLE);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                queryPos.add(folderId);
            }
            queryPos.add(groupId);
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                queryPos.add(8);
            }
            queryPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                queryPos.add(folderId);
            }
            if (Validator.isNotNull((String)ddmStructureKey)) {
                queryPos.add(ddmStructureKey);
            }
            queryPos.add(LocaleUtil.toLanguageId((Locale)locale));
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                long modelFolder = (Long)array[1];
                JournalFolder object = null;
                if (modelFolder == 1L) {
                    long curFolderId = (Long)array[0];
                    object = JournalFolderUtil.findByPrimaryKey((long)curFolderId);
                } else {
                    String articleId = (String)array[2];
                    double version = (Double)array[3];
                    object = JournalArticleUtil.findByG_A_V((long)groupId, (String)articleId, (double)version);
                }
                models.add(object);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getArticlesSQL(String id, long groupId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        String sql = this._customSQL.get(((Object)((Object)this)).getClass(), id, queryDefinition, "JournalArticle");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)JournalArticle.class.getName(), (String)"JournalArticle.resourcePrimKey", (long)groupId);
        }
        return sql;
    }

    protected String getDDMStructureKey(String ddmStructureKey) {
        if (Validator.isNull((String)ddmStructureKey)) {
            return "";
        }
        StringBundler sb = new StringBundler(3);
        sb.append(" AND ");
        sb.append("JournalArticle");
        sb.append(".ddmStructureKey = ? ");
        return sb.toString();
    }

    protected String getFolderId(long folderId, String tableName) {
        if (folderId < 0L) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(" AND ");
        sb.append(tableName);
        sb.append(".");
        if (tableName.equals("JournalFolder")) {
            sb.append("parentFolderId");
        } else {
            sb.append("folderId");
        }
        sb.append(" = ? ");
        return sb.toString();
    }

    protected String getFoldersSQL(String id, long groupId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        String sql = this._customSQL.get(((Object)((Object)this)).getClass(), id, queryDefinition, "JournalFolder");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)JournalFolder.class.getName(), (String)"JournalFolder.folderId", (long)groupId);
        }
        return sql;
    }

    protected String updateSQL(String sql, long folderId, String ddmStructureKey) {
        return StringUtil.replace((String)sql, (String[])new String[]{"[$ARTICLE_FOLDER_ID$]", "[$DDM_STRUCTURE_KEY$]", "[$FOLDER_PARENT_FOLDER_ID$]"}, (String[])new String[]{this.getFolderId(folderId, "JournalArticle"), this.getDDMStructureKey(ddmStructureKey), this.getFolderId(folderId, "JournalFolder")});
    }
}

