/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.uad.constants.JournalUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseJournalArticleUADAnonymizer
extends DynamicQueryUADAnonymizer<JournalArticle> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected JournalArticleLocalService journalArticleLocalService;

    public void autoAnonymize(JournalArticle journalArticle, long userId, User anonymousUser) throws PortalException {
        if (journalArticle.getUserId() == userId) {
            journalArticle.setUserId(anonymousUser.getUserId());
            journalArticle.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(journalArticle, anonymousUser);
        }
        if (journalArticle.getStatusByUserId() == userId) {
            journalArticle.setStatusByUserId(anonymousUser.getUserId());
            journalArticle.setStatusByUserName(anonymousUser.getFullName());
        }
        this.journalArticleLocalService.updateJournalArticle(journalArticle);
    }

    public void delete(JournalArticle journalArticle) throws PortalException {
        this.journalArticleLocalService.deleteArticle(journalArticle);
    }

    public Class<JournalArticle> getTypeClass() {
        return JournalArticle.class;
    }

    protected void autoAnonymizeAssetEntry(JournalArticle journalArticle, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(journalArticle);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.journalArticleLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return JournalUADConstants.USER_ID_FIELD_NAMES_JOURNAL_ARTICLE;
    }

    protected AssetEntry fetchAssetEntry(JournalArticle journalArticle) {
        return this.assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getId());
    }
}

