/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.uad.constants.JournalUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseJournalFolderUADAnonymizer
extends DynamicQueryUADAnonymizer<JournalFolder> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected JournalFolderLocalService journalFolderLocalService;

    public void autoAnonymize(JournalFolder journalFolder, long userId, User anonymousUser) throws PortalException {
        if (journalFolder.getUserId() == userId) {
            journalFolder.setUserId(anonymousUser.getUserId());
            journalFolder.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(journalFolder, anonymousUser);
        }
        if (journalFolder.getStatusByUserId() == userId) {
            journalFolder.setStatusByUserId(anonymousUser.getUserId());
            journalFolder.setStatusByUserName(anonymousUser.getFullName());
        }
        this.journalFolderLocalService.updateJournalFolder(journalFolder);
    }

    public void delete(JournalFolder journalFolder) throws PortalException {
        this.journalFolderLocalService.deleteFolder(journalFolder);
    }

    public Class<JournalFolder> getTypeClass() {
        return JournalFolder.class;
    }

    protected void autoAnonymizeAssetEntry(JournalFolder journalFolder, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(journalFolder);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.journalFolderLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return JournalUADConstants.USER_ID_FIELD_NAMES_JOURNAL_FOLDER;
    }

    protected AssetEntry fetchAssetEntry(JournalFolder journalFolder) {
        return this.assetEntryLocalService.fetchEntry(JournalFolder.class.getName(), journalFolder.getFolderId());
    }
}

