/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.importer;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrioritizationStrategy {
    private final long _groupId;
    private final Map<String, List<KBArticle>> _importedKBArticlesMap = new HashMap<String, List<KBArticle>>();
    private final Map<String, Double> _importedKBArticleUrlTitlesPrioritiesMap = new HashMap<String, Double>();
    private final long _parentKBFolderId;
    private final boolean _prioritizeByNumericalPrefix;

    public static PrioritizationStrategy create(long groupId, long parentKBFolderId, boolean prioritizeByNumericalPrefix) {
        HashMap<String, List<KBArticle>> existingKBArticlesMap = new HashMap<String, List<KBArticle>>();
        List existingParentKBArticles = KBArticleServiceUtil.getKBArticles((long)groupId, (long)parentKBFolderId, (int)-1, (int)-1, (int)-1, null);
        existingKBArticlesMap.put("", existingParentKBArticles);
        for (KBArticle existingParentKBArticle : existingParentKBArticles) {
            long resourcePrimKey = existingParentKBArticle.getResourcePrimKey();
            List existingChildKBArticles = KBArticleServiceUtil.getKBArticles((long)groupId, (long)resourcePrimKey, (int)-1, (int)-1, (int)-1, null);
            existingKBArticlesMap.put(existingParentKBArticle.getUrlTitle(), existingChildKBArticles);
        }
        return new PrioritizationStrategy(groupId, parentKBFolderId, prioritizeByNumericalPrefix, existingKBArticlesMap);
    }

    public void addKBArticle(KBArticle kbArticle, String filePath) throws PortalException {
        this.handleNumericalPrefix(kbArticle, filePath);
    }

    public void prioritizeKBArticles() throws PortalException {
        if (this._prioritizeByNumericalPrefix) {
            for (Map.Entry<String, Double> entry : this._importedKBArticleUrlTitlesPrioritiesMap.entrySet()) {
                if (entry.getValue() < 1.0) continue;
                KBArticle kbArticle = KBArticleLocalServiceUtil.getKBArticleByUrlTitle((long)this._groupId, (long)this._parentKBFolderId, (String)entry.getKey());
                KBArticleLocalServiceUtil.updatePriority((long)kbArticle.getResourcePrimKey(), (double)entry.getValue());
                this.remove(this._importedKBArticlesMap, kbArticle);
            }
        }
        this.prioritizeKBArticles(this._importedKBArticlesMap);
    }

    public void updateKBArticle(KBArticle kbArticle, String filePath) throws PortalException {
        this.handleNumericalPrefix(kbArticle, filePath);
    }

    protected PrioritizationStrategy(long groupId, long parentKBFolderId, boolean prioritizeByNumericalPrefix, Map<String, List<KBArticle>> existingKBArticlesMap) {
        this._groupId = groupId;
        this._parentKBFolderId = parentKBFolderId;
        this._prioritizeByNumericalPrefix = prioritizeByNumericalPrefix;
    }

    protected <S, T> List<T> getList(Map<S, List<T>> map, S key) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        return list;
    }

    protected double getNumericalPrefix(String filePath, boolean isChildArticleFile) {
        double numericalPrefix = -1.0;
        if (isChildArticleFile) {
            String digits;
            String fileName = filePath;
            int i = filePath.lastIndexOf(47);
            if (i != -1) {
                fileName = filePath.substring(i + 1);
            }
            if (Validator.isNull((String)(digits = StringUtil.extractLeadingDigits((String)fileName)))) {
                return numericalPrefix;
            }
            return GetterUtil.getDouble((String)digits);
        }
        String[] pathEntries = filePath.split("/");
        if (pathEntries == null) {
            String digits = StringUtil.extractLeadingDigits((String)filePath);
            if (Validator.isNull((String)digits)) {
                return numericalPrefix;
            }
            return GetterUtil.getDouble((String)digits);
        }
        int length = pathEntries.length;
        for (int i = length - 1; i > -1; --i) {
            String fileName = pathEntries[i];
            String digits = StringUtil.extractLeadingDigits((String)fileName);
            if (Validator.isNull((String)digits) || !((numericalPrefix = GetterUtil.getDouble((String)digits)) >= 1.0)) continue;
            return numericalPrefix;
        }
        return numericalPrefix;
    }

    protected String getParentKBArticleUrlTitle(KBArticle kbArticle) throws PortalException {
        KBArticle parentKBArticle = kbArticle.getParentKBArticle();
        if (parentKBArticle == null) {
            return "";
        }
        return parentKBArticle.getUrlTitle();
    }

    protected void handleNumericalPrefix(KBArticle kbArticle, String filePath) throws PortalException {
        String parentKBArticleUrlTitle = this.getParentKBArticleUrlTitle(kbArticle);
        List<KBArticle> kbArticles = this.getList(this._importedKBArticlesMap, parentKBArticleUrlTitle);
        kbArticles.add(kbArticle);
        if (this._prioritizeByNumericalPrefix) {
            double sectionFileEntryNamePrefix;
            boolean isChildArticle = true;
            if (kbArticle.getParentKBArticle() == null) {
                isChildArticle = false;
            }
            if (!((sectionFileEntryNamePrefix = this.getNumericalPrefix(filePath, isChildArticle)) < 0.0)) {
                if (sectionFileEntryNamePrefix < 1.0) {
                    kbArticle.setPriority(1.0);
                    this._importedKBArticleUrlTitlesPrioritiesMap.put(kbArticle.getUrlTitle(), sectionFileEntryNamePrefix);
                } else {
                    this._importedKBArticleUrlTitlesPrioritiesMap.put(kbArticle.getUrlTitle(), sectionFileEntryNamePrefix);
                }
            }
        }
    }

    protected void prioritizeKBArticles(Map<String, List<KBArticle>> kbArticlesMap) throws PortalException {
        for (Map.Entry<String, List<KBArticle>> entry : kbArticlesMap.entrySet()) {
            List<KBArticle> kbArticles = entry.getValue();
            if (kbArticles == null) continue;
            List siblingKBArticles = null;
            if (Validator.isNull((String)entry.getKey())) {
                siblingKBArticles = KBArticleLocalServiceUtil.getKBArticles((long)this._groupId, (long)this._parentKBFolderId, (int)-1, (int)-1, (int)-1, null);
            } else {
                KBArticle parentKBArticle = KBArticleLocalServiceUtil.fetchKBArticleByUrlTitle((long)this._groupId, (long)this._parentKBFolderId, (String)entry.getKey());
                siblingKBArticles = KBArticleServiceUtil.getKBArticles((long)this._groupId, (long)parentKBArticle.getResourcePrimKey(), (int)-1, (int)-1, (int)-1, null);
            }
            List siblingKBArticlesCopy = ListUtil.copy((List)siblingKBArticles);
            siblingKBArticlesCopy.removeAll(kbArticles);
            double maxPriority = 0.0;
            for (KBArticle sibling : siblingKBArticlesCopy) {
                double priority = sibling.getPriority();
                if (!(priority > maxPriority)) continue;
                maxPriority = priority;
            }
            int size = kbArticles.size();
            for (int i = 0; i < size; ++i) {
                KBArticle kbArticle = kbArticles.get(i);
                if (kbArticle.getPriority() >= 1.0) continue;
                KBArticleLocalServiceUtil.updatePriority((long)kbArticle.getResourcePrimKey(), (double)(maxPriority += 1.0));
            }
        }
    }

    protected <S, T> void remove(Map<S, List<T>> map, T object) {
        for (Map.Entry<S, List<T>> entry : map.entrySet()) {
            List<T> list = entry.getValue();
            if (list == null) continue;
            list.remove(object);
        }
    }
}

