/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.lar;

import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.service.persistence.KBArticlePersistence;
import com.liferay.knowledge.base.service.util.AdminUtil;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class KBArticleStagedModelDataHandler
extends BaseStagedModelDataHandler<KBArticle> {
    public static final String[] CLASS_NAMES = new String[]{KBArticle.class.getName()};
    private KBArticleLocalService _kbArticleLocalService;
    private KBArticlePersistence _kbArticlePersistence;
    private KBFolderLocalService _kbFolderLocalService;
    private Portal _portal;
    private PortletFileRepository _portletFileRepository;

    public void deleteStagedModel(KBArticle kbArticle) throws PortalException {
        this._kbArticleLocalService.deleteKBArticle(kbArticle);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        KBArticle kbArticle = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (kbArticle != null) {
            this.deleteStagedModel(kbArticle);
        }
    }

    public KBArticle fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._kbArticleLocalService.fetchKBArticleByUuidAndGroupId(uuid, groupId);
    }

    public List<KBArticle> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._kbArticleLocalService.getKBArticlesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(KBArticle kbArticle) {
        return kbArticle.getTitle();
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) {
        return !portletDataContext.isModelCounted(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) throws Exception {
        if (kbArticle.getParentResourcePrimKey() != 0L) {
            long kbArticleClassNameId = this._portal.getClassNameId(KBArticleConstants.getClassName());
            if (kbArticle.getParentResourceClassNameId() == kbArticleClassNameId) {
                KBArticle parentKBArticle = this._kbArticleLocalService.getLatestKBArticle(kbArticle.getParentResourcePrimKey(), 0);
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbArticle, (StagedModel)parentKBArticle, (String)"parent");
            } else {
                KBFolder parentKBFolder = this._kbFolderLocalService.getKBFolder(kbArticle.getParentResourcePrimKey());
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbArticle, (StagedModel)parentKBFolder, (String)"parent");
            }
        }
        Element kbArticleElement = portletDataContext.getExportDataElement((ClassedModel)kbArticle);
        this.exportKBArticleAttachments(portletDataContext, kbArticleElement, kbArticle);
        portletDataContext.addClassedModel(kbArticleElement, ExportImportPathUtil.getModelPath((StagedModel)kbArticle), (ClassedModel)kbArticle);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) throws Exception {
        String urlTitle;
        Map kbFolderResourcePrimKeys;
        long userId = portletDataContext.getUserId(kbArticle.getUserUuid());
        Map kbArticleResourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBArticle.class);
        long resourcePrimaryKey = MapUtil.getLong((Map)kbArticleResourcePrimKeys, (long)kbArticle.getResourcePrimKey(), (long)kbArticle.getResourcePrimKey());
        long parentResourcePrimKey = MapUtil.getLong((Map)kbArticleResourcePrimKeys, (long)kbArticle.getParentResourcePrimKey(), (long)kbArticle.getParentResourcePrimKey());
        long kbFolderClassNameId = this._portal.getClassNameId(KBFolderConstants.getClassName());
        if (kbArticle.getParentResourceClassNameId() != kbArticle.getClassNameId() && kbArticle.getParentResourceClassNameId() != kbFolderClassNameId) {
            KBArticle parentKBArticle = this._kbArticleLocalService.fetchLatestKBArticle(parentResourcePrimKey, 0);
            if (parentKBArticle != null) {
                kbArticle.setParentResourceClassNameId(kbArticle.getClassNameId());
            } else {
                kbArticle.setParentResourceClassNameId(kbFolderClassNameId);
            }
        }
        if (kbArticle.getParentResourcePrimKey() != 0L) {
            if (kbArticle.getClassNameId() == kbArticle.getParentResourceClassNameId()) {
                StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)kbArticle, KBArticle.class);
            } else {
                StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)kbArticle, KBFolder.class);
                kbFolderResourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
                parentResourcePrimKey = MapUtil.getLong((Map)kbFolderResourcePrimKeys, (long)parentResourcePrimKey, (long)parentResourcePrimKey);
            }
        }
        if (parentResourcePrimKey == 0L) {
            kbFolderResourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
            parentResourcePrimKey = MapUtil.getLong((Map)kbFolderResourcePrimKeys, (long)kbArticle.getParentResourcePrimKey(), (long)0L);
        }
        if (Validator.isNotNull((String)(urlTitle = kbArticle.getUrlTitle())) && !urlTitle.startsWith("/")) {
            kbArticle.setUrlTitle("/" + urlTitle);
        }
        String[] sections = AdminUtil.unescapeSections(kbArticle.getSections());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)kbArticle);
        KBArticle importedKBArticle = null;
        if (portletDataContext.isDataStrategyMirror()) {
            KBArticle existingKBArticle = this._kbArticlePersistence.fetchByR_G_V(resourcePrimaryKey, portletDataContext.getScopeGroupId(), kbArticle.getVersion());
            if (existingKBArticle == null) {
                existingKBArticle = this.fetchStagedModelByUuidAndGroupId(kbArticle.getUuid(), portletDataContext.getScopeGroupId());
            }
            if (existingKBArticle == null) {
                serviceContext.setUuid(kbArticle.getUuid());
                existingKBArticle = this._kbArticlePersistence.fetchByR_G_L_First(resourcePrimaryKey, portletDataContext.getScopeGroupId(), true, null);
                if (existingKBArticle == null) {
                    importedKBArticle = this._kbArticleLocalService.addKBArticle(userId, kbArticle.getParentResourceClassNameId(), parentResourcePrimKey, kbArticle.getTitle(), kbArticle.getUrlTitle(), kbArticle.getContent(), kbArticle.getDescription(), kbArticle.getSourceURL(), sections, null, serviceContext);
                    this._kbArticleLocalService.updatePriority(importedKBArticle.getResourcePrimKey(), kbArticle.getPriority());
                } else {
                    this._kbArticleLocalService.updateKBArticle(userId, existingKBArticle.getResourcePrimKey(), kbArticle.getTitle(), kbArticle.getContent(), kbArticle.getDescription(), kbArticle.getSourceURL(), sections, null, null, serviceContext);
                    this._kbArticleLocalService.moveKBArticle(userId, existingKBArticle.getResourcePrimKey(), existingKBArticle.getParentResourceClassNameId(), parentResourcePrimKey, kbArticle.getPriority());
                    importedKBArticle = this._kbArticleLocalService.getLatestKBArticle(existingKBArticle.getResourcePrimKey(), 0);
                }
            } else {
                importedKBArticle = existingKBArticle;
            }
        } else if (resourcePrimaryKey != kbArticle.getResourcePrimKey()) {
            this._kbArticleLocalService.updateKBArticle(userId, resourcePrimaryKey, kbArticle.getTitle(), kbArticle.getContent(), kbArticle.getDescription(), kbArticle.getSourceURL(), sections, null, null, serviceContext);
            this._kbArticleLocalService.moveKBArticle(userId, resourcePrimaryKey, kbArticle.getParentResourceClassNameId(), parentResourcePrimKey, kbArticle.getPriority());
            importedKBArticle = this._kbArticleLocalService.getLatestKBArticle(resourcePrimaryKey, 0);
        } else {
            importedKBArticle = this._kbArticleLocalService.addKBArticle(userId, kbArticle.getParentResourceClassNameId(), parentResourcePrimKey, kbArticle.getTitle(), kbArticle.getUrlTitle(), kbArticle.getContent(), kbArticle.getDescription(), kbArticle.getSourceURL(), sections, null, serviceContext);
            this._kbArticleLocalService.updatePriority(importedKBArticle.getResourcePrimKey(), kbArticle.getPriority());
        }
        this.importKBArticleAttachments(portletDataContext, kbArticle, importedKBArticle);
        portletDataContext.importClassedModel((ClassedModel)kbArticle, (ClassedModel)importedKBArticle);
        if (!kbArticle.isMain()) {
            kbArticleResourcePrimKeys.put(kbArticle.getResourcePrimKey(), importedKBArticle.getResourcePrimKey());
        }
    }

    protected void exportKBArticleAttachments(PortletDataContext portletDataContext, Element kbArticleElement, KBArticle kbArticle) throws Exception {
        List attachmentsFileEntries = kbArticle.getAttachmentsFileEntries();
        for (FileEntry fileEntry : attachmentsFileEntries) {
            String path = ExportImportPathUtil.getModelPath((StagedModel)kbArticle, (String)fileEntry.getTitle());
            Element fileEntryElement = portletDataContext.getExportDataElement((ClassedModel)fileEntry);
            fileEntryElement.addAttribute("path", path);
            fileEntryElement.addAttribute("file-name", fileEntry.getTitle());
            portletDataContext.addZipEntry(path, fileEntry.getContentStream());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbArticle, (StagedModel)fileEntry, (String)"weak");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void importKBArticleAttachments(PortletDataContext portletDataContext, KBArticle kbArticle, KBArticle importedKBArticle) throws Exception {
        List dlFileEntryElements = portletDataContext.getReferenceDataElements((StagedModel)kbArticle, DLFileEntry.class);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(portletDataContext.getCompanyId());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        UnsyncByteArrayInputStream inputStream = null;
        for (Element dlFileEntryElement : dlFileEntryElements) {
            try {
                byte[] bytes = portletDataContext.getZipEntryAsByteArray(dlFileEntryElement.attributeValue("path"));
                inputStream = new UnsyncByteArrayInputStream(bytes);
                String fileName = dlFileEntryElement.attributeValue("file-name");
                String mimeType = KnowledgeBaseUtil.getMimeType((byte[])bytes, (String)fileName);
                this._portletFileRepository.addPortletFileEntry(portletDataContext.getScopeGroupId(), portletDataContext.getUserId(importedKBArticle.getUserUuid()), KBArticle.class.getName(), importedKBArticle.getClassPK(), "com_liferay_knowledge_base_web_portlet_AdminPortlet", importedKBArticle.getAttachmentsFolderId(), (InputStream)inputStream, fileName, mimeType, true);
            }
            catch (DuplicateFileException dfe) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                continue;
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setKBArticlePersistence(KBArticlePersistence kbArticlePersistence) {
        this._kbArticlePersistence = kbArticlePersistence;
    }

    @Reference(unbind="-")
    protected void setKBFolderLocalService(KBFolderLocalService kbFolderLocalService) {
        this._kbFolderLocalService = kbFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(unbind="-")
    protected void setPortletFileRepository(PortletFileRepository portletFileRepository) {
        this._portletFileRepository = portletFileRepository;
    }
}

