/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.lar;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.service.persistence.KBFolderPersistence;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class KBFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<KBFolder> {
    public static final String[] CLASS_NAMES = new String[]{KBFolder.class.getName()};
    private KBFolderLocalService _kbFolderLocalService;
    private KBFolderPersistence _kbFolderPersistence;

    public void deleteStagedModel(KBFolder kbFolder) {
        this._kbFolderLocalService.deleteKBFolder(kbFolder);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        KBFolder kbFolder = this._kbFolderLocalService.fetchKBFolderByUuidAndGroupId(uuid, groupId);
        if (kbFolder != null) {
            this.deleteStagedModel(kbFolder);
        }
    }

    public List<KBFolder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._kbFolderLocalService.getKBFoldersByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, KBFolder kbFolder) throws Exception {
        if (kbFolder.getParentKBFolderId() != 0L) {
            KBFolder parentKBFolder = this._kbFolderLocalService.getKBFolder(kbFolder.getParentKBFolderId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbFolder, (StagedModel)parentKBFolder, (String)"parent");
        }
        Element kbFolderElement = portletDataContext.getExportDataElement((ClassedModel)kbFolder);
        portletDataContext.addClassedModel(kbFolderElement, ExportImportPathUtil.getModelPath((StagedModel)kbFolder), (ClassedModel)kbFolder);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, KBFolder kbFolder) throws Exception {
        KBFolder existingKBFolder;
        long userId = portletDataContext.getUserId(kbFolder.getUserUuid());
        if (kbFolder.getParentKBFolderId() != 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)kbFolder, KBFolder.class);
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)kbFolder);
        KBFolder importedKBFolder = null;
        importedKBFolder = portletDataContext.isDataStrategyMirror() ? ((existingKBFolder = this._kbFolderPersistence.fetchByUUID_G(kbFolder.getUuid(), portletDataContext.getScopeGroupId())) == null ? this._kbFolderLocalService.addKBFolder(userId, portletDataContext.getScopeGroupId(), kbFolder.getClassNameId(), kbFolder.getParentKBFolderId(), kbFolder.getName(), kbFolder.getDescription(), serviceContext) : this._kbFolderLocalService.updateKBFolder(kbFolder.getClassNameId(), kbFolder.getParentKBFolderId(), kbFolder.getKbFolderId(), kbFolder.getName(), kbFolder.getDescription())) : this._kbFolderLocalService.addKBFolder(userId, portletDataContext.getScopeGroupId(), kbFolder.getClassNameId(), kbFolder.getParentKBFolderId(), kbFolder.getName(), kbFolder.getDescription(), serviceContext);
        portletDataContext.importClassedModel((ClassedModel)kbFolder, (ClassedModel)importedKBFolder);
        Map kbFolderIds = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
        kbFolderIds.put(kbFolder.getKbFolderId(), importedKBFolder.getKbFolderId());
    }

    @Reference(unbind="-")
    protected void setKBFolderLocalService(KBFolderLocalService kbFolderLocalService) {
        this._kbFolderLocalService = kbFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setKbFolderPersistence(KBFolderPersistence kbFolderPersistence) {
        this._kbFolderPersistence = kbFolderPersistence;
    }
}

