/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.model.KBTemplateSearchDisplay;
import com.liferay.knowledge.base.model.impl.KBTemplateSearchDisplayImpl;
import com.liferay.knowledge.base.service.base.KBTemplateServiceBaseImpl;
import com.liferay.knowledge.base.service.permission.AdminPermission;
import com.liferay.knowledge.base.service.permission.DisplayPermission;
import com.liferay.knowledge.base.service.permission.KBTemplatePermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ProviderType
public class KBTemplateServiceImpl
extends KBTemplateServiceBaseImpl {
    private static final int _INTERVAL = 200;

    public KBTemplate addKBTemplate(String portletId, String title, String content, ServiceContext serviceContext) throws PortalException {
        if (portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
            AdminPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_KB_TEMPLATE");
        } else if (portletId.equals("com_liferay_knowledge_base_web_portlet_DisplayPortlet")) {
            DisplayPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_KB_TEMPLATE");
        }
        return this.kbTemplateLocalService.addKBTemplate(this.getUserId(), title, content, serviceContext);
    }

    public KBTemplate deleteKBTemplate(long kbTemplateId) throws PortalException {
        KBTemplatePermission.check(this.getPermissionChecker(), kbTemplateId, "DELETE");
        return this.kbTemplateLocalService.deleteKBTemplate(kbTemplateId);
    }

    public void deleteKBTemplates(long groupId, long[] kbTemplateIds) throws PortalException {
        AdminPermission.check(this.getPermissionChecker(), groupId, "DELETE_KB_TEMPLATES");
        this.kbTemplateLocalService.deleteKBTemplates(kbTemplateIds);
    }

    public List<KBTemplate> getGroupKBTemplates(long groupId, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        return this.kbTemplatePersistence.filterFindByGroupId(groupId, start, end, orderByComparator);
    }

    public int getGroupKBTemplatesCount(long groupId) {
        return this.kbTemplatePersistence.filterCountByGroupId(groupId);
    }

    public KBTemplate getKBTemplate(long kbTemplateId) throws PortalException {
        KBTemplatePermission.check(this.getPermissionChecker(), kbTemplateId, "VIEW");
        return this.kbTemplateLocalService.getKBTemplate(kbTemplateId);
    }

    public KBTemplateSearchDisplay getKBTemplateSearchDisplay(long groupId, String title, String content, Date startDate, Date endDate, boolean andOperator, int[] curStartValues, int cur, int delta, OrderByComparator<KBTemplate> orderByComparator) throws PortalException {
        List curKBTemplates;
        int start = 0;
        if (curStartValues.length > cur - 1) {
            start = curStartValues[cur - 1];
            curStartValues = ArrayUtil.subset((int[])curStartValues, (int)0, (int)(cur - 1 + 1));
        } else {
            cur = 1;
            curStartValues = new int[]{0};
        }
        int end = start + 200;
        ArrayList<KBTemplate> kbTemplates = new ArrayList<KBTemplate>();
        int curStartValue = 0;
        while (curStartValue == 0 && !(curKBTemplates = this.kbTemplateLocalService.search(groupId, title, content, startDate, endDate, andOperator, start, end, orderByComparator)).isEmpty()) {
            for (int i = 0; i < curKBTemplates.size(); ++i) {
                KBTemplate curKBTemplate = (KBTemplate)curKBTemplates.get(i);
                if (!KBTemplatePermission.contains(this.getPermissionChecker(), curKBTemplate, "VIEW")) continue;
                if (kbTemplates.size() == delta) {
                    curStartValue = start + i;
                    break;
                }
                kbTemplates.add(curKBTemplate);
            }
            end = (start += 200) + 200;
        }
        int total = (cur - 1) * delta + kbTemplates.size();
        if (curStartValue > 0) {
            curStartValues = ArrayUtil.append((int[])curStartValues, (int)curStartValue);
            ++total;
        }
        return new KBTemplateSearchDisplayImpl(kbTemplates, total, curStartValues);
    }

    public KBTemplate updateKBTemplate(long kbTemplateId, String title, String content, ServiceContext serviceContext) throws PortalException {
        KBTemplatePermission.check(this.getPermissionChecker(), kbTemplateId, "UPDATE");
        return this.kbTemplateLocalService.updateKBTemplate(kbTemplateId, title, content, serviceContext);
    }
}

