/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.importer;

import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.internal.importer.KBArchive;
import com.liferay.knowledge.base.internal.importer.KBArchiveFactory;
import com.liferay.knowledge.base.internal.importer.PrioritizationStrategy;
import com.liferay.knowledge.base.internal.importer.util.KBArticleMarkdownConverter;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBArticleImporter.class})
public class KBArticleImporter {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleImporter.class);
    private KBArchiveFactory _kbArchiveFactory;

    public int processZipFile(long userId, long groupId, long parentKBFolderId, boolean prioritizeByNumericalPrefix, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        if (inputStream == null) {
            throw new KBArticleImportException("Input stream is null");
        }
        try {
            ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)inputStream);
            Map<String, String> metadata = this.getMetadata(zipReader);
            return this.processKBArticleFiles(userId, groupId, parentKBFolderId, prioritizeByNumericalPrefix, zipReader, metadata, serviceContext);
        }
        catch (IOException ioe) {
            throw new KBArticleImportException((Throwable)ioe);
        }
    }

    protected KBArticle addKBArticleMarkdown(long userId, long groupId, long parentKBFolderId, long parentResourceClassNameId, long parentResourcePrimaryKey, String markdown, String fileEntryName, ZipReader zipReader, Map<String, String> metadata, PrioritizationStrategy prioritizationStrategy, ServiceContext serviceContext) throws KBArticleImportException {
        if (Validator.isNull((String)markdown)) {
            throw new KBArticleImportException("Markdown is null for file entry " + fileEntryName);
        }
        KBArticleMarkdownConverter kbArticleMarkdownConverter = new KBArticleMarkdownConverter(markdown, fileEntryName, metadata);
        String urlTitle = kbArticleMarkdownConverter.getUrlTitle();
        KBArticle kbArticle = KBArticleLocalServiceUtil.fetchKBArticleByUrlTitle((long)groupId, (long)parentKBFolderId, (String)urlTitle);
        boolean newKBArticle = false;
        if (kbArticle == null) {
            newKBArticle = true;
        }
        try {
            if (kbArticle == null) {
                int workflowAction = serviceContext.getWorkflowAction();
                serviceContext.setWorkflowAction(2);
                kbArticle = KBArticleLocalServiceUtil.addKBArticle((long)userId, (long)parentResourceClassNameId, (long)parentResourcePrimaryKey, (String)kbArticleMarkdownConverter.getTitle(), (String)urlTitle, (String)markdown, null, (String)kbArticleMarkdownConverter.getSourceURL(), null, null, (ServiceContext)serviceContext);
                serviceContext.setWorkflowAction(workflowAction);
            }
        }
        catch (Exception e) {
            StringBundler sb = new StringBundler(4);
            sb.append("Unable to add basic KB article for file entry ");
            sb.append(fileEntryName);
            sb.append(": ");
            sb.append(e.getLocalizedMessage());
            throw new KBArticleImportException(sb.toString(), (Throwable)e);
        }
        try {
            String html = kbArticleMarkdownConverter.processAttachmentsReferences(userId, kbArticle, zipReader, new HashMap<String, FileEntry>());
            kbArticle = KBArticleLocalServiceUtil.updateKBArticle((long)userId, (long)kbArticle.getResourcePrimKey(), (String)kbArticleMarkdownConverter.getTitle(), (String)html, (String)kbArticle.getDescription(), (String)kbArticleMarkdownConverter.getSourceURL(), null, null, null, (ServiceContext)serviceContext);
            if (newKBArticle) {
                prioritizationStrategy.addKBArticle(kbArticle, fileEntryName);
            } else {
                prioritizationStrategy.updateKBArticle(kbArticle, fileEntryName);
            }
            return kbArticle;
        }
        catch (Exception e) {
            StringBundler sb = new StringBundler(4);
            sb.append("Unable to update KB article for file entry ");
            sb.append(fileEntryName);
            sb.append(": ");
            sb.append(e.getLocalizedMessage());
            throw new KBArticleImportException(sb.toString(), (Throwable)e);
        }
    }

    protected Map<String, String> getMetadata(ZipReader zipReader) throws KBArticleImportException {
        HashMap<String, String> hashMap;
        InputStream inputStream;
        block6: {
            inputStream = null;
            inputStream = zipReader.getEntryAsInputStream(".METADATA");
            if (inputStream != null) break block6;
            Map<String, String> map = Collections.emptyMap();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return map;
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            HashMap<String, String> metadata = new HashMap<String, String>(properties.size());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                metadata.put(key.toString(), value.toString());
            }
            hashMap = metadata;
        }
        catch (IOException ioe) {
            try {
                throw new KBArticleImportException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        return hashMap;
    }

    protected int processKBArticleFiles(long userId, long groupId, long parentKBFolderId, boolean prioritizeByNumericalPrefix, ZipReader zipReader, Map<String, String> metadata, ServiceContext serviceContext) throws PortalException {
        int importedKBArticlesCount = 0;
        PrioritizationStrategy prioritizationStrategy = PrioritizationStrategy.create(groupId, parentKBFolderId, prioritizeByNumericalPrefix);
        KBArchive kbArchive = this._kbArchiveFactory.createKBArchive(groupId, zipReader);
        HashMap<KBArchive.File, KBArticle> introFileNameKBArticleMap = new HashMap<KBArchive.File, KBArticle>();
        for (KBArchive.Folder folder : kbArchive.getFolders()) {
            long sectionResourcePrimaryKey;
            long sectionResourceClassNameId;
            KBArchive.File introFile = folder.getIntroFile();
            KBArticle introKBArticle = (KBArticle)introFileNameKBArticleMap.get(introFile);
            if (introFile != null && introKBArticle == null) {
                sectionResourceClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
                sectionResourcePrimaryKey = parentKBFolderId;
                KBArticle parentIntroKBArticle = (KBArticle)introFileNameKBArticleMap.get(folder.getParentFolderIntroFile());
                if (parentIntroKBArticle != null) {
                    sectionResourceClassNameId = PortalUtil.getClassNameId((String)KBArticleConstants.getClassName());
                    sectionResourcePrimaryKey = parentIntroKBArticle.getResourcePrimKey();
                }
                introKBArticle = this.addKBArticleMarkdown(userId, groupId, parentKBFolderId, sectionResourceClassNameId, sectionResourcePrimaryKey, introFile.getContent(), introFile.getName(), zipReader, metadata, prioritizationStrategy, serviceContext);
                ++importedKBArticlesCount;
                introFileNameKBArticleMap.put(introFile, introKBArticle);
            }
            sectionResourceClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
            sectionResourcePrimaryKey = parentKBFolderId;
            if (introKBArticle != null) {
                sectionResourceClassNameId = PortalUtil.getClassNameId((String)KBArticleConstants.getClassName());
                sectionResourcePrimaryKey = introKBArticle.getResourcePrimKey();
            }
            for (KBArchive.File file : folder.getFiles()) {
                String markdown = file.getContent();
                if (Validator.isNull((String)markdown) && _log.isWarnEnabled()) {
                    _log.warn((Object)("Missing Markdown in file entry " + file.getName()));
                }
                this.addKBArticleMarkdown(userId, groupId, parentKBFolderId, sectionResourceClassNameId, sectionResourcePrimaryKey, markdown, file.getName(), zipReader, metadata, prioritizationStrategy, serviceContext);
                ++importedKBArticlesCount;
            }
        }
        prioritizationStrategy.prioritizeKBArticles();
        return importedKBArticlesCount;
    }

    @Reference(unbind="-")
    protected void setKBArchiveFactory(KBArchiveFactory kbArchiveFactory) {
        this._kbArchiveFactory = kbArchiveFactory;
    }
}

