/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.search;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class KBArticleIndexer
extends BaseIndexer<KBArticle> {
    public static final String CLASS_NAME = KBArticle.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(KBArticleIndexer.class);
    private KBArticleLocalService _kbArticleLocalService;
    private KBFolderLocalService _kbFolderLocalService;

    public KBArticleIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "content", "createDate", "description", "entryClassName", "entryClassPK", "modified", "title", "uid", "userName"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return KBArticlePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "content", true);
        this.addSearchTerm(searchQuery, searchContext, "description", true);
        this.addSearchTerm(searchQuery, searchContext, "title", true);
        this.addSearchTerm(searchQuery, searchContext, "userName", true);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        Hits hits = super.search(searchContext);
        Object[] queryTerms = hits.getQueryTerms();
        String keywords = searchContext.getKeywords();
        queryTerms = (String[])ArrayUtil.append((Object[])queryTerms, (Object[])KnowledgeBaseUtil.splitKeywords((String)keywords));
        hits.setQueryTerms((String[])queryTerms);
        return hits;
    }

    protected void doDelete(KBArticle kbArticle) throws Exception {
        this.deleteDocument(kbArticle.getCompanyId(), kbArticle.getResourcePrimKey());
    }

    protected Document doGetDocument(KBArticle kbArticle) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)kbArticle);
        document.addText("content", HtmlUtil.extractText((String)kbArticle.getContent()));
        document.addText("description", kbArticle.getDescription());
        document.addText("title", kbArticle.getTitle());
        document.addKeyword("folderNames", this.getKBFolderNames(kbArticle));
        document.addKeyword("titleKeyword", kbArticle.getTitle(), true);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet) && Validator.isNull((String)(content = document.get("description")))) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        return new Summary(title, content);
    }

    protected void doReindex(KBArticle kbArticle) throws Exception {
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)kbArticle.getCompanyId(), (Document)this.getDocument(kbArticle), (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(classPK, -1);
        this.reindexKBArticles(kbArticle);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexKBArticles(companyId);
    }

    protected String[] getKBFolderNames(KBArticle kbArticle) throws PortalException {
        long kbFolderId = kbArticle.getKbFolderId();
        ArrayList<String> kbFolderNames = new ArrayList<String>();
        while (kbFolderId != 0L) {
            KBFolder kbFolder = this._kbFolderLocalService.getKBFolder(kbFolderId);
            kbFolderNames.add(kbFolder.getName());
            kbFolderId = kbFolder.getParentKBFolderId();
        }
        return kbFolderNames.toArray(new String[kbFolderNames.size()]);
    }

    protected void reindexKBArticles(KBArticle kbArticle) throws Exception {
        List kbArticles = this._kbArticleLocalService.getKBArticleAndAllDescendantKBArticles(kbArticle.getResourcePrimKey(), 0, null);
        ArrayList<Document> documents = new ArrayList<Document>();
        for (KBArticle curKBArticle : kbArticles) {
            documents.add(this.getDocument(curKBArticle));
        }
        IndexWriterHelperUtil.updateDocuments((String)this.getSearchEngineId(), (long)kbArticle.getCompanyId(), documents, (boolean)this.isCommitImmediately());
    }

    protected void reindexKBArticles(long companyId) throws Exception {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._kbArticleLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"status");
                dynamicQuery.add(property.eq((Object)0));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<KBArticle>(){

            public void performAction(KBArticle kbArticle) {
                block2: {
                    try {
                        Document document = KBArticleIndexer.this.getDocument(kbArticle);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index knowledge base article " + kbArticle.getKbArticleId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setKBFolderLocalService(KBFolderLocalService kbFolderLocalService) {
        this._kbFolderLocalService = kbFolderLocalService;
    }
}

