/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_3_0;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.v6_2_0.BaseUpgradeAttachments;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeKBAttachments
extends BaseUpgradeAttachments {
    protected void deleteEmptyDirectories() throws Exception {
        for (long companyId : PortalUtil.getCompanyIds()) {
            DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)"knowledgebase/kbarticles");
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateAttachments();
        this.deleteEmptyDirectories();
    }

    protected String getClassName() {
        return "com.liferay.knowledgebase.model.KBArticle";
    }

    protected long getContainerModelFolderId(long groupId, long companyId, long resourcePrimKey, long containerId, long userId, String userName, Timestamp createDate) throws Exception {
        long repositoryId = this.getRepositoryId(groupId, companyId, userId, userName, createDate, this.getClassNameId(), this.getPortletId());
        long repositoryFolderId = this.getFolderId(groupId, companyId, userId, userName, createDate, repositoryId, 0L, this.getPortletId(), false);
        long kbArticleFolderId = this.getFolderId(groupId, companyId, userId, userName, createDate, repositoryId, repositoryFolderId, String.valueOf(resourcePrimKey), false);
        return kbArticleFolderId;
    }

    protected String getDirName(long containerModelId, long resourcePrimKey) {
        return "knowledgebase/kbarticles/" + resourcePrimKey;
    }

    protected String getPortletId() {
        return "3_WAR_knowledgebaseportlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAttachments() throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBundler sb = new StringBundler(5);
            sb.append("select MIN(kbArticleId) as kbArticleId, ");
            sb.append("resourcePrimKey, groupId, companyId, ");
            sb.append("MIN(userId) as userId, MIN(userName) as userName, ");
            sb.append("MIN(status) as status from KBArticle ");
            sb.append("group by resourcePrimKey, groupId, companyId");
            ps = this.connection.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long kbArticleId = rs.getLong("kbArticleId");
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                int status = rs.getInt("status");
                long classPK = resourcePrimKey;
                if (status != 0) {
                    classPK = kbArticleId;
                }
                this.updateEntryAttachments(companyId, groupId, classPK, 0L, userId, userName);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps, (ResultSet)rs);
    }
}

