/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.DuplicateKBFolderNameException;
import com.liferay.knowledge.base.exception.InvalidKBFolderNameException;
import com.liferay.knowledge.base.exception.KBFolderParentException;
import com.liferay.knowledge.base.exception.NoSuchFolderException;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.base.KBFolderLocalServiceBaseImpl;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;

public class KBFolderLocalServiceImpl
extends KBFolderLocalServiceBaseImpl {
    public KBFolder addKBFolder(long userId, long groupId, long parentResourceClassNameId, long parentResourcePrimKey, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        this.validateName(groupId, parentResourcePrimKey, name);
        this.validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderId = this.counterLocalService.increment();
        KBFolder kbFolder = this.kbFolderPersistence.create(kbFolderId);
        kbFolder.setUuid(serviceContext.getUuid());
        kbFolder.setGroupId(groupId);
        kbFolder.setCompanyId(user.getCompanyId());
        kbFolder.setUserId(userId);
        kbFolder.setUserName(user.getFullName());
        kbFolder.setCreateDate(now);
        kbFolder.setModifiedDate(now);
        kbFolder.setParentKBFolderId(parentResourcePrimKey);
        kbFolder.setName(name);
        kbFolder.setUrlTitle(this.getUniqueUrlTitle(groupId, parentResourcePrimKey, kbFolderId, name));
        kbFolder.setDescription(description);
        kbFolder.setExpandoBridgeAttributes(serviceContext);
        kbFolder = (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addKBFolderResources(kbFolder, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addKBFolderResources(kbFolder, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return kbFolder;
    }

    @Override
    public KBFolder deleteKBFolder(long kbFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        this.kbArticleLocalService.deleteKBArticles(kbFolder.getGroupId(), kbFolder.getKbFolderId());
        List childKBFolders = this.kbFolderPersistence.findByG_P(kbFolder.getGroupId(), kbFolder.getKbFolderId());
        for (KBFolder childKBFolder : childKBFolders) {
            this.deleteKBFolder(childKBFolder.getKbFolderId());
        }
        this.expandoRowLocalService.deleteRows(kbFolder.getKbFolderId());
        return (KBFolder)this.kbFolderPersistence.remove((BaseModel)kbFolder);
    }

    public void deleteKBFolders(long groupId) throws PortalException {
        List<KBFolder> kbFolders = this.getKBFolders(groupId, 0L, -1, -1);
        for (KBFolder kbFolder : kbFolders) {
            this.deleteKBFolder(kbFolder.getKbFolderId());
        }
    }

    public KBFolder fetchFirstChildKBFolder(long groupId, long kbFolderId) throws PortalException {
        return this.fetchFirstChildKBFolder(groupId, kbFolderId, null);
    }

    public KBFolder fetchFirstChildKBFolder(long groupId, long kbFolderId, OrderByComparator<KBFolder> obc) throws PortalException {
        return this.kbFolderPersistence.fetchByG_P_First(groupId, kbFolderId, obc);
    }

    @Override
    public KBFolder fetchKBFolder(long kbFolderId) {
        return this.kbFolderPersistence.fetchByPrimaryKey(kbFolderId);
    }

    public KBFolder fetchKBFolder(String uuid, long groupId) {
        return this.kbFolderPersistence.fetchByUUID_G(uuid, groupId);
    }

    public KBFolder fetchKBFolderByUrlTitle(long groupId, long parentKbFolderId, String urlTitle) throws PortalException {
        return this.kbFolderPersistence.fetchByG_P_UT(groupId, parentKbFolderId, urlTitle);
    }

    public KBFolder getKBFolderByUrlTitle(long groupId, long parentKbFolderId, String urlTitle) throws PortalException {
        return this.kbFolderPersistence.findByG_P_UT(groupId, parentKbFolderId, urlTitle);
    }

    public List<KBFolder> getKBFolders(long groupId, long parentKBFolderId, int start, int end) throws PortalException {
        return this.kbFolderPersistence.findByG_P(groupId, parentKBFolderId, start, end);
    }

    public List<Object> getKBFoldersAndKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.kbFolderFinder.findF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public int getKBFoldersAndKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.kbFolderFinder.countF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public int getKBFoldersCount(long groupId, long parentKBFolderId) throws PortalException {
        return this.kbFolderPersistence.countByG_P(groupId, parentKBFolderId);
    }

    public void moveKBFolder(long kbFolderId, long parentKBFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        if (parentKBFolderId != 0L) {
            KBFolder parentKBFolder = this.kbFolderPersistence.findByPrimaryKey(parentKBFolderId);
            this.validateParent(kbFolder, parentKBFolder);
            parentKBFolderId = parentKBFolder.getKbFolderId();
        }
        kbFolder.setParentKBFolderId(parentKBFolderId);
        this.kbFolderPersistence.update((BaseModel)kbFolder);
    }

    @Deprecated
    public KBFolder updateKBFolder(long parentResourceClassNameId, long parentResourcePrimKey, long kbFolderId, String name, String description) throws PortalException {
        return this.updateKBFolder(parentResourceClassNameId, parentResourcePrimKey, kbFolderId, name, description, new ServiceContext());
    }

    public KBFolder updateKBFolder(long parentResourceClassNameId, long parentResourcePrimKey, long kbFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validateParent(parentResourceClassNameId, parentResourcePrimKey);
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        kbFolder.setModifiedDate(new Date());
        kbFolder.setParentKBFolderId(parentResourcePrimKey);
        kbFolder.setName(name);
        kbFolder.setDescription(description);
        kbFolder.setExpandoBridgeAttributes(serviceContext);
        return (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
    }

    protected void addKBFolderResources(KBFolder kbFolder, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(kbFolder.getCompanyId(), kbFolder.getGroupId(), kbFolder.getUserId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addKBFolderResources(KBFolder kbFolder, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(kbFolder.getCompanyId(), kbFolder.getGroupId(), kbFolder.getUserId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), groupPermissions, guestPermissions);
    }

    protected String getUniqueUrlTitle(long groupId, long parentKbFolderId, long kbFolderId, String name) {
        String urlTitle;
        String uniqueUrlTitle = urlTitle = KnowledgeBaseUtil.getUrlTitle((long)kbFolderId, (String)name);
        KBFolder kbFolder = this.kbFolderPersistence.fetchByG_P_UT(groupId, parentKbFolderId, uniqueUrlTitle);
        int i = 1;
        while (kbFolder != null) {
            uniqueUrlTitle = urlTitle + "-" + i;
            kbFolder = this.kbFolderPersistence.fetchByG_P_UT(groupId, parentKbFolderId, uniqueUrlTitle);
            ++i;
        }
        return uniqueUrlTitle;
    }

    protected void validateName(long groupId, long parentKBFolderId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new InvalidKBFolderNameException("KB folder name is null");
        }
        KBFolder kbFolder = this.kbFolderPersistence.fetchByG_P_N(groupId, parentKBFolderId, name);
        if (kbFolder != null) {
            throw new DuplicateKBFolderNameException(String.format("A KB folder with name %s already exists", name));
        }
    }

    protected void validateParent(KBFolder kbFolder, KBFolder parentKBFolder) throws PortalException {
        if (kbFolder.getGroupId() != parentKBFolder.getGroupId()) {
            throw new NoSuchFolderException(String.format("No KB folder with KB folder ID %s found in group %s", parentKBFolder.getKbFolderId(), kbFolder.getGroupId()));
        }
        List ancestorKBFolderIds = parentKBFolder.getAncestorKBFolderIds();
        if (ancestorKBFolderIds.contains(kbFolder.getKbFolderId())) {
            throw new KBFolderParentException(String.format("Cannot move KBFolder %s inside its descendant KBFolder %s", kbFolder.getKbFolderId(), parentKBFolder.getKbFolderId()));
        }
    }

    protected void validateParent(long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        long kbFolderClassNameId = this.classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        KBFolder parentKBFolder = null;
        if (parentResourceClassNameId == kbFolderClassNameId) {
            if (parentResourcePrimKey == 0L) {
                return;
            }
            parentKBFolder = this.kbFolderPersistence.fetchByPrimaryKey(parentResourcePrimKey);
        }
        if (parentKBFolder == null) {
            throw new NoSuchFolderException(String.format("No KB folder found with KB folder ID %", parentResourcePrimKey));
        }
    }
}

