/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.permission;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.service.KBCommentLocalServiceUtil;
import com.liferay.knowledge.base.service.KBTemplateLocalServiceUtil;
import com.liferay.knowledge.base.service.permission.AdminPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBComment"}, service={BaseModelPermissionChecker.class})
public class KBCommentPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, KBComment kbComment, String actionId) throws PortalException {
        if (!KBCommentPermission.contains(permissionChecker, kbComment, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long kbCommentId, String actionId) throws PortalException {
        if (!KBCommentPermission.contains(permissionChecker, kbCommentId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, KBComment kbComment, String actionId) throws PortalException {
        if (permissionChecker.getUserId() == kbComment.getUserId()) {
            return true;
        }
        if (actionId.equals("VIEW")) {
            return AdminPermission.contains(permissionChecker, kbComment.getGroupId(), "VIEW_SUGGESTIONS");
        }
        if (!actionId.equals("DELETE") && !actionId.equals("UPDATE")) {
            return false;
        }
        String className = kbComment.getClassName();
        if (className.equals(KBArticle.class.getName())) {
            KBArticle kbArticle = KBArticleLocalServiceUtil.getLatestKBArticle((long)kbComment.getClassPK(), (int)-1);
            return permissionChecker.hasPermission(kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), "UPDATE");
        }
        if (className.equals(KBTemplate.class.getName())) {
            KBTemplate kbTemplate = KBTemplateLocalServiceUtil.getKBTemplate((long)kbComment.getClassPK());
            return permissionChecker.hasPermission(kbTemplate.getGroupId(), KBTemplate.class.getName(), kbTemplate.getPrimaryKey(), "UPDATE");
        }
        return false;
    }

    public static boolean contains(PermissionChecker permissionChecker, long kbCommentId, String actionId) throws PortalException {
        KBComment kbComment = KBCommentLocalServiceUtil.getKBComment((long)kbCommentId);
        return KBCommentPermission.contains(permissionChecker, kbComment, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        KBCommentPermission.check(permissionChecker, primaryKey, actionId);
    }
}

