/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.KBArticleContentException;
import com.liferay.knowledge.base.exception.KBArticleParentException;
import com.liferay.knowledge.base.exception.KBArticlePriorityException;
import com.liferay.knowledge.base.exception.KBArticleSourceURLException;
import com.liferay.knowledge.base.exception.KBArticleStatusException;
import com.liferay.knowledge.base.exception.KBArticleTitleException;
import com.liferay.knowledge.base.exception.KBArticleUrlTitleException;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.internal.importer.KBArchiveFactory;
import com.liferay.knowledge.base.internal.importer.KBArticleImporter;
import com.liferay.knowledge.base.internal.util.AdminSubscriptionSenderFactory;
import com.liferay.knowledge.base.internal.util.KBArticleLocalSiblingNavigationHelper;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.base.KBArticleLocalServiceBaseImpl;
import com.liferay.knowledge.base.util.AdminHelper;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleVersionComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KBArticleLocalServiceImpl
extends KBArticleLocalServiceBaseImpl {
    @BeanReference(type=AdminHelper.class)
    protected AdminHelper adminHelper;
    @ServiceReference(type=ConfigurationProvider.class)
    protected ConfigurationProvider configurationProvider;
    @ServiceReference(type=DLURLHelper.class)
    protected DLURLHelper dlURLHelper;
    @ServiceReference(type=IndexerRegistry.class)
    protected IndexerRegistry indexerRegistry;
    @ServiceReference(type=IndexWriterHelper.class)
    protected IndexWriterHelper indexWriterHelper;
    @ServiceReference(type=KBArchiveFactory.class)
    protected KBArchiveFactory kbArchiveFactory;
    @ServiceReference(type=Portal.class)
    protected Portal portal;
    @BeanReference(type=PortletFileRepository.class)
    protected PortletFileRepository portletFileRepository;
    @ServiceReference(type=SubscriptionLocalService.class)
    protected SubscriptionLocalService subscriptionLocalService;
    private static final int[] _STATUSES = new int[]{0, 1};
    private static final long _TICKET_EXPIRATION = 3600000L;
    private static final Log _log = LogFactoryUtil.getLog(KBArticleLocalServiceImpl.class);

    public FileEntry addAttachment(long userId, long resourcePrimKey, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(resourcePrimKey, -1);
        return this.portletFileRepository.addPortletFileEntry(kbArticle.getGroupId(), userId, KBArticle.class.getName(), kbArticle.getClassPK(), "com.liferay.knowledge.base", kbArticle.getAttachmentsFolderId(), inputStream, fileName, mimeType, false);
    }

    public KBArticle addKBArticle(long userId, long parentResourceClassNameId, long parentResourcePrimKey, String title, String urlTitle, String content, String description, String sourceURL, String[] sections, String[] selectedFileNames, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        urlTitle = this.normalizeUrlTitle(urlTitle);
        double priority = this.getPriority(groupId, parentResourcePrimKey);
        Date now = new Date();
        this.validate(title, content, sourceURL);
        this.validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderId = KnowledgeBaseUtil.getKBFolderId((long)parentResourceClassNameId, (long)parentResourcePrimKey);
        urlTitle = StringUtil.toLowerCase((String)urlTitle);
        this.validateUrlTitle(groupId, kbFolderId, urlTitle);
        long kbArticleId = this.counterLocalService.increment();
        long resourcePrimKey = this.counterLocalService.increment();
        long rootResourcePrimKey = this.getRootResourcePrimKey(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        KBArticle kbArticle = this.kbArticlePersistence.create(kbArticleId);
        kbArticle.setUuid(serviceContext.getUuid());
        kbArticle.setResourcePrimKey(resourcePrimKey);
        kbArticle.setGroupId(groupId);
        kbArticle.setCompanyId(user.getCompanyId());
        kbArticle.setUserId(user.getUserId());
        kbArticle.setUserName(user.getFullName());
        kbArticle.setCreateDate(serviceContext.getCreateDate(now));
        kbArticle.setModifiedDate(serviceContext.getModifiedDate(now));
        kbArticle.setRootResourcePrimKey(rootResourcePrimKey);
        kbArticle.setParentResourceClassNameId(parentResourceClassNameId);
        kbArticle.setParentResourcePrimKey(parentResourcePrimKey);
        kbArticle.setKbFolderId(kbFolderId);
        kbArticle.setVersion(1);
        kbArticle.setTitle(title);
        kbArticle.setUrlTitle(this.getUniqueUrlTitle(groupId, kbFolderId, kbArticleId, title, urlTitle));
        kbArticle.setContent(content);
        kbArticle.setDescription(description);
        kbArticle.setPriority(priority);
        kbArticle.setSections(StringUtil.merge((Object[])this.adminHelper.escapeSections(sections)));
        kbArticle.setViewCount(0);
        kbArticle.setLatest(true);
        kbArticle.setMain(false);
        kbArticle.setSourceURL(sourceURL);
        kbArticle.setStatus(2);
        kbArticle.setExpandoBridgeAttributes(serviceContext);
        this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addKBArticleResources(kbArticle, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addKBArticleResources(kbArticle, serviceContext.getModelPermissions());
        }
        this.updateKBArticleAsset(userId, kbArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.addKBArticleAttachments(userId, kbArticle, selectedFileNames);
        return (KBArticle)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)KBArticle.class.getName(), (long)resourcePrimKey, (Object)kbArticle, (ServiceContext)serviceContext, Collections.emptyMap());
    }

    public void addKBArticleResources(KBArticle kbArticle, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addKBArticleResources(KBArticle kbArticle, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), modelPermissions);
    }

    @Deprecated
    public void addKBArticleResources(KBArticle kbArticle, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addKBArticleResources(long kbArticleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        KBArticle kbArticle = this.kbArticlePersistence.findByPrimaryKey(kbArticleId);
        this.addKBArticleResources(kbArticle, addGroupPermissions, addGuestPermissions);
    }

    @Deprecated
    public void addKBArticleResources(long kbArticleId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        KBArticle kbArticle = this.kbArticlePersistence.findByPrimaryKey(kbArticleId);
        this.addKBArticleResources(kbArticle, groupPermissions, guestPermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addKBArticlesMarkdown(long userId, long groupId, long parentKbFolderId, String fileName, boolean prioritizeByNumericalPrefix, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            KBArticleImporter kbArticleImporter = new KBArticleImporter(this.kbArchiveFactory, this, this.portal, this.dlURLHelper);
            int n = kbArticleImporter.processZipFile(userId, groupId, parentKbFolderId, prioritizeByNumericalPrefix, inputStream, serviceContext);
            return n;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public void addTempAttachment(long groupId, long userId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException {
        TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)tempFolderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void deleteGroupKBArticles(long groupId) throws PortalException {
        this.deleteKBArticles(groupId, 0L);
        Group group = this.groupLocalService.getGroup(groupId);
        List subscriptions = this.subscriptionLocalService.getSubscriptions(group.getCompanyId(), KBArticle.class.getName(), groupId);
        for (Subscription subscription : subscriptions) {
            this.unsubscribeGroupKBArticles(subscription.getUserId(), groupId);
        }
    }

    @Override
    @SystemEvent(action=1, type=1)
    public KBArticle deleteKBArticle(KBArticle kbArticle) throws PortalException {
        this.deleteKBArticles(kbArticle.getGroupId(), kbArticle.getResourcePrimKey());
        this.resourceLocalService.deleteResource(kbArticle.getCompanyId(), KBArticle.class.getName(), 4, kbArticle.getResourcePrimKey());
        this.kbArticlePersistence.removeByResourcePrimKey(kbArticle.getResourcePrimKey());
        this.kbCommentLocalService.deleteKBComments(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        this.deleteAssets(kbArticle);
        this.expandoRowLocalService.deleteRows(kbArticle.getKbArticleId());
        this.ratingsStatsLocalService.deleteStats(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        this.socialActivityLocalService.deleteActivities(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        Indexer indexer = this.indexerRegistry.getIndexer(KBArticle.class);
        indexer.delete((Object)kbArticle);
        this.portletFileRepository.deletePortletFolder(kbArticle.getAttachmentsFolderId());
        this.deleteSubscriptions(kbArticle);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(kbArticle.getCompanyId(), kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        return kbArticle;
    }

    @Override
    public KBArticle deleteKBArticle(long resourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        return this.kbArticleLocalService.deleteKBArticle(kbArticle);
    }

    public void deleteKBArticles(long groupId, long parentResourcePrimKey) throws PortalException {
        List<KBArticle> childKBArticles = this.getKBArticles(groupId, parentResourcePrimKey, -1, -1, -1, null);
        for (KBArticle childKBArticle : childKBArticles) {
            this.kbArticleLocalService.deleteKBArticle(childKBArticle);
        }
    }

    public void deleteKBArticles(long[] resourcePrimKeys) throws PortalException {
        List<KBArticle> kbArticles = this.getKBArticles(resourcePrimKeys, -1, null);
        for (KBArticle kbArticle : kbArticles) {
            this.kbArticleLocalService.deleteKBArticle(kbArticle);
        }
    }

    public void deleteTempAttachment(long groupId, long userId, String fileName, String tempFolderName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)tempFolderName, (String)fileName);
    }

    public KBArticle fetchFirstChildKBArticle(long groupId, long parentResourcePrimKey) {
        return this.kbArticlePersistence.fetchByG_P_L_First(groupId, parentResourcePrimKey, true, (OrderByComparator)new KBArticlePriorityComparator(true));
    }

    public KBArticle fetchKBArticle(long resourcePrimKey, long groupId, int version) {
        return this.kbArticlePersistence.fetchByR_G_V(resourcePrimKey, groupId, version);
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) {
        KBArticle kbArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), 0);
        if (kbArticle == null) {
            kbArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle, 1);
        }
        return kbArticle;
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        List kbArticles = this.kbArticleFinder.findByUrlTitle(groupId, kbFolderUrlTitle, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), _STATUSES, 0, 1);
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)new KBArticleVersionComparator());
        }
        return this.kbArticlePersistence.fetchByR_S_First(resourcePrimKey, status, (OrderByComparator)new KBArticleVersionComparator());
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, long groupId) {
        return this.kbArticlePersistence.fetchByR_G_L_First(resourcePrimKey, groupId, true, null);
    }

    public KBArticle fetchLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) {
        urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)"");
        List kbArticles = null;
        KBArticleVersionComparator orderByComparator = new KBArticleVersionComparator();
        kbArticles = status == -1 ? this.kbArticlePersistence.findByG_KBFI_UT(groupId, kbFolderId, urlTitle, 0, 1, (OrderByComparator)orderByComparator) : this.kbArticlePersistence.findByG_KBFI_UT_ST(groupId, kbFolderId, urlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public List<KBArticle> getAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this.getAllDescendantKBArticles(resourcePrimKey, status, orderByComparator, false);
    }

    public List<KBArticle> getCompanyKBArticles(long companyId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByC_L(companyId, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByC_M(companyId, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getCompanyKBArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByC_L(companyId, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByC_M(companyId, true);
        }
        return this.kbArticlePersistence.countByC_S(companyId, status);
    }

    public List<KBArticle> getGroupKBArticles(long groupId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByG_L(groupId, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_M(groupId, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public int getGroupKBArticlesCount(long groupId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByG_L(groupId, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_M(groupId, true);
        }
        return this.kbArticlePersistence.countByG_S(groupId, status);
    }

    public KBArticle getKBArticle(long resourcePrimKey, int version) throws PortalException {
        return this.kbArticlePersistence.findByR_V(resourcePrimKey, version);
    }

    public List<KBArticle> getKBArticleAndAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this.getAllDescendantKBArticles(resourcePrimKey, status, orderByComparator, true);
    }

    @Deprecated
    public List<KBArticle> getKBArticleAndAllDescendants(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this.getKBArticleAndAllDescendantKBArticles(resourcePrimKey, status, orderByComparator);
    }

    public KBArticle getKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.fetchKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""));
        if (kbArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {groupId=", groupId, ", kbFolderId=", kbFolderId, ", urlTitle=", urlTitle, "}"}));
        }
        return kbArticle;
    }

    public KBArticle getKBArticleByUrlTitle(long groupId, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.fetchKBArticleByUrlTitle(groupId, kbFolderUrlTitle, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""));
        if (kbArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle with the key {groupId=", groupId, ", urlTitle=", urlTitle, "} found in a folder with URL title ", kbFolderUrlTitle}));
        }
        return kbArticle;
    }

    public List<KBArticle> getKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByG_P_L(groupId, parentResourcePrimKey, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_P_M(groupId, parentResourcePrimKey, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_P_S(groupId, parentResourcePrimKey, status, start, end, orderByComparator);
    }

    public List<KBArticle> getKBArticles(long[] resourcePrimKeys, int status, OrderByComparator<KBArticle> orderByComparator) {
        List kbArticles = new ArrayList();
        Long[][] params = new Long[][]{ArrayUtil.toArray((long[])resourcePrimKeys)};
        while ((params = KnowledgeBaseUtil.getParams((Long[])params[0])) != null) {
            List curKBArticles = null;
            curKBArticles = status == -1 ? this.kbArticlePersistence.findByR_L(ArrayUtil.toArray((Long[])params[1]), true) : (status == 0 ? this.kbArticlePersistence.findByR_M(ArrayUtil.toArray((Long[])params[1]), true) : this.kbArticlePersistence.findByR_S(ArrayUtil.toArray((Long[])params[1]), status));
            kbArticles.addAll(curKBArticles);
        }
        kbArticles = orderByComparator != null ? ListUtil.sort(kbArticles, orderByComparator) : KnowledgeBaseUtil.sort((long[])resourcePrimKeys, kbArticles);
        return Collections.unmodifiableList(kbArticles);
    }

    public int getKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByG_P_L(groupId, parentResourcePrimKey, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_P_M(groupId, parentResourcePrimKey, true);
        }
        return this.kbArticlePersistence.countByG_P_S(groupId, parentResourcePrimKey, status);
    }

    public List<KBArticle> getKBArticleVersions(long resourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByResourcePrimKey(resourcePrimKey, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByR_S(resourcePrimKey, status, start, end, orderByComparator);
    }

    public int getKBArticleVersionsCount(long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByResourcePrimKey(resourcePrimKey);
        }
        return this.kbArticlePersistence.countByR_S(resourcePrimKey, status);
    }

    public List<KBArticle> getKBFolderKBArticles(long groupId, long kbFolderId) {
        return this.kbArticlePersistence.findByG_KBFI_L(groupId, kbFolderId, true);
    }

    public int getKBFolderKBArticlesCount(long groupId, long kbFolderId, int status) {
        return this.kbArticlePersistence.countByG_KBFI_S(groupId, kbFolderId, status);
    }

    public KBArticle getLatestKBArticle(long resourcePrimKey, int status) throws PortalException {
        if (status == -1) {
            return this.kbArticlePersistence.findByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)new KBArticleVersionComparator());
        }
        return this.kbArticlePersistence.findByR_S_First(resourcePrimKey, status, (OrderByComparator)new KBArticleVersionComparator());
    }

    public KBArticle getLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) throws PortalException {
        KBArticle latestKBArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), status);
        if (latestKBArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {groupId=", groupId, ", kbFolderId=", kbFolderId, ", urlTitle=", urlTitle, ", status=", status, "}"}));
        }
        return latestKBArticle;
    }

    public KBArticle[] getPreviousAndNextKBArticles(long kbArticleId) throws PortalException {
        KBArticleLocalSiblingNavigationHelper kbArticleLocalSiblingNavigationHelper = new KBArticleLocalSiblingNavigationHelper(this.kbArticlePersistence);
        return kbArticleLocalSiblingNavigationHelper.getPreviousAndNextKBArticles(kbArticleId);
    }

    public List<KBArticle> getSectionsKBArticles(long groupId, String[] sections, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        String[] array = this.adminHelper.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.findByG_S_L(groupId, array, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_S_M(groupId, array, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_S_S(groupId, array, status, start, end, orderByComparator);
    }

    public int getSectionsKBArticlesCount(long groupId, String[] sections, int status) {
        String[] array = this.adminHelper.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.countByG_S_L(groupId, array, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_S_M(groupId, array, true);
        }
        return this.kbArticlePersistence.countByG_S_S(groupId, array, status);
    }

    @Deprecated
    public List<KBArticle> getSiblingKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        return this.getKBArticles(groupId, parentResourcePrimKey, status, start, end, orderByComparator);
    }

    @Deprecated
    public int getSiblingKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        return this.getKBArticlesCount(groupId, parentResourcePrimKey, status);
    }

    public String[] getTempAttachmentNames(long groupId, long userId, String tempFolderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)tempFolderName);
    }

    public void moveKBArticle(long userId, long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey, double priority) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        if (kbArticle.getResourcePrimKey() == parentResourcePrimKey) {
            return;
        }
        this.validateParent(kbArticle, parentResourceClassNameId, parentResourcePrimKey);
        this.validateParentStatus(parentResourceClassNameId, parentResourcePrimKey, kbArticle.getStatus());
        this.validate(priority);
        this.updatePermissionFields(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderClassNameId = this.classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        long kbFolderId = 0L;
        if (parentResourceClassNameId == kbFolderClassNameId) {
            kbFolderId = parentResourcePrimKey;
        } else {
            KBArticle parentKBArticle = this.getLatestKBArticle(parentResourcePrimKey, -1);
            kbFolderId = parentKBArticle.getKbFolderId();
        }
        List<KBArticle> kbArticles = this.getKBArticleVersions(resourcePrimKey, -1, -1, -1, (OrderByComparator<KBArticle>)new KBArticleVersionComparator());
        for (KBArticle kBArticle : kbArticles) {
            kBArticle.setParentResourceClassNameId(parentResourceClassNameId);
            kBArticle.setParentResourcePrimKey(parentResourcePrimKey);
            kBArticle.setKbFolderId(kbFolderId);
            kBArticle.setPriority(priority);
            this.kbArticlePersistence.update((BaseModel)kBArticle);
        }
        if (kbArticle.getKbFolderId() != kbFolderId) {
            List<KBArticle> descendantKBArticles = this.getAllDescendantKBArticles(resourcePrimKey, -1, null);
            for (KBArticle curKBArticle : descendantKBArticles) {
                List<KBArticle> kbArticleVersions = this.getKBArticleVersions(curKBArticle.getResourcePrimKey(), -1, -1, -1, (OrderByComparator<KBArticle>)new KBArticleVersionComparator());
                for (KBArticle kbArticleVersion : kbArticleVersions) {
                    kbArticleVersion.setKbFolderId(kbFolderId);
                    this.kbArticlePersistence.update((BaseModel)kbArticleVersion);
                }
            }
        }
        KBArticle latestKBArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        JSONObject jSONObject = JSONUtil.put((String)"title", (Object)latestKBArticle.getTitle());
        if (latestKBArticle.isApproved() || !latestKBArticle.isFirstVersion()) {
            this.socialActivityLocalService.addActivity(userId, latestKBArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 7, jSONObject.toString(), 0L);
        }
    }

    public KBArticle revertKBArticle(long userId, long resourcePrimKey, int version, ServiceContext serviceContext) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getKBArticle(resourcePrimKey, version);
        ExpandoBridge expandoBridge = kbArticle.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
        return this.updateKBArticle(userId, resourcePrimKey, kbArticle.getTitle(), kbArticle.getContent(), kbArticle.getDescription(), kbArticle.getSourceURL(), StringUtil.split((String)kbArticle.getSections()), null, null, serviceContext);
    }

    public List<KBArticle> search(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(groupId, title, content, status, startDate, endDate, andOperator);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public void subscribeGroupKBArticles(long userId, long groupId) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, KBArticle.class.getName(), groupId);
    }

    public void subscribeKBArticle(long userId, long groupId, long resourcePrimKey) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, KBArticle.class.getName(), resourcePrimKey);
    }

    public void unsubscribeGroupKBArticles(long userId, long groupId) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, KBArticle.class.getName(), groupId);
    }

    public void unsubscribeKBArticle(long userId, long resourcePrimKey) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, KBArticle.class.getName(), resourcePrimKey);
    }

    public KBArticle updateKBArticle(long userId, long resourcePrimKey, String title, String content, String description, String sourceURL, String[] sections, String[] selectedFileNames, long[] removeFileEntryIds, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(title, content, sourceURL);
        KBArticle oldKBArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        int oldVersion = oldKBArticle.getVersion();
        KBArticle kbArticle = null;
        if (oldKBArticle.isApproved()) {
            long kbArticleId = this.counterLocalService.increment();
            kbArticle = this.kbArticlePersistence.create(kbArticleId);
            kbArticle.setUuid(serviceContext.getUuid());
            kbArticle.setResourcePrimKey(oldKBArticle.getResourcePrimKey());
            kbArticle.setGroupId(oldKBArticle.getGroupId());
            kbArticle.setCompanyId(user.getCompanyId());
            kbArticle.setUserId(user.getUserId());
            kbArticle.setUserName(user.getFullName());
            kbArticle.setCreateDate(oldKBArticle.getCreateDate());
            kbArticle.setRootResourcePrimKey(oldKBArticle.getRootResourcePrimKey());
            kbArticle.setParentResourceClassNameId(oldKBArticle.getParentResourceClassNameId());
            kbArticle.setParentResourcePrimKey(oldKBArticle.getParentResourcePrimKey());
            kbArticle.setKbFolderId(oldKBArticle.getKbFolderId());
            kbArticle.setVersion(oldVersion + 1);
            kbArticle.setUrlTitle(oldKBArticle.getUrlTitle());
            kbArticle.setPriority(oldKBArticle.getPriority());
            kbArticle.setViewCount(oldKBArticle.getViewCount());
        } else {
            kbArticle = oldKBArticle;
        }
        if (oldKBArticle.isPending()) {
            kbArticle.setStatus(1);
        } else {
            kbArticle.setStatus(2);
        }
        kbArticle.setModifiedDate(serviceContext.getModifiedDate(null));
        kbArticle.setTitle(title);
        kbArticle.setContent(content);
        kbArticle.setDescription(description);
        kbArticle.setSections(StringUtil.merge((Object[])this.adminHelper.escapeSections(sections)));
        kbArticle.setLatest(true);
        kbArticle.setMain(false);
        kbArticle.setSourceURL(sourceURL);
        kbArticle.setExpandoBridgeAttributes(serviceContext);
        this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (oldKBArticle.isApproved()) {
            oldKBArticle.setLatest(false);
            this.kbArticlePersistence.update((BaseModel)oldKBArticle);
        }
        this.updateKBArticleAsset(userId, kbArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.addKBArticleAttachments(userId, kbArticle, selectedFileNames);
        this.removeKBArticleAttachments(removeFileEntryIds);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)kbArticle.getGroupId(), (long)userId, (String)KBArticle.class.getName(), (long)resourcePrimKey, (Object)kbArticle, (ServiceContext)serviceContext);
        return kbArticle;
    }

    public void updateKBArticleAsset(long userId, KBArticle kbArticle, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        long classTypeId = 0L;
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, kbArticle.getGroupId(), kbArticle.getCreateDate(), kbArticle.getModifiedDate(), KBArticle.class.getName(), kbArticle.getClassPK(), kbArticle.getUuid(), classTypeId, assetCategoryIds, assetTagNames, true, false, null, null, null, null, "text/html", kbArticle.getTitle(), kbArticle.getDescription(), null, null, null, 0, 0, null);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public void updateKBArticleResources(KBArticle kbArticle, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.updateResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void updateKBArticlesPriorities(Map<Long, Double> resourcePrimKeyToPriorityMap) throws PortalException {
        for (double priority : resourcePrimKeyToPriorityMap.values()) {
            this.validate(priority);
        }
        long[] resourcePrimKeys = StringUtil.split((String)StringUtil.merge(resourcePrimKeyToPriorityMap.keySet()), (long)0L);
        List<KBArticle> kbArticles = this.getKBArticles(resourcePrimKeys, -1, null);
        for (KBArticle kbArticle : kbArticles) {
            double priority = resourcePrimKeyToPriorityMap.get(kbArticle.getResourcePrimKey());
            this.updatePriority(kbArticle.getResourcePrimKey(), priority);
        }
    }

    public void updatePriority(long resourcePrimKey, double priority) {
        List<KBArticle> kbArticleVersions = this.getKBArticleVersions(resourcePrimKey, -1, -1, -1, null);
        for (KBArticle kbArticle : kbArticleVersions) {
            kbArticle.setPriority(priority);
            this.kbArticlePersistence.update((BaseModel)kbArticle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        boolean main = false;
        Date now = new Date();
        if (status == 0) {
            main = true;
        }
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        this.validateParentStatus(kbArticle.getParentResourceClassNameId(), kbArticle.getParentResourcePrimKey(), status);
        kbArticle.setModifiedDate(serviceContext.getModifiedDate(now));
        kbArticle.setMain(main);
        kbArticle.setStatus(status);
        kbArticle.setStatusByUserId(user.getUserId());
        kbArticle.setStatusByUserName(user.getFullName());
        kbArticle.setStatusDate(serviceContext.getModifiedDate(now));
        this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (status != 0) {
            return kbArticle;
        }
        if (!kbArticle.isFirstVersion()) {
            KBArticle oldKBArticle = this.kbArticlePersistence.findByR_V(resourcePrimKey, kbArticle.getVersion() - 1);
            oldKBArticle.setMain(false);
            this.kbArticlePersistence.update((BaseModel)oldKBArticle);
        }
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
        List assetLinks = this.assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), 0);
        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        this.updateKBArticleAsset(userId, kbArticle, assetEntry.getCategoryIds(), assetEntry.getTagNames(), assetLinkEntryIds);
        SystemEventHierarchyEntryThreadLocal.push(KBArticle.class);
        try {
            this.assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(KBArticle.class);
        }
        this.assetEntryLocalService.updateVisible(KBArticle.class.getName(), kbArticle.getResourcePrimKey(), true);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)kbArticle.getTitle());
        if (!kbArticle.isFirstVersion()) {
            this.socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 3, extraDataJSONObject.toString(), 0L);
        } else {
            this.socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 1, extraDataJSONObject.toString(), 0L);
        }
        Indexer indexer = this.indexerRegistry.getIndexer(KBArticle.class);
        indexer.reindex((Object)kbArticle);
        this.notifySubscribers(userId, kbArticle, serviceContext);
        return kbArticle;
    }

    public void updateViewCount(long userId, long resourcePrimKey, int viewCount) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        kbArticle.setModifiedDate(kbArticle.getModifiedDate());
        kbArticle.setViewCount(viewCount);
        this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (kbArticle.isApproved() || kbArticle.isFirstVersion()) {
            return;
        }
        kbArticle = this.getLatestKBArticle(resourcePrimKey, 0);
        kbArticle.setModifiedDate(kbArticle.getModifiedDate());
        kbArticle.setViewCount(viewCount);
        this.kbArticlePersistence.update((BaseModel)kbArticle);
    }

    protected void addKBArticleAttachment(long userId, long groupId, long resourcePrimKey, String selectedFileName) throws PortalException {
        FileEntry tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)"com.liferay.knowledge.base.admin", (String)selectedFileName);
        InputStream inputStream = tempFileEntry.getContentStream();
        String mimeType = tempFileEntry.getMimeType();
        this.addAttachment(userId, resourcePrimKey, selectedFileName, inputStream, mimeType);
        if (tempFileEntry != null) {
            TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
        }
    }

    protected void addKBArticleAttachments(long userId, KBArticle kbArticle, String[] selectedFileNames) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])selectedFileNames)) {
            return;
        }
        for (String selectedFileName : selectedFileNames) {
            this.addKBArticleAttachment(userId, kbArticle.getGroupId(), kbArticle.getResourcePrimKey(), selectedFileName);
        }
    }

    protected DynamicQuery buildDynamicQuery(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator) {
        Property property;
        Object junction = null;
        junction = andOperator ? RestrictionsFactoryUtil.conjunction() : RestrictionsFactoryUtil.disjunction();
        HashMap<String, String> terms = new HashMap<String, String>();
        if (Validator.isNotNull((String)title)) {
            terms.put("title", title);
        }
        if (Validator.isNotNull((String)content)) {
            terms.put("content", content);
        }
        for (Map.Entry entry : terms.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String keyword : KnowledgeBaseUtil.splitKeywords((String)value)) {
                Criterion criterion = RestrictionsFactoryUtil.ilike((String)key, (Object)StringUtil.quote((String)keyword, (String)"%"));
                disjunction.add(criterion);
            }
            junction.add((Criterion)disjunction);
        }
        if (status != -1) {
            Property property2 = PropertyFactoryUtil.forName((String)"status");
            junction.add(property2.eq((Object)status));
        }
        if (endDate != null && startDate != null) {
            String[] propertyNames;
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String propertyName : propertyNames = new String[]{"createDate", "modifiedDate"}) {
                Property property3 = PropertyFactoryUtil.forName((String)propertyName);
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(property3.gt((Object)startDate));
                conjunction.add(property3.lt((Object)endDate));
                disjunction.add((Criterion)conjunction);
            }
            junction.add((Criterion)disjunction);
        }
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KBArticle.class, (ClassLoader)this.getClassLoader());
        if (status == -1) {
            property = PropertyFactoryUtil.forName((String)"latest");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        } else if (status == 0) {
            property = PropertyFactoryUtil.forName((String)"main");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        }
        if (groupId > 0L) {
            property = PropertyFactoryUtil.forName((String)"groupId");
            dynamicQuery.add(property.eq((Object)groupId));
        }
        return dynamicQuery.add((Criterion)junction);
    }

    protected void deleteAssets(KBArticle kbArticle) throws PortalException {
        this.assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getClassPK());
        if (!kbArticle.isApproved() && !kbArticle.isFirstVersion()) {
            this.assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        }
    }

    protected void deleteSubscriptions(KBArticle kbArticle) throws PortalException {
        List subscriptions = this.subscriptionLocalService.getSubscriptions(kbArticle.getCompanyId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        for (Subscription subscription : subscriptions) {
            this.unsubscribeKBArticle(subscription.getUserId(), subscription.getClassPK());
        }
    }

    protected void getAllDescendantKBArticles(List<KBArticle> kbArticles, long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        List curKBArticles = null;
        curKBArticles = status == -1 ? this.kbArticlePersistence.findByP_L(resourcePrimKey, true, -1, -1, orderByComparator) : (status == 0 ? this.kbArticlePersistence.findByP_M(resourcePrimKey, true, -1, -1, orderByComparator) : this.kbArticlePersistence.findByP_S(resourcePrimKey, status, -1, -1, orderByComparator));
        for (KBArticle curKBArticle : curKBArticles) {
            kbArticles.add(curKBArticle);
            this.getAllDescendantKBArticles(kbArticles, curKBArticle.getResourcePrimKey(), status, orderByComparator);
        }
    }

    protected List<KBArticle> getAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator, boolean includeParentArticle) {
        List<Object> kbArticles = null;
        if (includeParentArticle) {
            kbArticles = this.getKBArticles(new long[]{resourcePrimKey}, status, null);
            kbArticles = ListUtil.copy(kbArticles);
        } else {
            kbArticles = new ArrayList<KBArticle>();
        }
        this.getAllDescendantKBArticles(kbArticles, resourcePrimKey, status, orderByComparator);
        return Collections.unmodifiableList(kbArticles);
    }

    protected Map<String, String> getEmailKBArticleDiffs(KBArticle kbArticle) {
        HashMap<String, String> emailKBArticleDiffs = new HashMap<String, String>();
        for (String param : new String[]{"content", "title"}) {
            String value = BeanPropertiesUtil.getString((Object)kbArticle, (String)param);
            try {
                value = this.adminHelper.getKBArticleDiff(kbArticle.getResourcePrimKey(), kbArticle.getVersion() - 1, kbArticle.getVersion(), param);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            emailKBArticleDiffs.put(param, value);
        }
        return emailKBArticleDiffs;
    }

    protected KBGroupServiceConfiguration getKBGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (KBGroupServiceConfiguration)this.configurationProvider.getConfiguration(KBGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.knowledge.base"));
    }

    protected double getPriority(long groupId, long parentResourcePrimKey) throws PortalException {
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this.getKBGroupServiceConfiguration(groupId);
        if (!kbGroupServiceConfiguration.articleIncrementPriorityEnabled()) {
            return 1.0;
        }
        List<KBArticle> kbArticles = this.getKBArticles(groupId, parentResourcePrimKey, -1, 0, 1, (OrderByComparator<KBArticle>)new KBArticlePriorityComparator());
        if (kbArticles.isEmpty()) {
            return 1.0;
        }
        KBArticle kbArticle = kbArticles.get(0);
        return Math.floor(kbArticle.getPriority()) + 1.0;
    }

    protected long getRootResourcePrimKey(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        if (parentResourcePrimKey == 0L) {
            return resourcePrimKey;
        }
        long classNameId = this.classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (parentResourceClassNameId == classNameId) {
            KBArticle kbArticle = this.getLatestKBArticle(parentResourcePrimKey, -1);
            return kbArticle.getRootResourcePrimKey();
        }
        return resourcePrimKey;
    }

    protected Date getTicketExpirationDate() {
        return new Date(System.currentTimeMillis() + 3600000L);
    }

    protected String getUniqueUrlTitle(long groupId, long kbFolderId, long kbArticleId, String title) throws PortalException {
        String urlTitle;
        String uniqueUrlTitle = urlTitle = KnowledgeBaseUtil.getUrlTitle((long)kbArticleId, (String)title);
        if (kbFolderId == 0L) {
            int kbArticlesCount = this.kbArticlePersistence.countByG_KBFI_UT_ST(groupId, kbFolderId, uniqueUrlTitle, _STATUSES);
            int i = 1;
            while (kbArticlesCount > 0) {
                uniqueUrlTitle = this.getUniqueUrlTitle(urlTitle, i);
                kbArticlesCount = this.kbArticlePersistence.countByG_KBFI_UT_ST(groupId, kbFolderId, uniqueUrlTitle, _STATUSES);
                ++i;
            }
            return uniqueUrlTitle;
        }
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        int kbArticlesCount = this.kbArticleFinder.countByUrlTitle(groupId, kbFolder.getUrlTitle(), uniqueUrlTitle, _STATUSES);
        int i = 1;
        while (kbArticlesCount > 0) {
            uniqueUrlTitle = this.getUniqueUrlTitle(urlTitle, i);
            kbArticlesCount = this.kbArticleFinder.countByUrlTitle(groupId, kbFolder.getUrlTitle(), uniqueUrlTitle, _STATUSES);
            ++i;
        }
        return uniqueUrlTitle;
    }

    protected String getUniqueUrlTitle(long groupId, long kbFolderId, long kbArticleId, String title, String urlTitle) throws PortalException {
        if (Validator.isNull((String)urlTitle)) {
            return this.getUniqueUrlTitle(groupId, kbFolderId, kbArticleId, title);
        }
        return urlTitle.substring(1);
    }

    protected String getUniqueUrlTitle(String urlTitle, int suffix) {
        String uniqueUrlTitle = urlTitle + "-" + suffix;
        int maxLength = ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle");
        return StringUtil.shorten((String)uniqueUrlTitle, (int)maxLength, (String)("-" + suffix));
    }

    protected boolean isValidFileName(String name) {
        return name != null && !name.contains("\\") && !name.contains("/");
    }

    protected String normalizeUrlTitle(String urlTitle) {
        if (Validator.isNull((String)urlTitle)) {
            return null;
        }
        if (StringUtil.startsWith((String)urlTitle, (char)'/')) {
            return urlTitle;
        }
        return "/" + urlTitle;
    }

    protected void notifySubscribers(long userId, KBArticle kbArticle, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)serviceContext.getLayoutFullURL())) {
            return;
        }
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this.getKBGroupServiceConfiguration(kbArticle.getGroupId());
        if (serviceContext.isCommandAdd() && !kbGroupServiceConfiguration.emailKBArticleAddedEnabled()) {
            return;
        }
        if (serviceContext.isCommandUpdate() && !kbGroupServiceConfiguration.emailKBArticleUpdatedEnabled()) {
            return;
        }
        String fromName = kbGroupServiceConfiguration.emailFromName();
        String fromAddress = kbGroupServiceConfiguration.emailFromAddress();
        String kbArticleContent = StringUtil.replace((String)kbArticle.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
        Map<String, String> kbArticleDiffs = this.getEmailKBArticleDiffs(kbArticle);
        for (Map.Entry<String, String> entry : kbArticleDiffs.entrySet()) {
            String value = StringUtil.replace((String)entry.getValue(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
            kbArticleDiffs.put(entry.getKey(), value);
        }
        String subject = null;
        String body = null;
        if (serviceContext.isCommandAdd()) {
            subject = kbGroupServiceConfiguration.emailKBArticleAddedSubject();
            body = kbGroupServiceConfiguration.emailKBArticleAddedBody();
        } else {
            subject = kbGroupServiceConfiguration.emailKBArticleUpdatedSubject();
            body = kbGroupServiceConfiguration.emailKBArticleUpdatedBody();
        }
        SubscriptionSender subscriptionSender = AdminSubscriptionSenderFactory.createSubscriptionSender(kbArticle, serviceContext);
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(kbArticle.getCompanyId());
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)kbArticleContent, false);
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT_DIFF$]", (Object)kbArticleDiffs.get("content"), false);
        subscriptionSender.setContextAttribute("[$ARTICLE_TITLE$]", (Object)kbArticle.getTitle(), false);
        subscriptionSender.setContextAttribute("[$ARTICLE_TITLE_DIFF$]", (Object)kbArticleDiffs.get("title"), false);
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(kbArticle.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("kb_article", new Object[]{kbArticle.getKbArticleId()});
        subscriptionSender.setPortletId(serviceContext.getPortletId());
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(kbArticle.getGroupId());
        subscriptionSender.setSubject(subject);
        subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getGroupId());
        subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        while (!kbArticle.isRoot() && kbArticle.getClassNameId() == kbArticle.getParentResourceClassNameId()) {
            kbArticle = this.getLatestKBArticle(kbArticle.getParentResourcePrimKey(), 0);
            subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        }
        subscriptionSender.flushNotificationsAsync();
    }

    protected void removeKBArticleAttachments(long[] removeFileEntryIds) throws PortalException {
        if (ArrayUtil.isEmpty((long[])removeFileEntryIds)) {
            return;
        }
        for (long removeFileEntryId : removeFileEntryIds) {
            this.portletFileRepository.deletePortletFileEntry(removeFileEntryId);
        }
    }

    protected void updatePermissionFields(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        if (kbArticle.getParentResourcePrimKey() == parentResourcePrimKey) {
            return;
        }
        long rootResourcePrimKey = this.getRootResourcePrimKey(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        if (kbArticle.getRootResourcePrimKey() == rootResourcePrimKey) {
            return;
        }
        List<KBArticle> kbArticles1 = this.getKBArticleAndAllDescendantKBArticles(resourcePrimKey, -1, null);
        for (KBArticle kbArticle1 : kbArticles1) {
            List<KBArticle> kbArticles2 = this.getKBArticleVersions(kbArticle1.getResourcePrimKey(), -1, -1, -1, null);
            for (KBArticle kbArticle2 : kbArticles2) {
                kbArticle2.setRootResourcePrimKey(rootResourcePrimKey);
                this.kbArticlePersistence.update((BaseModel)kbArticle2);
            }
        }
        this.indexWriterHelper.updatePermissionFields(KBArticle.class.getName(), String.valueOf(resourcePrimKey));
    }

    protected void validate(double priority) throws PortalException {
        if (priority <= 0.0) {
            throw new KBArticlePriorityException("Invalid priority " + priority);
        }
    }

    protected void validate(String title, String content, String sourceURL) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new KBArticleTitleException("Title is null");
        }
        if (Validator.isNull((String)content)) {
            throw new KBArticleContentException("Content is null");
        }
        this.validateSourceURL(sourceURL);
    }

    protected void validateParent(KBArticle kbArticle, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle parentKBArticle;
        List ancestorResourcePrimaryKeys;
        this.validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbArticleClassNameId = this.classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (parentResourceClassNameId == kbArticleClassNameId && (ancestorResourcePrimaryKeys = (parentKBArticle = this.getLatestKBArticle(parentResourcePrimKey, -1)).getAncestorResourcePrimaryKeys()).contains(kbArticle.getResourcePrimKey())) {
            throw new KBArticleParentException(String.format("Cannot move KBArticle %s inside its descendant KBArticle %s", kbArticle.getResourcePrimKey(), parentKBArticle.getResourcePrimKey()));
        }
    }

    protected void validateParent(long resourceClassNameId, long resourcePrimKey) throws PortalException {
        long kbArticleClassNameId = this.classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        long kbFolderClassNameId = this.classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        if (resourceClassNameId != kbArticleClassNameId && resourceClassNameId != kbFolderClassNameId) {
            throw new KBArticleParentException(String.format("Invalid parent with resource class name ID %s and resource primary key %s", resourceClassNameId, resourcePrimKey));
        }
    }

    protected void validateParentStatus(long parentResourceClassNameId, long parentResourcePrimKey, int status) throws PortalException {
        long kbFolderClassNameId = this.classNameLocalService.getClassNameId(KBFolder.class);
        if (parentResourceClassNameId == kbFolderClassNameId) {
            return;
        }
        KBArticle kbArticle = this.fetchLatestKBArticle(parentResourcePrimKey, 0);
        if (kbArticle == null && status == 0) {
            throw new KBArticleStatusException();
        }
    }

    protected void validateSourceURL(String sourceURL) throws PortalException {
        if (Validator.isNull((String)sourceURL)) {
            return;
        }
        if (!Validator.isUrl((String)sourceURL)) {
            throw new KBArticleSourceURLException(sourceURL);
        }
    }

    protected void validateUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        if (Validator.isNull((String)urlTitle)) {
            return;
        }
        if (!KnowledgeBaseUtil.isValidUrlTitle((String)urlTitle)) {
            throw new KBArticleUrlTitleException.MustNotContainInvalidCharacters(urlTitle);
        }
        int urlTitleMaxSize = ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle");
        if (urlTitle.length() > urlTitleMaxSize + 1) {
            throw new KBArticleUrlTitleException.MustNotExceedMaximumSize(urlTitle, urlTitleMaxSize);
        }
        List kbArticles = this.kbArticlePersistence.findByG_KBFI_UT(groupId, kbFolderId, urlTitle.substring(1));
        if (!kbArticles.isEmpty()) {
            throw new KBArticleUrlTitleException.MustNotBeDuplicate(urlTitle);
        }
    }
}

