/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class KBArticleIndexer
extends BaseIndexer<KBArticle> {
    public static final String CLASS_NAME = KBArticle.class.getName();
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected KBArticleLocalService kbArticleLocalService;
    @Reference
    protected KBFolderLocalService kbFolderLocalService;
    private static final Log _log = LogFactoryUtil.getLog(KBArticleIndexer.class);
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;

    public KBArticleIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "content", "createDate", "description", "entryClassName", "entryClassPK", "modified", "title", "uid", "userName"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws PortalException {
        return this._kbArticleModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "content", true);
        this.addSearchTerm(searchQuery, searchContext, "description", true);
        this.addSearchTerm(searchQuery, searchContext, "title", true);
        this.addSearchTerm(searchQuery, searchContext, "userName", true);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        Hits hits = super.search(searchContext);
        String[] queryTerms = (String[])ArrayUtil.append((Object[])GetterUtil.getStringValues((String[])hits.getQueryTerms()), (Object[])KnowledgeBaseUtil.splitKeywords((String)searchContext.getKeywords()));
        hits.setQueryTerms(queryTerms);
        return hits;
    }

    protected void doDelete(KBArticle kbArticle) throws Exception {
        this.deleteDocument(kbArticle.getCompanyId(), kbArticle.getResourcePrimKey());
    }

    protected Document doGetDocument(KBArticle kbArticle) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)kbArticle);
        document.addText("content", HtmlUtil.extractText((String)kbArticle.getContent()));
        document.addText("description", kbArticle.getDescription());
        document.addKeyword("folderId", kbArticle.getKbFolderId());
        document.addText("title", kbArticle.getTitle());
        document.addKeyword("folderNames", this.getKBFolderNames(kbArticle));
        document.addKeyword("parentMessageId", kbArticle.getParentResourcePrimKey());
        document.addKeyword("titleKeyword", kbArticle.getTitle(), true);
        document.addKeywordSortable("urlTitle", kbArticle.getUrlTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String prefix = "snippet_";
        String title = document.get(prefix + "title", "title");
        String content = snippet;
        if (Validator.isNull((String)snippet) && Validator.isNull((String)(content = document.get(prefix + "description", "description")))) {
            content = document.get(prefix + "content", "content");
        }
        Summary summary = new Summary(title, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(KBArticle kbArticle) throws Exception {
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), kbArticle.getCompanyId(), this.getDocument(kbArticle), this.isCommitImmediately());
        this.reindexAttachments(kbArticle);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(classPK, -1);
        this.reindexKBArticles(kbArticle);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexKBArticles(companyId);
    }

    protected String[] getKBFolderNames(KBArticle kbArticle) throws PortalException {
        long kbFolderId = kbArticle.getKbFolderId();
        ArrayList<String> kbFolderNames = new ArrayList<String>();
        while (kbFolderId != 0L) {
            KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(kbFolderId);
            kbFolderNames.add(kbFolder.getName());
            kbFolderId = kbFolder.getParentKBFolderId();
        }
        return kbFolderNames.toArray(new String[0]);
    }

    protected void reindexAttachments(KBArticle kbArticle) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        for (FileEntry attachmentsFileEntry : kbArticle.getAttachmentsFileEntries()) {
            indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
        }
    }

    protected void reindexKBArticles(KBArticle kbArticle) throws Exception {
        List kbArticles = this.kbArticleLocalService.getKBArticleAndAllDescendantKBArticles(kbArticle.getResourcePrimKey(), 0, null);
        ArrayList<Document> documents = new ArrayList<Document>();
        for (KBArticle curKBArticle : kbArticles) {
            documents.add(this.getDocument(curKBArticle));
        }
        this.indexWriterHelper.updateDocuments(this.getSearchEngineId(), kbArticle.getCompanyId(), documents, this.isCommitImmediately());
    }

    protected void reindexKBArticles(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.kbArticleLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(property.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(kbArticle -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(kbArticle)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index knowledge base article " + kbArticle.getKbArticleId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

