/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0.util;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;

public class KBArticleAttachmentsUtil {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleAttachmentsUtil.class);

    public static void deleteAttachmentsDirectory(long companyId) {
        try {
            String[] fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"knowledgebase/articles");
            if (fileNames.length > 0) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to delete knowledgebase/articles");
                }
                return;
            }
            DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)"knowledgebase/articles");
        }
        catch (Exception exception) {
            _log.error((Object)exception.getMessage());
        }
    }

    public static void updateAttachments(KBArticle kbArticle) {
        try {
            long folderId = kbArticle.getClassPK();
            String oldDirName = "knowledgebase/articles/" + folderId;
            String newDirName = "knowledgebase/kbarticles/" + folderId;
            String[] fileNames = DLStoreUtil.getFileNames((long)kbArticle.getCompanyId(), (long)0L, (String)oldDirName);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(kbArticle.getCompanyId());
            serviceContext.setScopeGroupId(kbArticle.getGroupId());
            for (String fileName : fileNames) {
                String shortFileName = FileUtil.getShortFileName((String)fileName);
                byte[] bytes = DLStoreUtil.getFileAsBytes((long)kbArticle.getCompanyId(), (long)0L, (String)fileName);
                DLStoreUtil.addFile((long)kbArticle.getCompanyId(), (long)0L, (String)(newDirName + "/" + shortFileName), (byte[])bytes);
            }
            DLStoreUtil.deleteDirectory((long)kbArticle.getCompanyId(), (long)0L, (String)oldDirName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Added attachments for " + folderId));
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception.getMessage());
        }
    }
}

