/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.util;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Reader;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;

public class KBArticleDiffUtil {
    public static String getKBArticleDiff(UnsafeFunction<Integer, KBArticle, Exception> versionToKBArticleUnsafeFunction, int sourceVersion, int targetVersion, String param) throws Exception {
        if (sourceVersion < 1) {
            sourceVersion = 1;
        }
        if (sourceVersion == targetVersion) {
            KBArticle kbArticle = (KBArticle)versionToKBArticleUnsafeFunction.apply((Object)targetVersion);
            return BeanPropertiesUtil.getString((Object)kbArticle, (String)param);
        }
        KBArticle sourceKBArticle = (KBArticle)versionToKBArticleUnsafeFunction.apply((Object)sourceVersion);
        KBArticle targetKBArticle = (KBArticle)versionToKBArticleUnsafeFunction.apply((Object)targetVersion);
        String sourceHtml = BeanPropertiesUtil.getString((Object)sourceKBArticle, (String)param);
        String targetHtml = BeanPropertiesUtil.getString((Object)targetKBArticle, (String)param);
        String diff = DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceHtml), (Reader)new UnsyncStringReader(targetHtml));
        Source source = new Source((CharSequence)diff);
        OutputDocument outputDocument = new OutputDocument(source);
        for (Element element : source.getAllElements()) {
            Attribute classAttribute;
            Attributes attributes = element.getAttributes();
            if (attributes == null) continue;
            StringBundler sb = new StringBundler(4);
            Attribute changeTypeAttribute = attributes.get("changeType");
            if (changeTypeAttribute != null) {
                String changeTypeValue = changeTypeAttribute.getValue();
                if (changeTypeValue.contains("diff-added-image")) {
                    sb.append("border: 10px solid #CFC; ");
                } else if (changeTypeValue.contains("diff-changed-image")) {
                    sb.append("border: 10px solid #C6C6FD; ");
                } else if (changeTypeValue.contains("diff-removed-image")) {
                    sb.append("border: 10px solid #FDC6C6; ");
                }
            }
            if ((classAttribute = attributes.get("class")) != null) {
                String classValue = classAttribute.getValue();
                if (classValue.contains("diff-html-added")) {
                    sb.append("background-color: #CFC; ");
                } else if (classValue.contains("diff-html-changed")) {
                    sb.append("background-color: #C6C6FD; ");
                } else if (classValue.contains("diff-html-removed")) {
                    sb.append("background-color: #FDC6C6; text-decoration: ");
                    sb.append("line-through; ");
                }
            }
            if (Validator.isNull((String)sb.toString())) continue;
            Attribute styleAttribute = attributes.get("style");
            if (styleAttribute != null) {
                sb.append(GetterUtil.getString((String)styleAttribute.getValue()));
            }
            Map map = outputDocument.replace(attributes, false);
            map.put("style", sb.toString());
        }
        return outputDocument.toString();
    }

    private KBArticleDiffUtil() {
    }
}

