/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBTemplateLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class KBTemplateStagedModelDataHandler
extends BaseStagedModelDataHandler<KBTemplate> {
    public static final String[] CLASS_NAMES = new String[]{KBTemplate.class.getName()};
    @Reference
    private KBTemplateLocalService _kbTemplateLocalService;

    public void deleteStagedModel(KBTemplate kbTemplate) throws PortalException {
        this._kbTemplateLocalService.deleteKBTemplate(kbTemplate);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        KBTemplate kbTemplate = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (kbTemplate != null) {
            this.deleteStagedModel(kbTemplate);
        }
    }

    public KBTemplate fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._kbTemplateLocalService.fetchKBTemplateByUuidAndGroupId(uuid, groupId);
    }

    public List<KBTemplate> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._kbTemplateLocalService.getKBTemplatesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(KBTemplate kbTemplate) {
        return kbTemplate.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, KBTemplate kbTemplate) throws Exception {
        Element kbTemplateElement = portletDataContext.getExportDataElement((ClassedModel)kbTemplate);
        portletDataContext.addClassedModel(kbTemplateElement, ExportImportPathUtil.getModelPath((StagedModel)kbTemplate), (ClassedModel)kbTemplate);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, KBTemplate kbTemplate) throws Exception {
        long userId = portletDataContext.getUserId(kbTemplate.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)kbTemplate);
        KBTemplate importedKBTemplate = null;
        if (portletDataContext.isDataStrategyMirror()) {
            KBTemplate existingKBTemplate = this.fetchStagedModelByUuidAndGroupId(kbTemplate.getUuid(), portletDataContext.getScopeGroupId());
            if (existingKBTemplate == null) {
                serviceContext.setUuid(kbTemplate.getUuid());
                importedKBTemplate = this._kbTemplateLocalService.addKBTemplate(userId, kbTemplate.getTitle(), kbTemplate.getContent(), serviceContext);
            } else {
                importedKBTemplate = this._kbTemplateLocalService.updateKBTemplate(existingKBTemplate.getKbTemplateId(), kbTemplate.getTitle(), kbTemplate.getContent(), serviceContext);
            }
        } else {
            importedKBTemplate = this._kbTemplateLocalService.addKBTemplate(userId, kbTemplate.getTitle(), kbTemplate.getContent(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)kbTemplate, (ClassedModel)importedKBTemplate);
    }
}

