/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0;

import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBTemplateTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class KBTemplateUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(KBTemplateUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this.renameAndUpdateTable(StringUtil.replaceFirst((String)"KBTemplate", (String)"KB", (String)"KB_"), "KBTemplate", KBTemplateTable.TABLE_COLUMNS, "create table KBTemplate (uuid_ VARCHAR(75) null,kbTemplateId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,title STRING null,content TEXT null,engineType INTEGER,cacheable BOOLEAN)", "drop table KBTemplate");
    }

    protected void renameAndUpdateTable(String oldTableName, String newTableName, Object[][] tableColumns, String tableSqlCreate, String tableSqlDrop) throws Exception {
        if (this.hasRows(newTableName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", newTableName, " has data"}));
            }
            return;
        }
        if (!this.hasRows(oldTableName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", oldTableName, " has no data"}));
            }
            return;
        }
        this.updateSchema(oldTableName, newTableName, tableSqlDrop);
        this.renameTable(oldTableName, tableColumns, tableSqlCreate);
    }

    protected void renameTable(String oldTableName, Object[][] tableColumns, String tableSqlCreate) throws Exception {
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)oldTableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
        upgradeTable.setCreateSQL(tableSqlCreate);
        upgradeTable.updateTable();
    }

    protected void updateColumn(String tableName, String columnName, String dataType, String data) throws Exception {
        if (this.hasColumn(tableName, columnName)) {
            return;
        }
        String dataTypeUpperCase = StringUtil.toUpperCase((String)dataType);
        if (dataTypeUpperCase.equals("DATE") || dataType.equals("STRING")) {
            dataTypeUpperCase = dataTypeUpperCase.concat(" null");
        }
        this.alterTableAddColumn(tableName, columnName, dataTypeUpperCase);
        this.runSQL(StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = ", data}));
    }

    protected void updateSchema(String oldTableName, String newTableName, String tableSqlDrop) throws Exception {
        if (this.hasTable(newTableName)) {
            this.runSQL(tableSqlDrop);
        }
        this.updateColumn(oldTableName, "kbTemplateId", "LONG", "templateId");
        this.updateColumn(oldTableName, "engineType", "INTEGER", "0");
        this.updateColumn(oldTableName, "cacheable", "BOOLEAN", "TRUE");
        this.alterTableDropColumn(oldTableName, "templateId");
        this.alterTableDropColumn(oldTableName, "description");
    }
}

