/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.util;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.SubscriptionSender;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public class AdminSubscriptionSender
extends SubscriptionSender {
    private final KBArticle _kbArticle;
    private final ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    private final ServiceContext _serviceContext;

    public AdminSubscriptionSender(KBArticle kbArticle, ModelResourcePermission<KBArticle> kbArticleModelResourcePermission, ServiceContext serviceContext) {
        this._kbArticle = kbArticle;
        this._kbArticleModelResourcePermission = kbArticleModelResourcePermission;
        this._serviceContext = serviceContext;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.setContextAttribute("[$ARTICLE_TITLE$]", this._kbArticle.getTitle());
        this.setContextAttribute("[$ARTICLE_URL$]", KnowledgeBaseUtil.getKBArticleURL((long)this._serviceContext.getPlid(), (long)this._kbArticle.getResourcePrimKey(), (int)this._kbArticle.getStatus(), (String)this._serviceContext.getPortalURL(), (boolean)false));
        this.setLocalizedContextAttributeWithFunction("[$ARTICLE_ATTACHMENTS$]", this._getEmailKBArticleAttachmentsFunction());
        this.setLocalizedContextAttributeWithFunction("[$ARTICLE_VERSION$]", locale -> LanguageUtil.format((Locale)locale, (String)"version-x", (Object)String.valueOf(this._kbArticle.getVersion()), (boolean)false));
        this.setLocalizedContextAttributeWithFunction("[$CATEGORY_TITLE$]", locale -> LanguageUtil.get((Locale)locale, (String)"category.kb"));
    }

    protected void deleteSubscription(Subscription subscription) throws Exception {
        if (subscription.getClassPK() == this._kbArticle.getResourcePrimKey()) {
            KBArticleLocalServiceUtil.unsubscribeKBArticle((long)subscription.getUserId(), (long)this._kbArticle.getResourcePrimKey());
        }
        if (subscription.getClassPK() == this._kbArticle.getGroupId()) {
            KBArticleLocalServiceUtil.unsubscribeGroupKBArticles((long)subscription.getUserId(), (long)this._kbArticle.getGroupId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPermission(Subscription subscription, String inferredClassName, long inferredClassPK, User user) throws Exception {
        String name = PrincipalThreadLocal.getName();
        PermissionChecker contextPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            boolean bl = this._kbArticleModelResourcePermission.contains(permissionChecker, (ClassedModel)this._kbArticle, "VIEW");
            return bl;
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)contextPermissionChecker);
        }
    }

    private Function<Locale, String> _getEmailKBArticleAttachmentsFunction() throws Exception {
        List attachmentsFileEntries = this._kbArticle.getAttachmentsFileEntries();
        if (attachmentsFileEntries.isEmpty()) {
            return locale -> "";
        }
        return locale -> {
            StringBundler sb = new StringBundler(attachmentsFileEntries.size() * 5);
            for (FileEntry fileEntry : attachmentsFileEntries) {
                sb.append(fileEntry.getTitle());
                sb.append(" (");
                sb.append(LanguageUtil.formatStorageSize((double)fileEntry.getSize(), (Locale)locale));
                sb.append(")");
                sb.append("<br />");
            }
            return sb.toString();
        };
    }
}

