/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.diff.DiffHtml;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.DuplicateKBArticleExternalReferenceCodeException;
import com.liferay.knowledge.base.exception.KBArticleContentException;
import com.liferay.knowledge.base.exception.KBArticleExpirationDateException;
import com.liferay.knowledge.base.exception.KBArticleParentException;
import com.liferay.knowledge.base.exception.KBArticlePriorityException;
import com.liferay.knowledge.base.exception.KBArticleReviewDateException;
import com.liferay.knowledge.base.exception.KBArticleSourceURLException;
import com.liferay.knowledge.base.exception.KBArticleStatusException;
import com.liferay.knowledge.base.exception.KBArticleTitleException;
import com.liferay.knowledge.base.exception.KBArticleUrlTitleException;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.internal.helper.KBArticleLocalSiblingNavigationHelper;
import com.liferay.knowledge.base.internal.importer.KBArchiveFactory;
import com.liferay.knowledge.base.internal.importer.KBArticleImporter;
import com.liferay.knowledge.base.internal.util.AdminSubscriptionSenderFactory;
import com.liferay.knowledge.base.internal.util.KBArticleDiffUtil;
import com.liferay.knowledge.base.internal.util.KBCommentUtil;
import com.liferay.knowledge.base.internal.util.KBSectionEscapeUtil;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleTable;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.base.KBArticleLocalServiceBaseImpl;
import com.liferay.knowledge.base.service.persistence.KBCommentPersistence;
import com.liferay.knowledge.base.service.persistence.KBFolderPersistence;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleVersionComparator;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={AopService.class})
public class KBArticleLocalServiceImpl
extends KBArticleLocalServiceBaseImpl {
    private static final int[] _STATUSES = new int[]{0, 1};
    private static final Log _log = LogFactoryUtil.getLog(KBArticleLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private BeanProperties _beanProperties;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DiffHtml _diffHtml;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private KBArchiveFactory _kbArchiveFactory;
    @Reference
    private KBCommentPersistence _kbCommentPersistence;
    @Reference
    private KBFolderPersistence _kbFolderPersistence;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private ViewCountManager _viewCountManager;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public FileEntry addAttachment(long userId, long resourcePrimKey, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(resourcePrimKey, -1);
        return this._portletFileRepository.addPortletFileEntry(null, kbArticle.getGroupId(), userId, KBArticle.class.getName(), kbArticle.getClassPK(), "com.liferay.knowledge.base", kbArticle.getAttachmentsFolderId(), inputStream, fileName, mimeType, false);
    }

    public KBArticle addKBArticle(String externalReferenceCode, long userId, long parentResourceClassNameId, long parentResourcePrimKey, String title, String urlTitle, String content, String description, String[] sections, String sourceURL, Date expirationDate, Date reviewDate, String[] selectedFileNames, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        urlTitle = this._normalizeUrlTitle(urlTitle);
        double priority = this._getPriority(groupId, parentResourcePrimKey);
        long kbArticleId = this.counterLocalService.increment();
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        this._validate(expirationDate, content, reviewDate, sourceURL, title);
        this._validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderId = KnowledgeBaseUtil.getKBFolderId((long)parentResourceClassNameId, (long)parentResourcePrimKey);
        urlTitle = StringUtil.toLowerCase((String)urlTitle);
        this._validateUrlTitle(groupId, kbFolderId, urlTitle);
        long resourcePrimKey = this.counterLocalService.increment();
        long rootResourcePrimKey = this._getRootResourcePrimKey(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        KBArticle kbArticle = this.kbArticlePersistence.create(kbArticleId);
        kbArticle.setUuid(serviceContext.getUuid());
        kbArticle.setResourcePrimKey(resourcePrimKey);
        kbArticle.setGroupId(groupId);
        kbArticle.setCompanyId(user.getCompanyId());
        kbArticle.setUserId(user.getUserId());
        kbArticle.setUserName(user.getFullName());
        kbArticle.setExternalReferenceCode(externalReferenceCode);
        kbArticle.setRootResourcePrimKey(rootResourcePrimKey);
        kbArticle.setParentResourceClassNameId(parentResourceClassNameId);
        kbArticle.setParentResourcePrimKey(parentResourcePrimKey);
        kbArticle.setKbFolderId(kbFolderId);
        kbArticle.setVersion(1);
        kbArticle.setTitle(title);
        kbArticle.setUrlTitle(this._getUniqueUrlTitle(groupId, kbFolderId, kbArticleId, title, urlTitle));
        kbArticle.setContent(content);
        kbArticle.setDescription(description);
        kbArticle.setPriority(priority);
        kbArticle.setSections(StringUtil.merge((Object[])KBSectionEscapeUtil.escapeSections(sections)));
        kbArticle.setLatest(true);
        kbArticle.setMain(false);
        kbArticle.setSourceURL(sourceURL);
        kbArticle.setExpirationDate(expirationDate);
        kbArticle.setReviewDate(reviewDate);
        kbArticle.setStatus(2);
        kbArticle.setExpandoBridgeAttributes(serviceContext);
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addKBArticleResources(kbArticle, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addKBArticleResources(kbArticle, serviceContext.getModelPermissions());
        }
        this.updateKBArticleAsset(userId, kbArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this._addKBArticleAttachments(userId, kbArticle, selectedFileNames);
        this._startWorkflowInstance(userId, kbArticle, serviceContext);
        return kbArticle;
    }

    public void addKBArticleResources(KBArticle kbArticle, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addKBArticleResources(KBArticle kbArticle, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), modelPermissions);
    }

    public void addKBArticleResources(long kbArticleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        KBArticle kbArticle = this.kbArticlePersistence.findByPrimaryKey(kbArticleId);
        this.addKBArticleResources(kbArticle, addGroupPermissions, addGuestPermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addKBArticlesMarkdown(long userId, long groupId, long parentKbFolderId, String fileName, boolean prioritizeByNumericalPrefix, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            KBArticleImporter kbArticleImporter = new KBArticleImporter(this._kbArchiveFactory, this, this._portal, this._dlURLHelper);
            int n = kbArticleImporter.processZipFile(userId, groupId, parentKbFolderId, prioritizeByNumericalPrefix, inputStream, serviceContext);
            return n;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public void addTempAttachment(long groupId, long userId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException {
        TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)tempFolderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void checkKBArticles() throws PortalException {
        this._checkKBArticles(new Date());
    }

    public void deleteGroupKBArticles(long groupId) throws PortalException {
        this.deleteKBArticles(groupId, 0L);
        Group group = this._groupLocalService.getGroup(groupId);
        List subscriptions = this._subscriptionLocalService.getSubscriptions(group.getCompanyId(), KBArticle.class.getName(), groupId);
        for (Subscription subscription : subscriptions) {
            this.unsubscribeGroupKBArticles(subscription.getUserId(), groupId);
        }
    }

    @Override
    @SystemEvent(action=1, type=1)
    public KBArticle deleteKBArticle(KBArticle kbArticle) throws PortalException {
        this.deleteKBArticles(kbArticle.getGroupId(), kbArticle.getResourcePrimKey());
        this._resourceLocalService.deleteResource(kbArticle.getCompanyId(), KBArticle.class.getName(), 4, kbArticle.getResourcePrimKey());
        this.kbArticlePersistence.removeByResourcePrimKey(kbArticle.getResourcePrimKey());
        KBCommentUtil.deleteKBComments(KBArticle.class.getName(), this._classNameLocalService, kbArticle.getResourcePrimKey(), this._kbCommentPersistence);
        this._deleteAssets(kbArticle);
        this._expandoRowLocalService.deleteRows(kbArticle.getKbArticleId());
        this._ratingsStatsLocalService.deleteStats(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        this._socialActivityLocalService.deleteActivities(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
        indexer.delete((Object)kbArticle);
        this._portletFileRepository.deletePortletFolder(kbArticle.getAttachmentsFolderId());
        this._deleteSubscriptions(kbArticle);
        this._viewCountManager.deleteViewCount(kbArticle.getCompanyId(), this._classNameLocalService.getClassNameId(KBArticle.class), kbArticle.getPrimaryKey());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(kbArticle.getCompanyId(), kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        return kbArticle;
    }

    @Override
    public KBArticle deleteKBArticle(long resourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        return this.kbArticleLocalService.deleteKBArticle(kbArticle);
    }

    public void deleteKBArticles(long groupId, long parentResourcePrimKey) throws PortalException {
        List<KBArticle> childKBArticles = this.getKBArticles(groupId, parentResourcePrimKey, -1, -1, -1, null);
        for (KBArticle childKBArticle : childKBArticles) {
            this.kbArticleLocalService.deleteKBArticle(childKBArticle);
        }
    }

    public void deleteKBArticles(long[] resourcePrimKeys) throws PortalException {
        List<KBArticle> kbArticles = this.getKBArticles(resourcePrimKeys, -1, null);
        for (KBArticle kbArticle : kbArticles) {
            this.kbArticleLocalService.deleteKBArticle(kbArticle);
        }
    }

    public void deleteTempAttachment(long groupId, long userId, String fileName, String tempFolderName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)tempFolderName, (String)fileName);
    }

    public KBArticle expireKBArticle(long userId, long resourcePrimKey, ServiceContext serviceContext) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        kbArticle.setExpirationDate(new Date());
        this.kbArticleLocalService.updateKBArticle(kbArticle);
        return this.updateStatus(userId, resourcePrimKey, 3, serviceContext);
    }

    public KBArticle fetchFirstChildKBArticle(long groupId, long parentResourcePrimKey) {
        return this.kbArticlePersistence.fetchByG_P_L_First(groupId, parentResourcePrimKey, true, (OrderByComparator)new KBArticlePriorityComparator(true));
    }

    public KBArticle fetchKBArticle(long resourcePrimKey, long groupId, int version) {
        return this.kbArticlePersistence.fetchByR_G_V(resourcePrimKey, groupId, version);
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) {
        KBArticle kbArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), 0);
        if (kbArticle == null) {
            kbArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle, 1);
        }
        return kbArticle;
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, String kbFolderUrlTitle, String urlTitle) {
        List kbArticles = this.kbArticleFinder.findByUrlTitle(groupId, kbFolderUrlTitle, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), _STATUSES, 0, 1);
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)new KBArticleVersionComparator());
        }
        return this.kbArticlePersistence.fetchByR_S_First(resourcePrimKey, status, (OrderByComparator)new KBArticleVersionComparator());
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, long groupId) {
        return this.kbArticlePersistence.fetchByR_G_L_First(resourcePrimKey, groupId, true, null);
    }

    public KBArticle fetchLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode) {
        return this.kbArticlePersistence.fetchByG_ERC_Last(groupId, externalReferenceCode, (OrderByComparator)new KBArticleVersionComparator());
    }

    public KBArticle fetchLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) {
        urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)"");
        List kbArticles = null;
        KBArticleVersionComparator orderByComparator = new KBArticleVersionComparator();
        kbArticles = status == -1 ? this.kbArticlePersistence.findByG_KBFI_UT(groupId, kbFolderId, urlTitle, 0, 1, (OrderByComparator)orderByComparator) : this.kbArticlePersistence.findByG_KBFI_UT_ST(groupId, kbFolderId, urlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public List<KBArticle> getAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this._getAllDescendantKBArticles(resourcePrimKey, status, orderByComparator, false);
    }

    public List<KBArticle> getCompanyKBArticles(long companyId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByC_L(companyId, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByC_M(companyId, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getCompanyKBArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByC_L(companyId, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByC_M(companyId, true);
        }
        return this.kbArticlePersistence.countByC_S(companyId, status);
    }

    public List<KBArticle> getGroupKBArticles(long groupId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByG_L(groupId, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_M(groupId, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public int getGroupKBArticlesCount(long groupId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByG_L(groupId, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_M(groupId, true);
        }
        return this.kbArticlePersistence.countByG_S(groupId, status);
    }

    public KBArticle getKBArticle(long resourcePrimKey, int version) throws PortalException {
        return this.kbArticlePersistence.findByR_V(resourcePrimKey, version);
    }

    public List<KBArticle> getKBArticleAndAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this._getAllDescendantKBArticles(resourcePrimKey, status, orderByComparator, true);
    }

    public KBArticle getKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.fetchKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""));
        if (kbArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {groupId=", groupId, ", kbFolderId=", kbFolderId, ", urlTitle=", urlTitle, "}"}));
        }
        return kbArticle;
    }

    public KBArticle getKBArticleByUrlTitle(long groupId, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.fetchKBArticleByUrlTitle(groupId, kbFolderUrlTitle, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""));
        if (kbArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle with the key {groupId=", groupId, ", urlTitle=", urlTitle, "} found in a folder with URL title ", kbFolderUrlTitle}));
        }
        return kbArticle;
    }

    public List<KBArticle> getKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByG_P_L(groupId, parentResourcePrimKey, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_P_M(groupId, parentResourcePrimKey, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_P_S(groupId, parentResourcePrimKey, status, start, end, orderByComparator);
    }

    public List<KBArticle> getKBArticles(long[] resourcePrimKeys, int status, OrderByComparator<KBArticle> orderByComparator) {
        List kbArticles = new ArrayList();
        Long[][] params = new Long[][]{ArrayUtil.toArray((long[])resourcePrimKeys)};
        while ((params = KnowledgeBaseUtil.getParams((Long[])params[0])) != null) {
            List curKBArticles = null;
            curKBArticles = status == -1 ? this.kbArticlePersistence.findByR_L(ArrayUtil.toArray((Long[])params[1]), true) : (status == 0 ? this.kbArticlePersistence.findByR_M(ArrayUtil.toArray((Long[])params[1]), true) : this.kbArticlePersistence.findByR_S(ArrayUtil.toArray((Long[])params[1]), status));
            kbArticles.addAll(curKBArticles);
        }
        kbArticles = orderByComparator != null ? ListUtil.sort(kbArticles, orderByComparator) : KnowledgeBaseUtil.sort((long[])resourcePrimKeys, kbArticles);
        return Collections.unmodifiableList(kbArticles);
    }

    public int getKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByG_P_L(groupId, parentResourcePrimKey, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_P_M(groupId, parentResourcePrimKey, true);
        }
        return this.kbArticlePersistence.countByG_P_S(groupId, parentResourcePrimKey, status);
    }

    public List<KBArticle> getKBArticleVersions(long resourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByResourcePrimKey(resourcePrimKey, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByR_S(resourcePrimKey, status, start, end, orderByComparator);
    }

    public int getKBArticleVersionsCount(long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByResourcePrimKey(resourcePrimKey);
        }
        return this.kbArticlePersistence.countByR_S(resourcePrimKey, status);
    }

    public List<KBArticle> getKBFolderKBArticles(long groupId, long kbFolderId) {
        return this.kbArticlePersistence.findByG_KBFI_L(groupId, kbFolderId, true);
    }

    public int getKBFolderKBArticlesCount(long groupId, long kbFolderId, int status) {
        return this.kbArticlePersistence.countByG_KBFI_S(groupId, kbFolderId, status);
    }

    public KBArticle getLatestKBArticle(long resourcePrimKey, int status) throws PortalException {
        if (status == -1) {
            return this.kbArticlePersistence.findByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)new KBArticleVersionComparator());
        }
        return this.kbArticlePersistence.findByR_S_First(resourcePrimKey, status, (OrderByComparator)new KBArticleVersionComparator());
    }

    public KBArticle getLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        return this.kbArticlePersistence.findByG_ERC_First(groupId, externalReferenceCode, (OrderByComparator)new KBArticleVersionComparator());
    }

    public KBArticle getLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) throws PortalException {
        KBArticle latestKBArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), status);
        if (latestKBArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {groupId=", groupId, ", kbFolderId=", kbFolderId, ", urlTitle=", urlTitle, ", status=", status, "}"}));
        }
        return latestKBArticle;
    }

    public KBArticle[] getPreviousAndNextKBArticles(long kbArticleId) throws PortalException {
        KBArticleLocalSiblingNavigationHelper kbArticleLocalSiblingNavigationHelper = new KBArticleLocalSiblingNavigationHelper(this.kbArticlePersistence);
        return kbArticleLocalSiblingNavigationHelper.getPreviousAndNextKBArticles(kbArticleId);
    }

    public List<KBArticle> getSectionsKBArticles(long groupId, String[] sections, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        String[] array = KBSectionEscapeUtil.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.findByG_LikeS_L(groupId, array, true, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_LikeS_M(groupId, array, true, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_LikeS_S(groupId, array, status, start, end, orderByComparator);
    }

    public int getSectionsKBArticlesCount(long groupId, String[] sections, int status) {
        String[] array = KBSectionEscapeUtil.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.countByG_LikeS_L(groupId, array, true);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_LikeS_M(groupId, array, true);
        }
        return this.kbArticlePersistence.countByG_LikeS_S(groupId, array, status);
    }

    public String[] getTempAttachmentNames(long groupId, long userId, String tempFolderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)tempFolderName);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void incrementViewCount(long userId, long resourcePrimKey, int increment) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        long classNameId = this._classNameLocalService.getClassNameId(KBArticle.class);
        this._viewCountManager.incrementViewCount(kbArticle.getCompanyId(), classNameId, kbArticle.getPrimaryKey(), increment);
        if (kbArticle.isApproved() || kbArticle.isFirstVersion()) {
            return;
        }
        kbArticle = this.getLatestKBArticle(resourcePrimKey, 0);
        this._viewCountManager.incrementViewCount(kbArticle.getCompanyId(), classNameId, kbArticle.getPrimaryKey(), increment);
    }

    public void moveKBArticle(long userId, long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey, double priority) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        if (kbArticle.getResourcePrimKey() == parentResourcePrimKey) {
            return;
        }
        this._validateParent(kbArticle, parentResourceClassNameId, parentResourcePrimKey);
        this._validateParentStatus(parentResourceClassNameId, parentResourcePrimKey, kbArticle.getStatus());
        this._validate(priority);
        this._updatePermissionFields(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        long kbFolderId = 0L;
        if (parentResourceClassNameId == kbFolderClassNameId) {
            kbFolderId = parentResourcePrimKey;
        } else {
            KBArticle parentKBArticle = this.getLatestKBArticle(parentResourcePrimKey, -1);
            kbFolderId = parentKBArticle.getKbFolderId();
        }
        List<KBArticle> kbArticles = this.getKBArticleVersions(resourcePrimKey, -1, -1, -1, (OrderByComparator<KBArticle>)new KBArticleVersionComparator());
        for (KBArticle kBArticle : kbArticles) {
            kBArticle.setParentResourceClassNameId(parentResourceClassNameId);
            kBArticle.setParentResourcePrimKey(parentResourcePrimKey);
            kBArticle.setKbFolderId(kbFolderId);
            kBArticle.setPriority(priority);
            KBArticle kBArticle2 = (KBArticle)this.kbArticlePersistence.update((BaseModel)kBArticle);
            this._indexKBArticle(kBArticle2);
        }
        if (kbArticle.getKbFolderId() != kbFolderId) {
            List<KBArticle> descendantKBArticles = this.getAllDescendantKBArticles(resourcePrimKey, -1, null);
            for (KBArticle curKBArticle : descendantKBArticles) {
                List<KBArticle> kbArticleVersions = this.getKBArticleVersions(curKBArticle.getResourcePrimKey(), -1, -1, -1, (OrderByComparator<KBArticle>)new KBArticleVersionComparator());
                for (KBArticle kbArticleVersion : kbArticleVersions) {
                    kbArticleVersion.setKbFolderId(kbFolderId);
                    kbArticleVersion = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticleVersion);
                    this._indexKBArticle(kbArticleVersion);
                }
            }
        }
        KBArticle latestKBArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        JSONObject jSONObject = JSONUtil.put((String)"title", (Object)latestKBArticle.getTitle());
        if (latestKBArticle.isApproved() || !latestKBArticle.isFirstVersion()) {
            this._socialActivityLocalService.addActivity(userId, latestKBArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 7, jSONObject.toString(), 0L);
        }
        this._indexKBArticle(latestKBArticle);
    }

    public KBArticle revertKBArticle(long userId, long resourcePrimKey, int version, ServiceContext serviceContext) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getKBArticle(resourcePrimKey, version);
        ExpandoBridge expandoBridge = kbArticle.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
        return this.updateKBArticle(userId, resourcePrimKey, kbArticle.getTitle(), kbArticle.getContent(), kbArticle.getDescription(), StringUtil.split((String)kbArticle.getSections()), kbArticle.getSourceURL(), kbArticle.getExpirationDate(), kbArticle.getReviewDate(), null, null, serviceContext);
    }

    public List<KBArticle> search(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        DynamicQuery dynamicQuery = this._buildDynamicQuery(groupId, title, content, status, startDate, endDate, andOperator);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public void subscribeGroupKBArticles(long userId, long groupId) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, KBArticle.class.getName(), groupId);
    }

    public void subscribeKBArticle(long userId, long groupId, long resourcePrimKey) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, KBArticle.class.getName(), resourcePrimKey);
    }

    public void unsubscribeGroupKBArticles(long userId, long groupId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, KBArticle.class.getName(), groupId);
    }

    public void unsubscribeKBArticle(long userId, long resourcePrimKey) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, KBArticle.class.getName(), resourcePrimKey);
    }

    public KBArticle updateKBArticle(long userId, long resourcePrimKey, String title, String content, String description, String[] sections, String sourceURL, Date expirationDate, Date reviewDate, String[] selectedFileNames, long[] removeFileEntryIds, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(expirationDate, content, reviewDate, sourceURL, title);
        KBArticle oldKBArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        int oldVersion = oldKBArticle.getVersion();
        KBArticle kbArticle = null;
        if (oldKBArticle.isApproved() || oldKBArticle.isExpired()) {
            long kbArticleId = this.counterLocalService.increment();
            kbArticle = this.kbArticlePersistence.create(kbArticleId);
            kbArticle.setUuid(serviceContext.getUuid());
            kbArticle.setResourcePrimKey(oldKBArticle.getResourcePrimKey());
            kbArticle.setGroupId(oldKBArticle.getGroupId());
            kbArticle.setCompanyId(user.getCompanyId());
            kbArticle.setUserId(user.getUserId());
            kbArticle.setUserName(user.getFullName());
            kbArticle.setCreateDate(oldKBArticle.getCreateDate());
            kbArticle.setExternalReferenceCode(oldKBArticle.getExternalReferenceCode());
            kbArticle.setRootResourcePrimKey(oldKBArticle.getRootResourcePrimKey());
            kbArticle.setParentResourceClassNameId(oldKBArticle.getParentResourceClassNameId());
            kbArticle.setParentResourcePrimKey(oldKBArticle.getParentResourcePrimKey());
            kbArticle.setKbFolderId(oldKBArticle.getKbFolderId());
            kbArticle.setVersion(oldVersion + 1);
            kbArticle.setUrlTitle(oldKBArticle.getUrlTitle());
            kbArticle.setPriority(oldKBArticle.getPriority());
            this._viewCountManager.incrementViewCount(kbArticle.getCompanyId(), this._classNameLocalService.getClassNameId(KBArticle.class), kbArticle.getPrimaryKey(), (int)oldKBArticle.getViewCount());
        } else {
            kbArticle = oldKBArticle;
        }
        if (oldKBArticle.isPending()) {
            kbArticle.setStatus(1);
        } else {
            kbArticle.setStatus(2);
        }
        kbArticle.setTitle(title);
        kbArticle.setContent(content);
        kbArticle.setDescription(description);
        kbArticle.setSections(StringUtil.merge((Object[])KBSectionEscapeUtil.escapeSections(sections)));
        kbArticle.setLatest(true);
        kbArticle.setMain(false);
        kbArticle.setSourceURL(sourceURL);
        kbArticle.setExpirationDate(expirationDate);
        kbArticle.setReviewDate(reviewDate);
        kbArticle.setExpandoBridgeAttributes(serviceContext);
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (oldKBArticle.isApproved() || oldKBArticle.isExpired()) {
            oldKBArticle.setModifiedDate(oldKBArticle.getModifiedDate());
            oldKBArticle.setLatest(false);
            this.kbArticlePersistence.update((BaseModel)oldKBArticle);
        }
        this.updateKBArticleAsset(userId, kbArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this._addKBArticleAttachments(userId, kbArticle, selectedFileNames);
        this._removeKBArticleAttachments(removeFileEntryIds);
        this._startWorkflowInstance(userId, kbArticle, serviceContext);
        return kbArticle;
    }

    public void updateKBArticleAsset(long userId, KBArticle kbArticle, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        boolean visible = false;
        if (kbArticle.isApproved()) {
            visible = true;
        }
        String summary = this._htmlParser.extractText(StringUtil.shorten((String)kbArticle.getContent(), (int)500));
        AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, kbArticle.getGroupId(), kbArticle.getCreateDate(), kbArticle.getModifiedDate(), KBArticle.class.getName(), kbArticle.getClassPK(), kbArticle.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, null, kbArticle.getExpirationDate(), "text/html", kbArticle.getTitle(), kbArticle.getDescription(), summary, null, null, 0, 0, null);
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public void updateKBArticleResources(KBArticle kbArticle, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this._resourceLocalService.updateResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void updateKBArticlesPriorities(Map<Long, Double> resourcePrimKeyToPriorityMap) throws PortalException {
        for (double priority : resourcePrimKeyToPriorityMap.values()) {
            this._validate(priority);
        }
        long[] resourcePrimKeys = StringUtil.split((String)StringUtil.merge(resourcePrimKeyToPriorityMap.keySet()), (long)0L);
        List<KBArticle> kbArticles = this.getKBArticles(resourcePrimKeys, -1, null);
        for (KBArticle kbArticle : kbArticles) {
            double priority = resourcePrimKeyToPriorityMap.get(kbArticle.getResourcePrimKey());
            this.updatePriority(kbArticle.getResourcePrimKey(), priority);
        }
    }

    public void updatePriority(long resourcePrimKey, double priority) {
        List<KBArticle> kbArticleVersions = this.getKBArticleVersions(resourcePrimKey, -1, -1, -1, null);
        for (KBArticle kbArticle : kbArticleVersions) {
            kbArticle.setPriority(priority);
            this.kbArticlePersistence.update((BaseModel)kbArticle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        boolean main = false;
        Date date = new Date();
        if (status == 0) {
            main = true;
        }
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        this._validateParentStatus(kbArticle.getParentResourceClassNameId(), kbArticle.getParentResourcePrimKey(), status);
        kbArticle.setMain(main);
        kbArticle.setStatus(status);
        kbArticle.setStatusByUserId(user.getUserId());
        kbArticle.setStatusByUserName(user.getFullName());
        kbArticle.setStatusDate(serviceContext.getModifiedDate(date));
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (status != 0 && status != 3) {
            return kbArticle;
        }
        if (!kbArticle.isFirstVersion()) {
            KBArticle oldKBArticle = this.kbArticlePersistence.findByR_V(resourcePrimKey, kbArticle.getVersion() - 1);
            oldKBArticle.setModifiedDate(oldKBArticle.getModifiedDate());
            oldKBArticle.setMain(false);
            this.kbArticlePersistence.update((BaseModel)oldKBArticle);
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        if (status == 0) {
            assetEntry = this._assetEntryLocalService.getEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
        }
        List assetLinks = this._assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), 0);
        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        this.updateKBArticleAsset(userId, kbArticle, assetEntry.getCategoryIds(), assetEntry.getTagNames(), assetLinkEntryIds);
        SystemEventHierarchyEntryThreadLocal.push(KBArticle.class);
        try {
            this._assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(KBArticle.class);
        }
        boolean visible = false;
        if (kbArticle.isApproved()) {
            visible = true;
        }
        this._assetEntryLocalService.updateVisible(KBArticle.class.getName(), kbArticle.getResourcePrimKey(), visible);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)kbArticle.getTitle());
        if (!kbArticle.isFirstVersion()) {
            this._socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 3, extraDataJSONObject.toString(), 0L);
        } else {
            this._socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 1, extraDataJSONObject.toString(), 0L);
        }
        Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
        indexer.reindex((Object)kbArticle);
        this._notifySubscribers(userId, kbArticle, serviceContext);
        return kbArticle;
    }

    private void _addKBArticleAttachment(long userId, long groupId, long resourcePrimKey, String selectedFileName) throws PortalException {
        FileEntry tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)"com.liferay.knowledge.base.admin", (String)selectedFileName);
        InputStream inputStream = tempFileEntry.getContentStream();
        this.addAttachment(userId, resourcePrimKey, selectedFileName, inputStream, tempFileEntry.getMimeType());
        if (tempFileEntry != null) {
            TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
        }
    }

    private void _addKBArticleAttachments(long userId, KBArticle kbArticle, String[] selectedFileNames) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])selectedFileNames)) {
            return;
        }
        for (String selectedFileName : selectedFileNames) {
            this._addKBArticleAttachment(userId, kbArticle.getGroupId(), kbArticle.getResourcePrimKey(), selectedFileName);
        }
    }

    private DynamicQuery _buildDynamicQuery(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator) {
        Property property;
        Object junction = null;
        junction = andOperator ? RestrictionsFactoryUtil.conjunction() : RestrictionsFactoryUtil.disjunction();
        HashMap<String, String> terms = new HashMap<String, String>();
        if (Validator.isNotNull((String)title)) {
            terms.put("title", title);
        }
        if (Validator.isNotNull((String)content)) {
            terms.put("content", content);
        }
        for (Map.Entry entry : terms.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String keyword : KnowledgeBaseUtil.splitKeywords((String)value)) {
                Criterion criterion = RestrictionsFactoryUtil.ilike((String)key, (Object)StringUtil.quote((String)keyword, (String)"%"));
                disjunction.add(criterion);
            }
            junction.add((Criterion)disjunction);
        }
        if (status != -1) {
            Property property2 = PropertyFactoryUtil.forName((String)"status");
            junction.add(property2.eq((Object)status));
        }
        if (endDate != null && startDate != null) {
            String[] propertyNames;
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String propertyName : propertyNames = new String[]{"createDate", "modifiedDate"}) {
                Property property3 = PropertyFactoryUtil.forName((String)propertyName);
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(property3.gt((Object)startDate));
                conjunction.add(property3.lt((Object)endDate));
                disjunction.add((Criterion)conjunction);
            }
            junction.add((Criterion)disjunction);
        }
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KBArticle.class, (ClassLoader)this.getClassLoader());
        if (status == -1) {
            property = PropertyFactoryUtil.forName((String)"latest");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        } else if (status == 0) {
            property = PropertyFactoryUtil.forName((String)"main");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        }
        if (groupId > 0L) {
            property = PropertyFactoryUtil.forName((String)"groupId");
            dynamicQuery.add(property.eq((Object)groupId));
        }
        return dynamicQuery.add((Criterion)junction);
    }

    private void _checkKBArticles(Date expirationDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring file entries with expiration date previous to " + expirationDate));
        }
        this._companyLocalService.forEachCompanyId(companyId -> this._expireKBArticlesByCompanyId((long)companyId, expirationDate, new ServiceContext()));
    }

    private void _deleteAssets(KBArticle kbArticle) throws PortalException {
        int kbArticleVersionsCount;
        this._assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getClassPK());
        if (!(kbArticle.isApproved() || (kbArticleVersionsCount = this.kbArticleLocalService.getKBArticleVersionsCount(kbArticle.getResourcePrimKey(), -1)) != 0 && kbArticle.isFirstVersion())) {
            this._assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        }
    }

    private void _deleteSubscriptions(KBArticle kbArticle) throws PortalException {
        List subscriptions = this._subscriptionLocalService.getSubscriptions(kbArticle.getCompanyId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        for (Subscription subscription : subscriptions) {
            this.unsubscribeKBArticle(subscription.getUserId(), subscription.getClassPK());
        }
    }

    private void _expireKBArticlesByCompanyId(long companyId, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        long userId = this._userLocalService.getDefaultUserId(companyId);
        List<KBArticle> kbArticles = this._getKBArticlesByCompanyIdAndExpirationDate(companyId, expirationDate);
        for (KBArticle kbArticle : kbArticles) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expiring KB Article ", kbArticle.getKbArticleId(), " with expiration date ", kbArticle.getExpirationDate()}));
            }
            this.updateStatus(userId, kbArticle.getResourcePrimKey(), 3, serviceContext);
        }
    }

    private void _getAllDescendantKBArticles(List<KBArticle> kbArticles, long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        List curKBArticles = null;
        curKBArticles = status == -1 ? this.kbArticlePersistence.findByP_L(resourcePrimKey, true, -1, -1, orderByComparator) : (status == 0 ? this.kbArticlePersistence.findByP_M(resourcePrimKey, true, -1, -1, orderByComparator) : this.kbArticlePersistence.findByP_S(resourcePrimKey, status, -1, -1, orderByComparator));
        for (KBArticle curKBArticle : curKBArticles) {
            kbArticles.add(curKBArticle);
            this._getAllDescendantKBArticles(kbArticles, curKBArticle.getResourcePrimKey(), status, orderByComparator);
        }
    }

    private List<KBArticle> _getAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator, boolean includeParentArticle) {
        List<Object> kbArticles = null;
        if (includeParentArticle) {
            kbArticles = this.getKBArticles(new long[]{resourcePrimKey}, status, null);
            kbArticles = ListUtil.copy(kbArticles);
        } else {
            kbArticles = new ArrayList<KBArticle>();
        }
        this._getAllDescendantKBArticles(kbArticles, resourcePrimKey, status, orderByComparator);
        return Collections.unmodifiableList(kbArticles);
    }

    private Map<String, String> _getEmailKBArticleDiffs(KBArticle kbArticle) {
        HashMap<String, String> emailKBArticleDiffs = new HashMap<String, String>();
        for (String param : new String[]{"content", "title"}) {
            String value = this._beanProperties.getString((Object)kbArticle, param);
            try {
                value = KBArticleDiffUtil.getKBArticleDiff((UnsafeFunction<Integer, KBArticle, Exception>)((UnsafeFunction)version -> this.getKBArticle(kbArticle.getResourcePrimKey(), (int)version)), kbArticle.getVersion() - 1, kbArticle.getVersion(), param, this._diffHtml);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            emailKBArticleDiffs.put(param, value);
        }
        return emailKBArticleDiffs;
    }

    private String _getEntryURL(KBArticle kbArticle, ServiceContext serviceContext) {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return "";
        }
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_knowledge_base_web_portlet_AdminPortlet", "RENDER_PHASE")).setMVCRenderCommandName("/knowledge_base/view_kb_article").setParameter("resourceClassNameId", (Object)kbArticle.getClassNameId()).setParameter("resourcePrimKey", (Object)kbArticle.getResourcePrimKey()).setParameter("selectedItemId", (Object)kbArticle.getResourcePrimKey()).buildString();
    }

    private List<KBArticle> _getKBArticlesByCompanyIdAndExpirationDate(long companyId, Date expirationDate) {
        return (List)this.kbArticlePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)KBArticleTable.INSTANCE).from((Table)KBArticleTable.INSTANCE).where(KBArticleTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)KBArticleTable.INSTANCE.expirationDate.lte((Object)expirationDate)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)3))));
    }

    private KBGroupServiceConfiguration _getKBGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (KBGroupServiceConfiguration)this._configurationProvider.getConfiguration(KBGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.knowledge.base"));
    }

    private int _getNotificationType(ServiceContext serviceContext) {
        if (serviceContext.isCommandAdd()) {
            return 0;
        }
        return 1;
    }

    private double _getPriority(long groupId, long parentResourcePrimKey) throws PortalException {
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this._getKBGroupServiceConfiguration(groupId);
        if (!kbGroupServiceConfiguration.articleIncrementPriorityEnabled()) {
            return 1.0;
        }
        List<KBArticle> kbArticles = this.getKBArticles(groupId, parentResourcePrimKey, -1, 0, 1, (OrderByComparator<KBArticle>)new KBArticlePriorityComparator());
        if (kbArticles.isEmpty()) {
            return 1.0;
        }
        KBArticle kbArticle = kbArticles.get(0);
        return Math.floor(kbArticle.getPriority()) + 1.0;
    }

    private long _getRootResourcePrimKey(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        if (parentResourcePrimKey == 0L) {
            return resourcePrimKey;
        }
        long classNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (parentResourceClassNameId == classNameId) {
            KBArticle kbArticle = this.getLatestKBArticle(parentResourcePrimKey, -1);
            return kbArticle.getRootResourcePrimKey();
        }
        return resourcePrimKey;
    }

    private String _getUniqueUrlTitle(long groupId, long kbFolderId, long kbArticleId, String title) throws PortalException {
        String urlTitle;
        String uniqueUrlTitle = urlTitle = KnowledgeBaseUtil.getUrlTitle((long)kbArticleId, (String)title);
        if (kbFolderId == 0L) {
            int kbArticlesCount = this.kbArticlePersistence.countByG_KBFI_UT_ST(groupId, kbFolderId, uniqueUrlTitle, _STATUSES);
            int i = 1;
            while (kbArticlesCount > 0) {
                uniqueUrlTitle = this._getUniqueUrlTitle(urlTitle, i);
                kbArticlesCount = this.kbArticlePersistence.countByG_KBFI_UT_ST(groupId, kbFolderId, uniqueUrlTitle, _STATUSES);
                ++i;
            }
            return uniqueUrlTitle;
        }
        KBFolder kbFolder = this._kbFolderPersistence.findByPrimaryKey(kbFolderId);
        int kbArticlesCount = this.kbArticleFinder.countByUrlTitle(groupId, kbFolder.getUrlTitle(), uniqueUrlTitle, _STATUSES);
        int i = 1;
        while (kbArticlesCount > 0) {
            uniqueUrlTitle = this._getUniqueUrlTitle(urlTitle, i);
            kbArticlesCount = this.kbArticleFinder.countByUrlTitle(groupId, kbFolder.getUrlTitle(), uniqueUrlTitle, _STATUSES);
            ++i;
        }
        return uniqueUrlTitle;
    }

    private String _getUniqueUrlTitle(long groupId, long kbFolderId, long kbArticleId, String title, String urlTitle) throws PortalException {
        if (Validator.isNull((String)urlTitle)) {
            return this._getUniqueUrlTitle(groupId, kbFolderId, kbArticleId, title);
        }
        return urlTitle.substring(1);
    }

    private String _getUniqueUrlTitle(String urlTitle, int suffix) {
        String uniqueUrlTitle = urlTitle + "-" + suffix;
        return StringUtil.shorten((String)uniqueUrlTitle, (int)ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle"), (String)("-" + suffix));
    }

    private void _indexKBArticle(KBArticle kbArticle) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
            indexer.reindex((Object)kbArticle);
            return null;
        });
    }

    private String _normalizeUrlTitle(String urlTitle) {
        if (Validator.isNull((String)urlTitle)) {
            return null;
        }
        if (StringUtil.startsWith((String)urlTitle, (char)'/')) {
            return urlTitle;
        }
        return "/" + urlTitle;
    }

    private void _notifySubscribers(long userId, KBArticle kbArticle, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)serviceContext.getLayoutFullURL())) {
            return;
        }
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this._getKBGroupServiceConfiguration(kbArticle.getGroupId());
        if (serviceContext.isCommandAdd() && !kbGroupServiceConfiguration.emailKBArticleAddedEnabled()) {
            return;
        }
        if (serviceContext.isCommandUpdate() && !kbGroupServiceConfiguration.emailKBArticleUpdatedEnabled()) {
            return;
        }
        String fromName = kbGroupServiceConfiguration.emailFromName();
        String fromAddress = kbGroupServiceConfiguration.emailFromAddress();
        String kbArticleContent = StringUtil.replace((String)kbArticle.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
        Map<String, String> kbArticleDiffs = this._getEmailKBArticleDiffs(kbArticle);
        for (Map.Entry<String, String> entry : kbArticleDiffs.entrySet()) {
            String value = StringUtil.replace((String)entry.getValue(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
            kbArticleDiffs.put(entry.getKey(), value);
        }
        String subject = null;
        String body = null;
        if (serviceContext.isCommandAdd()) {
            subject = kbGroupServiceConfiguration.emailKBArticleAddedSubject();
            body = kbGroupServiceConfiguration.emailKBArticleAddedBody();
        } else {
            subject = kbGroupServiceConfiguration.emailKBArticleUpdatedSubject();
            body = kbGroupServiceConfiguration.emailKBArticleUpdatedBody();
        }
        SubscriptionSender subscriptionSender = AdminSubscriptionSenderFactory.createSubscriptionSender(kbArticle, serviceContext);
        subscriptionSender.setBody(body);
        subscriptionSender.setClassName(kbArticle.getModelClassName());
        subscriptionSender.setClassPK(kbArticle.getClassPK());
        subscriptionSender.setCompanyId(kbArticle.getCompanyId());
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)kbArticleContent, false);
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT_DIFF$]", (Object)kbArticleDiffs.get("content"), false);
        subscriptionSender.setContextAttribute("[$ARTICLE_TITLE$]", (Object)kbArticle.getTitle(), false);
        subscriptionSender.setContextAttribute("[$ARTICLE_TITLE_DIFF$]", (Object)kbArticleDiffs.get("title"), false);
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(kbArticle.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(kbArticle.getTitle());
        subscriptionSender.setEntryURL(this._getEntryURL(kbArticle, serviceContext));
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("kb_article", new Object[]{kbArticle.getKbArticleId()});
        subscriptionSender.setNotificationType(this._getNotificationType(serviceContext));
        subscriptionSender.setPortletId(serviceContext.getPortletId());
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(kbArticle.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.addAssetEntryPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getGroupId());
        subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        while (!kbArticle.isRoot() && kbArticle.getClassNameId() == kbArticle.getParentResourceClassNameId()) {
            kbArticle = this.getLatestKBArticle(kbArticle.getParentResourcePrimKey(), 0);
            subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        }
        subscriptionSender.flushNotificationsAsync();
    }

    private void _removeKBArticleAttachments(long[] removeFileEntryIds) throws PortalException {
        if (ArrayUtil.isEmpty((long[])removeFileEntryIds)) {
            return;
        }
        for (long removeFileEntryId : removeFileEntryIds) {
            this._portletFileRepository.deletePortletFileEntry(removeFileEntryId);
        }
    }

    private void _startWorkflowInstance(long userId, KBArticle kbArticle, ServiceContext serviceContext) throws PortalException {
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)kbArticle.getCompanyId(), (long)kbArticle.getGroupId(), (long)userId, (String)KBArticle.class.getName(), (long)kbArticle.getResourcePrimKey(), (Object)kbArticle, (ServiceContext)serviceContext, Collections.emptyMap());
    }

    private void _updatePermissionFields(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        if (kbArticle.getParentResourcePrimKey() == parentResourcePrimKey) {
            return;
        }
        long rootResourcePrimKey = this._getRootResourcePrimKey(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        if (kbArticle.getRootResourcePrimKey() == rootResourcePrimKey) {
            return;
        }
        List<KBArticle> kbArticles1 = this.getKBArticleAndAllDescendantKBArticles(resourcePrimKey, -1, null);
        for (KBArticle curKBArticle1 : kbArticles1) {
            List<KBArticle> kbArticles2 = this.getKBArticleVersions(curKBArticle1.getResourcePrimKey(), -1, -1, -1, null);
            for (KBArticle curKBArticle2 : kbArticles2) {
                curKBArticle2.setRootResourcePrimKey(rootResourcePrimKey);
                this.kbArticlePersistence.update((BaseModel)curKBArticle2);
            }
        }
        this._indexWriterHelper.updatePermissionFields(KBArticle.class.getName(), String.valueOf(resourcePrimKey));
    }

    private void _validate(Date expirationDate, String content, Date reviewDate, String sourceURL, String title) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new KBArticleTitleException("Title is null");
        }
        if (Validator.isNull((String)content)) {
            throw new KBArticleContentException("Content is null");
        }
        this._validateExpirationReviewDate(expirationDate, reviewDate);
        this._validateSourceURL(sourceURL);
    }

    private void _validate(double priority) throws PortalException {
        if (priority <= 0.0) {
            throw new KBArticlePriorityException("Invalid priority " + priority);
        }
    }

    private void _validateExpirationReviewDate(Date expirationDate, Date reviewDate) throws PortalException {
        Date now = new Date();
        if (expirationDate != null && expirationDate.before(now)) {
            throw new KBArticleExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
        if (reviewDate != null && reviewDate.before(now)) {
            throw new KBArticleReviewDateException("Review date is " + reviewDate + " in the past");
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        KBArticle kbArticle = this.fetchLatestKBArticleByExternalReferenceCode(groupId, externalReferenceCode);
        if (kbArticle != null) {
            throw new DuplicateKBArticleExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate knowledge base article external reference code ", externalReferenceCode, " in group ", groupId}));
        }
    }

    private void _validateParent(KBArticle kbArticle, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle parentKBArticle;
        List ancestorResourcePrimaryKeys;
        this._validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbArticleClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (parentResourceClassNameId == kbArticleClassNameId && (ancestorResourcePrimaryKeys = (parentKBArticle = this.getLatestKBArticle(parentResourcePrimKey, -1)).getAncestorResourcePrimaryKeys()).contains(kbArticle.getResourcePrimKey())) {
            throw new KBArticleParentException(String.format("Cannot move KBArticle %s inside its descendant KBArticle %s", kbArticle.getResourcePrimKey(), parentKBArticle.getResourcePrimKey()));
        }
    }

    private void _validateParent(long resourceClassNameId, long resourcePrimKey) throws PortalException {
        long kbArticleClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        if (resourceClassNameId != kbArticleClassNameId && resourceClassNameId != kbFolderClassNameId) {
            throw new KBArticleParentException(String.format("Invalid parent with resource class name ID %s and resource primary key %s", resourceClassNameId, resourcePrimKey));
        }
    }

    private void _validateParentStatus(long parentResourceClassNameId, long parentResourcePrimKey, int status) throws PortalException {
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolder.class);
        if (parentResourceClassNameId == kbFolderClassNameId) {
            return;
        }
        KBArticle kbArticle = this.fetchLatestKBArticle(parentResourcePrimKey, 0);
        if (kbArticle == null && status == 0) {
            throw new KBArticleStatusException();
        }
    }

    private void _validateSourceURL(String sourceURL) throws PortalException {
        if (Validator.isNull((String)sourceURL)) {
            return;
        }
        if (!Validator.isUrl((String)sourceURL)) {
            throw new KBArticleSourceURLException(sourceURL);
        }
    }

    private void _validateUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        if (Validator.isNull((String)urlTitle)) {
            return;
        }
        if (!KnowledgeBaseUtil.isValidUrlTitle((String)urlTitle)) {
            throw new KBArticleUrlTitleException.MustNotContainInvalidCharacters(urlTitle);
        }
        int urlTitleMaxSize = ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle");
        if (urlTitle.length() > urlTitleMaxSize + 1) {
            throw new KBArticleUrlTitleException.MustNotExceedMaximumSize(urlTitle, urlTitleMaxSize);
        }
        List kbArticles = this.kbArticlePersistence.findByG_KBFI_UT(groupId, kbFolderId, urlTitle.substring(1));
        if (!kbArticles.isEmpty()) {
            throw new KBArticleUrlTitleException.MustNotBeDuplicate(urlTitle);
        }
    }
}

