/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_1_0;

import com.liferay.knowledge.base.internal.upgrade.v1_1_0.util.KBCommentTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class KBCommentUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(KBCommentUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this.renameAndUpdateTable(StringUtil.replaceFirst((String)"KBComment", (String)"KB", (String)"KB_"), "KBComment", KBCommentTable.TABLE_COLUMNS, "create table KBComment (uuid_ VARCHAR(75) null,kbCommentId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,content STRING null,helpful BOOLEAN)", "drop table KBComment");
    }

    protected void renameAndUpdateTable(String oldTableName, String newTableName, Object[][] tableColumns, String tableSqlCreate, String tableSqlDrop) throws Exception {
        if (this.hasRows(newTableName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", newTableName, " has data"}));
            }
            return;
        }
        if (!this.hasRows(oldTableName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", oldTableName, " has no data"}));
            }
            return;
        }
        this.updateSchema(oldTableName, newTableName, tableSqlDrop);
        this.renameTable(oldTableName, tableColumns, tableSqlCreate);
    }

    protected void renameTable(String oldTableName, Object[][] tableColumns, String tableSqlCreate) throws Exception {
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)oldTableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
        upgradeTable.setCreateSQL(tableSqlCreate);
        upgradeTable.updateTable();
    }

    protected void updateColumn(String tableName, String columnName, String dataType, String data) throws Exception {
        if (this.hasColumn(tableName, columnName)) {
            return;
        }
        String dataTypeUpperCase = StringUtil.toUpperCase((String)dataType);
        StringBundler sb = new StringBundler(6);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" add ");
        sb.append(columnName);
        sb.append(" ");
        sb.append(dataTypeUpperCase);
        String sql = sb.toString();
        if (dataTypeUpperCase.equals("DATE") || dataType.equals("STRING")) {
            sql = sql.concat(" null");
        }
        this.runSQL(sql);
        sb.setIndex(0);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set ");
        sb.append(columnName);
        sb.append(" = ");
        sb.append(data);
        this.runSQL(sb.toString());
    }

    protected void updateSchema(String oldTableName, String newTableName, String tableSqlDrop) throws Exception {
        if (this.hasTable(newTableName)) {
            this.runSQL(tableSqlDrop);
        }
        this.updateColumn(oldTableName, "kbCommentId", "LONG", "commentId");
        if (this.hasColumn(oldTableName, "commentId")) {
            this.runSQL("alter table " + oldTableName + " drop column commentId");
        }
    }
}

