/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.lang.builder;

import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.language.LanguageValidator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.memetix.mst.language.Language;
import com.memetix.mst.translate.Translate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class LangBuilder {
    public static final String AUTOMATIC_COPY = " (Automatic Copy)";
    public static final String AUTOMATIC_TRANSLATION = " (Automatic Translation)";
    private final Set<String> _keysWithUpdatedValues = new HashSet<String>();
    private final String _langDirName;
    private final String _langFileName;
    private final Properties _portalLanguageProperties;
    private final Properties _renameKeys;
    private final boolean _translate;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        System.setProperty("line.separator", "\n");
        String langDirName = GetterUtil.getString(arguments.get("lang.dir"), "src/content");
        String langFileName = GetterUtil.getString(arguments.get("lang.file"), "Language");
        boolean plugin = GetterUtil.getBoolean(arguments.get("lang.plugin"), true);
        String portalLanguagePropertiesFileName = arguments.get("lang.portal.language.properties.file");
        boolean translate = GetterUtil.getBoolean(arguments.get("lang.translate"), true);
        String translateClientId = arguments.get("lang.translate.client.id");
        String translateClientSecret = arguments.get("lang.translate.client.secret");
        boolean buildCurrentBranch = ArgumentsUtil.getBoolean(arguments, "build.current.branch", false);
        if (buildCurrentBranch) {
            String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
            LangBuilder._processCurrentBranch(langFileName, plugin, portalLanguagePropertiesFileName, translate, translateClientId, translateClientSecret, gitWorkingBranchName);
            return;
        }
        try {
            new LangBuilder(langDirName, langFileName, plugin, portalLanguagePropertiesFileName, translate, translateClientId, translateClientSecret);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LangBuilder(String langDirName, String langFileName, boolean plugin, String portalLanguagePropertiesFileName, boolean translate, String translateClientId, String translateClientSecret) throws Exception {
        this._langDirName = langDirName;
        this._langFileName = langFileName;
        this._translate = translate;
        Translate.setClientId((String)translateClientId);
        Translate.setClientSecret((String)translateClientSecret);
        this._initKeysWithUpdatedValues();
        if (plugin) {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("content/Language.properties");
            if (inputStream == null && Validator.isNotNull(portalLanguagePropertiesFileName)) {
                inputStream = new FileInputStream(portalLanguagePropertiesFileName);
            }
            if (inputStream != null) {
                try {
                    this._portalLanguageProperties = PropertiesUtil.load(inputStream, "UTF-8");
                }
                finally {
                    inputStream.close();
                }
            } else {
                this._portalLanguageProperties = null;
            }
        } else {
            this._portalLanguageProperties = null;
        }
        File renameKeysFile = new File(this._langDirName + "/rename.properties");
        this._renameKeys = renameKeysFile.exists() ? this._readProperties(renameKeysFile) : null;
        File propertiesFile = new File(this._langDirName + "/" + this._langFileName + ".properties");
        String content = this._orderProperties(propertiesFile);
        if (Validator.isNull(content)) {
            return;
        }
        this._orderProperties(new File(this._langDirName + "/" + this._langFileName + "_en_AU.properties"));
        this._orderProperties(new File(this._langDirName + "/" + this._langFileName + "_en_GB.properties"));
        this._orderProperties(new File(this._langDirName + "/" + this._langFileName + "_fr_CA.properties"));
        this._copyProperties(propertiesFile, "en");
        this._createProperties(content, "ar");
        this._createProperties(content, "eu");
        this._createProperties(content, "bg");
        this._createProperties(content, "ca");
        this._createProperties(content, "zh_CN");
        this._createProperties(content, "zh_TW");
        this._createProperties(content, "hr");
        this._createProperties(content, "cs");
        this._createProperties(content, "da");
        this._createProperties(content, "nl");
        this._createProperties(content, "nl_BE", "nl");
        this._createProperties(content, "et");
        this._createProperties(content, "fi");
        this._createProperties(content, "fr");
        this._createProperties(content, "gl");
        this._createProperties(content, "de");
        this._createProperties(content, "el");
        this._createProperties(content, "iw");
        this._createProperties(content, "hi_IN");
        this._createProperties(content, "hu");
        this._createProperties(content, "in");
        this._createProperties(content, "it");
        this._createProperties(content, "ja");
        this._createProperties(content, "ko");
        this._createProperties(content, "lo");
        this._createProperties(content, "lt");
        this._createProperties(content, "nb");
        this._createProperties(content, "fa");
        this._createProperties(content, "pl");
        this._createProperties(content, "pt_BR");
        this._createProperties(content, "pt_PT", "pt_BR");
        this._createProperties(content, "ro");
        this._createProperties(content, "ru");
        this._createProperties(content, "sr_RS");
        this._createProperties(content, "sr_RS_latin");
        this._createProperties(content, "sk");
        this._createProperties(content, "sl");
        this._createProperties(content, "es");
        this._createProperties(content, "sv");
        this._createProperties(content, "tr");
        this._createProperties(content, "uk");
        this._createProperties(content, "vi");
    }

    private static String _getSpecialPropertyValue(String key) {
        if (key.equals("lang.dir")) {
            return "ltr";
        }
        if (key.equals("lang.line.begin")) {
            return "left";
        }
        if (key.equals("lang.line.end")) {
            return "right";
        }
        return "";
    }

    private static void _processCurrentBranch(String langFileName, boolean plugin, String portalLanguagePropertiesFileName, boolean translate, String translateClientId, String translateClientSecret, String gitWorkingBranchName) throws Exception {
        try {
            String basedir = ".././";
            List<String> fileNames = GitUtil.getCurrentBranchFileNames(basedir, gitWorkingBranchName);
            for (String fileName : fileNames) {
                int pos = fileName.indexOf("content/" + langFileName + ".properties");
                if (pos == -1) continue;
                String langDirName = basedir + fileName.substring(0, pos + 7);
                new LangBuilder(langDirName, langFileName, plugin, portalLanguagePropertiesFileName, translate, translateClientId, translateClientSecret);
            }
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
        }
    }

    private void _copyProperties(File file, String languageId) throws IOException {
        Path path = Paths.get(this._langDirName, this._langFileName + "_" + languageId + ".properties");
        Files.copy(file.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void _createProperties(String content, String languageId) throws IOException {
        this._createProperties(content, languageId, null);
    }

    private void _createProperties(String content, String languageId, String parentLanguageId) throws IOException {
        File parentPropertiesFile;
        File propertiesFile = new File(this._langDirName + "/" + this._langFileName + "_" + languageId + ".properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            properties = this._readProperties(propertiesFile);
        }
        Properties parentProperties = null;
        if (parentLanguageId != null && (parentPropertiesFile = new File(this._langDirName + "/" + this._langFileName + "_" + parentLanguageId + ".properties")).exists()) {
            parentProperties = this._readProperties(parentPropertiesFile);
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));
             UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter(new OutputStreamWriter(new FileOutputStream(propertiesFile), "UTF-8"));){
            boolean firstLine = true;
            int state = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos = (line = line.trim()).indexOf("=");
                if (pos != -1) {
                    String renameKey;
                    String key = line.substring(0, pos);
                    String value = line.substring(pos + 1);
                    if (state == 1 && !key.startsWith("lang.") || state == 2 && !key.startsWith("javax.portlet.") || state == 3 && !key.startsWith("category.") || state == 4 && !key.startsWith("model.resource.") || state == 5 && !key.startsWith("action.") || state == 7 && !key.startsWith("country.") || state == 8 && !key.startsWith("currency.") || state == 9 && !key.startsWith("language.") || state != 9 && key.startsWith("language.")) {
                        throw new RuntimeException("File " + languageId + " with state " + state + " has key " + key);
                    }
                    String translatedText = properties.getProperty(key);
                    if (this._keysWithUpdatedValues.contains(key)) {
                        translatedText = null;
                    }
                    if (translatedText == null && parentProperties != null) {
                        translatedText = parentProperties.getProperty(key);
                    }
                    if (translatedText == null && this._renameKeys != null && (renameKey = this._renameKeys.getProperty(key)) != null && (translatedText = properties.getProperty(key)) == null && parentProperties != null) {
                        translatedText = parentProperties.getProperty(key);
                    }
                    if (translatedText != null) {
                        if (translatedText.contains("Babel Fish") || translatedText.contains("Yahoo! - 999")) {
                            translatedText = "";
                        } else if (translatedText.endsWith(AUTOMATIC_COPY)) {
                            translatedText = value + AUTOMATIC_COPY;
                        }
                    }
                    if (translatedText == null || translatedText.equals("")) {
                        if (line.contains("{") || line.contains("<")) {
                            translatedText = value + AUTOMATIC_COPY;
                        } else if (line.contains("[")) {
                            pos = line.indexOf("[");
                            String baseKey = line.substring(0, pos);
                            String translatedBaseKey = properties.getProperty(baseKey);
                            translatedText = Validator.isNotNull(translatedBaseKey) ? translatedBaseKey : value + AUTOMATIC_COPY;
                        } else if (LanguageValidator.isSpecialPropertyKey(key)) {
                            translatedText = LangBuilder._getSpecialPropertyValue(key);
                        } else if (languageId.equals("el") && (key.equals("enabled") || key.equals("on") || key.equals("on-date"))) {
                            translatedText = "";
                        } else if (languageId.equals("es") && key.equals("am")) {
                            translatedText = "";
                        } else if (languageId.equals("fi") && (key.equals("on") || key.equals("the"))) {
                            translatedText = "";
                        } else if (languageId.equals("it") && key.equals("am")) {
                            translatedText = "";
                        } else if (languageId.equals("ja") && (key.equals("any") || key.equals("anytime") || key.equals("down") || key.equals("on") || key.equals("on-date") || key.equals("the"))) {
                            translatedText = "";
                        } else if (languageId.equals("ko") && key.equals("the")) {
                            translatedText = "";
                        } else {
                            translatedText = this._translate("en", languageId, key, value, 0);
                            if (Validator.isNull(translatedText)) {
                                translatedText = value + AUTOMATIC_COPY;
                            } else if (!key.startsWith("country.") && !key.startsWith("language.")) {
                                translatedText = translatedText + AUTOMATIC_TRANSLATION;
                            }
                        }
                    }
                    if (!Validator.isNotNull(translatedText)) continue;
                    if (translatedText.contains("Babel Fish") || translatedText.contains("Yahoo! - 999")) {
                        throw new IOException("IP was blocked because of over usage. Please use another IP.");
                    }
                    translatedText = this._fixTranslation(translatedText);
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        unsyncBufferedWriter.newLine();
                    }
                    unsyncBufferedWriter.write(key + "=" + translatedText);
                    unsyncBufferedWriter.flush();
                    continue;
                }
                if (line.startsWith("## Language settings")) {
                    if (state == 1) {
                        throw new RuntimeException(languageId);
                    }
                    state = 1;
                } else if (line.startsWith("## Portlet descriptions and titles")) {
                    if (state == 2) {
                        throw new RuntimeException(languageId);
                    }
                    state = 2;
                } else if (line.startsWith("## Category titles")) {
                    if (state == 3) {
                        throw new RuntimeException(languageId);
                    }
                    state = 3;
                } else if (line.startsWith("## Model resources")) {
                    if (state == 4) {
                        throw new RuntimeException(languageId);
                    }
                    state = 4;
                } else if (line.startsWith("## Action names")) {
                    if (state == 5) {
                        throw new RuntimeException(languageId);
                    }
                    state = 5;
                } else if (line.startsWith("## Messages")) {
                    if (state == 6) {
                        throw new RuntimeException(languageId);
                    }
                    state = 6;
                } else if (line.startsWith("## Country")) {
                    if (state == 7) {
                        throw new RuntimeException(languageId);
                    }
                    state = 7;
                } else if (line.startsWith("## Currency")) {
                    if (state == 8) {
                        throw new RuntimeException(languageId);
                    }
                    state = 8;
                } else if (line.startsWith("## Language")) {
                    if (state == 9) {
                        throw new RuntimeException(languageId);
                    }
                    state = 9;
                }
                if (firstLine) {
                    firstLine = false;
                } else {
                    unsyncBufferedWriter.newLine();
                }
                unsyncBufferedWriter.write(line);
                unsyncBufferedWriter.flush();
            }
        }
    }

    private String _fixEnglishTranslation(String key, String value) {
        if (value.contains(" this ")) {
            if (!(value.contains(".") || value.contains("?") || value.contains(":") || key.equals("the-url-of-the-page-comparing-this-page-content-with-the-previous-version"))) {
                value = StringUtil.replace(value, " this ", " This ");
            }
        } else {
            value = StringUtil.replace(value, " From ", " from ");
        }
        return value;
    }

    private String _fixTranslation(String value) {
        value = StringUtil.replace(value.trim(), new String[]{"  ", "<b>", "</b>", "<i>", "</i>", " url ", "&#39;", "&#39 ;", "&quot;", "&quot ;", "ReCaptcha", "Captcha"}, new String[]{" ", "<strong>", "</strong>", "<em>", "</em>", " URL ", "'", "'", "\"", "\"", "reCAPTCHA", "CAPTCHA"});
        return value;
    }

    private String _getMicrosoftLanguageId(String languageId) {
        if (languageId.equals("pt_BR") || languageId.equals("pt_PT")) {
            return "pt";
        }
        if (languageId.equals("hi_IN")) {
            return "hi";
        }
        if (languageId.equals("in")) {
            return "id";
        }
        if (languageId.equals("iw")) {
            return "he";
        }
        if (languageId.equals("nb")) {
            return "no";
        }
        if (languageId.equals("zh_CN")) {
            return "zh-CHS";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-CHT";
        }
        return languageId;
    }

    private void _initKeysWithUpdatedValues() throws Exception {
        File backupLanguageFile = new File(this._langDirName + "/" + this._langFileName + "_en.properties");
        if (!backupLanguageFile.exists()) {
            return;
        }
        Properties backupLanguageProperties = this._readProperties(backupLanguageFile);
        File languageFile = new File(this._langDirName + "/" + this._langFileName + ".properties");
        Properties languageProperties = this._readProperties(languageFile);
        Set<Map.Entry<Object, Object>> set = languageProperties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.equals(backupLanguageProperties.get(key))) continue;
            this._keysWithUpdatedValues.add(key);
        }
    }

    private String _orderProperties(File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            return null;
        }
        String content = this._read(propertiesFile);
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));
             UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter(new FileWriter(propertiesFile));){
            TreeMap<String, String> messages = new TreeMap<String, String>(new NaturalOrderStringComparator(true, true));
            boolean begin = false;
            boolean firstLine = true;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos = line.indexOf("=");
                if (pos != -1) {
                    String key = line.substring(0, pos);
                    String value = line.substring(pos + 1);
                    if (Validator.isNotNull(value)) {
                        String portalValue;
                        value = this._fixTranslation(line.substring(pos + 1));
                        value = this._fixEnglishTranslation(key, value);
                        if (this._portalLanguageProperties != null && value.equals(portalValue = String.valueOf(this._portalLanguageProperties.get(key)))) {
                            System.out.println("Duplicate key " + key);
                        }
                        messages.put(key, value);
                    }
                } else {
                    if (begin && line.equals("")) {
                        this._sortAndWrite(unsyncBufferedWriter, messages, firstLine);
                    }
                    if (line.equals("")) {
                        boolean bl = begin = !begin;
                    }
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        unsyncBufferedWriter.newLine();
                    }
                    unsyncBufferedWriter.write(line);
                }
                unsyncBufferedWriter.flush();
            }
            if (!messages.isEmpty()) {
                this._sortAndWrite(unsyncBufferedWriter, messages, firstLine);
            }
        }
        return this._read(propertiesFile);
    }

    private String _read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    private Properties _readProperties(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Properties properties = PropertiesUtil.load(fileInputStream, "UTF-8");
            return properties;
        }
    }

    private void _sortAndWrite(UnsyncBufferedWriter unsyncBufferedWriter, Map<String, String> messages, boolean firstLine) throws IOException {
        boolean firstEntry = true;
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            if (!firstLine || !firstEntry) {
                unsyncBufferedWriter.newLine();
            }
            firstEntry = false;
            unsyncBufferedWriter.write(entry.getKey() + "=" + entry.getValue());
        }
        messages.clear();
    }

    private String _translate(String fromLanguageId, String toLanguageId, String key, String fromText, int limit) {
        if (!this._translate) {
            return null;
        }
        if (toLanguageId.equals("da") || toLanguageId.equals("de") || toLanguageId.equals("fi") || toLanguageId.equals("ja") || toLanguageId.equals("nl") || toLanguageId.equals("pt_PT") || toLanguageId.equals("sv")) {
            return null;
        }
        if (limit == 3) {
            return null;
        }
        Language fromLanguage = Language.fromString((String)this._getMicrosoftLanguageId(fromLanguageId));
        Language toLanguage = Language.fromString((String)this._getMicrosoftLanguageId(toLanguageId));
        if (toLanguage == null) {
            return null;
        }
        String toText = null;
        try {
            StringBundler sb = new StringBundler(8);
            sb.append("Translating ");
            sb.append(fromLanguageId);
            sb.append("_");
            sb.append(toLanguageId);
            sb.append(" ");
            sb.append(key);
            sb.append(" ");
            sb.append(fromText);
            System.out.println(sb.toString());
            toText = Translate.execute((String)fromText, (Language)fromLanguage, (Language)toLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (toText == null) {
            return this._translate(fromLanguageId, toLanguageId, key, fromText, ++limit);
        }
        return toText;
    }
}

