/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import com.liferay.portal.kernel.language.LanguageConstants;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class LanguageValidator {
    public static boolean isSpecialPropertyKey(String key) {
        return ArrayUtil.contains(LanguageConstants.KEYS_SPECIAL_PROPERTIES, key);
    }

    public static boolean isValid(String key, String value) {
        if (key.equals("lang.dir")) {
            return ArrayUtil.contains(LanguageConstants.VALUES_DIR, value);
        }
        if (key.equals("lang.line.begin") || key.equals("lang.line.end")) {
            return ArrayUtil.contains(LanguageConstants.VALUES_LINE, value);
        }
        if (key.equals("lang.user.name.field.names")) {
            return LanguageValidator._isValidUserNameFieldNamesValue(value);
        }
        if (key.equals("lang.user.name.required.field.names")) {
            return LanguageValidator._isValidUserNameRequiredFieldNamesValue(value);
        }
        return true;
    }

    private static boolean _isValidUserNameFieldNamesValue(String value) {
        Object[] valueArray = StringUtil.split(value);
        if (ArrayUtil.isEmpty(valueArray)) {
            return false;
        }
        if (!ArrayUtil.contains(valueArray, "first-name") || !ArrayUtil.contains(valueArray, "last-name")) {
            return false;
        }
        if (ArrayUtil.contains(valueArray, "prefix") && !((String)valueArray[0]).equals("prefix")) {
            return false;
        }
        int index = valueArray.length - 1;
        if (ArrayUtil.contains(valueArray, "suffix") && !((String)valueArray[index]).equals("suffix")) {
            return false;
        }
        for (Object curValue : valueArray) {
            if (ArrayUtil.contains(LanguageConstants.VALUES_USER_NAME_FIELD_NAMES, curValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean _isValidUserNameRequiredFieldNamesValue(String value) {
        Object[] valuesArray = StringUtil.split(value);
        if (ArrayUtil.isEmpty(valuesArray)) {
            return false;
        }
        for (Object curValue : valuesArray) {
            if (ArrayUtil.contains(LanguageConstants.VALUES_USER_NAME_FIELD_NAMES, curValue)) continue;
            return false;
        }
        return true;
    }
}

