/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.application.list.GroupProvider;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class BaseLayoutDisplayContext {
    protected final GroupProvider groupProvider;
    protected final LiferayPortletRequest liferayPortletRequest;
    protected final LiferayPortletResponse liferayPortletResponse;
    protected final ThemeDisplay themeDisplay;
    private Long _layoutId;
    private Group _liveGroup;
    private Boolean _privateLayout;
    private String _rootNodeName;
    private Group _selGroup;
    private Layout _selLayout;
    private LayoutSet _selLayoutSet;
    private Long _selPlid;
    private Group _stagingGroup;

    public BaseLayoutDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        this.liferayPortletRequest = liferayPortletRequest;
        this.liferayPortletResponse = liferayPortletResponse;
        this.groupProvider = (GroupProvider)liferayPortletRequest.getAttribute("GROUP_PROVIDER");
        this.themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public PortletURL getAddLayoutURL(long selPlid, Boolean privateLayout) {
        PortletURL addLayoutURL = PortalUtil.getControlPanelPortletURL((PortletRequest)this.liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE");
        addLayoutURL.setParameter("mvcPath", "/add_layout.jsp");
        if (selPlid >= 0L) {
            addLayoutURL.setParameter("selPlid", String.valueOf(selPlid));
        }
        addLayoutURL.setParameter("groupId", String.valueOf(this.getSelGroupId()));
        if (privateLayout != null) {
            addLayoutURL.setParameter("privateLayout", String.valueOf(privateLayout));
        }
        return addLayoutURL;
    }

    public PortletURL getEditLayoutURL(long selPlid, Boolean privateLayout) {
        PortletURL editLayoutURL = PortalUtil.getControlPanelPortletURL((PortletRequest)this.liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE");
        if (selPlid >= 0L) {
            editLayoutURL.setParameter("selPlid", String.valueOf(selPlid));
        }
        if (privateLayout != null) {
            editLayoutURL.setParameter("privateLayout", String.valueOf(privateLayout));
        }
        Group selGroup = this.getSelGroup();
        editLayoutURL.setParameter("groupId", String.valueOf(selGroup.getGroupId()));
        return editLayoutURL;
    }

    public Long getLayoutId() {
        if (this._layoutId != null) {
            return this._layoutId;
        }
        this._layoutId = 0L;
        Layout selLayout = this.getSelLayout();
        if (selLayout != null) {
            this._layoutId = selLayout.getLayoutId();
        }
        return this._layoutId;
    }

    public String getRootNodeName() {
        if (this._rootNodeName != null) {
            return this._rootNodeName;
        }
        this._rootNodeName = this.getRootNodeName(this.isPrivateLayout());
        return this._rootNodeName;
    }

    public String getRootNodeName(boolean privateLayout) {
        Group liveGroup = this.getLiveGroup();
        return liveGroup.getLayoutRootNodeName(privateLayout, this.themeDisplay.getLocale());
    }

    public long getSelGroupId() {
        Group selGroup = this.getSelGroup();
        if (selGroup != null) {
            return selGroup.getGroupId();
        }
        return 0L;
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public LayoutSet getSelLayoutSet() throws PortalException {
        if (this._selLayoutSet != null) {
            return this._selLayoutSet;
        }
        Group group = this.getStagingGroup();
        if (group == null) {
            group = this.getLiveGroup();
        }
        this._selLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)this.isPrivateLayout());
        return this._selLayoutSet;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((PortletRequest)this.liferayPortletRequest, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public boolean isPrivateLayout() {
        if (this._privateLayout != null) {
            return this._privateLayout;
        }
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutSetPrototype() || selGroup.isLayoutSetPrototype()) {
            this._privateLayout = true;
            return this._privateLayout;
        }
        Layout selLayout = this.getSelLayout();
        if (this.getSelLayout() != null) {
            this._privateLayout = selLayout.isPrivateLayout();
            return this._privateLayout;
        }
        Layout layout = this.themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            this._privateLayout = layout.isPrivateLayout();
            return this._privateLayout;
        }
        this._privateLayout = ParamUtil.getBoolean((PortletRequest)this.liferayPortletRequest, (String)"privateLayout");
        return this._privateLayout;
    }

    public boolean isShowAddRootLayoutButton() throws PortalException {
        return GroupPermissionUtil.contains((PermissionChecker)this.themeDisplay.getPermissionChecker(), (Group)this.getSelGroup(), (String)"ADD_LAYOUT");
    }

    protected Group getLiveGroup() {
        if (this._liveGroup != null) {
            return this._liveGroup;
        }
        this._liveGroup = StagingUtil.getLiveGroup((long)this.getSelGroupId());
        if (this._liveGroup == null) {
            this._liveGroup = this.getSelGroup();
        }
        return this._liveGroup;
    }

    protected Group getSelGroup() {
        if (this._selGroup != null) {
            return this._selGroup;
        }
        this._selGroup = this.groupProvider.getGroup(PortalUtil.getHttpServletRequest((PortletRequest)this.liferayPortletRequest));
        return this._selGroup;
    }

    protected Group getStagingGroup() {
        if (this._stagingGroup != null) {
            return this._stagingGroup;
        }
        this._stagingGroup = StagingUtil.getStagingGroup((long)this.getSelGroupId());
        if (this._stagingGroup == null) {
            this._stagingGroup = this.getSelGroup();
        }
        return this._stagingGroup;
    }
}

