/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.layout.admin.web.internal.display.context.BaseLayoutDisplayContext;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetBranchException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutsTreeDisplayContext
extends BaseLayoutDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsTreeDisplayContext.class);
    private LayoutSetBranch _layoutSetBranch;
    private List<LayoutSetBranch> _layoutSetBranches;

    public LayoutsTreeDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        super(liferayPortletRequest, liferayPortletResponse);
    }

    public Long getCurSelPlid() {
        Long curSelPlid = null;
        if (this.getSelPlid() != 0L) {
            curSelPlid = this.getSelPlid();
        } else {
            Layout layout = this.themeDisplay.getLayout();
            if (!layout.isTypeControlPanel()) {
                curSelPlid = layout.getPlid();
            }
        }
        return curSelPlid;
    }

    public PortletURL getDeleteLayoutURL(long selPlid) {
        LiferayPortletURL deleteLayoutURL;
        block4: {
            deleteLayoutURL = (LiferayPortletURL)PortalUtil.getControlPanelPortletURL((PortletRequest)this.liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"ACTION_PHASE");
            deleteLayoutURL.setParameter("javax.portlet.action", "deleteLayout");
            deleteLayoutURL.setParameter("mvcPath", "/edit_layout.jsp");
            String redirect = PortalUtil.getCurrentURL((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this.liferayPortletRequest));
            deleteLayoutURL.setParameter("redirect", redirect);
            if (selPlid >= 0L) {
                deleteLayoutURL.setParameter("selPlid", String.valueOf(selPlid));
            }
            try {
                LayoutSetBranch layoutSetBranch = this.getLayoutSetBranch();
                Map parameterMap = deleteLayoutURL.getParameterMap();
                if (layoutSetBranch != null && !parameterMap.containsKey("layoutSetBranchId")) {
                    deleteLayoutURL.setParameter("layoutSetBranchId", String.valueOf(layoutSetBranch.getLayoutSetBranchId()));
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        deleteLayoutURL.setRefererPlid(this.themeDisplay.getPlid());
        return deleteLayoutURL;
    }

    public PortletURL getEmptyLayoutSetURL(boolean privateLayout) {
        PortletURL emptyLayoutSetURL = PortalUtil.getControlPanelPortletURL((PortletRequest)this.liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE");
        emptyLayoutSetURL.setParameter("mvcPath", "/empty_layout_set.jsp");
        emptyLayoutSetURL.setParameter("selPlid", String.valueOf(0L));
        Group liveGroup = this.getSelGroup();
        emptyLayoutSetURL.setParameter("groupId", String.valueOf(liveGroup.getGroupId()));
        emptyLayoutSetURL.setParameter("privateLayout", String.valueOf(privateLayout));
        return emptyLayoutSetURL;
    }

    public LayoutSetBranch getLayoutSetBranch() throws PortalException {
        block6: {
            if (this._layoutSetBranch != null) {
                return this._layoutSetBranch;
            }
            long layoutSetBranchId = ParamUtil.getLong((PortletRequest)this.liferayPortletRequest, (String)"layoutSetBranchId");
            if (layoutSetBranchId <= 0L) {
                LayoutSet selLayoutSet = this.getSelLayoutSet();
                layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)this.themeDisplay.getUser(), (long)selLayoutSet.getLayoutSetId());
            }
            if (layoutSetBranchId > 0L) {
                this._layoutSetBranch = LayoutSetBranchLocalServiceUtil.fetchLayoutSetBranch((long)layoutSetBranchId);
            }
            if (this._layoutSetBranch == null) {
                try {
                    Group stagingGroup = this.getStagingGroup();
                    this._layoutSetBranch = LayoutSetBranchLocalServiceUtil.getMasterLayoutSetBranch((long)stagingGroup.getGroupId(), (boolean)this.isPrivateLayout());
                }
                catch (NoSuchLayoutSetBranchException nslsbe) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Object)nslsbe, (Throwable)nslsbe);
                }
            }
        }
        return this._layoutSetBranch;
    }

    public String getLayoutSetBranchCssClass(LayoutSetBranch layoutSetBranch) throws PortalException {
        if (this.isLayoutSetBranchSelected(layoutSetBranch)) {
            return "active";
        }
        return "";
    }

    public List<LayoutSetBranch> getLayoutSetBranches() {
        if (this._layoutSetBranches != null) {
            return this._layoutSetBranches;
        }
        Group stagingGroup = this.getStagingGroup();
        this._layoutSetBranches = LayoutSetBranchLocalServiceUtil.getLayoutSetBranches((long)stagingGroup.getGroupId(), (boolean)this.isPrivateLayout());
        return this._layoutSetBranches;
    }

    public String getLayoutSetBranchName() throws PortalException {
        LayoutSetBranch layoutSetBranch = this.getLayoutSetBranch();
        if ("main-variation".equals(layoutSetBranch.getName())) {
            return LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this.liferayPortletRequest), (String)layoutSetBranch.getName());
        }
        return layoutSetBranch.getName();
    }

    public String getLayoutSetBranchURL(LayoutSetBranch layoutSetBranch) throws PortalException {
        PortletURL layoutSetBranchURL = PortalUtil.getControlPanelPortletURL((PortletRequest)this.liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"ACTION_PHASE");
        layoutSetBranchURL.setParameter("javax.portlet.action", "selectLayoutSetBranch");
        layoutSetBranchURL.setParameter("redirect", this.themeDisplay.getURLCurrent());
        layoutSetBranchURL.setParameter("groupId", String.valueOf(layoutSetBranch.getGroupId()));
        layoutSetBranchURL.setParameter("privateLayout", String.valueOf(this.isPrivateLayout()));
        layoutSetBranchURL.setParameter("layoutSetBranchId", String.valueOf(layoutSetBranch.getLayoutSetBranchId()));
        return layoutSetBranchURL.toString();
    }

    public Map<String, PortletURL> getPortletURLs() {
        HashMap<String, PortletURL> portletURLs = new HashMap<String, PortletURL>();
        portletURLs.put("addLayoutURL", this.getAddLayoutURL(0L, null));
        portletURLs.put("deleteLayoutURL", this.getDeleteLayoutURL(0L));
        portletURLs.put("editLayoutURL", this.getEditLayoutURL(0L, null));
        return portletURLs;
    }

    public String getPrivateLayoutsURL() {
        Group selGroup = this.getSelGroup();
        if (!selGroup.hasPrivateLayouts()) {
            PortletURL portletURL = this.getEmptyLayoutSetURL(true);
            return portletURL.toString();
        }
        return selGroup.getDisplayURL(this.themeDisplay, true);
    }

    public String getPublicLayoutsURL() {
        Group selGroup = this.getSelGroup();
        if (!selGroup.hasPublicLayouts()) {
            PortletURL portletURL = this.getEmptyLayoutSetURL(false);
            return portletURL.toString();
        }
        return selGroup.getDisplayURL(this.themeDisplay, false);
    }

    @Override
    public String getRootNodeName(boolean privateLayout) {
        if (this.isShowEmptyLayoutsTree()) {
            return "pages";
        }
        return super.getRootNodeName(privateLayout);
    }

    public boolean isShowAddBothRootLayoutButtons() throws PortalException {
        if (!super.isShowAddRootLayoutButton()) {
            return false;
        }
        Group selGroup = this.getSelGroup();
        if (selGroup.hasPublicLayouts() && selGroup.hasPrivateLayouts()) {
            return false;
        }
        if (!selGroup.hasPublicLayouts() && !selGroup.hasPrivateLayouts()) {
            return false;
        }
        return !selGroup.isLayoutSetPrototype() && !selGroup.isLayoutPrototype();
    }

    public boolean isShowAddLayoutButton() throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)this.themeDisplay.getPermissionChecker(), (Layout)this.getSelLayout(), (String)"ADD_LAYOUT");
    }

    @Override
    public boolean isShowAddRootLayoutButton() throws PortalException {
        if (this.isShowAddBothRootLayoutButtons()) {
            return false;
        }
        return super.isShowAddRootLayoutButton();
    }

    public boolean isShowEditLayoutSetButton() throws PortalException {
        return GroupPermissionUtil.contains((PermissionChecker)this.themeDisplay.getPermissionChecker(), (Group)this.getSelGroup(), (String)"MANAGE_LAYOUTS");
    }

    public boolean isShowEmptyLayoutsTree() {
        Group selGroup = this.getSelGroup();
        return !selGroup.hasPrivateLayouts() && !selGroup.hasPublicLayouts();
    }

    public boolean isShowExpandLayoutSetButton(boolean privateLayout) {
        Group selGroup = this.getSelGroup();
        if (privateLayout && selGroup.hasPrivateLayouts()) {
            return true;
        }
        return !privateLayout && selGroup.hasPublicLayouts();
    }

    public boolean isShowLayoutSetBranchesSelector() {
        Group stagingGroup = this.getStagingGroup();
        if (stagingGroup == null || !stagingGroup.isStaged() || this.getSelGroupId() != stagingGroup.getGroupId()) {
            return false;
        }
        List<LayoutSetBranch> layoutSetBranches = this.getLayoutSetBranches();
        return layoutSetBranches.size() >= 2;
    }

    public boolean isShowLayoutTabs() {
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutPrototype()) {
            return false;
        }
        return ParamUtil.getBoolean((PortletRequest)this.liferayPortletRequest, (String)"showLayoutTabs", (boolean)true);
    }

    public boolean isShowPrivateLayoutOptions() throws PortalException {
        if (!this.isPrivateLayout()) {
            return false;
        }
        if (this.isShowAddRootLayoutButton()) {
            return true;
        }
        if (this.isShowAddBothRootLayoutButtons()) {
            return true;
        }
        if (this.isShowEditLayoutSetButton()) {
            return true;
        }
        if (this.isShowExpandLayoutSetButton(false)) {
            return true;
        }
        return this.isShowAddBothRootLayoutButtons();
    }

    public boolean isShowPrivateLayoutsTree() {
        Group selGroup = this.getSelGroup();
        return selGroup.hasPrivateLayouts();
    }

    public boolean isShowPublicLayoutOptions() throws PortalException {
        if (this.isPrivateLayout()) {
            return false;
        }
        if (this.isShowAddRootLayoutButton()) {
            return true;
        }
        if (this.isShowAddBothRootLayoutButtons()) {
            return true;
        }
        if (this.isShowEditLayoutSetButton()) {
            return true;
        }
        if (this.isShowExpandLayoutSetButton(false)) {
            return true;
        }
        return this.isShowAddBothRootLayoutButtons();
    }

    public boolean isShowPublicLayoutsTree() {
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutSetPrototype() || selGroup.isLayoutPrototype()) {
            return false;
        }
        return selGroup.hasPublicLayouts();
    }

    public boolean isShowStagingProcessMessage() throws PortalException {
        Group group = this.getSelGroup();
        if (!GroupPermissionUtil.contains((PermissionChecker)this.themeDisplay.getPermissionChecker(), (Group)group, (String)"PUBLISH_STAGING")) {
            return false;
        }
        Group backgroundTaskExcutorGroup = null;
        backgroundTaskExcutorGroup = group.isStagingGroup() ? this.getLiveGroup() : this.getStagingGroup();
        int incompleteBackgroundTaskCount = BackgroundTaskManagerUtil.getBackgroundTasksCount((long)backgroundTaskExcutorGroup.getGroupId(), (String)"com.liferay.exportimport.background.task.LayoutStagingBackgroundTaskExecutor", (boolean)false);
        return incompleteBackgroundTaskCount > 0;
    }

    protected boolean isLayoutSetBranchSelected(LayoutSetBranch layoutSetBranch) throws PortalException {
        LayoutSetBranch curLayoutSetBranch = this.getLayoutSetBranch();
        if (curLayoutSetBranch == null) {
            return false;
        }
        return curLayoutSetBranch.getLayoutSetBranchId() == layoutSetBranch.getLayoutSetBranchId();
    }
}

