/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletTitleComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class OrphanPortletsDisplayContext {
    private String _displayStyle;
    private String _orderByCol;
    private String _orderByType;
    private final PortletRequest _portletRequest;
    private Layout _selLayout;
    private Long _selPlid;

    public OrphanPortletsDisplayContext(PortletRequest portletRequest) throws PortalException {
        this._portletRequest = portletRequest;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public List<Portlet> getOrphanPortlets() {
        Layout selLayout = this.getSelLayout();
        if (!selLayout.isSupportsEmbeddedPortlets()) {
            return Collections.emptyList();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet selLayoutTypePortlet = (LayoutTypePortlet)selLayout.getLayoutType();
        List explicitlyAddedPortlets = selLayoutTypePortlet.getExplicitlyAddedPortlets();
        ArrayList<String> explicitlyAddedPortletIds = new ArrayList<String>();
        for (Portlet explicitlyAddedPortlet : explicitlyAddedPortlets) {
            explicitlyAddedPortletIds.add(explicitlyAddedPortlet.getPortletId());
        }
        ArrayList<Portlet> orphanPortlets = new ArrayList();
        List portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)this.getSelPlid());
        for (PortletPreferences portletPreference : portletPreferences) {
            String portletId = portletPreference.getPortletId();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
            if (portlet.isSystem() || explicitlyAddedPortletIds.contains(portletId)) continue;
            orphanPortlets.add(portlet);
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._portletRequest);
        PortletTitleComparator portletTitleComparator = new PortletTitleComparator(request.getServletContext(), themeDisplay.getLocale());
        orphanPortlets = ListUtil.sort(orphanPortlets, (Comparator)portletTitleComparator);
        return orphanPortlets;
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((PortletRequest)this._portletRequest, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public String getStatus(Portlet portlet) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._portletRequest);
        if (!portlet.isActive()) {
            return LanguageUtil.get((HttpServletRequest)request, (String)"inactive");
        }
        if (!portlet.isReady()) {
            return LanguageUtil.format((HttpServletRequest)request, (String)"is-not-ready", (Object)"portlet");
        }
        if (portlet.isUndeployedPortlet()) {
            return LanguageUtil.get((HttpServletRequest)request, (String)"undeployed");
        }
        return LanguageUtil.get((HttpServletRequest)request, (String)"active");
    }
}

