Liferay.Loader.define("layout-admin-web@2.0.112/js/fragments_editor/FragmentsEditor.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './dialogs/SelectMappingDialog.es', './dialogs/SelectMappingTypeDialog.es', './fragment_entry_link/FragmentEntryLinkList.es', './sidebar/FragmentsEditorSidebar.es', './toolbar/FragmentsEditorToolbar.es', './fragment_entry_link/FragmentEntryLink.es', './FragmentsEditor.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentsEditor = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("./dialogs/SelectMappingDialog.es");

  require("./dialogs/SelectMappingTypeDialog.es");

  require("./fragment_entry_link/FragmentEntryLinkList.es");

  require("./sidebar/FragmentsEditorSidebar.es");

  require("./toolbar/FragmentsEditorToolbar.es");

  var _FragmentEntryLink = _interopRequireDefault(require("./fragment_entry_link/FragmentEntryLink.es"));

  var _FragmentsEditor = _interopRequireDefault(require("./FragmentsEditor.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentsEditor
   * @review
   */
  var FragmentsEditor =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentsEditor, _Component);

    function FragmentsEditor() {
      _classCallCheck(this, FragmentsEditor);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentsEditor).apply(this, arguments));
    }

    _createClass(FragmentsEditor, [{
      key: "rendered",

      /**
       * @inheritDoc
       * @review
       */
      value: function rendered(firstRender) {
        if (firstRender) {
          this._translationStatus = this._getTranslationStatus(Object.keys(this.availableLanguages).filter(function (languageId) {
            return languageId !== '_INJECTED_DATA_';
          }), this._getEditableValues());
        }
      }
      /**
       * Sends message to delete a single fragment entry link to the server and,
       * if success, sets the _dirty property to false.
       * @param {!string} fragmentEntryLinkId
       * @private
       * @review
       */

    }, {
      key: "_deleteFragmentEntryLink",
      value: function _deleteFragmentEntryLink(fragmentEntryLinkId) {
        var _this = this;

        if (!this._dirty) {
          this._dirty = true;
          var formData = new FormData();
          formData.append("".concat(this.portletNamespace, "fragmentEntryLinkId"), fragmentEntryLinkId);
          fetch(this.deleteFragmentEntryLinkURL, {
            body: formData,
            credentials: 'include',
            method: 'POST'
          }).then(function () {
            _this._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());
            _this._dirty = false;
          });
        }
      }
      /**
       * Fetches a FragmentEntryLink content from the fragment ID and
       * fragmentEntryLink ID, returns a promise that resolves into it's content.
       * @param {!string} fragmentEntryLinkId
       * @return {Promise<string>}
       * @review
       */

    }, {
      key: "_fetchFragmentContent",
      value: function _fetchFragmentContent(fragmentEntryLinkId) {
        var formData = new FormData();
        formData.append("".concat(this.portletNamespace, "fragmentEntryLinkId"), fragmentEntryLinkId);
        return fetch(this.renderFragmentEntryURL, {
          body: formData,
          credentials: 'include',
          method: 'POST'
        }).then(function (response) {
          return response.json();
        }).then(function (response) {
          return response.content;
        });
      }
      /**
       * Focus a fragmentEntryLink for a given ID
       * @param {string} fragmentEntryLinkId
       * @review
       */

    }, {
      key: "_focusFragmentEntryLink",
      value: function _focusFragmentEntryLink(fragmentEntryLinkId) {
        this.refs.fragmentsEditorRender.focusFragmentEntryLink(fragmentEntryLinkId);
      }
      /**
       * Gets all editable values in the current fragment
       * @returns Array<Object>
       * @private
       * @review
       */

    }, {
      key: "_getEditableValues",
      value: function _getEditableValues() {
        var _this2 = this;

        return this.fragmentEntryLinks.map(function (fragmentEntryLink) {
          var component = _this2._getFragmentEntryLinkComponent(fragmentEntryLink.fragmentEntryLinkId);

          return component ? component.getEditableValues() : null;
        }).filter(function (editableValues) {
          return editableValues;
        });
      }
      /**
       * Returns a FragmentEntryLink instance for a fragmentEntryLinkId
       * @param {string} fragmentEntryLinkId
       * @private
       * @return {FragmentEntryLink}
       * @review
       */

    }, {
      key: "_getFragmentEntryLinkComponent",
      value: function _getFragmentEntryLinkComponent(fragmentEntryLinkId) {
        return this.refs.fragmentsEditorRender.refs["fragmentEntryLink_".concat(fragmentEntryLinkId)];
      }
      /**
       * Gets a fragmentEntryLink index for the given fragmentEntryLinkId
       * @param {!string} fragmentEntryLinkId
       * @private
       * @return {number} fragmentEntryLink index or -1 if it's not found
       */

    }, {
      key: "_getFragmentEntryLinkIndex",
      value: function _getFragmentEntryLinkIndex(fragmentEntryLinkId) {
        return this.fragmentEntryLinks.indexOf(this.fragmentEntryLinks.find(function (fragmentEntryLink) {
          return fragmentEntryLink.fragmentEntryLinkId === fragmentEntryLinkId;
        }));
      }
      /**
       * Gets a new FragmentEntryLink position.
       * @returns {number}
       * @private
       * @review
       */

    }, {
      key: "_getNewFragmentEntryLinkPosition",
      value: function _getNewFragmentEntryLinkPosition() {
        var position = Math.max.apply(Math, [0].concat(_toConsumableArray(this.fragmentEntryLinks.map(function (fragmentEntryLink) {
          return fragmentEntryLink.position;
        }))));
        return position + 1;
      }
      /**
       * Gets the translation status for a given set of parameters
       * @param languageIds The set of languageIds to check
       * @param editableValues The current editable values state
       * @private
       * @returns {object} A translation status object
       * @review
       */

    }, {
      key: "_getTranslationStatus",
      value: function _getTranslationStatus(languageIds, editableValues) {
        var translationKeys = editableValues.map(function (editableValue) {
          return Object.keys(editableValue).map(function (editableValueId) {
            return editableValue[editableValueId].defaultValue;
          });
        }).reduce(function (acc, val) {
          return acc.concat(val);
        }, []);
        var languageValues = languageIds.map(function (languageId) {
          var values = editableValues.map(function (editableValue) {
            return Object.keys(editableValue).map(function (editableValueId) {
              return editableValue[editableValueId][languageId];
            });
          }).reduce(function (acc, val) {
            return acc.concat(val);
          }, []).filter(function (localeValue) {
            return localeValue;
          });
          return {
            languageId: languageId,
            values: values
          };
        });
        return {
          languageValues: languageValues,
          translationKeys: translationKeys
        };
      }
      /**
       * Callback executed everytime an editable field has been changed
       * @param {{
       *   editableId: !string,
       *   fragmentEntryLinkId: !string,
       *   value: !string
       * }} data
       * @private
       * @review
       */

    }, {
      key: "_handleEditableChanged",
      value: function _handleEditableChanged(data) {
        this._setFragmentEntryLinkEditableValue(data.fragmentEntryLinkId, data.editableId, _defineProperty({}, this.languageId || 'defaultValue', data.value));
      }
      /**
       * Callback executed when a fragment entry of a collection is clicked.
       * It receives fragmentEntryId and fragmentName as event data.
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentEntryClick",
      value: function _handleFragmentEntryClick(event) {
        var _this3 = this;

        if (!this._dirty) {
          this._dirty = true;
          var formData = new FormData();

          var position = this._getNewFragmentEntryLinkPosition();

          formData.append("".concat(this.portletNamespace, "fragmentId"), event.fragmentEntryId);
          formData.append("".concat(this.portletNamespace, "classNameId"), this.classNameId);
          formData.append("".concat(this.portletNamespace, "classPK"), this.classPK);
          formData.append("".concat(this.portletNamespace, "position"), position);
          fetch(this.addFragmentEntryLinkURL, {
            body: formData,
            credentials: 'include',
            method: 'POST'
          }).then(function (response) {
            return response.json();
          }).then(function (response) {
            if (!response.fragmentEntryLinkId) {
              throw new Error();
            }

            _this3.fragmentEntryLinks = [].concat(_toConsumableArray(_this3.fragmentEntryLinks), [{
              config: {},
              content: '',
              editableValues: JSON.parse(response.editableValues),
              fragmentEntryId: event.fragmentEntryId,
              fragmentEntryLinkId: response.fragmentEntryLinkId,
              name: event.fragmentName,
              position: position
            }]);

            _this3._focusFragmentEntryLink(response.fragmentEntryLinkId);

            return _this3._fetchFragmentContent(response.fragmentEntryLinkId).then(function (content) {
              var index = _this3._getFragmentEntryLinkIndex(response.fragmentEntryLinkId);

              if (index !== -1) {
                var newFragmentEntryLinks = _toConsumableArray(_this3.fragmentEntryLinks);

                var newFragmentEntryLink = Object.assign({}, newFragmentEntryLinks[index], {
                  content: content
                });
                newFragmentEntryLinks[index] = newFragmentEntryLink;
                _this3.fragmentEntryLinks = newFragmentEntryLinks;
              }
            }).then(function () {
              _this3._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());
              _this3._dirty = false;

              if (_this3.refs.sidebar) {
                _this3.refs.sidebar.toggleAddedTab(true);
              }

              _this3._focusFragmentEntryLink(response.fragmentEntryLinkId);
            });
          });
        }
      }
      /**
       * Moves a fragment one position onto the specified direction.
       * @param {!{
       *   direction: !number,
       *   fragmentEntryLinkId: !string
       * }} data
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentMove",
      value: function _handleFragmentMove(data) {
        var _this4 = this;

        var direction = data.direction;

        var index = this._getFragmentEntryLinkIndex(data.fragmentEntryLinkId);

        if (direction === _FragmentEntryLink["default"].MOVE_DIRECTIONS.DOWN && index < this.fragmentEntryLinks.length - 1 || direction === _FragmentEntryLink["default"].MOVE_DIRECTIONS.UP && index > 0) {
          var formData = new FormData();
          formData.append("".concat(this.portletNamespace, "fragmentEntryLinkId1"), this.fragmentEntryLinks[index].fragmentEntryLinkId);
          formData.append("".concat(this.portletNamespace, "fragmentEntryLinkId2"), this.fragmentEntryLinks[index + direction].fragmentEntryLinkId);
          fetch(this.updateFragmentEntryLinksURL, {
            body: formData,
            credentials: 'include',
            method: 'POST'
          }).then(function () {
            _this4._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());
            _this4._dirty = false;
          });
          this.fragmentEntryLinks = this._swapListElements(Array.prototype.slice.call(this.fragmentEntryLinks), index, index + direction);
        }
      }
      /**
       * Removes a fragment from the fragment list. The fragment to
       * be removed should be specified inside the event as fragmentEntryLinkId
       * @param {!{
       *   fragmentEntryLinkId: !string
       * }} data
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentRemove",
      value: function _handleFragmentRemove(data) {
        var index = this._getFragmentEntryLinkIndex(data.fragmentEntryLinkId);

        if (index !== -1) {
          this.fragmentEntryLinks = [].concat(_toConsumableArray(this.fragmentEntryLinks.slice(0, index)), _toConsumableArray(this.fragmentEntryLinks.slice(index + 1)));

          if (this.fragmentEntryLinks.length === 0 && this.refs.sidebar) {
            this.refs.sidebar.toggleAddedTab(false);
          }

          this._translationStatus = this._getTranslationStatus(Object.keys(this.availableLanguages).filter(function (languageId) {
            return languageId !== '_INJECTED_DATA_';
          }), this._getEditableValues());

          this._deleteFragmentEntryLink(data.fragmentEntryLinkId);
        }
      }
      /**
       * Callback executed when the sidebar should be hidden
       * @private
       * @review
       */

    }, {
      key: "_handleHideContextualSidebar",
      value: function _handleHideContextualSidebar() {
        this._contextualSidebarVisible = false;
      }
      /**
       * Callback executed when a mappeable fragment has been clicked
       * @param {!{ fragmentEntryLinkId: !string, editableId: !string }} event
       * @private
       * @review
       */

    }, {
      key: "_handleMappeableFieldClicked",
      value: function _handleMappeableFieldClicked(event) {
        this._selectMappingDialogEditableId = event.editableId;
        this._selectMappingDialogEditableType = event.editableType;
        this._selectMappingDialogFragmentEntryLinkId = event.fragmentEntryLinkId;
        this._selectMappingDialogMappedFieldId = event.mappedFieldId;

        if (this.selectedMappingTypes && this.selectedMappingTypes.type) {
          this._selectMappingDialogVisible = true;
        } else {
          this._handleSelectAssetTypeButtonClick();
        }
      }
      /**
       * Callback executed when a mappeable field has been selected for the
       * given editable.
       * @param {!{
       *   editableId: !string,
       *   fragmentEntryLinkId: !string,
       *   key: !string
       * }} event
       * @private
       */

    }, {
      key: "_handleMappeableFieldSelected",
      value: function _handleMappeableFieldSelected(event) {
        this._setFragmentEntryLinkEditableValue(event.fragmentEntryLinkId, event.editableId, {
          mappedField: event.key
        });
      }
      /**
       * Callback executed when a mapping type has selected
       * @param {{
       * 	 mappingTypes: {
       *     subtype: {
       *   	  id: !string,
       *   	  label: !string
       *     },
       *     type: {
       *   	  id: !string,
       *   	  label: !string
       *     }
       * 	 }
       * }} event
       * @private
       * @review
       */

    }, {
      key: "_handleMappingTypeSelected",
      value: function _handleMappingTypeSelected(event) {
        this.selectedMappingTypes = event.mappingTypes;

        if (this._selectMappingDialogFragmentEntryLinkId && this._selectMappingDialogEditableId) {
          this._selectMappingDialogVisible = true;
        }
      }
      /**
       * Callback executed when the SelectMappingTypeDialog should be shown
       * @review
       */

    }, {
      key: "_handleSelectAssetTypeButtonClick",
      value: function _handleSelectAssetTypeButtonClick() {
        this._selectMappingTypeDialogVisible = true;
      }
      /**
       * Callback executed when the SelectMappingDialog visibility changes
       * @param {{ newVal: boolean }} change
       * @private
       * @review
       */

    }, {
      key: "_handleSelectMappingDialogVisibleChanged",
      value: function _handleSelectMappingDialogVisibleChanged(change) {
        this._selectMappingDialogVisible = change.newVal;
      }
      /**
       * Callback executed when the SelectMappingTypeDialog visibility changes
       * @param {{ newVal: boolean }} change
       * @private
       * @review
       */

    }, {
      key: "_handleSelectMappingTypeDialogVisibleChanged",
      value: function _handleSelectMappingTypeDialogVisibleChanged(change) {
        this._selectMappingTypeDialogVisible = change.newVal;
      }
      /**
       * Callback executed when the sidebar visible state should be toggled
       * @private
       * @review
       */

    }, {
      key: "_handleToggleContextualSidebarButtonClick",
      value: function _handleToggleContextualSidebarButtonClick() {
        this._contextualSidebarVisible = !this._contextualSidebarVisible;
      }
      /**
       * Toggle highlightMapping attribute value
       * @private
       * @review
       */

    }, {
      key: "_handleToggleHighlightMapping",
      value: function _handleToggleHighlightMapping() {
        this._highlightMapping = !this._highlightMapping;
      }
      /**
       * Callback executed when the translation language has changed
       * @private
       * @param {{languageId: string}} event
       * @review
       */

    }, {
      key: "_handleTranslationLanguageChange",
      value: function _handleTranslationLanguageChange(event) {
        this.languageId = event.languageId;
      }
      /**
       * Swap the positions of two fragmentEntryLinks
       * @param {Array} list
       * @param {number} indexA
       * @param {number} indexB
       * @private
       */

    }, {
      key: "_swapListElements",
      value: function _swapListElements(list, indexA, indexB) {
        var _ref = [list[indexB], list[indexA]];
        list[indexA] = _ref[0];
        list[indexB] = _ref[1];
        return list;
      }
      /**
       * Updates the given fragmentEntryLinkId editable value without mutating
       * the fragmentEntryLinks property but creating a new array and
       * synchronizing changes with server.
       *
       * @param {!string} fragmentEntryLinkId
       * @param {!string} editableValueId
       * @param {!object} editableValueContent
       * @private
       */

    }, {
      key: "_setFragmentEntryLinkEditableValue",
      value: function _setFragmentEntryLinkEditableValue(fragmentEntryLinkId, editableValueId, editableValueContent) {
        var component = this._getFragmentEntryLinkComponent(fragmentEntryLinkId);

        var index = this._getFragmentEntryLinkIndex(fragmentEntryLinkId);

        if (component && index !== -1) {
          var newEditableValues = component.setEditableValue(editableValueId, editableValueContent);
          var newFragmentEntryLink = Object.assign({}, this.fragmentEntryLinks[index], {
            editableValues: newEditableValues
          });

          var newFragmentEntryLinks = _toConsumableArray(this.fragmentEntryLinks);

          newFragmentEntryLinks[index] = newFragmentEntryLink;
          this.fragmentEntryLinks = newFragmentEntryLinks;

          this._updateFragmentEntryLink(newFragmentEntryLink);
        }
      }
      /**
       * Sends the change of a single fragment entry link to the server and, if
       * success, sets the _dirty property to false.
       * @private
       * @review
       */

    }, {
      key: "_updateFragmentEntryLink",
      value: function _updateFragmentEntryLink(fragmentEntryLink) {
        var _this5 = this;

        if (!this._dirty) {
          this._dirty = true;
          var formData = new FormData();
          formData.append("".concat(this.portletNamespace, "fragmentEntryLinkId"), fragmentEntryLink.fragmentEntryLinkId);
          formData.append("".concat(this.portletNamespace, "editableValues"), JSON.stringify(fragmentEntryLink.editableValues));
          fetch(this.editFragmentEntryLinkURL, {
            body: formData,
            credentials: 'include',
            method: 'POST'
          }).then(function () {
            _this5._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());
            _this5._translationStatus = _this5._getTranslationStatus(Object.keys(_this5.availableLanguages).filter(function (languageId) {
              return languageId !== '_INJECTED_DATA_';
            }), _this5._getEditableValues());
            _this5._dirty = false;
          });
        }
      }
    }]);

    return FragmentsEditor;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentsEditor = FragmentsEditor;
  FragmentsEditor.STATE = {
    /**
     * URL for associating fragment entries to the underlying model.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    addFragmentEntryLinkURL: _metalState.Config.string().required(),

    /**
     * List of available languages for translation.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!object}
     */
    availableLanguages: _metalState.Config.object().required(),

    /**
     * Class name id used for storing changes.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    classNameId: _metalState.Config.string().required(),

    /**
     * Class primary key used for storing changes.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    classPK: _metalState.Config.string().required(),

    /**
     * Default configurations for AlloyEditor instances.
     * @default {}
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {object}
     */
    defaultEditorConfigurations: _metalState.Config.object().value({}),

    /**
     * Default language id.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    defaultLanguageId: _metalState.Config.string().required(),

    /**
     * URL for removing fragment entries of the underlying model.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    deleteFragmentEntryLinkURL: _metalState.Config.string().required(),

    /**
     * CSS class for the fragments drop target.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    dropTargetClass: _metalState.Config.string().value('dropTarget'),

    /**
     * URL for updating a distinct fragment entries of the editor.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    editFragmentEntryLinkURL: _metalState.Config.string().required(),

    /**
     * Available entries that can be used, organized by collections.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!Array<object>}
     */
    fragmentCollections: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      entries: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        fragmentEntryId: _metalState.Config.string().required(),
        name: _metalState.Config.string().required()
      })).required(),
      fragmentCollectionId: _metalState.Config.string().required(),
      name: _metalState.Config.string().required()
    })).required(),

    /**
     * List of fragment instances being used, the order
     * of the elements in this array defines their position.
     * @default []
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {Array<{
     *   config: Object,
     *   content: string,
     *   editableValues: Object,
     *   fragmentEntryId: !string,
     *   fragmentEntryLinkId: !string,
     *   name: !string,
     *   position: !number
     * }>}
     */
    fragmentEntryLinks: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      config: _metalState.Config.object().value({}),
      content: _metalState.Config.any().value(''),
      editableValues: _metalState.Config.object().value({}),
      fragmentEntryId: _metalState.Config.string().required(),
      fragmentEntryLinkId: _metalState.Config.string().required(),
      name: _metalState.Config.string().required(),
      position: _metalState.Config.number().required()
    })).value([]),

    /**
     * URL for obtaining the class types of an asset
     * created.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    getAssetClassTypesURL: _metalState.Config.string(),

    /**
     * URL for obtaining the asset types for which asset display pages can be
     * created.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    getAssetDisplayContributorsURL: _metalState.Config.string(),

    /**
     * Optional ID provided by the template system.
     * @default ''
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {string}
     */
    id: _metalState.Config.string().value(''),

    /**
     * Image selector url
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    imageSelectorURL: _metalState.Config.string().required(),

    /**
     * URL for getting the list of mapping fields
     * @default null
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {string}
     */
    mappingFieldsURL: _metalState.Config.string().value(null),

    /**
     * Currently selected language id.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    languageId: _metalState.Config.string().required(),

    /**
     * Portlet namespace needed for prefixing form inputs
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     *
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    publishLayoutPageTemplateEntryURL: _metalState.Config.string(),

    /**
     * URL for redirect.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    redirectURL: _metalState.Config.string().required(),

    /**
     * URL for getting a fragment content.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    renderFragmentEntryURL: _metalState.Config.string().required(),

    /**
     * Selected mapping types
     * @default {}
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {{
     *   subtype: {
     *   	id: !string,
     *   	label: !string
     *   },
     *   type: {
     *   	id: !string,
     *   	label: !string
     *   }
     * }}
     */
    selectedMappingTypes: _metalState.Config.shapeOf({
      subtype: _metalState.Config.shapeOf({
        id: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      }),
      type: _metalState.Config.shapeOf({
        id: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      })
    }).value({}),

    /**
     * Path of the available icons.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * URL for swapping to fragmentEntryLinks.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    updateFragmentEntryLinksURL: _metalState.Config.string().required(),

    /**
     * URL for updating the asset type associated to a template.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    updateLayoutPageTemplateEntryAssetTypeURL: _metalState.Config.string(),

    /**
     * Allow opening/closing contextual sidebar
     * @default true
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {boolean}
     */
    _contextualSidebarVisible: _metalState.Config.bool().internal().value(true),

    /**
     * When true, it indicates that are changes pending to save.
     * @default false
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {boolean}
     */
    _dirty: _metalState.Config.bool().internal().value(false),

    /**
     * If true, editable values should be highlighted.
     * @default false
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {boolean}
     */
    _highlightMapping: _metalState.Config.bool().internal().value(false),

    /**
     * Last data when the autosave has been executed.
     * @default ''
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @type {string}
     */
    _lastSaveDate: _metalState.Config.string().internal().value(''),

    /**
     * Editable type of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {string}
     */
    _selectMappingDialogEditableType: _metalState.Config.string().internal().value(''),

    /**
     * EditableId of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {string}
     */
    _selectMappingDialogEditableId: _metalState.Config.string().internal().value(''),

    /**
     * FragmentEntryLinkId of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {string}
     */
    _selectMappingDialogFragmentEntryLinkId: _metalState.Config.string().internal().value(''),

    /**
     * Mapped field ID of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {string}
     */
    _selectMappingDialogMappedFieldId: _metalState.Config.string().internal().value(''),

    /**
     * Flag indicating if the SelectMappingDialog should be shown
     * @default false
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {boolean}
     */
    _selectMappingDialogVisible: _metalState.Config.bool().internal().value(false),

    /**
     * Flag indicating if the SelectMappingTypeDialog should be shown
     * @default false
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {boolean}
     */
    _selectMappingTypeDialogVisible: _metalState.Config.bool().internal().value(false)
  };

  _metalSoy["default"].register(FragmentsEditor, _FragmentsEditor["default"]);

  var _default = FragmentsEditor;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentsEditor.es.js.map
});
//# sourceMappingURL=FragmentsEditor.es.js.map