Liferay.Loader.define("layout-admin-web@2.0.112/js/fragments_editor/dialogs/SelectMappingTypeDialog.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', 'frontend-js-web/liferay/compat/modal/Modal.es', './SelectMappingTypeDialog.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SelectMappingTypeDialog = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("frontend-js-web/liferay/compat/modal/Modal.es");

  var _SelectMappingTypeDialog = _interopRequireDefault(require("./SelectMappingTypeDialog.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SelectMappingTypeDialog
   */
  var SelectMappingTypeDialog =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(SelectMappingTypeDialog, _PortletBase);

    function SelectMappingTypeDialog() {
      _classCallCheck(this, SelectMappingTypeDialog);

      return _possibleConstructorReturn(this, _getPrototypeOf(SelectMappingTypeDialog).apply(this, arguments));
    }

    _createClass(SelectMappingTypeDialog, [{
      key: "rendered",

      /**
       * @inheritDoc
       * @review
       */
      value: function rendered() {
        if (this.visible && !this._mappingTypes) {
          this._loadMappingTypes();
        }

        if (this._mappingTypes && this._mappingTypes.length === 1 && !this._selectedMappingTypeId) {
          this._handleMappingTypeSelectChange();
        }

        if (this._mappingSubtypes && this._mappingSubtypes.length === 1 && !this._selectedMappingSubtypeId) {
          this._handleMappingSubtypeSelectChange();
        }
      }
      /**
       * Emits a mappingTypeSelected event with the corresponding labels
       * @review
       */

    }, {
      key: "_emitSelectedMappingLabels",
      value: function _emitSelectedMappingLabels() {
        var _this = this;

        var mappingTypes = {};

        var subtype = this._mappingSubtypes.find(function (subtype) {
          return subtype.id === _this._selectedMappingSubtypeId;
        });

        var type = this._mappingTypes.find(function (type) {
          return type.id === _this._selectedMappingTypeId;
        });

        if (subtype) {
          mappingTypes.subtype = {
            id: this._selectedMappingSubtypeId,
            label: subtype.label
          };
        }

        if (type) {
          mappingTypes.type = {
            id: this._selectedMappingTypeId,
            label: type.label
          };
        }

        this.emit('mappingTypeSelected', {
          mappingTypes: mappingTypes
        });
      }
      /**
       * Close asset type selection dialog
       * @private
       * @review
       */

    }, {
      key: "_handleCloseButtonClick",
      value: function _handleCloseButtonClick() {
        this.visible = false;
      }
      /**
       * Callback executed when a mapping subtype has been selected.
       * @private
       * @review
       */

    }, {
      key: "_handleMappingSubtypeSelectChange",
      value: function _handleMappingSubtypeSelectChange() {
        var selectInput = this.refs.modal.refs.selectMappingSubtype;

        var mappingSubtype = this._mappingSubtypes.find(function (mappingSubtype) {
          return mappingSubtype.id === selectInput.value;
        });

        this._selectedMappingSubtypeId = mappingSubtype.id;
      }
      /**
       * Callback executed when a mapping type has been selected.
       * It loads a mapping subtype list if necessary.
       * @private
       * @review
       */

    }, {
      key: "_handleMappingTypeSelectChange",
      value: function _handleMappingTypeSelectChange() {
        var selectInput = this.refs.modal.refs.selectMappingType;

        var mappingType = this._mappingTypes.find(function (mappingType) {
          return mappingType.id === selectInput.value;
        });

        this._selectedMappingTypeId = mappingType.id;
        this._mappingSubtypes = [];

        this._loadMappingSubtypes();
      }
      /**
       * Sends selected mapping type and subtype to the server
       * and closes this dialog.
       * @private
       * @review
       */

    }, {
      key: "_handleSubmitButtonClick",
      value: function _handleSubmitButtonClick() {
        var _this2 = this;

        this._savingChanges = true;
        return this.fetch(this.updateLayoutPageTemplateEntryAssetTypeURL, {
          classNameId: this._selectedMappingTypeId,
          classPK: this.classPK,
          classTypeId: this._selectedMappingSubtypeId
        }).then(function (response) {
          return response.json();
        }).then(function () {
          _this2._emitSelectedMappingLabels();

          _this2.visible = false;
        });
      }
      /**
       * Change asset type selection dialog visibility.
       * @private
       * @review
       */

    }, {
      key: "_handleVisibleChanged",
      value: function _handleVisibleChanged(change) {
        if (this.visible !== change.newVal) {
          this.visible = change.newVal;
        }

        if (!change.newVal) {
          this._mappingSubtypes = [];
          this._mappingTypes = [];
          this._savingChanges = false;
          this._selectedMappingTypeId = '';
          this._selectedMappingSubtypeId = '';
        }
      }
      /**
       * Load a list of mapping subtypes.
       * @private
       * @review
       */

    }, {
      key: "_loadMappingSubtypes",
      value: function _loadMappingSubtypes() {
        var _this3 = this;

        this._mappingSubtypes = null;
        return this.fetch(this.getAssetClassTypesURL, {
          classNameId: this._selectedMappingTypeId
        }).then(function (response) {
          return response.json();
        }).then(function (response) {
          _this3._mappingSubtypes = response;
        });
      }
      /**
       * Load a list of mapping types.
       * @private
       * @review
       */

    }, {
      key: "_loadMappingTypes",
      value: function _loadMappingTypes() {
        var _this4 = this;

        return this.fetch(this.getAssetDisplayContributorsURL, {}).then(function (response) {
          return response.json();
        }).then(function (response) {
          _this4._mappingTypes = response;
        });
      }
    }]);

    return SelectMappingTypeDialog;
  }(_PortletBase2["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SelectMappingTypeDialog = SelectMappingTypeDialog;
  SelectMappingTypeDialog.STATE = {
    /**
     * Class primary key used for storing changes.
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!string}
     */
    classPK: _metalState.Config.string().required(),

    /**
     * URL for obtaining the asset types for which asset display pages can be
     * created.
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!string}
     */
    getAssetClassTypesURL: _metalState.Config.string().required(),

    /**
     * URL for obtaining the asset types for which asset display pages can be
     * created.
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!string}
     */
    getAssetDisplayContributorsURL: _metalState.Config.string().required(),

    /**
     * Portlet namespace needed for prefixing form inputs
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Path of the available icons.
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * URL for updating the asset type associated to a template.
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!string}
     */
    updateLayoutPageTemplateEntryAssetTypeURL: _metalState.Config.string().required(),

    /**
     * Whether to show the mapping dialog or not
     * @default undefined
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @review
     * @type {!boolean}
     */
    visible: _metalState.Config.bool().required(),

    /**
     * List of available mapping types
     * @default null
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @private
     * @review
     * @type {Array<{
     *   id: !string,
     *   label: !string
     * }>}
     */
    _mappingTypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    })).value(null),

    /**
     * List of available mapping subtypes
     * @default null
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @private
     * @review
     * @type {Array<{
     *   id: !string,
     *   label: !string
     * }>}
     */
    _mappingSubtypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    })).value([]),

    /**
     * Flag indicating if changes are being sent to the server
     * @default false
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @private
     * @review
     * @type {boolean}
     */
    _savingChanges: _metalState.Config.bool().internal().value(false),

    /**
     * String with the selected mapping type id
     * @default ''
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @private
     * @review
     * @type {string}
     */
    _selectedMappingTypeId: _metalState.Config.string().internal().value(''),

    /**
     * String with the selected mapping subtype id
     * @default ''
     * @instance
     * @memberOf SelectMappingTypeDialog
     * @private
     * @review
     * @type {string}
     */
    _selectedMappingSubtypeId: _metalState.Config.string().internal().value('')
  };

  _metalSoy["default"].register(SelectMappingTypeDialog, _SelectMappingTypeDialog["default"]);

  var _default = SelectMappingTypeDialog;
  exports["default"] = _default;
  //# sourceMappingURL=SelectMappingTypeDialog.es.js.map
});
//# sourceMappingURL=SelectMappingTypeDialog.es.js.map