Liferay.Loader.define("layout-admin-web@2.0.112/js/fragments_editor/fragment_entry_link/FragmentEditableField.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-soy', './FragmentEditableFieldTooltip.es', '../fragment_processors/FragmentProcessors.es', '../fragment_processors/EditableTextFragmentProcessor.es', './FragmentEditableField.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEditableField = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metal = require("frontend-js-metal-web$metal");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("./FragmentEditableFieldTooltip.es");

  var _FragmentProcessors = _interopRequireDefault(require("../fragment_processors/FragmentProcessors.es"));

  var _EditableTextFragmentProcessor = require("../fragment_processors/EditableTextFragmentProcessor.es");

  var _FragmentEditableField = _interopRequireDefault(require("./FragmentEditableField.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Buttons rendered inside the tooltip
   * @review
   */
  var TOOLTIP_BUTTONS = {
    edit: {
      id: 'edit',
      label: Liferay.Language.get('edit')
    },
    map: {
      id: 'map',
      label: Liferay.Language.get('map[relational]')
    },
    selectImage: {
      id: 'selectImage',
      label: Liferay.Language.get('select-image')
    }
  };

  var FragmentEditableField =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEditableField, _Component);

    function FragmentEditableField() {
      _classCallCheck(this, FragmentEditableField);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEditableField).apply(this, arguments));
    }

    _createClass(FragmentEditableField, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._handleBeforeNavigate = this._handleBeforeNavigate.bind(this);
        this._handleEditableChanged = this._handleEditableChanged.bind(this);
        this._handleEditableDestroyed = this._handleEditableDestroyed.bind(this);
        this._beforeNavigateHandler = Liferay.on('beforeNavigate', this._handleBeforeNavigate);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._destroyProcessors();
      }
      /**
       * @inheritDoc
       * @param {!object} state
       * @returns {object}
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var translatedContent = this.editableValues[this.languageId] || this.editableValues[this.defaultLanguageId] || this.editableValues.defaultValue;

        var content = _metalSoy["default"].toIncDom(translatedContent || this.content);

        if (this.type === 'image' && translatedContent) {
          var tempContent = document.createElement('div');
          tempContent.innerHTML = this.content;
          var tempImage = tempContent.querySelector('img');

          if (tempImage) {
            tempImage.src = translatedContent;
          }

          content = _metalSoy["default"].toIncDom(tempContent.innerHTML);
        }

        var _tooltipButtons = this._getTooltipButtons(this.type);

        return _metal.object.mixin({}, state, {
          content: content,
          _tooltipButtons: _tooltipButtons
        });
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this._showEditor) {
          this._showEditor = false;

          this._enableEditor();
        }

        if (this.refs.editable !== this._tooltipAlignElement) {
          this._tooltipAlignElement = this.refs.editable;
        }
      }
      /**
       * @inheritDoc
       * @param changes
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return !!changes._showTooltip;
      }
      /**
       * Call destroy method on all processors
       * @private
       * @review
       */

    }, {
      key: "_destroyProcessors",
      value: function _destroyProcessors() {
        Object.values(_FragmentProcessors["default"]).forEach(function (fragmentProcessor) {
          return fragmentProcessor.destroy();
        });
      }
      /**
       * Enables the corresponding editor
       * @private
       * @review
       */

    }, {
      key: "_enableEditor",
      value: function _enableEditor() {
        var _ref = _FragmentProcessors["default"][this.type] || _FragmentProcessors["default"].fallback,
            init = _ref.init;

        init(this.refs.editable, this.fragmentEntryLinkId, this.portletNamespace, this.processorsOptions, this._handleEditableChanged, this._handleEditableDestroyed);
        this._editing = true;
      }
      /**
       * Get the list of buttons that should be rendered inside the tooltip
       * @param {string} editableType
       * @private
       * @review
       */

    }, {
      key: "_getTooltipButtons",
      value: function _getTooltipButtons(editableType) {
        var _tooltipButtons = [];

        if (this.showMapping) {
          _tooltipButtons.push(TOOLTIP_BUTTONS.map);
        }

        if (editableType === 'image') {
          _tooltipButtons.push(TOOLTIP_BUTTONS.selectImage);
        } else {
          _tooltipButtons.push(TOOLTIP_BUTTONS.edit);
        }

        return _tooltipButtons;
      }
      /**
       * Handle beforeNavigate SPA event
       * and destroy all existing processors.
       * @private
       * @review
       */

    }, {
      key: "_handleBeforeNavigate",
      value: function _handleBeforeNavigate() {
        if (this._beforeNavigateHandler) {
          this._beforeNavigateHandler.detach();

          this._beforeNavigateHandler = null;
        }

        this._destroyProcessors();
      }
      /**
       * Handle editable click event
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleEditableClick",
      value: function _handleEditableClick(event) {
        event.preventDefault();
        event.stopPropagation();

        if (this._tooltipLabel) {
          this._showTooltip = false;
          this._tooltipLabel = '';
        }

        if (this.showMapping && !this._editing || (0, _EditableTextFragmentProcessor.getActiveEditableElement)() !== this.refs.editable) {
          if (!this.showMapping) {
            this._showTooltip = false;

            this._enableEditor();
          } else {
            this._showTooltip = !this._showTooltip;
          }

          if (!this._showTooltip) {
            this._handleEditableMouseEnter();
          }
        }
      }
      /**
       * Callback executed when the exiting editor is destroyed
       * @private
       * @review
       */

    }, {
      key: "_handleEditableDestroyed",
      value: function _handleEditableDestroyed() {
        this._editing = false;
      }
      /**
       * Callback executed when cursor enters editable element
       * @private
       * @review
       */

    }, {
      key: "_handleEditableMouseEnter",
      value: function _handleEditableMouseEnter() {
        if (!this._editing && this.editableValues.mappedField && !this._showTooltip) {
          this._showTooltip = true;
          this._tooltipLabel = this.editableValues.mappedField;
        }
      }
      /**
       * Callback executed when cursor leaves editable element
       * @private
       * @review
       */

    }, {
      key: "_handleEditableMouseLeave",
      value: function _handleEditableMouseLeave() {
        if (this._tooltipLabel && !this._editing) {
          this._showTooltip = false;
          this._tooltipLabel = '';
        }
      }
      /**
       * Handle image editor select event
       * @param {string} newValue
       * @private
       */

    }, {
      key: "_handleEditableChanged",
      value: function _handleEditableChanged(newValue) {
        this.emit('editableChanged', {
          editableId: this.editableId,
          value: newValue
        });
      }
      /**
       * Handle clicks outside tooltip element
       * @private
       * @review
       */

    }, {
      key: "_handleOutsideTooltipClick",
      value: function _handleOutsideTooltipClick() {
        this._showTooltip = false;
      }
      /**
       * Handle tooltip button click event
       * @param {{buttonId: string}} event
       * @private
       * @review
       */

    }, {
      key: "_handleTooltipButtonClick",
      value: function _handleTooltipButtonClick(event) {
        var buttonId = event.buttonId;

        if (buttonId === TOOLTIP_BUTTONS.edit.id || buttonId === TOOLTIP_BUTTONS.selectImage.id) {
          this._showEditor = true;
        } else if (buttonId === TOOLTIP_BUTTONS.map.id) {
          this.emit('mapButtonClicked', {
            editableId: this.editableId,
            editableType: this.type,
            mappedFieldId: this.editableValues.mappedField || ''
          });
        }

        this._showTooltip = false;
      }
    }]);

    return FragmentEditableField;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentEditableField = FragmentEditableField;
  FragmentEditableField.STATE = {
    /**
     * Editable content to be rendered
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    content: _metalState.Config.string().required(),

    /**
     * Default language id.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    defaultLanguageId: _metalState.Config.string().required(),

    /**
     * Editable ID
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    editableId: _metalState.Config.string().required(),

    /**
     * Editable values
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * Currently selected language id.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    languageId: _metalState.Config.string().required(),

    /**
     * Portlet namespace
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Set of options that are sent to the processors.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!object}
     */
    processorsOptions: _metalState.Config.object().required(),

    /**
     * Editable type
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    type: _metalState.Config.string().required(),

    /**
     * True if mapping is activated
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!boolean}
     */
    showMapping: _metalState.Config.bool().required(),

    /**
     * Flag indicating if the editable editor is active.
     * @default false
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {boolean}
     */
    _editing: _metalState.Config.internal().bool().value(false),

    /**
     * Flag indicating if the editable editor should be enabled.
     * @default false
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {boolean}
     */
    _showEditor: _metalState.Config.internal().bool().value(false),

    /**
     * Flag indicating if the click tooltip should be visible.
     * @default false
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {boolean}
     */
    _showTooltip: _metalState.Config.internal().bool().value(false),

    /**
     * Reference element used for aligning the tooltip
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {HTMLElement}
     */
    _tooltipAlignElement: _metalState.Config.internal().object(),

    /**
     * List of buttons rendered inside the tooltip
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {Array<{
     *   id: !string,
     *   label: !string
     * }>}
     */
    _tooltipButtons: _metalState.Config.internal().arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    })),

    /**
     * Label shown inside editable's tooltip instead of action buttons
     * @default ''
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {string}
     */
    _tooltipLabel: _metalState.Config.internal().string().value('')
  };

  _metalSoy["default"].register(FragmentEditableField, _FragmentEditableField["default"]);

  var _default = FragmentEditableField;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEditableField.es.js.map
});
//# sourceMappingURL=FragmentEditableField.es.js.map