Liferay.Loader.define("layout-admin-web@2.0.112/js/fragments_editor/fragment_entry_link/FragmentEntryLink.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal', './FragmentEditableField.es', './FragmentEntryLink.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEntryLink = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metal = require("frontend-js-metal-web$metal");

  var _FragmentEditableField = _interopRequireDefault(require("./FragmentEditableField.es"));

  var _FragmentEntryLink = _interopRequireDefault(require("./FragmentEntryLink.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var ARROW_DOWN_KEYCODE = 40;
  var ARROW_UP_KEYCODE = 38;
  var EDITABLE_FRAGMENT_ENTRY_PROCESSOR = 'com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor';
  /**
   * FragmentEntryLink
   * @review
   */

  var FragmentEntryLink =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEntryLink, _Component);

    function FragmentEntryLink() {
      _classCallCheck(this, FragmentEntryLink);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEntryLink).apply(this, arguments));
    }

    _createClass(FragmentEntryLink, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._handleEditableChanged = this._handleEditableChanged.bind(this);
        this._handleMapButtonClick = this._handleMapButtonClick.bind(this);
        this._updateEditableStatus = this._updateEditableStatus.bind(this);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._destroyEditables();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        return Object.assign({}, state, {
          content: this.content ? _metalSoy["default"].toIncDom(this.content) : null
        });
      }
      /**
       * Handle content changed
       * @inheritDoc
       * @param {string} newContent
       * @review
       */

    }, {
      key: "syncContent",
      value: function syncContent(newContent) {
        if (newContent) {
          this._renderContent(newContent);
        }
      }
      /**
       * Handle editableValues changed
       * @inheritDoc
       * @param {object} newEditableValues
       * @review
       */

    }, {
      key: "syncEditableValues",
      value: function syncEditableValues(newEditableValues) {
        if (this._editables) {
          this._editables.forEach(function (editable) {
            var editableValues = newEditableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR] && newEditableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.editableId] ? newEditableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.editableId] : {
              defaultValue: editable.content
            };
            editable.editableValues = editableValues;
          });
        }
      }
      /**
       * Callback executed when languageId property has changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncLanguageId",
      value: function syncLanguageId() {
        if (this.content) {
          this._renderContent(this.content);
        }
      }
      /**
       * Returns the given editable value
       */

    }, {
      key: "getEditableValue",
      value: function getEditableValue(editableId) {
        return this.getEditableValues()[editableId];
      }
      /**
       * Returns the editable values property content
       * @return {object}
       * @review
       */

    }, {
      key: "getEditableValues",
      value: function getEditableValues() {
        return this.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR];
      }
      /**
       * Returns a new object with the updated editableId
       * @param {string} editableId
       * @param {object} content
       */

    }, {
      key: "setEditableValue",
      value: function setEditableValue(editableId, content) {
        var editableValues = this.getEditableValues();
        var editableValue = this.getEditableValue(editableId);
        editableValues[editableId] = _metal.object.mixin({}, editableValue, content);

        this._update(this.languageId, this.defaultLanguageId, [this._updateEditableStatus]);

        return _defineProperty({}, EDITABLE_FRAGMENT_ENTRY_PROCESSOR, editableValues);
      }
      /**
       * Create instances of FragmentEditableField for each editable.
       */

    }, {
      key: "_createEditables",
      value: function _createEditables() {
        var _this = this;

        this._destroyEditables();

        this._editables = _toConsumableArray(this.refs.content.querySelectorAll('lfr-editable')).map(function (editable) {
          var editableValues = _this.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR] && _this.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.id] ? _this.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.id] : {
            defaultValue: editable.innerHTML
          };

          var defaultEditorConfiguration = _this.defaultEditorConfigurations[editable.getAttribute('type')] || _this.defaultEditorConfigurations.text;

          return new _FragmentEditableField["default"]({
            content: editable.innerHTML,
            defaultLanguageId: _this.defaultLanguageId,
            editableId: editable.id,
            editableValues: editableValues,
            element: editable,
            events: {
              editableChanged: _this._handleEditableChanged,
              mapButtonClicked: _this._handleMapButtonClick
            },
            fragmentEntryLinkId: _this.fragmentEntryLinkId,
            languageId: _this.languageId,
            portletNamespace: _this.portletNamespace,
            processorsOptions: {
              defaultEditorConfiguration: defaultEditorConfiguration,
              imageSelectorURL: _this.imageSelectorURL
            },
            showMapping: _this.showMapping,
            type: editable.getAttribute('type')
          });
        });
      }
      /**
       * Destroy existing FragmentEditableField instances.
       */

    }, {
      key: "_destroyEditables",
      value: function _destroyEditables() {
        if (this._editables) {
          this._editables.forEach(function (editable) {
            return editable.dispose();
          });

          this._editables = [];
        }
      }
      /**
       * Emits a move event with the fragmentEntryLinkId and the direction.
       * @param {!number} direction
       * @private
       */

    }, {
      key: "_emitMoveEvent",
      value: function _emitMoveEvent(direction) {
        this.emit('move', {
          direction: direction,
          fragmentEntryLinkId: this.fragmentEntryLinkId
        });
      }
      /**
       * Handle a changed editable event
       * @param {{editableId: string, value: string}} event
       * @private
       * @review
       */

    }, {
      key: "_handleEditableChanged",
      value: function _handleEditableChanged(event) {
        this.emit('editableChanged', {
          editableId: event.editableId,
          fragmentEntryLinkId: this.fragmentEntryLinkId,
          value: event.value
        });
      }
      /**
       * Handle fragment keyup event so it can emit when it
       * should be moved or selected.
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentKeyUp",
      value: function _handleFragmentKeyUp(event) {
        if (document.activeElement === this.refs.fragmentEntryLinkWrapper) {
          switch (event.which) {
            case ARROW_DOWN_KEYCODE:
              this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.DOWN);

              break;

            case ARROW_UP_KEYCODE:
              this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.UP);

              break;
          }
        }
      }
      /**
       * Callback executed when the fragment move down button is clicked.
       * It emits a 'moveDown' event with
       * the FragmentEntryLink id.
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentMoveDownButtonClick",
      value: function _handleFragmentMoveDownButtonClick() {
        this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.DOWN);
      }
      /**
       * Callback executed when the fragment move up button is clicked.
       * It emits a 'moveUp' event with
       * the FragmentEntryLink id.
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentMoveUpButtonClick",
      value: function _handleFragmentMoveUpButtonClick() {
        this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.UP);
      }
      /**
       * Callback executed when the fragment remove button is clicked.
       * It emits a 'remove' event with
       * the FragmentEntryLink id.
       * @private
       */

    }, {
      key: "_handleFragmentRemoveButtonClick",
      value: function _handleFragmentRemoveButtonClick() {
        this.emit('remove', {
          fragmentEntryLinkId: this.fragmentEntryLinkId
        });
      }
      /**
       * Propagates mapButtonClick event.
       */

    }, {
      key: "_handleMapButtonClick",
      value: function _handleMapButtonClick(event) {
        this.emit('mappeableFieldClicked', {
          editableId: event.editableId,
          editableType: event.editableType,
          fragmentEntryLinkId: this.fragmentEntryLinkId,
          mappedFieldId: event.mappedFieldId
        });
      }
      /**
       * Renders the FragmentEntryLink content parsing with AUI
       * @param {string} content
       * @private
       * @review
       */

    }, {
      key: "_renderContent",
      value: function _renderContent(content) {
        var _this2 = this;

        if (this.refs.content) {
          AUI().use('aui-parse-content', function (A) {
            var contentNode = A.one(_this2.refs.content);
            contentNode.plug(A.Plugin.ParseContent);
            contentNode.setContent(content);

            _this2._createEditables();

            _this2._update(_this2.languageId, _this2.defaultLanguageId, [_this2._updateEditableStatus]);
          });
        }
      }
      /**
       * Runs a set of update functions through the collection of editable values
       * inside this fragment entry link.
       * @param {string} languageId The current language id
       * @param {string} defaultLanguageId The default language id
       * @param {Array<Function>} updateFunctions The set of update functions to execute for each editable value
       * @private
       * @review
       */

    }, {
      key: "_update",
      value: function _update(languageId, defaultLanguageId, updateFunctions) {
        var editableValues = this.getEditableValues();
        Object.keys(editableValues).forEach(function (editableId) {
          var editableValue = editableValues[editableId];
          var defaultValue = editableValue[defaultLanguageId] || editableValue.defaultValue;
          var mappedField = editableValue.mappedField || '';
          var value = editableValue[languageId];
          updateFunctions.forEach(function (updateFunction) {
            return updateFunction(editableId, value, defaultValue, mappedField);
          });
        });
      }
      /**
       * Flags a DOM editable section as translated or untranslated compared to
       * the stored default value for that same editable id.
       * @param {string} editableId The editable id
       * @param {string} value The value for the editable section
       * @param {string} defaultValue
       * @param {string} mappedField
       * @private
       * @review
       */

    }, {
      key: "_updateEditableStatus",
      value: function _updateEditableStatus(editableId, value, defaultValue, mappedField) {
        var element = this.element.querySelector("lfr-editable[id=\"".concat(editableId, "\"]"));

        if (element) {
          (0, _metalDom.removeClasses)(element, 'mapped', 'translated', 'unmapped', 'untranslated');

          (0, _metalDom.addClasses)(element, !!mappedField ? 'mapped' : 'unmapped');
          (0, _metalDom.addClasses)(element, !mappedField && !!value ? 'translated' : 'untranslated');
        }
      }
    }]);

    return FragmentEntryLink;
  }(_metalComponent["default"]);
  /**
   * Directions where a fragment can be moved to
   * @review
   * @static
   * @type {!object}
   */

  exports.FragmentEntryLink = FragmentEntryLink;
  FragmentEntryLink.MOVE_DIRECTIONS = {
    DOWN: 1,
    UP: -1
  };
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  FragmentEntryLink.STATE = {
    /**
     * Fragment content to be rendered
     * @default ''
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {string}
     */
    content: _metalState.Config.any().setter(function (content) {
      return !(0, _metal.isFunction)(content) && (0, _metal.isObject)(content) ? content.value.content : content;
    }).value(''),

    /**
     * Default configurations for AlloyEditor instances.
     * @default {}
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {object}
     */
    defaultEditorConfigurations: _metalState.Config.object().value({}),

    /**
     * Default language id.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    defaultLanguageId: _metalState.Config.string().required(),

    /**
     * Editable values that should be used instead of the default ones
     * inside editable fields.
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!Object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * Image selector url
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    imageSelectorURL: _metalState.Config.string().required(),

    /**
     * Currently selected language id.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    languageId: _metalState.Config.string().required(),

    /**
     * Fragment name
     * @default ''
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {string}
     */
    name: _metalState.Config.string().value(''),

    /**
     * Selected mapping type label
     * @default {}
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {{
     *   subtype: {
     *   	id: !string,
     *   	label: !string
     *   },
     *   type: {
     *   	id: !string,
     *   	label: !string
     *   }
     * }}
     */
    selectedMappingTypes: _metalState.Config.shapeOf({
      subtype: _metalState.Config.shapeOf({
        id: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      }),
      type: _metalState.Config.shapeOf({
        id: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      })
    }).value({}),

    /**
     * Shows FragmentEntryLink control toolbar
     * @default true
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!bool}
     */
    showControlBar: _metalState.Config.bool().value(true),

    /**
     * If true, asset mapping is enabled
     * @default false
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {bool}
     */
    showMapping: _metalState.Config.bool().value(false),

    /**
     * Portlet namespace needed for prefixing Alloy Editor instances
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Fragment spritemap
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };

  _metalSoy["default"].register(FragmentEntryLink, _FragmentEntryLink["default"]);

  var _default = FragmentEntryLink;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEntryLink.es.js.map
});
//# sourceMappingURL=FragmentEntryLink.es.js.map