Liferay.Loader.define("layout-admin-web@2.0.112/js/fragments_editor/sidebar/FragmentsEditorSidebar.es", ['module', 'exports', 'require', 'frontend-taglib/contextual_sidebar/ContextualSidebar.es', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-soy', './SidebarAddedFragments.es', './SidebarAvailableFragments.es', './SidebarMapping.es', './FragmentsEditorSidebar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentsEditorSidebar = void 0;

  require("frontend-taglib/contextual_sidebar/ContextualSidebar.es");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("./SidebarAddedFragments.es");

  require("./SidebarAvailableFragments.es");

  require("./SidebarMapping.es");

  var _FragmentsEditorSidebar = _interopRequireDefault(require("./FragmentsEditorSidebar.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Added tab ID
   * @review
   * @type {!string}
   */
  var ADDED_TAB_ID = 'added';
  /**
   * Default selected tab
   * @review
   * @type {!string}
   */

  var DEFAULT_TAB_ID = 'available';
  /**
   * FragmentsEditorSidebar
   * @review
   */

  var FragmentsEditorSidebar =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentsEditorSidebar, _Component);

    function FragmentsEditorSidebar() {
      _classCallCheck(this, FragmentsEditorSidebar);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentsEditorSidebar).apply(this, arguments));
    }

    _createClass(FragmentsEditorSidebar, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        var addedTab = this.sidebarTabs.find(function (tab) {
          return tab.id === ADDED_TAB_ID;
        });

        if (addedTab) {
          this._addedTabEnabled = addedTab.enabled;
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "dispose",
      value: function dispose() {
        this._disposeTabEventProxy();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        return Object.assign({}, state, {
          sidebarTabs: state.sidebarTabs.map(function (sidebarTab) {
            return sidebarTab.id !== ADDED_TAB_ID ? sidebarTab : Object.assign({}, sidebarTab, {
              enabled: state._addedTabEnabled
            });
          })
        });
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.refs.contextualSidebar && this.refs.contextualSidebar.refs.sidebarTab) {
          this._updateTabEventProxy(this.refs.contextualSidebar.refs.sidebarTab);
        }
      }
      /**
       * Disallow setting element display to none
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncVisible",
      value: function syncVisible() {}
      /**
       * Enable or disable added tab depending on we have fragments or not
       * @private
       * @review
       */

    }, {
      key: "toggleAddedTab",
      value: function toggleAddedTab(enabled) {
        this._addedTabEnabled = !!enabled;

        if (!enabled) {
          this._selectedTab = DEFAULT_TAB_ID;
        }
      }
      /**
       * Dispose the existing _tabEventProxy, if any.
       * @private
       * @review
       */

    }, {
      key: "_disposeTabEventProxy",
      value: function _disposeTabEventProxy() {
        if (this._tabEventProxy) {
          this._tabEventProxy.dispose();

          this._tabEventProxy = null;
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleHide",
      value: function _handleHide() {
        this.emit('hide');
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleHideSidebarButtonClick",
      value: function _handleHideSidebarButtonClick() {
        this.emit('hide');
      }
      /**
       * Updates _selectedTab according to the clicked element
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleTabClick",
      value: function _handleTabClick(event) {
        this._selectedTab = event.delegateTarget.dataset.tabId || DEFAULT_TAB_ID;
      }
      /**
       *
       * Update or create the _tabEventProxy to propagate all events emitted
       * from the given tab.
       * @param {EventEmitter} sidebarTab
       * @private
       * @review
       */

    }, {
      key: "_updateTabEventProxy",
      value: function _updateTabEventProxy(sidebarTab) {
        if (!this._tabEventProxy) {
          this._tabEventProxy = new _metalEvents.EventEmitterProxy(sidebarTab, this);
        } else {
          this._tabEventProxy.setOriginEmitter(sidebarTab);
        }
      }
    }]);

    return FragmentsEditorSidebar;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentsEditorSidebar = FragmentsEditorSidebar;
  FragmentsEditorSidebar.STATE = {
    /**
     * CSS class for the fragments drop target.
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {!string}
     */
    dropTargetClass: _metalState.Config.string(),

    /**
     * Tabs being shown in sidebar
     * @default undefined
     * @instance
     * @memberOf FragmentsEditorSidebar
     * @review
     * @type {!Array<{
     *   enabled: bool,
     * 	 id: string,
     * 	 label: string
     * }>}
     */
    sidebarTabs: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      enabled: _metalState.Config.bool().required(),
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    })).required(),

    /**
     * Whether to show added tab or not
     * @default null
     * @instance
     * @memberOf FragmentsEditorSidebar
     * @private
     * @review
     * @type {bool}
     */
    _addedTabEnabled: _metalState.Config.bool().internal().value(null),

    /**
     * Tab selected inside sidebar
     * @default DEFAULT_TAB_ID
     * @instance
     * @memberOf FragmentsEditorSidebar
     * @private
     * @review
     * @type {string}
     */
    _selectedTab: _metalState.Config.string().internal().value(DEFAULT_TAB_ID),

    /**
     * Event proxy used for propagating tabs events
     * @default null
     * @instance
     * @memberOf FragmentsEditorSidebar
     * @private
     * @review
     * @type {object|null}
     */
    _tabEventProxy: _metalState.Config.object().internal().value(null)
  };

  _metalSoy["default"].register(FragmentsEditorSidebar, _FragmentsEditorSidebar["default"]);

  var _default = FragmentsEditorSidebar;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentsEditorSidebar.es.js.map
});
//# sourceMappingURL=FragmentsEditorSidebar.es.js.map