Liferay.Loader.define("layout-admin-web@2.0.112/js/miller_columns/LayoutColumn.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-soy', 'frontend-js-web/liferay/modal/commands/OpenSimpleInputModal.es', './LayoutColumn.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.LayoutColumn = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _OpenSimpleInputModal = _interopRequireDefault(require("frontend-js-web/liferay/modal/commands/OpenSimpleInputModal.es"));

  var _LayoutColumn = _interopRequireDefault(require("./LayoutColumn.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * LayoutColumn
   */
  var LayoutColumn =
  /*#__PURE__*/
  function (_Component) {
    _inherits(LayoutColumn, _Component);

    function LayoutColumn() {
      _classCallCheck(this, LayoutColumn);

      return _possibleConstructorReturn(this, _getPrototypeOf(LayoutColumn).apply(this, arguments));
    }

    _createClass(LayoutColumn, [{
      key: "rendered",

      /**
       * @inheritDoc
       * @review
       */
      value: function rendered() {
        if (this.refs.active) {
          this.refs.active.scrollIntoView();
        }
      }
      /**
       * Handle copy layout click in order to show simple input modal.
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleCopyLayoutClick",
      value: function _handleCopyLayoutClick(event) {
        event.preventDefault();
        var config = {
          dialogTitle: Liferay.Language.get('copy-page'),
          formSubmitURL: event.delegateTarget.href,
          mainFieldLabel: Liferay.Language.get('name'),
          mainFieldName: 'name',
          namespace: this.portletNamespace,
          spritemap: this.pathThemeImages + '/lexicon/icons.svg'
        };

        if (this.siteNavigationMenuNames !== '') {
          config.checkboxFieldLabel = Liferay.Util.sub(Liferay.Language.get('add-this-page-to-the-following-menus-x'), this.siteNavigationMenuNames);
          config.checkboxFieldName = 'TypeSettingsProperties--addToAutoMenus--';
          config.checkboxFieldValue = true;
        }

        new _OpenSimpleInputModal["default"](config);
      }
      /**
       * Handle permission item click in order to open the target href
       * in a dialog.
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handlePermissionLinkClick",
      value: function _handlePermissionLinkClick(event) {
        Liferay.Util.openInDialog(event, {
          dialog: {
            destroyOnHide: true
          },
          dialogIframe: {
            bodyCssClass: 'dialog-with-footer'
          },
          uri: event.delegateTarget.href
        });
      }
      /**
       * Handle delete item click in order to show a previous confirmation
       * alert.
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleDeleteItemClick",
      value: function _handleDeleteItemClick(event) {
        if (!confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'))) {
          event.preventDefault();
        }
      }
      /**
       * Handle column item title click event and propagate it to
       * the corresponding item mask.
       * @param {MouseEvent} event
       */

    }, {
      key: "_handleLayoutColumnItemTitleClick",
      value: function _handleLayoutColumnItemTitleClick(event) {
        var layoutItemElement = (0, _metalDom.closest)(event.delegateTarget, '.layout-item');
        var maskElement = layoutItemElement && layoutItemElement.querySelector('.layout-column-item-click-mask');

        if (maskElement) {
          maskElement.click();
        }
      }
    }]);

    return LayoutColumn;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @type {!Object}
   * @static
   */

  exports.LayoutColumn = LayoutColumn;
  LayoutColumn.STATE = {
    /**
     * List of layouts in the current column
     * @default undefined
     * @instance
     * @memberof LayoutColumn
     * @type {!Array}
     */
    layoutColumn: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      actions: _metalState.Config.string().required(),
      actionURLs: _metalState.Config.object().required(),
      active: _metalState.Config.bool().required(),
      description: _metalState.Config.string().required(),
      hasChild: _metalState.Config.bool().required(),
      plid: _metalState.Config.string().required(),
      title: _metalState.Config.string().required(),
      url: _metalState.Config.string().required()
    })).required(),

    /**
     * URL for using icons
     * @default undefined
     * @instance
     * @memberof LayoutColumn
     * @type {!string}
     */
    pathThemeImages: _metalState.Config.string().required(),

    /**
     * Namespace of portlet to prefix parameters names
     * @default undefined
     * @instance
     * @memberof LayoutColumn
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Site navigation menu names, to add layouts by default
     * @instance
     * @memberof Layout
     * @type {!string}
     */
    siteNavigationMenuNames: _metalState.Config.string().required(),

    /**
     * CSS class to modify style
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    styleModifier: _metalState.Config.string()
  };

  _metalSoy["default"].register(LayoutColumn, _LayoutColumn["default"]);

  var _default = LayoutColumn;
  exports["default"] = _default;
  //# sourceMappingURL=LayoutColumn.es.js.map
});
//# sourceMappingURL=LayoutColumn.es.js.map