/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.asset;

import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LayoutRevisionAssetRenderer
extends BaseJSPAssetRenderer<LayoutRevision> {
    private final LayoutBranch _layoutBranch;
    private final LayoutRevision _layoutRevision;
    private final LayoutSetBranch _layoutSetBranch;

    public LayoutRevisionAssetRenderer(LayoutRevision layoutRevision) {
        this._layoutRevision = layoutRevision;
        try {
            this._layoutBranch = layoutRevision.getLayoutBranch();
            this._layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)this._layoutRevision.getLayoutSetBranchId());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public LayoutRevision getAssetObject() {
        return this._layoutRevision;
    }

    public String getClassName() {
        return LayoutRevision.class.getName();
    }

    public long getClassPK() {
        return this._layoutRevision.getLayoutRevisionId();
    }

    public long getGroupId() {
        return this._layoutRevision.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("full_content")) {
            return "/asset/" + template + ".jsp";
        }
        return null;
    }

    public int getStatus() {
        return this._layoutRevision.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        Locale locale = this.getLocale(portletRequest);
        StringBundler sb = new StringBundler(15);
        sb.append(LanguageUtil.get((Locale)locale, (String)"page"));
        sb.append(": ");
        sb.append(this._layoutRevision.getHTMLTitle(locale));
        sb.append("\n");
        sb.append(LanguageUtil.get((Locale)locale, (String)"site-pages-variation"));
        sb.append(": ");
        sb.append(LanguageUtil.get((Locale)locale, (String)this._layoutSetBranch.getName()));
        sb.append("\n");
        sb.append(LanguageUtil.get((Locale)locale, (String)"page-variation"));
        sb.append(": ");
        sb.append(LanguageUtil.get((Locale)locale, (String)this._layoutBranch.getName()));
        sb.append("\n");
        sb.append(LanguageUtil.get((Locale)locale, (String)"revision-id"));
        sb.append(": ");
        sb.append(this._layoutRevision.getLayoutRevisionId());
        return sb.toString();
    }

    public String getTitle(Locale locale) {
        return this._layoutRevision.getHTMLTitle(locale);
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = LayoutLocalServiceUtil.getLayout((long)this._layoutRevision.getPlid());
            String layoutURL = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
            layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"layoutSetBranchId", (long)this._layoutRevision.getLayoutSetBranchId());
            layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"layoutRevisionId", (long)this._layoutRevision.getLayoutRevisionId());
            return layoutURL;
        }
        catch (Exception e) {
            return "";
        }
    }

    public long getUserId() {
        return this._layoutRevision.getUserId();
    }

    public String getUserName() {
        return this._layoutRevision.getUserName();
    }

    public String getUuid() {
        return null;
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("LAYOUT_REVISION", (Object)this._layoutRevision);
        return super.include(request, response, template);
    }

    public boolean isPreviewInContext() {
        return true;
    }
}

