/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.layout.admin.web.internal.util.LayoutPageTemplatePortletUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPrototypeDisplayContext {
    private String _displayStyle;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public LayoutPrototypeDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest request) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._request = request;
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedLayoutPrototypes");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public Boolean getActive() {
        String navigation = this.getNavigation();
        Boolean active = null;
        if (navigation.equals("active")) {
            active = true;
        } else if (navigation.equals("inactive")) {
            active = false;
        }
        return active;
    }

    public CreationMenu getCreationMenu() {
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(LayoutPrototypeDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_layout_prototype.jsp"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"add"));
                });
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(LayoutPrototypeDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(LayoutPrototypeDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"create-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        String navigation = this.getNavigation();
        if (Validator.isNotNull((String)navigation)) {
            portletURL.setParameter("navigation", navigation);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public SearchContainer getSearchContainer() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._renderResponse.createRenderURL(), null, "there-are-no-page-templates");
        searchContainer.setId("layoutPrototype");
        searchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        searchContainer.setOrderByCol(this.getOrderByCol());
        OrderByComparator<LayoutPageTemplateEntry> orderByComparator = LayoutPageTemplatePortletUtil.getLayoutPageTemplateEntryOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        searchContainer.setOrderByComparator(orderByComparator);
        searchContainer.setOrderByType(this.getOrderByType());
        int count = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCountByType((long)themeDisplay.getScopeGroupId(), (long)0L, (int)2);
        searchContainer.setTotal(count);
        List results = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesByType((long)themeDisplay.getScopeGroupId(), (long)0L, (int)2, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), orderByComparator);
        searchContainer.setResults(results);
        return searchContainer;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() {
        SearchContainer searchContainer = this.getSearchContainer();
        return searchContainer.getTotal();
    }

    public boolean isDisabledManagementBar() {
        if (this.getTotal() > 0) {
            return false;
        }
        return Objects.equals(this.getNavigation(), "all");
    }

    public boolean isShowAddButton() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return PortalPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (String)"ADD_LAYOUT_PROTOTYPE");
    }

    protected String getNavigation() {
        if (Validator.isNotNull((String)this._navigation)) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
        return this._navigation;
    }

    protected int getTotal() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return LayoutPrototypeLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (Boolean)this.getActive());
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(LayoutPrototypeDisplayContext.this.getNavigation(), "all"));
                    dropdownItem.setHref(LayoutPrototypeDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"all"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(LayoutPrototypeDisplayContext.this.getNavigation(), "active"));
                    dropdownItem.setHref(LayoutPrototypeDisplayContext.this.getPortletURL(), new Object[]{"navigation", "active"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"active"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(LayoutPrototypeDisplayContext.this.getNavigation(), "inactive"));
                    dropdownItem.setHref(LayoutPrototypeDisplayContext.this.getPortletURL(), new Object[]{"navigation", "inactive"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"inactive"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(LayoutPrototypeDisplayContext.this.getOrderByCol(), "create-date"));
                    dropdownItem.setHref(LayoutPrototypeDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "create-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeDisplayContext.this._request, (String)"create-date"));
                });
            }
        };
    }
}

