/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class LayoutPageTemplateEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutPageTemplateEntry> {
    public static final String[] CLASS_NAMES = new String[]{LayoutPageTemplateEntry.class.getName()};
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry)", unbind="-")
    private StagedModelRepository<LayoutPageTemplateEntry> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(LayoutPageTemplateEntry layoutPageTemplateEntry) {
        return layoutPageTemplateEntry.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        if (layoutPageTemplateCollection != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)layoutPageTemplateCollection, (String)"parent");
        }
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(layoutPageTemplateEntry.getGroupId(), this._portal.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)fragmentEntryLink, (String)"dependency");
        }
        this._exportAssetDisplayPages(portletDataContext, layoutPageTemplateEntry);
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)layoutPageTemplateEntry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)layoutPageTemplateEntry), (ClassedModel)layoutPageTemplateEntry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long layoutPageTemplateEntryId) throws Exception {
        LayoutPageTemplateEntry existingLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this.fetchMissingReference(uuid, groupId);
        if (existingLayoutPageTemplateEntry == null) {
            return;
        }
        Map layoutPageTemplateEntryIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateEntry.class);
        layoutPageTemplateEntryIds.put(layoutPageTemplateEntryId, existingLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, LayoutPageTemplateCollection.class, (long)layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        Map layoutPageTemplateCollectionIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateCollection.class);
        long layoutPageTemplateCollectionId = MapUtil.getLong((Map)layoutPageTemplateCollectionIds, (long)layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), (long)layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        LayoutPageTemplateEntry importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)layoutPageTemplateEntry.clone();
        importedLayoutPageTemplateEntry.setGroupId(portletDataContext.getScopeGroupId());
        importedLayoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        LayoutPageTemplateEntry existingLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(layoutPageTemplateEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingLayoutPageTemplateEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedLayoutPageTemplateEntry);
        } else {
            importedLayoutPageTemplateEntry.setLayoutPageTemplateEntryId(existingLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedLayoutPageTemplateEntry);
        }
        this.importFragmentEntryLinks(portletDataContext, layoutPageTemplateEntry, importedLayoutPageTemplateEntry);
        this._importAssetDisplayPages(portletDataContext, layoutPageTemplateEntry, importedLayoutPageTemplateEntry);
        portletDataContext.importClassedModel((ClassedModel)layoutPageTemplateEntry, (ClassedModel)importedLayoutPageTemplateEntry);
    }

    protected StagedModelRepository<LayoutPageTemplateEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    protected void importFragmentEntryLinks(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry, LayoutPageTemplateEntry importedLayoutPageTemplateEntry) throws Exception {
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(LayoutPageTemplateEntry.class), importedLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        List fragmentEntryLinkElements = portletDataContext.getReferenceDataElements((StagedModel)layoutPageTemplateEntry, FragmentEntryLink.class);
        for (Element fragmentEntryLinkElement : fragmentEntryLinkElements) {
            String fragmentEntryLinkPath = fragmentEntryLinkElement.attributeValue("path");
            FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)portletDataContext.getZipEntryAsObject(fragmentEntryLinkPath);
            fragmentEntryLink.setClassNameId(this._portal.getClassNameId(LayoutPageTemplateEntry.class));
            fragmentEntryLink.setClassPK(importedLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentEntryLink);
        }
    }

    protected boolean isSkipImportReferenceStagedModels() {
        return true;
    }

    private void _exportAssetDisplayPages(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortletDataException {
        List assetDisplayPageEntries = this._assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        for (AssetDisplayPageEntry assetDisplayPageEntry : assetDisplayPageEntries) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)assetDisplayPageEntry, (String)"dependency");
        }
    }

    private void _importAssetDisplayPages(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry, LayoutPageTemplateEntry importedLayoutPageTemplateEntry) {
        List assetDisplayPageEntryElements = portletDataContext.getReferenceDataElements((StagedModel)layoutPageTemplateEntry, AssetDisplayPageEntry.class);
        Map assetDisplayPageEntries = portletDataContext.getNewPrimaryKeysMap(AssetDisplayPageEntry.class);
        for (Element assetDisplayPageEntryElement : assetDisplayPageEntryElements) {
            String path = assetDisplayPageEntryElement.attributeValue("path");
            AssetDisplayPageEntry assetDisplayPageEntry = (AssetDisplayPageEntry)portletDataContext.getZipEntryAsObject(path);
            long assetDisplayPageEntryId = MapUtil.getLong((Map)assetDisplayPageEntries, (long)assetDisplayPageEntry.getAssetDisplayPageEntryId(), (long)assetDisplayPageEntry.getAssetDisplayPageEntryId());
            AssetDisplayPageEntry existingAssetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(assetDisplayPageEntryId);
            if (existingAssetDisplayPageEntry == null) continue;
            existingAssetDisplayPageEntry.setLayoutPageTemplateEntryId(importedLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            this._assetDisplayPageEntryLocalService.updateAssetDisplayPageEntry(existingAssetDisplayPageEntry);
        }
    }
}

