/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ActionUtil.class})
public class ActionUtil {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private ThemeLocalService _themeLocalService;

    public void deleteThemeSettingsProperties(UnicodeProperties typeSettingsProperties, String device) {
        String keyPrefix = ThemeSettingImpl.namespaceProperty((String)device);
        Set keys = typeSettingsProperties.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(keyPrefix)) continue;
            itr.remove();
        }
    }

    public String getColorSchemeId(long companyId, String themeId, String colorSchemeId) throws Exception {
        Theme theme = this._themeLocalService.getTheme(companyId, themeId);
        if (!theme.hasColorSchemes()) {
            colorSchemeId = "";
        }
        if (Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = this._themeLocalService.getColorScheme(companyId, themeId, colorSchemeId);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        return colorSchemeId;
    }

    public void updateLookAndFeel(ActionRequest actionRequest, long companyId, long liveGroupId, long stagingGroupId, boolean privateLayout, long layoutId, UnicodeProperties typeSettingsProperties) throws Exception {
        String[] devices;
        for (String device : devices = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"devices"))) {
            String deviceThemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ThemeId"));
            String deviceColorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ColorSchemeId"));
            String deviceCss = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "Css"));
            boolean deviceInheritLookAndFeel = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)(device + "InheritLookAndFeel"));
            if (deviceInheritLookAndFeel) {
                deviceThemeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)companyId);
                deviceColorSchemeId = "";
                this.deleteThemeSettingsProperties(typeSettingsProperties, device);
            } else if (Validator.isNotNull((String)deviceThemeId)) {
                deviceColorSchemeId = this.getColorSchemeId(companyId, deviceThemeId, deviceColorSchemeId);
                this.updateThemeSettingsProperties(actionRequest, companyId, typeSettingsProperties, device, deviceThemeId, true);
            }
            long groupId = liveGroupId;
            if (stagingGroupId > 0L) {
                groupId = stagingGroupId;
            }
            this._layoutService.updateLayout(groupId, privateLayout, layoutId, typeSettingsProperties.toString());
            this._layoutService.updateLookAndFeel(groupId, privateLayout, layoutId, deviceThemeId, deviceColorSchemeId, deviceCss);
        }
    }

    public UnicodeProperties updateThemeSettingsProperties(ActionRequest actionRequest, long companyId, UnicodeProperties typeSettingsProperties, String device, String deviceThemeId, boolean layout) throws Exception {
        Theme theme = this._themeLocalService.getTheme(companyId, deviceThemeId);
        this.deleteThemeSettingsProperties(typeSettingsProperties, device);
        Map themeSettings = theme.getConfigurableSettings();
        if (themeSettings.isEmpty()) {
            return typeSettingsProperties;
        }
        this.setThemeSettingProperties(actionRequest, typeSettingsProperties, themeSettings, device, layout);
        return typeSettingsProperties;
    }

    protected void setThemeSettingProperties(ActionRequest actionRequest, UnicodeProperties typeSettingsProperties, Map<String, ThemeSetting> themeSettings, String device, boolean isLayout) throws PortalException {
        Layout layout = null;
        if (isLayout) {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
            layout = this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        }
        for (Map.Entry<String, ThemeSetting> entry : themeSettings.entrySet()) {
            String key = entry.getKey();
            ThemeSetting themeSetting = entry.getValue();
            String property = StringBundler.concat((String[])new String[]{device, "ThemeSettingsProperties--", key, "--"});
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)property, (String)themeSetting.getValue());
            if ((!isLayout || Objects.equals(value, layout.getDefaultThemeSetting(key, device, false))) && (isLayout || value.equals(themeSetting.getValue()))) continue;
            typeSettingsProperties.setProperty(ThemeSettingImpl.namespaceProperty((String)device, (String)key), value);
        }
    }
}

